/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Observer;

public class Observable {
    List<Observer> observers = new ArrayList<Observer>();
    boolean changed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException("observer == null");
        }
        Observable observable = this;
        synchronized (observable) {
            if (!this.observers.contains(observer)) {
                this.observers.add(observer);
            }
        }
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public int countObservers() {
        return this.observers.size();
    }

    public synchronized void deleteObserver(Observer observer) {
        this.observers.remove(observer);
    }

    public synchronized void deleteObservers() {
        this.observers.clear();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object data) {
        int size = 0;
        Observer[] arrays = null;
        Observable observable = this;
        synchronized (observable) {
            if (this.hasChanged()) {
                this.clearChanged();
                size = this.observers.size();
                arrays = new Observer[size];
                this.observers.toArray(arrays);
            }
        }
        if (arrays != null) {
            for (Observer observer : arrays) {
                observer.update(this, data);
            }
        }
    }

    protected void setChanged() {
        this.changed = true;
    }
}

