/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteOrder;
import java.nio.charset.ModifiedUtf8;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import libcore.io.Memory;
import libcore.io.Streams;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private static final int ZIPLocalHeaderVersionNeeded = 20;
    private boolean entriesEnd = false;
    private boolean hasDD = false;
    private int entryIn = 0;
    private int inRead;
    private int lastRead = 0;
    private ZipEntry currentEntry;
    private final byte[] hdrBuf = new byte[26];
    private final CRC32 crc = new CRC32();
    private byte[] stringBytesBuf = new byte[256];
    private char[] stringCharBuf = new char[256];

    public ZipInputStream(InputStream stream) {
        super(new PushbackInputStream(stream, 512), new Inflater(true));
        if (stream == null) {
            throw new NullPointerException("stream == null");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeEntry();
            super.close();
        }
    }

    public void closeEntry() throws IOException {
        Exception failure;
        block11: {
            int out;
            int inB;
            this.checkClosed();
            if (this.currentEntry == null) {
                return;
            }
            failure = null;
            try {
                Streams.skipAll(this);
            }
            catch (Exception e) {
                failure = e;
            }
            if (this.currentEntry.compressionMethod == 8) {
                inB = this.inf.getTotalIn();
                out = this.inf.getTotalOut();
            } else {
                inB = this.inRead;
                out = this.inRead;
            }
            int diff = this.entryIn - inB;
            if (diff != 0) {
                ((PushbackInputStream)this.in).unread(this.buf, this.len - diff, diff);
            }
            try {
                this.readAndVerifyDataDescriptor(inB, out);
            }
            catch (Exception e) {
                if (failure != null) break block11;
                failure = e;
            }
        }
        this.inf.reset();
        this.len = 0;
        this.entryIn = 0;
        this.inRead = 0;
        this.lastRead = 0;
        this.crc.reset();
        this.currentEntry = null;
        if (failure != null) {
            if (failure instanceof IOException) {
                throw (IOException)failure;
            }
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            AssertionError error = new AssertionError();
            ((Throwable)((Object)error)).initCause(failure);
            throw error;
        }
    }

    private void readAndVerifyDataDescriptor(int inB, int out) throws IOException {
        if (this.hasDD) {
            Streams.readFully(this.in, this.hdrBuf, 0, 16);
            int sig = Memory.peekInt(this.hdrBuf, 0, ByteOrder.LITTLE_ENDIAN);
            if (sig != 134695760) {
                throw new ZipException(String.format("unknown format (EXTSIG=%x)", sig));
            }
            this.currentEntry.crc = (long)Memory.peekInt(this.hdrBuf, 4, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
            this.currentEntry.compressedSize = (long)Memory.peekInt(this.hdrBuf, 8, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
            this.currentEntry.size = (long)Memory.peekInt(this.hdrBuf, 12, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
        }
        if (this.currentEntry.crc != this.crc.getValue()) {
            throw new ZipException("CRC mismatch");
        }
        if (this.currentEntry.compressedSize != (long)inB || this.currentEntry.size != (long)out) {
            throw new ZipException("Size mismatch");
        }
    }

    public ZipEntry getNextEntry() throws IOException {
        int nameLength;
        this.closeEntry();
        if (this.entriesEnd) {
            return null;
        }
        Streams.readFully(this.in, this.hdrBuf, 0, 4);
        int hdr = Memory.peekInt(this.hdrBuf, 0, ByteOrder.LITTLE_ENDIAN);
        if ((long)hdr == 33639248L) {
            this.entriesEnd = true;
            return null;
        }
        if ((long)hdr != 67324752L) {
            return null;
        }
        Streams.readFully(this.in, this.hdrBuf, 0, 26);
        int version = this.peekShort(0) & 0xFF;
        if (version > 20) {
            throw new ZipException("Cannot read local header version " + version);
        }
        int flags = this.peekShort(2);
        if ((flags & 1) != 0) {
            throw new ZipException("Invalid General Purpose Bit Flag: " + flags);
        }
        this.hasDD = (flags & 8) != 0;
        int ceLastModifiedTime = this.peekShort(6);
        int ceLastModifiedDate = this.peekShort(8);
        int ceCompressionMethod = this.peekShort(4);
        long ceCrc = 0L;
        long ceCompressedSize = 0L;
        long ceSize = -1L;
        if (!this.hasDD) {
            ceCrc = (long)Memory.peekInt(this.hdrBuf, 10, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
            ceCompressedSize = (long)Memory.peekInt(this.hdrBuf, 14, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
            ceSize = (long)Memory.peekInt(this.hdrBuf, 18, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
        }
        if ((nameLength = this.peekShort(22)) == 0) {
            throw new ZipException("Entry is not named");
        }
        int extraLength = this.peekShort(24);
        String name = this.readString(nameLength);
        this.currentEntry = this.createZipEntry(name);
        this.currentEntry.time = ceLastModifiedTime;
        this.currentEntry.modDate = ceLastModifiedDate;
        this.currentEntry.setMethod(ceCompressionMethod);
        if (ceSize != -1L) {
            this.currentEntry.setCrc(ceCrc);
            this.currentEntry.setSize(ceSize);
            this.currentEntry.setCompressedSize(ceCompressedSize);
        }
        if (extraLength > 0) {
            byte[] extraData = new byte[extraLength];
            Streams.readFully(this.in, extraData, 0, extraLength);
            this.currentEntry.setExtra(extraData);
        }
        return this.currentEntry;
    }

    private String readString(int byteLength) throws IOException {
        if (byteLength > this.stringBytesBuf.length) {
            this.stringBytesBuf = new byte[byteLength];
        }
        Streams.readFully(this.in, this.stringBytesBuf, 0, byteLength);
        if (byteLength > this.stringCharBuf.length) {
            this.stringCharBuf = new char[byteLength];
        }
        return ModifiedUtf8.decode(this.stringBytesBuf, this.stringCharBuf, 0, byteLength);
    }

    private int peekShort(int offset) {
        return Memory.peekShort(this.hdrBuf, offset, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int read;
        this.checkClosed();
        Arrays.checkOffsetAndCount(buffer.length, byteOffset, byteCount);
        if (this.inf.finished() || this.currentEntry == null) {
            return -1;
        }
        if (this.currentEntry.compressionMethod == 0) {
            int toRead;
            int csize = (int)this.currentEntry.size;
            if (this.inRead >= csize) {
                return -1;
            }
            if (this.lastRead >= this.len) {
                this.lastRead = 0;
                this.len = this.in.read(this.buf);
                if (this.len == -1) {
                    this.eof = true;
                    return -1;
                }
                this.entryIn += this.len;
            }
            int n = toRead = byteCount > this.len - this.lastRead ? this.len - this.lastRead : byteCount;
            if (csize - this.inRead < toRead) {
                toRead = csize - this.inRead;
            }
            System.arraycopy((byte[])this.buf, (int)this.lastRead, (byte[])buffer, (int)byteOffset, (int)toRead);
            this.lastRead += toRead;
            this.inRead += toRead;
            this.crc.update(buffer, byteOffset, toRead);
            return toRead;
        }
        if (this.inf.needsInput()) {
            this.fill();
            if (this.len > 0) {
                this.entryIn += this.len;
            }
        }
        try {
            read = this.inf.inflate(buffer, byteOffset, byteCount);
        }
        catch (DataFormatException e) {
            throw new ZipException(e.getMessage());
        }
        if (read == 0 && this.inf.finished()) {
            return -1;
        }
        this.crc.update(buffer, byteOffset, read);
        return read;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return this.currentEntry == null || (long)this.inRead < this.currentEntry.size ? 1 : 0;
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }
}

