/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.harmony.crypto.internal.NullCipherSpi;
import org.apache.harmony.security.fortress.Engine;

public class Cipher {
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int PUBLIC_KEY = 1;
    public static final int SECRET_KEY = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private int mode;
    private static final String SERVICE = "Cipher";
    private static final Engine ENGINE = new Engine("Cipher");
    private static final String ATTRIBUTE_PADDINGS = "SupportedPaddings";
    private static final String ATTRIBUTE_MODES = "SupportedModes";
    private Provider provider;
    private final Provider specifiedProvider;
    private CipherSpi spiImpl;
    private final CipherSpi specifiedSpi;
    private final String transformation;
    private final String[] transformParts;
    private final Object initLock = new Object();
    private static SecureRandom secureRandom;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String transformation) {
        if (cipherSpi == null) {
            throw new NullPointerException("cipherSpi == null");
        }
        if (!(cipherSpi instanceof NullCipherSpi) && provider == null) {
            throw new NullPointerException("provider == null");
        }
        this.specifiedProvider = provider;
        this.specifiedSpi = cipherSpi;
        this.transformation = transformation;
        this.transformParts = null;
    }

    private Cipher(String transformation, String[] transformParts, Provider provider) {
        this.transformation = transformation;
        this.transformParts = transformParts;
        this.specifiedProvider = provider;
        this.specifiedSpi = null;
    }

    public static final Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getCipher(transformation, null);
    }

    public static final Cipher getInstance(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException("Provider not available: " + provider);
        }
        return Cipher.getInstance(transformation, p);
    }

    public static final Cipher getInstance(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null");
        }
        return Cipher.getCipher(transformation, provider);
    }

    private static NoSuchAlgorithmException invalidTransformation(String transformation) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Invalid transformation: " + transformation);
    }

    private static Cipher getCipher(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (transformation == null || transformation.isEmpty()) {
            throw Cipher.invalidTransformation(transformation);
        }
        String[] transformParts = Cipher.checkTransformation(transformation);
        if (Cipher.tryCombinations(null, provider, transformParts) == null) {
            if (provider == null) {
                throw new NoSuchAlgorithmException("No provider found for " + transformation);
            }
            throw new NoSuchAlgorithmException("Provider " + provider.getName() + " does not provide " + transformation);
        }
        return new Cipher(transformation, transformParts, provider);
    }

    private static String[] checkTransformation(String transformation) throws NoSuchAlgorithmException {
        String[] pieces;
        if (transformation.startsWith("/")) {
            transformation = transformation.substring(1);
        }
        if ((pieces = transformation.split("/")).length > 3) {
            throw Cipher.invalidTransformation(transformation);
        }
        String[] result = new String[3];
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i].trim();
            if (piece.isEmpty()) continue;
            result[i] = piece;
        }
        if (result[0] == null) {
            throw Cipher.invalidTransformation(transformation);
        }
        if (!(result[1] == null && result[2] == null || result[1] != null && result[2] != null)) {
            throw Cipher.invalidTransformation(transformation);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CipherSpi getSpi(Key key) {
        if (this.specifiedSpi != null) {
            return this.specifiedSpi;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.spiImpl != null && key == null) {
                return this.spiImpl;
            }
            Engine.SpiAndProvider sap = Cipher.tryCombinations(key, this.specifiedProvider, this.transformParts);
            if (sap == null) {
                throw new ProviderException("No provider for " + this.transformation);
            }
            this.spiImpl = (CipherSpi)sap.spi;
            this.provider = sap.provider;
            return this.spiImpl;
        }
    }

    private CipherSpi getSpi() {
        return this.getSpi(null);
    }

    private static Engine.SpiAndProvider tryCombinations(Key key, Provider provider, String[] transformParts) {
        Engine.SpiAndProvider sap = null;
        if (transformParts[1] != null && transformParts[2] != null && (sap = Cipher.tryTransform(key, provider, transformParts[0] + "/" + transformParts[1] + "/" + transformParts[2], transformParts, NeedToSet.NONE)) != null) {
            return sap;
        }
        if (transformParts[1] != null && (sap = Cipher.tryTransform(key, provider, transformParts[0] + "/" + transformParts[1], transformParts, NeedToSet.PADDING)) != null) {
            return sap;
        }
        if (transformParts[2] != null && (sap = Cipher.tryTransform(key, provider, transformParts[0] + "//" + transformParts[2], transformParts, NeedToSet.MODE)) != null) {
            return sap;
        }
        return Cipher.tryTransform(key, provider, transformParts[0], transformParts, NeedToSet.BOTH);
    }

    private static Engine.SpiAndProvider tryTransform(Key key, Provider provider, String transform, String[] transformParts, NeedToSet type) {
        if (provider != null) {
            Provider.Service service = provider.getService(SERVICE, transform);
            if (service == null) {
                return null;
            }
            return Cipher.tryTransformWithProvider(key, transformParts, type, service);
        }
        ArrayList<Provider.Service> services = ENGINE.getServices(transform);
        if (services == null) {
            return null;
        }
        for (Provider.Service service : services) {
            Engine.SpiAndProvider sap = Cipher.tryTransformWithProvider(key, transformParts, type, service);
            if (sap == null) continue;
            return sap;
        }
        return null;
    }

    private static Engine.SpiAndProvider tryTransformWithProvider(Key key, String[] transformParts, NeedToSet type, Provider.Service service) {
        try {
            if (key != null && !service.supportsParameter(key)) {
                return null;
            }
            if (!Cipher.matchAttribute(service, ATTRIBUTE_MODES, transformParts[1]) || !Cipher.matchAttribute(service, ATTRIBUTE_PADDINGS, transformParts[2])) {
                return null;
            }
            Engine.SpiAndProvider sap = ENGINE.getInstance(service, null);
            if (sap.spi == null || sap.provider == null) {
                return null;
            }
            if (!(sap.spi instanceof CipherSpi)) {
                return null;
            }
            CipherSpi spi = (CipherSpi)sap.spi;
            if ((type == NeedToSet.MODE || type == NeedToSet.BOTH) && transformParts[1] != null) {
                spi.engineSetMode(transformParts[1]);
            }
            if ((type == NeedToSet.PADDING || type == NeedToSet.BOTH) && transformParts[2] != null) {
                spi.engineSetPadding(transformParts[2]);
            }
            return sap;
        }
        catch (NoSuchAlgorithmException ignored) {
        }
        catch (NoSuchPaddingException ignored) {
            // empty catch block
        }
        return null;
    }

    private static boolean matchAttribute(Provider.Service service, String attr2, String value) {
        if (value == null) {
            return true;
        }
        String pattern = service.getAttribute(attr2);
        if (pattern == null) {
            return true;
        }
        String valueUc = value.toUpperCase(Locale.US);
        return valueUc.matches(pattern.toUpperCase(Locale.US));
    }

    public final Provider getProvider() {
        this.getSpi();
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        return this.getSpi().engineGetBlockSize();
    }

    public final int getOutputSize(int inputLen) {
        if (this.mode == 0) {
            throw new IllegalStateException("Cipher has not yet been initialized");
        }
        return this.getSpi().engineGetOutputSize(inputLen);
    }

    public final byte[] getIV() {
        return this.getSpi().engineGetIV();
    }

    public final AlgorithmParameters getParameters() {
        return this.getSpi().engineGetParameters();
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    private void checkMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 4 && mode != 3) {
            throw new InvalidParameterException("Invalid mode: " + mode);
        }
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.init(opmode, key, secureRandom);
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.checkMode(opmode);
        this.getSpi(key).engineInit(opmode, key, random);
        this.mode = opmode;
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.init(opmode, key, params, secureRandom);
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.checkMode(opmode);
        this.getSpi(key).engineInit(opmode, key, params, random);
        this.mode = opmode;
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.init(opmode, key, params, secureRandom);
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.checkMode(opmode);
        this.getSpi(key).engineInit(opmode, key, params, random);
        this.mode = opmode;
    }

    public final void init(int opmode, Certificate certificate) throws InvalidKeyException {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.init(opmode, certificate, secureRandom);
    }

    public final void init(int opmode, Certificate certificate, SecureRandom random) throws InvalidKeyException {
        this.checkMode(opmode);
        if (certificate instanceof X509Certificate) {
            Set<String> ce = ((X509Certificate)certificate).getCriticalExtensionOIDs();
            boolean critical = false;
            if (ce != null && !ce.isEmpty()) {
                boolean[] keyUsage;
                for (String oid : ce) {
                    if (!oid.equals("2.5.29.15")) continue;
                    critical = true;
                    break;
                }
                if (critical && (keyUsage = ((X509Certificate)certificate).getKeyUsage()) != null) {
                    if (opmode == 1 && !keyUsage[3]) {
                        throw new InvalidKeyException("The public key in the certificate cannot be used for ENCRYPT_MODE");
                    }
                    if (opmode == 3 && !keyUsage[2]) {
                        throw new InvalidKeyException("The public key in the certificate cannot be used for WRAP_MODE");
                    }
                }
            }
        }
        PublicKey key = certificate.getPublicKey();
        this.getSpi(key).engineInit(opmode, key, random);
        this.mode = opmode;
    }

    public final byte[] update(byte[] input) {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        if (input.length == 0) {
            return null;
        }
        return this.getSpi().engineUpdate(input, 0, input.length);
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLen) {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        Cipher.checkInputOffsetAndCount(input.length, inputOffset, inputLen);
        if (input.length == 0) {
            return null;
        }
        return this.getSpi().engineUpdate(input, inputOffset, inputLen);
    }

    private static void checkInputOffsetAndCount(int inputArrayLength, int inputOffset, int inputLen) {
        if ((inputOffset | inputLen) < 0 || inputOffset > inputArrayLength || inputArrayLength - inputOffset < inputLen) {
            throw new IllegalArgumentException("input.length=" + inputArrayLength + "; inputOffset=" + inputOffset + "; inputLen=" + inputLen);
        }
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException {
        return this.update(input, inputOffset, inputLen, output, 0);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        if (output == null) {
            throw new IllegalArgumentException("output == null");
        }
        if (outputOffset < 0) {
            throw new IllegalArgumentException("outputOffset < 0. outputOffset=" + outputOffset);
        }
        Cipher.checkInputOffsetAndCount(input.length, inputOffset, inputLen);
        if (input.length == 0) {
            return 0;
        }
        return this.getSpi().engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    public final int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        if (input == output) {
            throw new IllegalArgumentException("input == output");
        }
        return this.getSpi().engineUpdate(input, output);
    }

    public final void updateAAD(byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        if (input.length == 0) {
            return;
        }
        this.getSpi().engineUpdateAAD(input, 0, input.length);
    }

    public final void updateAAD(byte[] input, int inputOffset, int inputLen) {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        Cipher.checkInputOffsetAndCount(input.length, inputOffset, inputLen);
        if (input.length == 0) {
            return;
        }
        this.getSpi().engineUpdateAAD(input, inputOffset, inputLen);
    }

    public final void updateAAD(ByteBuffer input) {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        this.getSpi().engineUpdateAAD(input);
    }

    public final byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        return this.getSpi().engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        if (outputOffset < 0) {
            throw new IllegalArgumentException("outputOffset < 0. outputOffset=" + outputOffset);
        }
        return this.getSpi().engineDoFinal(null, 0, 0, output, outputOffset);
    }

    public final byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        return this.getSpi().engineDoFinal(input, 0, input.length);
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        Cipher.checkInputOffsetAndCount(input.length, inputOffset, inputLen);
        return this.getSpi().engineDoFinal(input, inputOffset, inputLen);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(input, inputOffset, inputLen, output, 0);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        Cipher.checkInputOffsetAndCount(input.length, inputOffset, inputLen);
        return this.getSpi().engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    public final int doFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException();
        }
        if (input == output) {
            throw new IllegalArgumentException("input == output");
        }
        return this.getSpi().engineDoFinal(input, output);
    }

    public final byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.mode != 3) {
            throw new IllegalStateException();
        }
        return this.getSpi().engineWrap(key);
    }

    public final Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.mode != 4) {
            throw new IllegalStateException();
        }
        return this.getSpi().engineUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public static final int getMaxAllowedKeyLength(String transformation) throws NoSuchAlgorithmException {
        if (transformation == null) {
            throw new NullPointerException("transformation == null");
        }
        Cipher.checkTransformation(transformation);
        return Integer.MAX_VALUE;
    }

    public static final AlgorithmParameterSpec getMaxAllowedParameterSpec(String transformation) throws NoSuchAlgorithmException {
        if (transformation == null) {
            throw new NullPointerException("transformation == null");
        }
        Cipher.checkTransformation(transformation);
        return null;
    }

    private static enum NeedToSet {
        NONE,
        MODE,
        PADDING,
        BOTH;

    }
}

