/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class PBEParameterSpec
implements AlgorithmParameterSpec {
    private final byte[] salt;
    private final int iterationCount;

    public PBEParameterSpec(byte[] salt, int iterationCount) {
        if (salt == null) {
            throw new NullPointerException("salt == null");
        }
        this.salt = new byte[salt.length];
        System.arraycopy((byte[])salt, (int)0, (byte[])this.salt, (int)0, (int)salt.length);
        this.iterationCount = iterationCount;
    }

    public byte[] getSalt() {
        byte[] result = new byte[this.salt.length];
        System.arraycopy((byte[])this.salt, (int)0, (byte[])result, (int)0, (int)this.salt.length);
        return result;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }
}

