/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import libcore.icu.LocaleData;
import libcore.util.BasicLruCache;

public final class ICU {
    private static final BasicLruCache<String, String> CACHED_PATTERNS = new BasicLruCache(8);
    private static Locale[] availableLocalesCache;
    private static String[] isoCountries;
    private static String[] isoLanguages;
    private static final int IDX_LANGUAGE = 0;
    private static final int IDX_SCRIPT = 1;
    private static final int IDX_REGION = 2;
    private static final int IDX_VARIANT = 3;
    public static final int U_ZERO_ERROR = 0;
    public static final int U_INVALID_CHAR_FOUND = 10;
    public static final int U_TRUNCATED_CHAR_FOUND = 11;
    public static final int U_ILLEGAL_CHAR_FOUND = 12;
    public static final int U_BUFFER_OVERFLOW_ERROR = 15;

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = ICU.getISOLanguagesNative();
        }
        return (String[])isoLanguages.clone();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = ICU.getISOCountriesNative();
        }
        return (String[])isoCountries.clone();
    }

    private static void parseLangScriptRegionAndVariants(String string2, String[] outputArray) {
        int first = string2.indexOf(95);
        int second = string2.indexOf(95, first + 1);
        int third = string2.indexOf(95, second + 1);
        if (first == -1) {
            outputArray[0] = string2;
        } else if (second == -1) {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
            } else if (secondString.length() == 2 || secondString.length() == 3) {
                outputArray[2] = secondString;
            } else {
                outputArray[3] = secondString;
            }
        } else if (third == -1) {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1, second);
            String thirdString = string2.substring(second + 1);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
                if (thirdString.length() == 2 || thirdString.length() == 3 || thirdString.isEmpty()) {
                    outputArray[2] = thirdString;
                } else {
                    outputArray[3] = thirdString;
                }
            } else if (secondString.isEmpty() || secondString.length() == 2 || secondString.length() == 3) {
                outputArray[2] = secondString;
                outputArray[3] = thirdString;
            } else {
                outputArray[3] = string2.substring(first + 1);
            }
        } else {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1, second);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
                outputArray[2] = string2.substring(second + 1, third);
                outputArray[3] = string2.substring(third + 1);
            } else {
                outputArray[2] = secondString;
                outputArray[3] = string2.substring(second + 1);
            }
        }
    }

    public static Locale localeFromIcuLocaleId(String localeId) {
        int extensionsIndex = localeId.indexOf(64);
        HashMap<Character, String> extensionsMap = Collections.EMPTY_MAP;
        HashMap<String, String> unicodeKeywordsMap = Collections.EMPTY_MAP;
        HashSet<String> unicodeAttributeSet = Collections.EMPTY_SET;
        if (extensionsIndex != -1) {
            String[] extensions;
            extensionsMap = new HashMap<Character, String>();
            unicodeKeywordsMap = new HashMap<String, String>();
            unicodeAttributeSet = new HashSet<String>();
            String extensionsString = localeId.substring(extensionsIndex + 1);
            for (String extension : extensions = extensionsString.split(";")) {
                if (extension.startsWith("attribute=")) {
                    String unicodeAttributeValues = extension.substring("attribute=".length());
                    for (String unicodeAttribute : unicodeAttributeValues.split("-")) {
                        unicodeAttributeSet.add(unicodeAttribute);
                    }
                    continue;
                }
                int separatorIndex = extension.indexOf(61);
                if (separatorIndex == 1) {
                    String value = extension.substring(2);
                    char extensionId = extension.charAt(0);
                    extensionsMap.put(Character.valueOf(extensionId), value);
                    continue;
                }
                unicodeKeywordsMap.put(extension.substring(0, separatorIndex), extension.substring(separatorIndex + 1));
            }
        }
        String[] outputArray = new String[]{"", "", "", ""};
        if (extensionsIndex == -1) {
            ICU.parseLangScriptRegionAndVariants(localeId, outputArray);
        } else {
            ICU.parseLangScriptRegionAndVariants(localeId.substring(0, extensionsIndex), outputArray);
        }
        return new Locale(outputArray[0], outputArray[2], outputArray[3], outputArray[1], unicodeAttributeSet, unicodeKeywordsMap, extensionsMap, true);
    }

    public static Locale[] localesFromStrings(String[] localeNames) {
        LinkedHashSet<Locale> set = new LinkedHashSet<Locale>();
        for (String localeName : localeNames) {
            set.add(ICU.localeFromIcuLocaleId(localeName));
        }
        return set.toArray(new Locale[set.size()]);
    }

    public static Locale[] getAvailableLocales() {
        if (availableLocalesCache == null) {
            availableLocalesCache = ICU.localesFromStrings(ICU.getAvailableLocalesNative());
        }
        return (Locale[])availableLocalesCache.clone();
    }

    public static Locale[] getAvailableBreakIteratorLocales() {
        return ICU.localesFromStrings(ICU.getAvailableBreakIteratorLocalesNative());
    }

    public static Locale[] getAvailableCalendarLocales() {
        return ICU.localesFromStrings(ICU.getAvailableCalendarLocalesNative());
    }

    public static Locale[] getAvailableCollatorLocales() {
        return ICU.localesFromStrings(ICU.getAvailableCollatorLocalesNative());
    }

    public static Locale[] getAvailableDateFormatLocales() {
        return ICU.localesFromStrings(ICU.getAvailableDateFormatLocalesNative());
    }

    public static Locale[] getAvailableDateFormatSymbolsLocales() {
        return ICU.getAvailableDateFormatLocales();
    }

    public static Locale[] getAvailableDecimalFormatSymbolsLocales() {
        return ICU.getAvailableNumberFormatLocales();
    }

    public static Locale[] getAvailableNumberFormatLocales() {
        return ICU.localesFromStrings(ICU.getAvailableNumberFormatLocalesNative());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBestDateTimePattern(String skeleton, Locale locale) {
        String languageTag = locale.toLanguageTag();
        String key = skeleton + "\t" + languageTag;
        BasicLruCache<String, String> basicLruCache = CACHED_PATTERNS;
        synchronized (basicLruCache) {
            String pattern = CACHED_PATTERNS.get(key);
            if (pattern == null) {
                pattern = ICU.getBestDateTimePatternNative(skeleton, languageTag);
                CACHED_PATTERNS.put(key, pattern);
            }
            return pattern;
        }
    }

    private static native String getBestDateTimePatternNative(String var0, String var1);

    public static char[] getDateFormatOrder(String pattern) {
        char[] result = new char[3];
        int resultIndex = 0;
        boolean sawDay = false;
        boolean sawMonth = false;
        boolean sawYear = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == 'd' || ch == 'L' || ch == 'M' || ch == 'y') {
                if (ch == 'd' && !sawDay) {
                    result[resultIndex++] = 100;
                    sawDay = true;
                    continue;
                }
                if (!(ch != 'L' && ch != 'M' || sawMonth)) {
                    result[resultIndex++] = 77;
                    sawMonth = true;
                    continue;
                }
                if (ch != 'y' || sawYear) continue;
                result[resultIndex++] = 121;
                sawYear = true;
                continue;
            }
            if (ch == 'G') continue;
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                throw new IllegalArgumentException("Bad pattern character '" + ch + "' in " + pattern);
            }
            if (ch != '\'') continue;
            if (i < pattern.length() - 1 && pattern.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            if ((i = pattern.indexOf(39, i + 1)) == -1) {
                throw new IllegalArgumentException("Bad quoting in " + pattern);
            }
            ++i;
        }
        return result;
    }

    public static native String getCldrVersion();

    public static native String getIcuVersion();

    public static native String getUnicodeVersion();

    public static String toLowerCase(String s, Locale locale) {
        return ICU.toLowerCase(s, locale.toLanguageTag());
    }

    private static native String toLowerCase(String var0, String var1);

    public static String toUpperCase(String s, Locale locale) {
        return ICU.toUpperCase(s, locale.toLanguageTag());
    }

    private static native String toUpperCase(String var0, String var1);

    public static boolean U_FAILURE(int error) {
        return error > 0;
    }

    private static native String[] getAvailableBreakIteratorLocalesNative();

    private static native String[] getAvailableCalendarLocalesNative();

    private static native String[] getAvailableCollatorLocalesNative();

    private static native String[] getAvailableDateFormatLocalesNative();

    private static native String[] getAvailableLocalesNative();

    private static native String[] getAvailableNumberFormatLocalesNative();

    public static native String[] getAvailableCurrencyCodes();

    public static native String getCurrencyCode(String var0);

    public static String getCurrencyDisplayName(Locale locale, String currencyCode) {
        return ICU.getCurrencyDisplayName(locale.toLanguageTag(), currencyCode);
    }

    private static native String getCurrencyDisplayName(String var0, String var1);

    public static native int getCurrencyFractionDigits(String var0);

    public static native int getCurrencyNumericCode(String var0);

    public static String getCurrencySymbol(Locale locale, String currencyCode) {
        return ICU.getCurrencySymbol(locale.toLanguageTag(), currencyCode);
    }

    private static native String getCurrencySymbol(String var0, String var1);

    public static String getDisplayCountry(Locale targetLocale, Locale locale) {
        return ICU.getDisplayCountryNative(targetLocale.toLanguageTag(), locale.toLanguageTag());
    }

    private static native String getDisplayCountryNative(String var0, String var1);

    public static String getDisplayLanguage(Locale targetLocale, Locale locale) {
        return ICU.getDisplayLanguageNative(targetLocale.toLanguageTag(), locale.toLanguageTag());
    }

    private static native String getDisplayLanguageNative(String var0, String var1);

    public static String getDisplayVariant(Locale targetLocale, Locale locale) {
        return ICU.getDisplayVariantNative(targetLocale.toLanguageTag(), locale.toLanguageTag());
    }

    private static native String getDisplayVariantNative(String var0, String var1);

    public static String getDisplayScript(Locale targetLocale, Locale locale) {
        return ICU.getDisplayScriptNative(targetLocale.toLanguageTag(), locale.toLanguageTag());
    }

    private static native String getDisplayScriptNative(String var0, String var1);

    public static native String getISO3Country(String var0);

    public static native String getISO3Language(String var0);

    public static Locale addLikelySubtags(Locale locale) {
        return Locale.forLanguageTag(ICU.addLikelySubtags(locale.toLanguageTag()).replace('_', '-'));
    }

    @Deprecated
    public static native String addLikelySubtags(String var0);

    @Deprecated
    public static native String getScript(String var0);

    private static native String[] getISOLanguagesNative();

    private static native String[] getISOCountriesNative();

    static native boolean initLocaleDataNative(String var0, LocaleData var1);

    public static native void setDefaultLocale(String var0);

    public static native String getDefaultLocale();
}

