/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructGroupReq;
import android.system.StructGroupSourceReq;
import android.system.StructLinger;
import android.system.StructPollfd;
import android.system.StructTimeval;
import android.util.MutableInt;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import libcore.io.AsynchronousCloseMonitor;
import libcore.io.IoUtils;
import libcore.io.Libcore;

public final class IoBridge {
    public static final int JAVA_MCAST_JOIN_GROUP = 19;
    public static final int JAVA_MCAST_LEAVE_GROUP = 20;
    public static final int JAVA_MCAST_JOIN_SOURCE_GROUP = 21;
    public static final int JAVA_MCAST_LEAVE_SOURCE_GROUP = 22;
    public static final int JAVA_MCAST_BLOCK_SOURCE = 23;
    public static final int JAVA_MCAST_UNBLOCK_SOURCE = 24;
    public static final int JAVA_IP_MULTICAST_TTL = 17;

    private IoBridge() {
    }

    public static int available(FileDescriptor fd) throws IOException {
        try {
            MutableInt available = new MutableInt(0);
            Libcore.os.ioctlInt(fd, OsConstants.FIONREAD, available);
            if (available.value < 0) {
                available.value = 0;
            }
            return available.value;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.ENOTTY) {
                return 0;
            }
            throw errnoException.rethrowAsIOException();
        }
    }

    public static void bind(FileDescriptor fd, InetAddress address, int port) throws SocketException {
        Inet6Address inet6Address;
        if (address instanceof Inet6Address && (inet6Address = (Inet6Address)address).getScopeId() == 0 && inet6Address.isLinkLocalAddress()) {
            NetworkInterface nif = NetworkInterface.getByInetAddress(address);
            if (nif == null) {
                throw new SocketException("Can't bind to a link-local address without a scope id: " + address);
            }
            try {
                address = Inet6Address.getByAddress(address.getHostName(), address.getAddress(), nif.getIndex());
            }
            catch (UnknownHostException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        try {
            Libcore.os.bind(fd, address, port);
        }
        catch (ErrnoException errnoException) {
            throw new BindException(errnoException.getMessage(), errnoException);
        }
    }

    public static void connect(FileDescriptor fd, InetAddress inetAddress, int port) throws SocketException {
        try {
            IoBridge.connect(fd, inetAddress, port, 0);
        }
        catch (SocketTimeoutException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static void connect(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs) throws SocketException, SocketTimeoutException {
        try {
            IoBridge.connectErrno(fd, inetAddress, port, timeoutMs);
        }
        catch (ErrnoException errnoException) {
            throw new ConnectException(IoBridge.connectDetail(inetAddress, port, timeoutMs, errnoException), errnoException);
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (SocketTimeoutException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    private static void connectErrno(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs) throws ErrnoException, IOException {
        if (timeoutMs == 0) {
            Libcore.os.connect(fd, inetAddress, port);
            return;
        }
        IoUtils.setBlocking(fd, false);
        long finishTimeMs = System.currentTimeMillis() + (long)timeoutMs;
        try {
            Libcore.os.connect(fd, inetAddress, port);
            IoUtils.setBlocking(fd, true);
            return;
        }
        catch (ErrnoException errnoException) {
            int remainingTimeoutMs;
            if (errnoException.errno != OsConstants.EINPROGRESS) {
                throw errnoException;
            }
            do {
                if ((remainingTimeoutMs = (int)(finishTimeMs - System.currentTimeMillis())) > 0) continue;
                throw new SocketTimeoutException(IoBridge.connectDetail(inetAddress, port, timeoutMs, null));
            } while (!IoBridge.isConnected(fd, inetAddress, port, timeoutMs, remainingTimeoutMs));
            IoUtils.setBlocking(fd, true);
            return;
        }
    }

    private static String connectDetail(InetAddress inetAddress, int port, int timeoutMs, ErrnoException cause) {
        String detail = "failed to connect to " + inetAddress + " (port " + port + ")";
        if (timeoutMs > 0) {
            detail = detail + " after " + timeoutMs + "ms";
        }
        if (cause != null) {
            detail = detail + ": " + cause.getMessage();
        }
        return detail;
    }

    public static void closeAndSignalBlockedThreads(FileDescriptor fd) throws IOException {
        if (fd == null || !fd.valid()) {
            return;
        }
        int intFd = fd.getInt$();
        fd.setInt$(-1);
        FileDescriptor oldFd = new FileDescriptor();
        oldFd.setInt$(intFd);
        AsynchronousCloseMonitor.signalBlockedThreads(oldFd);
        try {
            Libcore.os.close(oldFd);
        }
        catch (ErrnoException errnoException) {
            // empty catch block
        }
    }

    public static boolean isConnected(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs, int remainingTimeoutMs) throws IOException {
        try {
            StructPollfd[] pollFds = new StructPollfd[]{new StructPollfd()};
            pollFds[0].fd = fd;
            pollFds[0].events = (short)OsConstants.POLLOUT;
            int rc = Libcore.os.poll(pollFds, remainingTimeoutMs);
            if (rc == 0) {
                return false;
            }
            int connectError = Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_ERROR);
            if (connectError == 0) {
                return true;
            }
            throw new ErrnoException("isConnected", connectError);
        }
        catch (ErrnoException errnoException) {
            if (!fd.valid()) {
                throw new SocketException("Socket closed");
            }
            if (errnoException.errno == OsConstants.EINTR) {
                return false;
            }
            ErrnoException cause = errnoException;
            String detail = IoBridge.connectDetail(inetAddress, port, timeoutMs, cause);
            if (cause.errno == OsConstants.ETIMEDOUT) {
                throw new SocketTimeoutException(detail, cause);
            }
            throw new ConnectException(detail, cause);
        }
    }

    public static Object getSocketOption(FileDescriptor fd, int option) throws SocketException {
        try {
            return IoBridge.getSocketOptionErrno(fd, option);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private static Object getSocketOptionErrno(FileDescriptor fd, int option) throws ErrnoException, SocketException {
        switch (option) {
            case 16: {
                return Libcore.os.getsockoptInAddr(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_IF);
            }
            case 31: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_IF);
            }
            case 18: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_LOOP));
            }
            case 17: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_HOPS);
            }
            case 3: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_TCLASS);
            }
            case 32: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST));
            }
            case 8: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_KEEPALIVE));
            }
            case 128: {
                StructLinger linger = Libcore.os.getsockoptLinger(fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER);
                if (!linger.isOn()) {
                    return false;
                }
                return linger.l_linger;
            }
            case 4099: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_OOBINLINE));
            }
            case 4098: {
                return Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF);
            }
            case 4: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR));
            }
            case 4097: {
                return Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDBUF);
            }
            case 4102: {
                return (int)Libcore.os.getsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO).toMillis();
            }
            case 1: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY));
            }
        }
        throw new SocketException("Unknown socket option: " + option);
    }

    private static boolean booleanFromInt(int i) {
        return i != 0;
    }

    private static int booleanToInt(boolean b) {
        return b ? 1 : 0;
    }

    public static void setSocketOption(FileDescriptor fd, int option, Object value) throws SocketException {
        try {
            IoBridge.setSocketOptionErrno(fd, option, value);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private static void setSocketOptionErrno(FileDescriptor fd, int option, Object value) throws ErrnoException, SocketException {
        switch (option) {
            case 16: {
                throw new UnsupportedOperationException("Use IP_MULTICAST_IF2 on Android");
            }
            case 31: {
                Libcore.os.setsockoptIpMreqn(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_IF, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_IF, (Integer)value);
                return;
            }
            case 18: {
                Libcore.os.setsockoptByte(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_LOOP, IoBridge.booleanToInt((Boolean)value));
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_LOOP, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 17: {
                Libcore.os.setsockoptByte(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_TTL, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_HOPS, (Integer)value);
                return;
            }
            case 3: {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IP, OsConstants.IP_TOS, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_TCLASS, (Integer)value);
                return;
            }
            case 32: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 8: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_KEEPALIVE, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 128: {
                boolean on = false;
                int seconds = 0;
                if (value instanceof Integer) {
                    on = true;
                    seconds = Math.min((Integer)value, 65535);
                }
                StructLinger linger = new StructLinger(IoBridge.booleanToInt(on), seconds);
                Libcore.os.setsockoptLinger(fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER, linger);
                return;
            }
            case 4099: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_OOBINLINE, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 4098: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, (Integer)value);
                return;
            }
            case 4: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 4097: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDBUF, (Integer)value);
                return;
            }
            case 4102: {
                int millis = (Integer)value;
                StructTimeval tv = StructTimeval.fromMillis(millis);
                Libcore.os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, tv);
                return;
            }
            case 1: {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 19: 
            case 20: {
                StructGroupReq groupReq = (StructGroupReq)value;
                int level = groupReq.gr_group instanceof Inet4Address ? OsConstants.IPPROTO_IP : OsConstants.IPPROTO_IPV6;
                int op = option == 19 ? OsConstants.MCAST_JOIN_GROUP : OsConstants.MCAST_LEAVE_GROUP;
                Libcore.os.setsockoptGroupReq(fd, level, op, groupReq);
                return;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                StructGroupSourceReq groupSourceReq = (StructGroupSourceReq)value;
                int level = groupSourceReq.gsr_group instanceof Inet4Address ? OsConstants.IPPROTO_IP : OsConstants.IPPROTO_IPV6;
                int op = IoBridge.getGroupSourceReqOp(option);
                Libcore.os.setsockoptGroupSourceReq(fd, level, op, groupSourceReq);
                return;
            }
        }
        throw new SocketException("Unknown socket option: " + option);
    }

    private static int getGroupSourceReqOp(int javaValue) {
        switch (javaValue) {
            case 21: {
                return OsConstants.MCAST_JOIN_SOURCE_GROUP;
            }
            case 22: {
                return OsConstants.MCAST_LEAVE_SOURCE_GROUP;
            }
            case 23: {
                return OsConstants.MCAST_BLOCK_SOURCE;
            }
            case 24: {
                return OsConstants.MCAST_UNBLOCK_SOURCE;
            }
        }
        throw new AssertionError((Object)("Unknown java value for setsocketopt op lookup: " + javaValue));
    }

    public static FileDescriptor open(String path, int flags) throws FileNotFoundException {
        FileDescriptor fd = null;
        try {
            int mode = (flags & OsConstants.O_ACCMODE) == OsConstants.O_RDONLY ? 0 : 384;
            fd = Libcore.os.open(path, flags, mode);
            if (OsConstants.S_ISDIR(Libcore.os.fstat((FileDescriptor)fd).st_mode)) {
                throw new ErrnoException("open", OsConstants.EISDIR);
            }
            return fd;
        }
        catch (ErrnoException errnoException) {
            try {
                if (fd != null) {
                    IoUtils.close(fd);
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            FileNotFoundException ex = new FileNotFoundException(path + ": " + errnoException.getMessage());
            ex.initCause(errnoException);
            throw ex;
        }
    }

    public static int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount(bytes.length, byteOffset, byteCount);
        if (byteCount == 0) {
            return 0;
        }
        try {
            int readCount = Libcore.os.read(fd, bytes, byteOffset, byteCount);
            if (readCount == 0) {
                return -1;
            }
            return readCount;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                return 0;
            }
            throw errnoException.rethrowAsIOException();
        }
    }

    public static void write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount(bytes.length, byteOffset, byteCount);
        if (byteCount == 0) {
            return;
        }
        try {
            while (byteCount > 0) {
                int bytesWritten = Libcore.os.write(fd, bytes, byteOffset, byteCount);
                byteCount -= bytesWritten;
                byteOffset += bytesWritten;
            }
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws IOException {
        int result;
        boolean isDatagram;
        boolean bl = isDatagram = inetAddress != null;
        if (!isDatagram && byteCount <= 0) {
            return 0;
        }
        try {
            result = Libcore.os.sendto(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterSendto(isDatagram, errnoException);
        }
        return result;
    }

    public static int sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws IOException {
        int result;
        boolean isDatagram;
        boolean bl = isDatagram = inetAddress != null;
        if (!isDatagram && buffer.remaining() == 0) {
            return 0;
        }
        try {
            result = Libcore.os.sendto(fd, buffer, flags, inetAddress, port);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterSendto(isDatagram, errnoException);
        }
        return result;
    }

    private static int maybeThrowAfterSendto(boolean isDatagram, ErrnoException errnoException) throws SocketException {
        if (isDatagram ? errnoException.errno == OsConstants.ECONNRESET || errnoException.errno == OsConstants.ECONNREFUSED : errnoException.errno == OsConstants.EAGAIN) {
            return 0;
        }
        throw errnoException.rethrowAsSocketException();
    }

    public static int recvfrom(boolean isRead, FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, DatagramPacket packet, boolean isConnected) throws IOException {
        int result;
        try {
            InetSocketAddress srcAddress = packet != null && !isConnected ? new InetSocketAddress() : null;
            result = Libcore.os.recvfrom(fd, bytes, byteOffset, byteCount, flags, srcAddress);
            result = IoBridge.postRecvfrom(isRead, packet, isConnected, srcAddress, result);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterRecvfrom(isRead, isConnected, errnoException);
        }
        return result;
    }

    public static int recvfrom(boolean isRead, FileDescriptor fd, ByteBuffer buffer, int flags, DatagramPacket packet, boolean isConnected) throws IOException {
        int result;
        try {
            InetSocketAddress srcAddress = packet != null && !isConnected ? new InetSocketAddress() : null;
            result = Libcore.os.recvfrom(fd, buffer, flags, srcAddress);
            result = IoBridge.postRecvfrom(isRead, packet, isConnected, srcAddress, result);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterRecvfrom(isRead, isConnected, errnoException);
        }
        return result;
    }

    private static int postRecvfrom(boolean isRead, DatagramPacket packet, boolean isConnected, InetSocketAddress srcAddress, int byteCount) {
        if (isRead && byteCount == 0) {
            return -1;
        }
        if (packet != null) {
            packet.setReceivedLength(byteCount);
            if (!isConnected) {
                packet.setAddress(srcAddress.getAddress());
                packet.setPort(srcAddress.getPort());
            }
        }
        return byteCount;
    }

    private static int maybeThrowAfterRecvfrom(boolean isRead, boolean isConnected, ErrnoException errnoException) throws SocketException, SocketTimeoutException {
        if (isRead) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                return 0;
            }
            throw errnoException.rethrowAsSocketException();
        }
        if (isConnected && errnoException.errno == OsConstants.ECONNREFUSED) {
            throw new PortUnreachableException("", errnoException);
        }
        if (errnoException.errno == OsConstants.EAGAIN) {
            throw new SocketTimeoutException(errnoException);
        }
        throw errnoException.rethrowAsSocketException();
    }

    public static FileDescriptor socket(boolean stream) throws SocketException {
        try {
            FileDescriptor fd = Libcore.os.socket(OsConstants.AF_INET6, stream ? OsConstants.SOCK_STREAM : OsConstants.SOCK_DGRAM, 0);
            if (!stream) {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_HOPS, 1);
            }
            return fd;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    public static InetAddress getSocketLocalAddress(FileDescriptor fd) throws SocketException {
        try {
            SocketAddress sa = Libcore.os.getsockname(fd);
            InetSocketAddress isa = (InetSocketAddress)sa;
            return isa.getAddress();
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    public static int getSocketLocalPort(FileDescriptor fd) throws SocketException {
        try {
            SocketAddress sa = Libcore.os.getsockname(fd);
            InetSocketAddress isa = (InetSocketAddress)sa;
            return isa.getPort();
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }
}

