/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import com.android.dex.Dex;
import com.android.dex.EncodedValueReader;
import com.android.dex.FieldId;
import com.android.dex.ProtoId;
import com.android.dex.TypeList;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import libcore.reflect.AnnotationFactory;
import libcore.reflect.AnnotationMember;
import libcore.reflect.InternalNames;
import libcore.util.EmptyArray;

public final class AnnotationAccess {
    private static final Class<?>[] NO_ARGUMENTS = null;
    private static final byte VISIBILITY_BUILD = 0;
    private static final byte VISIBILITY_RUNTIME = 1;
    private static final byte VISIBILITY_SYSTEM = 2;

    private AnnotationAccess() {
    }

    public static <A extends Annotation> A getAnnotation(Class<?> c, Class<A> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        A annotation = AnnotationAccess.getDeclaredAnnotation(c, annotationType);
        if (annotation != null) {
            return annotation;
        }
        if (AnnotationAccess.isInherited(annotationType)) {
            for (Class<?> sup = c.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                annotation = AnnotationAccess.getDeclaredAnnotation(sup, annotationType);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    private static boolean isInherited(Class<? extends Annotation> annotationType) {
        return AnnotationAccess.isDeclaredAnnotationPresent(annotationType, Inherited.class);
    }

    public static Annotation[] getAnnotations(Class<?> c) {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation declaredAnnotation : AnnotationAccess.getDeclaredAnnotations(c)) {
            map.put(declaredAnnotation.annotationType(), declaredAnnotation);
        }
        for (Class<?> sup = c.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
            for (Annotation declaredAnnotation : AnnotationAccess.getDeclaredAnnotations(sup)) {
                Class<? extends Annotation> clazz = declaredAnnotation.annotationType();
                if (map.containsKey(clazz) || !AnnotationAccess.isInherited(clazz)) continue;
                map.put(clazz, declaredAnnotation);
            }
        }
        Collection coll = map.values();
        return coll.toArray(new Annotation[coll.size()]);
    }

    public static boolean isAnnotationPresent(Class<?> c, Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        if (AnnotationAccess.isDeclaredAnnotationPresent(c, annotationType)) {
            return true;
        }
        if (AnnotationAccess.isInherited(annotationType)) {
            for (Class<?> sup = c.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                if (!AnnotationAccess.isDeclaredAnnotationPresent(sup, annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Annotation> getDeclaredAnnotations(AnnotatedElement element) {
        int offset = AnnotationAccess.getAnnotationSetOffset(element);
        return AnnotationAccess.annotationSetToAnnotations(AnnotationAccess.getDexClass(element), offset);
    }

    public static <A extends Annotation> A getDeclaredAnnotation(AnnotatedElement element, Class<A> annotationClass) {
        com.android.dex.Annotation a = AnnotationAccess.getAnnotation(element, annotationClass);
        return a != null ? (A)AnnotationAccess.toAnnotationInstance(AnnotationAccess.getDexClass(element), annotationClass, a) : null;
    }

    public static boolean isDeclaredAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        return AnnotationAccess.getAnnotation(element, annotationClass) != null;
    }

    private static com.android.dex.Annotation getAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        int annotationSetOffset = AnnotationAccess.getAnnotationSetOffset(element);
        if (annotationSetOffset == 0) {
            return null;
        }
        Class<?> dexClass = AnnotationAccess.getDexClass(element);
        Dex dex = dexClass.getDex();
        Dex.Section setIn = dex.open(annotationSetOffset);
        String annotationInternalName = InternalNames.getInternalName(annotationClass);
        int size = setIn.readInt();
        for (int i = 0; i < size; ++i) {
            int annotationOffset = setIn.readInt();
            Dex.Section annotationIn = dex.open(annotationOffset);
            com.android.dex.Annotation candidate = annotationIn.readAnnotation();
            String candidateInternalName = dex.typeNames().get(candidate.getTypeIndex());
            if (!candidateInternalName.equals(annotationInternalName)) continue;
            return candidate;
        }
        return null;
    }

    private static int getAnnotationSetOffset(AnnotatedElement element) {
        Class<?> dexClass = AnnotationAccess.getDexClass(element);
        int directoryOffset = dexClass.getDexAnnotationDirectoryOffset();
        if (directoryOffset == 0) {
            return 0;
        }
        Dex.Section directoryIn = dexClass.getDex().open(directoryOffset);
        int classSetOffset = directoryIn.readInt();
        if (element instanceof Class) {
            return classSetOffset;
        }
        int fieldsSize = directoryIn.readInt();
        int methodsSize = directoryIn.readInt();
        directoryIn.readInt();
        if (element instanceof Field) {
            int fieldIndex = ((Field)element).getDexFieldIndex();
            for (int i = 0; i < fieldsSize; ++i) {
                int candidateFieldIndex = directoryIn.readInt();
                int annotationSetOffset = directoryIn.readInt();
                if (candidateFieldIndex != fieldIndex) continue;
                return annotationSetOffset;
            }
            return 0;
        }
        directoryIn.skip(8 * fieldsSize);
        int methodIndex = element instanceof Method ? ((Method)element).getDexMethodIndex() : ((Constructor)element).getDexMethodIndex();
        for (int i = 0; i < methodsSize; ++i) {
            int candidateMethodIndex = directoryIn.readInt();
            int annotationSetOffset = directoryIn.readInt();
            if (candidateMethodIndex != methodIndex) continue;
            return annotationSetOffset;
        }
        return 0;
    }

    private static Class<?> getDexClass(AnnotatedElement element) {
        return element instanceof Class ? (Class<?>)element : ((Member)((Object)element)).getDeclaringClass();
    }

    public static Annotation[][] getParameterAnnotations(Class<?> declaringClass, int methodDexIndex) {
        int i;
        Dex dex = declaringClass.getDex();
        int protoIndex = dex.methodIds().get(methodDexIndex).getProtoIndex();
        ProtoId proto = dex.protoIds().get(protoIndex);
        TypeList parametersList = dex.readTypeList(proto.getParametersOffset());
        short[] types = parametersList.getTypes();
        int typesCount = types.length;
        int directoryOffset = declaringClass.getDexAnnotationDirectoryOffset();
        if (directoryOffset == 0) {
            return new Annotation[typesCount][0];
        }
        Dex.Section directoryIn = dex.open(directoryOffset);
        directoryIn.readInt();
        int fieldsSize = directoryIn.readInt();
        int methodsSize = directoryIn.readInt();
        int parametersSize = directoryIn.readInt();
        for (i = 0; i < fieldsSize; ++i) {
            directoryIn.readInt();
            directoryIn.readInt();
        }
        for (i = 0; i < methodsSize; ++i) {
            directoryIn.readInt();
            directoryIn.readInt();
        }
        for (i = 0; i < parametersSize; ++i) {
            int candidateMethodDexIndex = directoryIn.readInt();
            int annotationSetRefListOffset = directoryIn.readInt();
            if (candidateMethodDexIndex != methodDexIndex) continue;
            Dex.Section refList = dex.open(annotationSetRefListOffset);
            int parameterCount = refList.readInt();
            Annotation[][] result = new Annotation[parameterCount][];
            for (int p = 0; p < parameterCount; ++p) {
                int annotationSetOffset = refList.readInt();
                List<Annotation> annotations = AnnotationAccess.annotationSetToAnnotations(declaringClass, annotationSetOffset);
                result[p] = annotations.toArray(new Annotation[annotations.size()]);
            }
            return result;
        }
        return new Annotation[typesCount][0];
    }

    public static Object getDefaultValue(Method method) {
        Class<?> annotationClass = method.getDeclaringClass();
        Dex dex = annotationClass.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, annotationClass, "Ldalvik/annotation/AnnotationDefault;");
        if (reader == null) {
            return null;
        }
        int fieldCount = reader.readAnnotation();
        if (reader.getAnnotationType() != annotationClass.getDexTypeIndex()) {
            throw new AssertionError((Object)"annotation value type != annotation class");
        }
        int methodNameIndex = dex.findStringIndex(method.getName());
        for (int i = 0; i < fieldCount; ++i) {
            int candidateNameIndex = reader.readAnnotationName();
            if (candidateNameIndex == methodNameIndex) {
                Class<?> returnType = method.getReturnType();
                return AnnotationAccess.decodeValue(annotationClass, returnType, dex, reader);
            }
            reader.skipValue();
        }
        return null;
    }

    public static Class<?> getEnclosingClass(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, c, "Ldalvik/annotation/EnclosingClass;");
        if (reader == null) {
            return null;
        }
        return c.getDexCacheType(dex, reader.readType());
    }

    public static AccessibleObject getEnclosingMethodOrConstructor(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, c, "Ldalvik/annotation/EnclosingMethod;");
        if (reader == null) {
            return null;
        }
        return AnnotationAccess.indexToMethod(c, dex, reader.readMethod());
    }

    public static Class<?>[] getMemberClasses(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, c, "Ldalvik/annotation/MemberClasses;");
        if (reader == null) {
            return EmptyArray.CLASS;
        }
        return (Class[])AnnotationAccess.decodeValue(c, Class[].class, dex, reader);
    }

    public static String getSignature(AnnotatedElement element) {
        Class<?> dexClass = AnnotationAccess.getDexClass(element);
        Dex dex = dexClass.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, element, "Ldalvik/annotation/Signature;");
        if (reader == null) {
            return null;
        }
        String[] array2 = (String[])AnnotationAccess.decodeValue(dexClass, String[].class, dex, reader);
        StringBuilder result = new StringBuilder();
        for (String s : array2) {
            result.append(s);
        }
        return result.toString();
    }

    public static Class<?>[] getExceptions(AnnotatedElement element) {
        Class<?> dexClass = AnnotationAccess.getDexClass(element);
        Dex dex = dexClass.getDex();
        EncodedValueReader reader = AnnotationAccess.getOnlyAnnotationValue(dex, element, "Ldalvik/annotation/Throws;");
        if (reader == null) {
            return EmptyArray.CLASS;
        }
        return (Class[])AnnotationAccess.decodeValue(dexClass, Class[].class, dex, reader);
    }

    public static int getInnerClassFlags(Class<?> c, int defaultValue) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getAnnotationReader(dex, c, "Ldalvik/annotation/InnerClass;", 2);
        if (reader == null) {
            return defaultValue;
        }
        reader.readAnnotationName();
        return reader.readInt();
    }

    public static String getInnerClassName(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getAnnotationReader(dex, c, "Ldalvik/annotation/InnerClass;", 2);
        if (reader == null) {
            return null;
        }
        reader.readAnnotationName();
        reader.readInt();
        reader.readAnnotationName();
        return reader.peek() == 30 ? null : (String)AnnotationAccess.decodeValue(c, String.class, dex, reader);
    }

    public static boolean isAnonymousClass(Class<?> c) {
        Dex dex = c.getDex();
        EncodedValueReader reader = AnnotationAccess.getAnnotationReader(dex, c, "Ldalvik/annotation/InnerClass;", 2);
        if (reader == null) {
            return false;
        }
        reader.readAnnotationName();
        reader.readInt();
        reader.readAnnotationName();
        return reader.peek() == 30;
    }

    private static EncodedValueReader getAnnotationReader(Dex dex, AnnotatedElement element, String annotationName, int expectedFieldCount) {
        int annotationSetOffset = AnnotationAccess.getAnnotationSetOffset(element);
        if (annotationSetOffset == 0) {
            return null;
        }
        Dex.Section setIn = dex.open(annotationSetOffset);
        com.android.dex.Annotation annotation = null;
        int size = setIn.readInt();
        for (int i = 0; i < size; ++i) {
            int annotationOffset = setIn.readInt();
            Dex.Section annotationIn = dex.open(annotationOffset);
            com.android.dex.Annotation candidate = annotationIn.readAnnotation();
            String candidateAnnotationName = dex.typeNames().get(candidate.getTypeIndex());
            if (!annotationName.equals(candidateAnnotationName)) continue;
            annotation = candidate;
            break;
        }
        if (annotation == null) {
            return null;
        }
        EncodedValueReader reader = annotation.getReader();
        int fieldCount = reader.readAnnotation();
        String readerAnnotationName = dex.typeNames().get(reader.getAnnotationType());
        if (!readerAnnotationName.equals(annotationName)) {
            throw new AssertionError();
        }
        if (fieldCount != expectedFieldCount) {
            return null;
        }
        return reader;
    }

    private static EncodedValueReader getOnlyAnnotationValue(Dex dex, AnnotatedElement element, String annotationName) {
        EncodedValueReader reader = AnnotationAccess.getAnnotationReader(dex, element, annotationName, 1);
        if (reader == null) {
            return null;
        }
        reader.readAnnotationName();
        return reader;
    }

    private static Class<? extends Annotation> getAnnotationClass(Class<?> context, Dex dex, int typeIndex) {
        try {
            Class result = context.getDexCacheType(dex, typeIndex);
            if (!result.isAnnotation()) {
                throw new IncompatibleClassChangeError("Expected annotation: " + result.getName());
            }
            return result;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    private static AccessibleObject indexToMethod(Class<?> context, Dex dex, int methodIndex) {
        Class declaringClass = context.getDexCacheType(dex, dex.declaringClassIndexFromMethodIndex(methodIndex));
        String name = context.getDexCacheString(dex, dex.nameIndexFromMethodIndex(methodIndex));
        short[] types = dex.parameterTypeIndicesFromMethodIndex(methodIndex);
        Object[] parametersArray = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            parametersArray[i] = context.getDexCacheType(dex, types[i]);
        }
        try {
            return name.equals("<init>") ? declaringClass.getDeclaredConstructor((Class<?>[])parametersArray) : declaringClass.getDeclaredMethod(name, (Class<?>[])parametersArray);
        }
        catch (NoSuchMethodException e) {
            throw new IncompatibleClassChangeError("Couldn't find " + declaringClass.getName() + "." + name + Arrays.toString(parametersArray));
        }
    }

    private static List<Annotation> annotationSetToAnnotations(Class<?> context, int offset) {
        if (offset == 0) {
            return Collections.emptyList();
        }
        Dex dex = context.getDex();
        Dex.Section setIn = dex.open(offset);
        int size = setIn.readInt();
        ArrayList<Annotation> result = new ArrayList<Annotation>(size);
        for (int i = 0; i < size; ++i) {
            Class<? extends Annotation> annotationClass;
            int annotationOffset = setIn.readInt();
            Dex.Section annotationIn = dex.open(annotationOffset);
            com.android.dex.Annotation annotation = annotationIn.readAnnotation();
            if (annotation.getVisibility() != 1 || (annotationClass = AnnotationAccess.getAnnotationClass(context, dex, annotation.getTypeIndex())) == null) continue;
            result.add(AnnotationAccess.toAnnotationInstance(context, dex, annotationClass, annotation.getReader()));
        }
        return result;
    }

    private static <A extends Annotation> A toAnnotationInstance(Class<?> context, Class<A> annotationClass, com.android.dex.Annotation annotation) {
        return AnnotationAccess.toAnnotationInstance(context, context.getDex(), annotationClass, annotation.getReader());
    }

    private static <A extends Annotation> A toAnnotationInstance(Class<?> context, Dex dex, Class<A> annotationClass, EncodedValueReader reader) {
        int fieldCount = reader.readAnnotation();
        if (annotationClass != context.getDexCacheType(dex, reader.getAnnotationType())) {
            throw new AssertionError((Object)"annotation value type != return type");
        }
        AnnotationMember[] members = new AnnotationMember[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            Method method;
            int name = reader.readAnnotationName();
            String nameString = dex.strings().get(name);
            try {
                method = annotationClass.getMethod(nameString, NO_ARGUMENTS);
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleClassChangeError("Couldn't find " + annotationClass.getName() + "." + nameString);
            }
            Class<?> returnType = method.getReturnType();
            Object value = AnnotationAccess.decodeValue(context, returnType, dex, reader);
            members[i] = new AnnotationMember(nameString, value, returnType, method);
        }
        return AnnotationFactory.createAnnotation(annotationClass, members);
    }

    private static Object decodeValue(Class<?> context, Class<?> type, Dex dex, EncodedValueReader reader) {
        if (type.isArray()) {
            int size = reader.readArray();
            Class<?> componentType = type.getComponentType();
            Object array2 = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(array2, i, AnnotationAccess.decodeValue(context, componentType, dex, reader));
            }
            return array2;
        }
        if (type.isEnum()) {
            int fieldIndex = reader.readEnum();
            FieldId fieldId = dex.fieldIds().get(fieldIndex);
            String fieldName = dex.strings().get(fieldId.getNameIndex());
            try {
                Field field = type.getDeclaredField(fieldName);
                return field.get(null);
            }
            catch (NoSuchFieldException e) {
                NoSuchFieldError error = new NoSuchFieldError();
                error.initCause(e);
                throw error;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError error = new IllegalAccessError();
                error.initCause(e);
                throw error;
            }
        }
        if (type.isAnnotation()) {
            Class<?> annotationClass = type;
            return AnnotationAccess.toAnnotationInstance(context, dex, annotationClass, reader);
        }
        if (type == String.class) {
            int index = reader.readString();
            return context.getDexCacheString(dex, index);
        }
        if (type == Class.class) {
            int index = reader.readType();
            return context.getDexCacheType(dex, index);
        }
        if (type == Byte.TYPE) {
            return reader.readByte();
        }
        if (type == Short.TYPE) {
            return reader.readShort();
        }
        if (type == Integer.TYPE) {
            return reader.readInt();
        }
        if (type == Long.TYPE) {
            return reader.readLong();
        }
        if (type == Float.TYPE) {
            return Float.valueOf(reader.readFloat());
        }
        if (type == Double.TYPE) {
            return reader.readDouble();
        }
        if (type == Character.TYPE) {
            return Character.valueOf(reader.readChar());
        }
        if (type == Boolean.TYPE) {
            return reader.readBoolean();
        }
        throw new AssertionError((Object)("Unexpected annotation value type: " + type));
    }
}

