/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509.tsp;

import java.math.BigInteger;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1BitString;
import org.apache.harmony.security.asn1.ASN1Integer;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BitString;
import org.apache.harmony.security.x509.tsp.PKIFailureInfo;
import org.apache.harmony.security.x509.tsp.PKIStatus;

public class PKIStatusInfo {
    private final PKIStatus status;
    private final List statusString;
    private final PKIFailureInfo failInfo;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{ASN1Integer.getInstance(), new ASN1SequenceOf(ASN1StringType.UTF8STRING), ASN1BitString.getInstance()}){
        {
            this.setOptional(1);
            this.setOptional(2);
        }

        @Override
        protected void getValues(Object object, Object[] values) {
            PKIStatusInfo psi = (PKIStatusInfo)object;
            values[0] = BigInteger.valueOf(psi.status.getStatus()).toByteArray();
            values[1] = psi.statusString;
            if (psi.failInfo != null) {
                boolean[] failInfoBoolArray = new boolean[PKIFailureInfo.getMaxValue()];
                failInfoBoolArray[((PKIStatusInfo)psi).failInfo.getValue()] = true;
                values[2] = new BitString(failInfoBoolArray);
            } else {
                values[2] = null;
            }
        }

        @Override
        protected Object getDecodedObject(BerInputStream in) {
            Object[] values = (Object[])in.content;
            int failInfoValue = -1;
            if (values[2] != null) {
                boolean[] failInfoBoolArray = ((BitString)values[2]).toBooleanArray();
                for (int i = 0; i < failInfoBoolArray.length; ++i) {
                    if (!failInfoBoolArray[i]) continue;
                    failInfoValue = i;
                    break;
                }
            }
            return new PKIStatusInfo(PKIStatus.getInstance(ASN1Integer.toIntValue(values[0])), (List)values[1], PKIFailureInfo.getInstance(failInfoValue));
        }
    };

    public PKIStatusInfo(PKIStatus pKIStatus, List statusString, PKIFailureInfo failInfo) {
        this.status = pKIStatus;
        this.statusString = statusString;
        this.failInfo = failInfo;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("-- PKIStatusInfo:");
        res.append("\nPKIStatus : ");
        res.append((Object)this.status);
        res.append("\nstatusString:  ");
        res.append(this.statusString);
        res.append("\nfailInfo:  ");
        res.append((Object)this.failInfo);
        res.append("\n-- PKIStatusInfo End\n");
        return res.toString();
    }

    public PKIFailureInfo getFailInfo() {
        return this.failInfo;
    }

    public PKIStatus getStatus() {
        return this.status;
    }

    public List getStatusString() {
        return this.statusString;
    }
}

