/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.IOException;

public class GrantCredentialsPermissionActivity
extends Activity
implements View.OnClickListener {
    public static final String EXTRAS_ACCOUNT = "account";
    public static final String EXTRAS_AUTH_TOKEN_LABEL = "authTokenLabel";
    public static final String EXTRAS_AUTH_TOKEN_TYPE = "authTokenType";
    public static final String EXTRAS_RESPONSE = "response";
    public static final String EXTRAS_ACCOUNT_TYPE_LABEL = "accountTypeLabel";
    public static final String EXTRAS_PACKAGES = "application";
    public static final String EXTRAS_REQUESTING_UID = "uid";
    private Account mAccount;
    private String mAuthTokenType;
    private int mUid;
    private Bundle mResultBundle = null;
    protected LayoutInflater mInflater;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        String accountTypeLabel;
        super.onCreate(savedInstanceState);
        this.setContentView(17367140);
        this.setTitle(17040418);
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        Bundle extras = this.getIntent().getExtras();
        if (extras == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.mAccount = (Account)extras.getParcelable(EXTRAS_ACCOUNT);
        this.mAuthTokenType = extras.getString(EXTRAS_AUTH_TOKEN_TYPE);
        this.mUid = extras.getInt(EXTRAS_REQUESTING_UID);
        PackageManager pm = this.getPackageManager();
        String[] packages = pm.getPackagesForUid(this.mUid);
        if (this.mAccount == null || this.mAuthTokenType == null || packages == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        try {
            accountTypeLabel = this.getAccountLabel(this.mAccount);
        }
        catch (IllegalArgumentException e) {
            this.setResult(0);
            this.finish();
            return;
        }
        final TextView authTokenTypeView = (TextView)this.findViewById(16909108);
        authTokenTypeView.setVisibility(8);
        AccountManagerCallback<String> callback = new AccountManagerCallback<String>(){

            @Override
            public void run(AccountManagerFuture<String> future) {
                try {
                    final String authTokenLabel = future.getResult();
                    if (!TextUtils.isEmpty(authTokenLabel)) {
                        GrantCredentialsPermissionActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (!GrantCredentialsPermissionActivity.this.isFinishing()) {
                                    authTokenTypeView.setText(authTokenLabel);
                                    authTokenTypeView.setVisibility(0);
                                }
                            }
                        });
                    }
                }
                catch (OperationCanceledException e) {
                }
                catch (IOException e) {
                }
                catch (AuthenticatorException authenticatorException) {
                    // empty catch block
                }
            }
        };
        AccountManager.get(this).getAuthTokenLabel(this.mAccount.type, this.mAuthTokenType, callback, null);
        this.findViewById(16909112).setOnClickListener(this);
        this.findViewById(16909111).setOnClickListener(this);
        LinearLayout packagesListView = (LinearLayout)this.findViewById(16909104);
        for (String pkg : packages) {
            String packageLabel;
            try {
                packageLabel = pm.getApplicationLabel(pm.getApplicationInfo(pkg, 0)).toString();
            }
            catch (PackageManager.NameNotFoundException e) {
                packageLabel = pkg;
            }
            packagesListView.addView(this.newPackageView(packageLabel));
        }
        ((TextView)this.findViewById(16909107)).setText(this.mAccount.name);
        ((TextView)this.findViewById(16909106)).setText(accountTypeLabel);
    }

    private String getAccountLabel(Account account) {
        for (AuthenticatorDescription desc : AccountManager.get(this).getAuthenticatorTypes()) {
            if (!desc.type.equals(account.type)) continue;
            try {
                return this.createPackageContext(desc.packageName, 0).getString(desc.labelId);
            }
            catch (PackageManager.NameNotFoundException e) {
                return account.type;
            }
            catch (Resources.NotFoundException e) {
                return account.type;
            }
        }
        return account.type;
    }

    private View newPackageView(String packageLabel) {
        View view = this.mInflater.inflate(0x1090099, null);
        ((TextView)view.findViewById(16909191)).setText(packageLabel);
        return view;
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case 16909112: {
                AccountManager.get(this).updateAppPermission(this.mAccount, this.mAuthTokenType, this.mUid, true);
                Intent result = new Intent();
                result.putExtra("retry", true);
                this.setResult(-1, result);
                this.setAccountAuthenticatorResult(result.getExtras());
                break;
            }
            case 16909111: {
                AccountManager.get(this).updateAppPermission(this.mAccount, this.mAuthTokenType, this.mUid, false);
                this.setResult(0);
            }
        }
        this.finish();
    }

    public final void setAccountAuthenticatorResult(Bundle result) {
        this.mResultBundle = result;
    }

    @Override
    public void finish() {
        Intent intent = this.getIntent();
        AccountAuthenticatorResponse response = (AccountAuthenticatorResponse)intent.getParcelableExtra(EXTRAS_RESPONSE);
        if (response != null) {
            if (this.mResultBundle != null) {
                response.onResult(this.mResultBundle);
            } else {
                response.onError(4, "canceled");
            }
        }
        super.finish();
    }
}

