/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.ValueAnimator;
import android.view.animation.AnimationUtils;

public class TimeAnimator
extends ValueAnimator {
    private TimeListener mListener;
    private long mPreviousTime = -1L;

    @Override
    public void start() {
        this.mPreviousTime = -1L;
        super.start();
    }

    @Override
    boolean animationFrame(long currentTime) {
        if (this.mListener != null) {
            long totalTime = currentTime - this.mStartTime;
            long deltaTime = this.mPreviousTime < 0L ? 0L : currentTime - this.mPreviousTime;
            this.mPreviousTime = currentTime;
            this.mListener.onTimeUpdate(this, totalTime, deltaTime);
        }
        return false;
    }

    @Override
    public void setCurrentPlayTime(long playTime) {
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartTime = Math.max(this.mStartTime, currentTime - playTime);
        this.mStartTimeCommitted = true;
        this.animationFrame(currentTime);
    }

    public void setTimeListener(TimeListener listener) {
        this.mListener = listener;
    }

    @Override
    void animateValue(float fraction2) {
    }

    @Override
    void initAnimation() {
    }

    public static interface TimeListener {
        public void onTimeUpdate(TimeAnimator var1, long var2, long var4);
    }
}

