/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.os.Looper;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.view.Choreographer;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.HashMap;

public class ValueAnimator
extends Animator {
    private static final String TAG = "ValueAnimator";
    private static final boolean DEBUG = false;
    private static float sDurationScale = 1.0f;
    static final int STOPPED = 0;
    static final int RUNNING = 1;
    static final int SEEKED = 2;
    long mStartTime;
    boolean mStartTimeCommitted;
    float mSeekFraction = -1.0f;
    private long mPauseTime;
    private boolean mResumed = false;
    protected static ThreadLocal<AnimationHandler> sAnimationHandler = new ThreadLocal();
    private static final TimeInterpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    private boolean mPlayingBackwards = false;
    private boolean mReversing;
    private int mCurrentIteration = 0;
    private float mCurrentFraction = 0.0f;
    private boolean mStartedDelay = false;
    private long mDelayStartTime;
    int mPlayingState = 0;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mStartListenersCalled = false;
    boolean mInitialized = false;
    private long mDuration = (long)(300.0f * sDurationScale);
    private long mUnscaledDuration = 300L;
    private long mStartDelay = 0L;
    private long mUnscaledStartDelay = 0L;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private TimeInterpolator mInterpolator = sDefaultInterpolator;
    ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public static void setDurationScale(float durationScale) {
        sDurationScale = durationScale;
    }

    public static float getDurationScale() {
        return sDurationScale;
    }

    public static ValueAnimator ofInt(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        return anim2;
    }

    public static ValueAnimator ofArgb(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        anim2.setEvaluator(ArgbEvaluator.getInstance());
        return anim2;
    }

    public static ValueAnimator ofFloat(float ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setFloatValues(values);
        return anim2;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setValues(values);
        return anim2;
    }

    public static ValueAnimator ofObject(TypeEvaluator evaluator, Object ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    public void setIntValues(int ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setIntValues(values);
        }
        this.mInitialized = false;
    }

    public void setFloatValues(float ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setFloatValues(values);
        }
        this.mInitialized = false;
    }

    public void setObjectValues(Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", null, values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setObjectValues(values);
        }
        this.mInitialized = false;
    }

    public void setValues(PropertyValuesHolder ... values) {
        int numValues = values.length;
        this.mValues = values;
        this.mValuesMap = new HashMap(numValues);
        for (int i = 0; i < numValues; ++i) {
            PropertyValuesHolder valuesHolder = values[i];
            this.mValuesMap.put(valuesHolder.getPropertyName(), valuesHolder);
        }
        this.mInitialized = false;
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    void initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].init();
            }
            this.mInitialized = true;
        }
    }

    @Override
    public ValueAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mUnscaledDuration = duration;
        this.updateScaledDuration();
        return this;
    }

    private void updateScaledDuration() {
        this.mDuration = (long)((float)this.mUnscaledDuration * sDurationScale);
    }

    @Override
    public long getDuration() {
        return this.mUnscaledDuration;
    }

    public void setCurrentPlayTime(long playTime) {
        float fraction2 = this.mUnscaledDuration > 0L ? (float)playTime / (float)this.mUnscaledDuration : 1.0f;
        this.setCurrentFraction(fraction2);
    }

    public void setCurrentFraction(float fraction2) {
        this.initAnimation();
        if (fraction2 < 0.0f) {
            fraction2 = 0.0f;
        }
        int iteration = (int)fraction2;
        if (fraction2 == 1.0f) {
            --iteration;
        } else if (fraction2 > 1.0f) {
            if (iteration < this.mRepeatCount + 1 || this.mRepeatCount == -1) {
                if (this.mRepeatMode == 2) {
                    this.mPlayingBackwards = iteration % 2 != 0;
                }
                fraction2 %= 1.0f;
            } else {
                fraction2 = 1.0f;
                --iteration;
            }
        } else {
            this.mPlayingBackwards = this.mReversing;
        }
        this.mCurrentIteration = iteration;
        long seekTime = (long)((float)this.mDuration * fraction2);
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartTime = currentTime - seekTime;
        this.mStartTimeCommitted = true;
        if (this.mPlayingState != 1) {
            this.mSeekFraction = fraction2;
            this.mPlayingState = 2;
        }
        if (this.mPlayingBackwards) {
            fraction2 = 1.0f - fraction2;
        }
        this.animateValue(fraction2);
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || this.mPlayingState == 0) {
            return 0L;
        }
        return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
    }

    @Override
    public long getStartDelay() {
        return this.mUnscaledStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        this.mStartDelay = (long)((float)startDelay * sDurationScale);
        this.mUnscaledStartDelay = startDelay;
    }

    public static long getFrameDelay() {
        return Choreographer.getFrameDelay();
    }

    public static void setFrameDelay(long frameDelay) {
        Choreographer.setFrameDelay(frameDelay);
    }

    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    public Object getAnimatedValue(String propertyName) {
        PropertyValuesHolder valuesHolder = this.mValuesMap.get(propertyName);
        if (valuesHolder != null) {
            return valuesHolder.getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int value) {
        this.mRepeatCount = value;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int value) {
        this.mRepeatMode = value;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void addUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(listener);
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    public void removeUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(listener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    @Override
    public void setInterpolator(TimeInterpolator value) {
        this.mInterpolator = value != null ? value : new LinearInterpolator();
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(TypeEvaluator value) {
        if (value != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(value);
        }
    }

    private void notifyStartListeners() {
        if (this.mListeners != null && !this.mStartListenersCalled) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this);
            }
        }
        this.mStartListenersCalled = true;
    }

    private void start(boolean playBackwards) {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mReversing = playBackwards;
        this.mPlayingBackwards = playBackwards;
        if (playBackwards && this.mSeekFraction != -1.0f) {
            this.mSeekFraction = this.mSeekFraction == 0.0f && this.mCurrentIteration == 0 ? 0.0f : (this.mRepeatCount == -1 ? 1.0f - this.mSeekFraction % 1.0f : (float)(1 + this.mRepeatCount) - ((float)this.mCurrentIteration + this.mSeekFraction));
            this.mCurrentIteration = (int)this.mSeekFraction;
            this.mSeekFraction %= 1.0f;
        }
        if (this.mCurrentIteration > 0 && this.mRepeatMode == 2 && (this.mCurrentIteration < this.mRepeatCount + 1 || this.mRepeatCount == -1)) {
            this.mPlayingBackwards = playBackwards ? this.mCurrentIteration % 2 == 0 : this.mCurrentIteration % 2 != 0;
        }
        int prevPlayingState = this.mPlayingState;
        this.mPlayingState = 0;
        this.mStarted = true;
        this.mStartedDelay = false;
        this.mPaused = false;
        this.updateScaledDuration();
        AnimationHandler animationHandler = ValueAnimator.getOrCreateAnimationHandler();
        animationHandler.mPendingAnimations.add(this);
        if (this.mStartDelay == 0L) {
            if (prevPlayingState != 2) {
                this.setCurrentPlayTime(0L);
            }
            this.mPlayingState = 0;
            this.mRunning = true;
            this.notifyStartListeners();
        }
        animationHandler.start();
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public void cancel() {
        AnimationHandler handler = ValueAnimator.getOrCreateAnimationHandler();
        if (this.mPlayingState != 0 || handler.mPendingAnimations.contains(this) || handler.mDelayedAnims.contains(this)) {
            if ((this.mStarted || this.mRunning) && this.mListeners != null) {
                if (!this.mRunning) {
                    this.notifyStartListeners();
                }
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationCancel(this);
                }
            }
            this.endAnimation(handler);
        }
    }

    @Override
    public void end() {
        AnimationHandler handler = ValueAnimator.getOrCreateAnimationHandler();
        if (!handler.mAnimations.contains(this) && !handler.mPendingAnimations.contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation(handler);
            this.mStarted = true;
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        this.animateValue(this.mPlayingBackwards ? 0.0f : 1.0f);
        this.endAnimation(handler);
    }

    @Override
    public void resume() {
        if (this.mPaused) {
            this.mResumed = true;
        }
        super.resume();
    }

    @Override
    public void pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
            this.mResumed = false;
        }
    }

    @Override
    public boolean isRunning() {
        return this.mPlayingState == 1 || this.mRunning;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public void reverse() {
        boolean bl = this.mPlayingBackwards = !this.mPlayingBackwards;
        if (this.mPlayingState == 1) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long currentPlayTime = currentTime - this.mStartTime;
            long timeLeft = this.mDuration - currentPlayTime;
            this.mStartTime = currentTime - timeLeft;
            this.mStartTimeCommitted = true;
            this.mReversing = !this.mReversing;
        } else if (this.mStarted) {
            this.end();
        } else {
            this.start(true);
        }
    }

    @Override
    public boolean canReverse() {
        return true;
    }

    protected void endAnimation(AnimationHandler handler) {
        handler.mAnimations.remove(this);
        handler.mPendingAnimations.remove(this);
        handler.mDelayedAnims.remove(this);
        this.mPlayingState = 0;
        this.mPaused = false;
        if ((this.mStarted || this.mRunning) && this.mListeners != null) {
            if (!this.mRunning) {
                this.notifyStartListeners();
            }
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
            }
        }
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mPlayingBackwards = false;
        this.mReversing = false;
        this.mCurrentIteration = 0;
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceEnd(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
    }

    private void startAnimation(AnimationHandler handler) {
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceBegin(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
        this.initAnimation();
        handler.mAnimations.add(this);
        if (this.mStartDelay > 0L && this.mListeners != null) {
            this.notifyStartListeners();
        }
    }

    String getNameForTrace() {
        return "animator";
    }

    private boolean delayedAnimationFrame(long currentTime) {
        long deltaTime;
        if (!this.mStartedDelay) {
            this.mStartedDelay = true;
            this.mDelayStartTime = currentTime;
        }
        if (this.mPaused) {
            if (this.mPauseTime < 0L) {
                this.mPauseTime = currentTime;
            }
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mDelayStartTime += currentTime - this.mPauseTime;
            }
        }
        if ((deltaTime = currentTime - this.mDelayStartTime) > this.mStartDelay) {
            this.mStartTime = this.mDelayStartTime + this.mStartDelay;
            this.mStartTimeCommitted = true;
            this.mPlayingState = 1;
            return true;
        }
        return false;
    }

    void commitAnimationFrame(long adjustment) {
        if (!this.mStartTimeCommitted) {
            this.mStartTimeCommitted = true;
            if (this.mPlayingState == 1 && adjustment > 0L) {
                this.mStartTime += adjustment;
            }
        }
    }

    boolean animationFrame(long currentTime) {
        boolean done = false;
        switch (this.mPlayingState) {
            case 1: 
            case 2: {
                float fraction2;
                float f = fraction2 = this.mDuration > 0L ? (float)(currentTime - this.mStartTime) / (float)this.mDuration : 1.0f;
                if (this.mDuration == 0L && this.mRepeatCount != -1) {
                    this.mCurrentIteration = this.mRepeatCount;
                    if (!this.mReversing) {
                        this.mPlayingBackwards = false;
                    }
                }
                if (fraction2 >= 1.0f) {
                    if (this.mCurrentIteration < this.mRepeatCount || this.mRepeatCount == -1) {
                        if (this.mListeners != null) {
                            int numListeners = this.mListeners.size();
                            for (int i = 0; i < numListeners; ++i) {
                                ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                            }
                        }
                        if (this.mRepeatMode == 2) {
                            this.mPlayingBackwards = !this.mPlayingBackwards;
                        }
                        this.mCurrentIteration += (int)fraction2;
                        fraction2 %= 1.0f;
                        this.mStartTime += this.mDuration;
                    } else {
                        done = true;
                        fraction2 = Math.min(fraction2, 1.0f);
                    }
                }
                if (this.mPlayingBackwards) {
                    fraction2 = 1.0f - fraction2;
                }
                this.animateValue(fraction2);
            }
        }
        return done;
    }

    final boolean doAnimationFrame(long frameTime) {
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            if (this.mSeekFraction < 0.0f) {
                this.mStartTime = frameTime;
            } else {
                long seekTime = (long)((float)this.mDuration * this.mSeekFraction);
                this.mStartTime = frameTime - seekTime;
                this.mSeekFraction = -1.0f;
            }
            this.mStartTimeCommitted = false;
        }
        if (this.mPaused) {
            if (this.mPauseTime < 0L) {
                this.mPauseTime = frameTime;
            }
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mStartTime += frameTime - this.mPauseTime;
                this.mStartTimeCommitted = false;
            }
        }
        long currentTime = Math.max(frameTime, this.mStartTime);
        return this.animationFrame(currentTime);
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    void animateValue(float fraction2) {
        this.mCurrentFraction = fraction2 = this.mInterpolator.getInterpolation(fraction2);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].calculateValue(fraction2);
        }
        if (this.mUpdateListeners != null) {
            int numListeners = this.mUpdateListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mUpdateListeners.get(i).onAnimationUpdate(this);
            }
        }
    }

    @Override
    public ValueAnimator clone() {
        ValueAnimator anim2 = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            anim2.mUpdateListeners = new ArrayList<AnimatorUpdateListener>(this.mUpdateListeners);
        }
        anim2.mSeekFraction = -1.0f;
        anim2.mPlayingBackwards = false;
        anim2.mReversing = false;
        anim2.mCurrentIteration = 0;
        anim2.mInitialized = false;
        anim2.mPlayingState = 0;
        anim2.mStartedDelay = false;
        anim2.mStarted = false;
        anim2.mRunning = false;
        anim2.mPaused = false;
        anim2.mResumed = false;
        anim2.mStartListenersCalled = false;
        anim2.mStartTime = 0L;
        anim2.mStartTimeCommitted = false;
        anim2.mPauseTime = 0L;
        anim2.mCurrentFraction = 0.0f;
        anim2.mDelayStartTime = 0L;
        PropertyValuesHolder[] oldValues = this.mValues;
        if (oldValues != null) {
            int numValues = oldValues.length;
            anim2.mValues = new PropertyValuesHolder[numValues];
            anim2.mValuesMap = new HashMap(numValues);
            for (int i = 0; i < numValues; ++i) {
                PropertyValuesHolder newValuesHolder;
                anim2.mValues[i] = newValuesHolder = oldValues[i].clone();
                anim2.mValuesMap.put(newValuesHolder.getPropertyName(), newValuesHolder);
            }
        }
        return anim2;
    }

    public static int getCurrentAnimationsCount() {
        AnimationHandler handler = sAnimationHandler.get();
        return handler != null ? handler.mAnimations.size() : 0;
    }

    public static void clearAllAnimations() {
        AnimationHandler handler = sAnimationHandler.get();
        if (handler != null) {
            handler.mAnimations.clear();
            handler.mPendingAnimations.clear();
            handler.mDelayedAnims.clear();
        }
    }

    private static AnimationHandler getOrCreateAnimationHandler() {
        AnimationHandler handler = sAnimationHandler.get();
        if (handler == null) {
            handler = new AnimationHandler();
            sAnimationHandler.set(handler);
        }
        return handler;
    }

    public String toString() {
        String returnVal = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }

    @Override
    public void setAllowRunningAsynchronously(boolean mayRunAsync) {
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimator var1);
    }

    protected static class AnimationHandler {
        protected final ArrayList<ValueAnimator> mAnimations = new ArrayList();
        private final ArrayList<ValueAnimator> mTmpAnimations = new ArrayList();
        protected final ArrayList<ValueAnimator> mPendingAnimations = new ArrayList();
        protected final ArrayList<ValueAnimator> mDelayedAnims = new ArrayList();
        private final ArrayList<ValueAnimator> mEndingAnims = new ArrayList();
        private final ArrayList<ValueAnimator> mReadyAnims = new ArrayList();
        private final Choreographer mChoreographer;
        private boolean mAnimationScheduled;
        private long mLastFrameTime;
        final Runnable mAnimate = new Runnable(){

            @Override
            public void run() {
                AnimationHandler.this.mAnimationScheduled = false;
                AnimationHandler.this.doAnimationFrame(AnimationHandler.this.mChoreographer.getFrameTime());
            }
        };
        final Runnable mCommit = new Runnable(){

            @Override
            public void run() {
                AnimationHandler.this.commitAnimationFrame(AnimationHandler.this.mChoreographer.getFrameTime());
            }
        };

        private AnimationHandler() {
            this.mChoreographer = Choreographer.getInstance();
        }

        public void start() {
            this.scheduleAnimation();
        }

        void doAnimationFrame(long frameTime) {
            int i;
            ValueAnimator anim2;
            this.mLastFrameTime = frameTime;
            while (this.mPendingAnimations.size() > 0) {
                ArrayList pendingCopy = (ArrayList)this.mPendingAnimations.clone();
                this.mPendingAnimations.clear();
                int count = pendingCopy.size();
                for (int i2 = 0; i2 < count; ++i2) {
                    anim2 = (ValueAnimator)pendingCopy.get(i2);
                    if (anim2.mStartDelay == 0L) {
                        anim2.startAnimation(this);
                        continue;
                    }
                    this.mDelayedAnims.add(anim2);
                }
            }
            int numDelayedAnims = this.mDelayedAnims.size();
            for (int i3 = 0; i3 < numDelayedAnims; ++i3) {
                ValueAnimator anim3 = this.mDelayedAnims.get(i3);
                if (!anim3.delayedAnimationFrame(frameTime)) continue;
                this.mReadyAnims.add(anim3);
            }
            int numReadyAnims = this.mReadyAnims.size();
            if (numReadyAnims > 0) {
                for (int i4 = 0; i4 < numReadyAnims; ++i4) {
                    anim2 = this.mReadyAnims.get(i4);
                    anim2.startAnimation(this);
                    anim2.mRunning = true;
                    this.mDelayedAnims.remove(anim2);
                }
                this.mReadyAnims.clear();
            }
            int numAnims = this.mAnimations.size();
            for (i = 0; i < numAnims; ++i) {
                this.mTmpAnimations.add(this.mAnimations.get(i));
            }
            for (i = 0; i < numAnims; ++i) {
                ValueAnimator anim4 = this.mTmpAnimations.get(i);
                if (!this.mAnimations.contains(anim4) || !anim4.doAnimationFrame(frameTime)) continue;
                this.mEndingAnims.add(anim4);
            }
            this.mTmpAnimations.clear();
            if (this.mEndingAnims.size() > 0) {
                for (i = 0; i < this.mEndingAnims.size(); ++i) {
                    this.mEndingAnims.get(i).endAnimation(this);
                }
                this.mEndingAnims.clear();
            }
            this.mChoreographer.postCallback(3, this.mCommit, null);
            if (!this.mAnimations.isEmpty() || !this.mDelayedAnims.isEmpty()) {
                this.scheduleAnimation();
            }
        }

        void commitAnimationFrame(long frameTime) {
            long adjustment = frameTime - this.mLastFrameTime;
            int numAnims = this.mAnimations.size();
            for (int i = 0; i < numAnims; ++i) {
                this.mAnimations.get(i).commitAnimationFrame(adjustment);
            }
        }

        private void scheduleAnimation() {
            if (!this.mAnimationScheduled) {
                this.mChoreographer.postCallback(1, this.mAnimate, null);
                this.mAnimationScheduled = true;
            }
        }
    }
}

