/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityManagerProxy;
import android.app.ActivityOptions;
import android.app.ApplicationErrorReport;
import android.app.ApplicationThreadNative;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IProcessObserver;
import android.app.IServiceConnection;
import android.app.IStopUserCallback;
import android.app.ITaskStackListener;
import android.app.IUiAutomationConnection;
import android.app.IUidObserver;
import android.app.IUserSwitchObserver;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.ProfilerInfo;
import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.UriPermission;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.service.voice.IVoiceInteractionSession;
import android.text.TextUtils;
import android.util.Singleton;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.List;

public abstract class ActivityManagerNative
extends Binder
implements IActivityManager {
    static boolean sSystemReady = false;
    private static final Singleton<IActivityManager> gDefault = new Singleton<IActivityManager>(){

        @Override
        protected IActivityManager create() {
            IBinder b = ServiceManager.getService("activity");
            IActivityManager am = ActivityManagerNative.asInterface(b);
            return am;
        }
    };

    public static IActivityManager asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IActivityManager in = (IActivityManager)obj.queryLocalInterface("android.app.IActivityManager");
        if (in != null) {
            return in;
        }
        return new ActivityManagerProxy(obj);
    }

    public static IActivityManager getDefault() {
        return gDefault.get();
    }

    public static boolean isSystemReady() {
        if (!sSystemReady) {
            sSystemReady = ActivityManagerNative.getDefault().testIsSystemReady();
        }
        return sSystemReady;
    }

    public static void broadcastStickyIntent(Intent intent, String permission2, int userId) {
        ActivityManagerNative.broadcastStickyIntent(intent, permission2, -1, userId);
    }

    public static void broadcastStickyIntent(Intent intent, String permission2, int appOp, int userId) {
        try {
            ActivityManagerNative.getDefault().broadcastIntent(null, intent, null, null, -1, null, null, null, appOp, null, false, true, userId);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public static void noteWakeupAlarm(PendingIntent ps, int sourceUid, String sourcePkg, String tag) {
        try {
            ActivityManagerNative.getDefault().noteWakeupAlarm(ps.getTarget(), sourceUid, sourcePkg, tag);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public static void noteAlarmStart(PendingIntent ps, int sourceUid, String tag) {
        try {
            ActivityManagerNative.getDefault().noteAlarmStart(ps.getTarget(), sourceUid, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static void noteAlarmFinish(PendingIntent ps, int sourceUid, String tag) {
        try {
            ActivityManagerNative.getDefault().noteAlarmFinish(ps.getTarget(), sourceUid, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ActivityManagerNative() {
        this.attachInterface(this, "android.app.IActivityManager");
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        switch (code) {
            case 3: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String callingPackage = data.readString();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                int startFlags = data.readInt();
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                int result = this.startActivity(app, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, options);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 153: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String callingPackage = data.readString();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                int startFlags = data.readInt();
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                int userId = data.readInt();
                int result = this.startActivityAsUser(app, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, options, userId);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 233: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String callingPackage = data.readString();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                int startFlags = data.readInt();
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                boolean ignoreTargetSecurity = data.readInt() != 0;
                int userId = data.readInt();
                int result = this.startActivityAsCaller(app, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, options, ignoreTargetSecurity, userId);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 105: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String callingPackage = data.readString();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                int startFlags = data.readInt();
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                int userId = data.readInt();
                IActivityManager.WaitResult result = this.startActivityAndWait(app, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, options, userId);
                reply.writeNoException();
                result.writeToParcel(reply, 0);
                return true;
            }
            case 107: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String callingPackage = data.readString();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                int startFlags = data.readInt();
                Configuration config = Configuration.CREATOR.createFromParcel(data);
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                int userId = data.readInt();
                int result = this.startActivityWithConfig(app, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, config, options, userId);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 100: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                IntentSender intent = IntentSender.CREATOR.createFromParcel(data);
                Intent fillInIntent = null;
                if (data.readInt() != 0) {
                    fillInIntent = Intent.CREATOR.createFromParcel(data);
                }
                String resolvedType = data.readString();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                int flagsMask = data.readInt();
                int flagsValues = data.readInt();
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                int result = this.startActivityIntentSender(app, intent, fillInIntent, resolvedType, resultTo, resultWho, requestCode, flagsMask, flagsValues, options);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 219: {
                data.enforceInterface("android.app.IActivityManager");
                String callingPackage = data.readString();
                int callingPid = data.readInt();
                int callingUid = data.readInt();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                IVoiceInteractionSession session = IVoiceInteractionSession.Stub.asInterface(data.readStrongBinder());
                IVoiceInteractor interactor = IVoiceInteractor.Stub.asInterface(data.readStrongBinder());
                int startFlags = data.readInt();
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                int userId = data.readInt();
                int result = this.startVoiceActivity(callingPackage, callingPid, callingUid, intent, resolvedType, session, interactor, startFlags, profilerInfo, options, userId);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 67: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder callingActivity = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                boolean result = this.startNextMatchingActivity(callingActivity, intent, options);
                reply.writeNoException();
                reply.writeInt(result ? 1 : 0);
                return true;
            }
            case 230: {
                data.enforceInterface("android.app.IActivityManager");
                int taskId = data.readInt();
                Bundle options = data.readInt() == 0 ? null : Bundle.CREATOR.createFromParcel(data);
                int result = this.startActivityFromRecents(taskId, options);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 11: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Intent resultData = null;
                int resultCode = data.readInt();
                if (data.readInt() != 0) {
                    resultData = Intent.CREATOR.createFromParcel(data);
                }
                boolean finishTask = data.readInt() != 0;
                boolean res = this.finishActivity(token, resultCode, resultData, finishTask);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 32: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                this.finishSubActivity(token, resultWho, requestCode);
                reply.writeNoException();
                return true;
            }
            case 149: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean res = this.finishActivityAffinity(token);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 224: {
                data.enforceInterface("android.app.IActivityManager");
                IVoiceInteractionSession session = IVoiceInteractionSession.Stub.asInterface(data.readStrongBinder());
                this.finishVoiceTask(session);
                reply.writeNoException();
                return true;
            }
            case 236: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean res = this.releaseActivityInstance(token);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 237: {
                data.enforceInterface("android.app.IActivityManager");
                IApplicationThread app = ApplicationThreadNative.asInterface(data.readStrongBinder());
                this.releaseSomeActivities(app);
                reply.writeNoException();
                return true;
            }
            case 106: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean res = this.willActivityBeVisible(token);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 12: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = b != null ? ApplicationThreadNative.asInterface(b) : null;
                String packageName = data.readString();
                b = data.readStrongBinder();
                IIntentReceiver rec = b != null ? IIntentReceiver.Stub.asInterface(b) : null;
                IntentFilter filter = IntentFilter.CREATOR.createFromParcel(data);
                String perm = data.readString();
                int userId = data.readInt();
                Intent intent = this.registerReceiver(app, packageName, rec, filter, perm, userId);
                reply.writeNoException();
                if (intent != null) {
                    reply.writeInt(1);
                    intent.writeToParcel(reply, 0);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 13: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                if (b == null) {
                    return true;
                }
                IIntentReceiver rec = IIntentReceiver.Stub.asInterface(b);
                this.unregisterReceiver(rec);
                reply.writeNoException();
                return true;
            }
            case 14: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = b != null ? ApplicationThreadNative.asInterface(b) : null;
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                b = data.readStrongBinder();
                IIntentReceiver resultTo = b != null ? IIntentReceiver.Stub.asInterface(b) : null;
                int resultCode = data.readInt();
                String resultData = data.readString();
                Bundle resultExtras = data.readBundle();
                String[] perms = data.readStringArray();
                int appOp = data.readInt();
                Bundle options = data.readBundle();
                boolean serialized = data.readInt() != 0;
                boolean sticky = data.readInt() != 0;
                int userId = data.readInt();
                int res = this.broadcastIntent(app, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, perms, appOp, options, serialized, sticky, userId);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 15: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = b != null ? ApplicationThreadNative.asInterface(b) : null;
                Intent intent = Intent.CREATOR.createFromParcel(data);
                int userId = data.readInt();
                this.unbroadcastIntent(app, intent, userId);
                reply.writeNoException();
                return true;
            }
            case 16: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder who = data.readStrongBinder();
                int resultCode = data.readInt();
                String resultData = data.readString();
                Bundle resultExtras = data.readBundle();
                boolean resultAbort = data.readInt() != 0;
                int intentFlags = data.readInt();
                if (who != null) {
                    this.finishReceiver(who, resultCode, resultData, resultExtras, resultAbort, intentFlags);
                }
                reply.writeNoException();
                return true;
            }
            case 17: {
                data.enforceInterface("android.app.IActivityManager");
                IApplicationThread app = ApplicationThreadNative.asInterface(data.readStrongBinder());
                if (app != null) {
                    this.attachApplication(app);
                }
                reply.writeNoException();
                return true;
            }
            case 18: {
                boolean stopProfiling;
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Configuration config = null;
                if (data.readInt() != 0) {
                    config = Configuration.CREATOR.createFromParcel(data);
                }
                boolean bl = stopProfiling = data.readInt() != 0;
                if (token != null) {
                    this.activityIdle(token, config, stopProfiling);
                }
                reply.writeNoException();
                return true;
            }
            case 39: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.activityResumed(token);
                reply.writeNoException();
                return true;
            }
            case 19: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.activityPaused(token);
                reply.writeNoException();
                return true;
            }
            case 20: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Bundle map = data.readBundle();
                PersistableBundle persistentState = data.readPersistableBundle();
                CharSequence description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data);
                this.activityStopped(token, map, persistentState, description);
                reply.writeNoException();
                return true;
            }
            case 123: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.activitySlept(token);
                reply.writeNoException();
                return true;
            }
            case 62: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.activityDestroyed(token);
                reply.writeNoException();
                return true;
            }
            case 21: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                String res = token != null ? this.getCallingPackage(token) : null;
                reply.writeNoException();
                reply.writeString(res);
                return true;
            }
            case 22: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                ComponentName cn = this.getCallingActivity(token);
                reply.writeNoException();
                ComponentName.writeToParcel(cn, reply);
                return true;
            }
            case 221: {
                data.enforceInterface("android.app.IActivityManager");
                String callingPackage = data.readString();
                List<IAppTask> list = this.getAppTasks(callingPackage);
                reply.writeNoException();
                int N = list != null ? list.size() : -1;
                reply.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    IAppTask task = list.get(i);
                    reply.writeStrongBinder(task.asBinder());
                }
                return true;
            }
            case 234: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder activityToken = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                ActivityManager.TaskDescription descr = ActivityManager.TaskDescription.CREATOR.createFromParcel(data);
                Bitmap thumbnail = Bitmap.CREATOR.createFromParcel(data);
                int res = this.addAppTask(activityToken, intent, descr, thumbnail);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 235: {
                data.enforceInterface("android.app.IActivityManager");
                Point size = this.getAppTaskThumbnailSize();
                reply.writeNoException();
                size.writeToParcel(reply, 0);
                return true;
            }
            case 23: {
                data.enforceInterface("android.app.IActivityManager");
                int maxNum = data.readInt();
                int fl = data.readInt();
                List<ActivityManager.RunningTaskInfo> list = this.getTasks(maxNum, fl);
                reply.writeNoException();
                int N = list != null ? list.size() : -1;
                reply.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    ActivityManager.RunningTaskInfo info = list.get(i);
                    info.writeToParcel(reply, 0);
                }
                return true;
            }
            case 60: {
                data.enforceInterface("android.app.IActivityManager");
                int maxNum = data.readInt();
                int fl = data.readInt();
                int userId = data.readInt();
                List<ActivityManager.RecentTaskInfo> list = this.getRecentTasks(maxNum, fl, userId);
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 82: {
                data.enforceInterface("android.app.IActivityManager");
                int id2 = data.readInt();
                ActivityManager.TaskThumbnail taskThumbnail = this.getTaskThumbnail(id2);
                reply.writeNoException();
                if (taskThumbnail != null) {
                    reply.writeInt(1);
                    taskThumbnail.writeToParcel(reply, 1);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 81: {
                data.enforceInterface("android.app.IActivityManager");
                int maxNum = data.readInt();
                int fl = data.readInt();
                List<ActivityManager.RunningServiceInfo> list = this.getServices(maxNum, fl);
                reply.writeNoException();
                int N = list != null ? list.size() : -1;
                reply.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    ActivityManager.RunningServiceInfo info = list.get(i);
                    info.writeToParcel(reply, 0);
                }
                return true;
            }
            case 77: {
                data.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.ProcessErrorStateInfo> list = this.getProcessesInErrorState();
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 83: {
                data.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.RunningAppProcessInfo> list = this.getRunningAppProcesses();
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 108: {
                data.enforceInterface("android.app.IActivityManager");
                List<ApplicationInfo> list = this.getRunningExternalApplications();
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 24: {
                data.enforceInterface("android.app.IActivityManager");
                int task = data.readInt();
                int fl = data.readInt();
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                this.moveTaskToFront(task, fl, options);
                reply.writeNoException();
                return true;
            }
            case 75: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean nonRoot = data.readInt() != 0;
                boolean res = this.moveActivityTaskToBack(token, nonRoot);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 26: {
                data.enforceInterface("android.app.IActivityManager");
                int task = data.readInt();
                this.moveTaskBackwards(task);
                reply.writeNoException();
                return true;
            }
            case 169: {
                data.enforceInterface("android.app.IActivityManager");
                int taskId = data.readInt();
                int stackId = data.readInt();
                boolean toTop = data.readInt() != 0;
                this.moveTaskToStack(taskId, stackId, toTop);
                reply.writeNoException();
                return true;
            }
            case 170: {
                data.enforceInterface("android.app.IActivityManager");
                int stackId = data.readInt();
                Rect r = Rect.CREATOR.createFromParcel(data);
                this.resizeStack(stackId, r);
                reply.writeNoException();
                return true;
            }
            case 171: {
                data.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.StackInfo> list = this.getAllStackInfos();
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 173: {
                data.enforceInterface("android.app.IActivityManager");
                int stackId = data.readInt();
                ActivityManager.StackInfo info = this.getStackInfo(stackId);
                reply.writeNoException();
                if (info != null) {
                    reply.writeInt(1);
                    info.writeToParcel(reply, 0);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 213: {
                data.enforceInterface("android.app.IActivityManager");
                int taskId = data.readInt();
                boolean isInHomeStack = this.isInHomeStack(taskId);
                reply.writeNoException();
                reply.writeInt(isInHomeStack ? 1 : 0);
                return true;
            }
            case 172: {
                data.enforceInterface("android.app.IActivityManager");
                int stackId = data.readInt();
                this.setFocusedStack(stackId);
                reply.writeNoException();
                return true;
            }
            case 283: {
                data.enforceInterface("android.app.IActivityManager");
                int focusedStackId = this.getFocusedStackId();
                reply.writeNoException();
                reply.writeInt(focusedStackId);
                return true;
            }
            case 243: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.registerTaskStackListener(ITaskStackListener.Stub.asInterface(token));
                reply.writeNoException();
                return true;
            }
            case 27: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean onlyRoot = data.readInt() != 0;
                int res = token != null ? this.getTaskForActivity(token, onlyRoot) : -1;
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 29: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String name = data.readString();
                int userId = data.readInt();
                boolean stable = data.readInt() != 0;
                IActivityManager.ContentProviderHolder cph = this.getContentProvider(app, name, userId, stable);
                reply.writeNoException();
                if (cph != null) {
                    reply.writeInt(1);
                    cph.writeToParcel(reply, 0);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 141: {
                data.enforceInterface("android.app.IActivityManager");
                String name = data.readString();
                int userId = data.readInt();
                IBinder token = data.readStrongBinder();
                IActivityManager.ContentProviderHolder cph = this.getContentProviderExternal(name, userId, token);
                reply.writeNoException();
                if (cph != null) {
                    reply.writeInt(1);
                    cph.writeToParcel(reply, 0);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 30: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                ArrayList<IActivityManager.ContentProviderHolder> providers = data.createTypedArrayList(IActivityManager.ContentProviderHolder.CREATOR);
                this.publishContentProviders(app, providers);
                reply.writeNoException();
                return true;
            }
            case 31: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                int stable = data.readInt();
                int unstable = data.readInt();
                boolean res = this.refContentProvider(b, stable, unstable);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 151: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                this.unstableProviderDied(b);
                reply.writeNoException();
                return true;
            }
            case 183: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                this.appNotRespondingViaProvider(b);
                reply.writeNoException();
                return true;
            }
            case 69: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                boolean stable = data.readInt() != 0;
                this.removeContentProvider(b, stable);
                reply.writeNoException();
                return true;
            }
            case 142: {
                data.enforceInterface("android.app.IActivityManager");
                String name = data.readString();
                IBinder token = data.readStrongBinder();
                this.removeContentProviderExternal(name, token);
                reply.writeNoException();
                return true;
            }
            case 33: {
                data.enforceInterface("android.app.IActivityManager");
                ComponentName comp = ComponentName.CREATOR.createFromParcel(data);
                PendingIntent pi = this.getRunningServiceControlPanel(comp);
                reply.writeNoException();
                PendingIntent.writePendingIntentOrNullToParcel(pi, reply);
                return true;
            }
            case 34: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Intent service = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                String callingPackage = data.readString();
                int userId = data.readInt();
                ComponentName cn = this.startService(app, service, resolvedType, callingPackage, userId);
                reply.writeNoException();
                ComponentName.writeToParcel(cn, reply);
                return true;
            }
            case 35: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Intent service = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                int userId = data.readInt();
                int res = this.stopService(app, service, resolvedType, userId);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 48: {
                data.enforceInterface("android.app.IActivityManager");
                ComponentName className = ComponentName.readFromParcel(data);
                IBinder token = data.readStrongBinder();
                int startId = data.readInt();
                boolean res = this.stopServiceToken(className, token, startId);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 74: {
                data.enforceInterface("android.app.IActivityManager");
                ComponentName className = ComponentName.readFromParcel(data);
                IBinder token = data.readStrongBinder();
                int id3 = data.readInt();
                Notification notification = null;
                if (data.readInt() != 0) {
                    notification = Notification.CREATOR.createFromParcel(data);
                }
                boolean removeNotification = data.readInt() != 0;
                this.setServiceForeground(className, token, id3, notification, removeNotification);
                reply.writeNoException();
                return true;
            }
            case 36: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                IBinder token = data.readStrongBinder();
                Intent service = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                b = data.readStrongBinder();
                int fl = data.readInt();
                String callingPackage = data.readString();
                int userId = data.readInt();
                IServiceConnection conn = IServiceConnection.Stub.asInterface(b);
                int res = this.bindService(app, token, service, resolvedType, conn, fl, callingPackage, userId);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 37: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IServiceConnection conn = IServiceConnection.Stub.asInterface(b);
                boolean res = this.unbindService(conn);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 38: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                IBinder service = data.readStrongBinder();
                this.publishService(token, intent, service);
                reply.writeNoException();
                return true;
            }
            case 72: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                boolean doRebind = data.readInt() != 0;
                this.unbindFinished(token, intent, doRebind);
                reply.writeNoException();
                return true;
            }
            case 61: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int type = data.readInt();
                int startId = data.readInt();
                int res = data.readInt();
                this.serviceDoneExecuting(token, type, startId, res);
                reply.writeNoException();
                return true;
            }
            case 44: {
                data.enforceInterface("android.app.IActivityManager");
                ComponentName className = ComponentName.readFromParcel(data);
                String profileFile = data.readString();
                int fl = data.readInt();
                Bundle arguments = data.readBundle();
                IBinder b = data.readStrongBinder();
                IInstrumentationWatcher w = IInstrumentationWatcher.Stub.asInterface(b);
                b = data.readStrongBinder();
                IUiAutomationConnection c = IUiAutomationConnection.Stub.asInterface(b);
                int userId = data.readInt();
                String abiOverride = data.readString();
                boolean res = this.startInstrumentation(className, profileFile, fl, arguments, w, c, userId, abiOverride);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 45: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                int resultCode = data.readInt();
                Bundle results = data.readBundle();
                this.finishInstrumentation(app, resultCode, results);
                reply.writeNoException();
                return true;
            }
            case 46: {
                data.enforceInterface("android.app.IActivityManager");
                Configuration config = this.getConfiguration();
                reply.writeNoException();
                config.writeToParcel(reply, 0);
                return true;
            }
            case 47: {
                data.enforceInterface("android.app.IActivityManager");
                Configuration config = Configuration.CREATOR.createFromParcel(data);
                this.updateConfiguration(config);
                reply.writeNoException();
                return true;
            }
            case 70: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int requestedOrientation = data.readInt();
                this.setRequestedOrientation(token, requestedOrientation);
                reply.writeNoException();
                return true;
            }
            case 71: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int req = this.getRequestedOrientation(token);
                reply.writeNoException();
                reply.writeInt(req);
                return true;
            }
            case 49: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                ComponentName cn = this.getActivityClassForToken(token);
                reply.writeNoException();
                ComponentName.writeToParcel(cn, reply);
                return true;
            }
            case 50: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                reply.writeNoException();
                reply.writeString(this.getPackageForToken(token));
                return true;
            }
            case 63: {
                String[] requestResolvedTypes;
                Intent[] requestIntents;
                data.enforceInterface("android.app.IActivityManager");
                int type = data.readInt();
                String packageName = data.readString();
                IBinder token = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                if (data.readInt() != 0) {
                    requestIntents = data.createTypedArray(Intent.CREATOR);
                    requestResolvedTypes = data.createStringArray();
                } else {
                    requestIntents = null;
                    requestResolvedTypes = null;
                }
                int fl = data.readInt();
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                int userId = data.readInt();
                IIntentSender res = this.getIntentSender(type, packageName, token, resultWho, requestCode, requestIntents, requestResolvedTypes, fl, options, userId);
                reply.writeNoException();
                reply.writeStrongBinder(res != null ? res.asBinder() : null);
                return true;
            }
            case 64: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                this.cancelIntentSender(r);
                reply.writeNoException();
                return true;
            }
            case 65: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                String res = this.getPackageForIntentSender(r);
                reply.writeNoException();
                reply.writeString(res);
                return true;
            }
            case 93: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                int res = this.getUidForIntentSender(r);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 94: {
                data.enforceInterface("android.app.IActivityManager");
                int callingPid = data.readInt();
                int callingUid = data.readInt();
                int userId = data.readInt();
                boolean allowAll = data.readInt() != 0;
                boolean requireFull = data.readInt() != 0;
                String name = data.readString();
                String callerPackage = data.readString();
                int res = this.handleIncomingUser(callingPid, callingUid, userId, allowAll, requireFull, name, callerPackage);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 51: {
                data.enforceInterface("android.app.IActivityManager");
                int max = data.readInt();
                this.setProcessLimit(max);
                reply.writeNoException();
                return true;
            }
            case 52: {
                data.enforceInterface("android.app.IActivityManager");
                int limit = this.getProcessLimit();
                reply.writeNoException();
                reply.writeInt(limit);
                return true;
            }
            case 73: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int pid = data.readInt();
                boolean isForeground = data.readInt() != 0;
                this.setProcessForeground(token, pid, isForeground);
                reply.writeNoException();
                return true;
            }
            case 53: {
                data.enforceInterface("android.app.IActivityManager");
                String perm = data.readString();
                int pid = data.readInt();
                int uid = data.readInt();
                int res = this.checkPermission(perm, pid, uid);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 242: {
                data.enforceInterface("android.app.IActivityManager");
                String perm = data.readString();
                int pid = data.readInt();
                int uid = data.readInt();
                IBinder token = data.readStrongBinder();
                int res = this.checkPermissionWithToken(perm, pid, uid, token);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 54: {
                data.enforceInterface("android.app.IActivityManager");
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int pid = data.readInt();
                int uid = data.readInt();
                int mode = data.readInt();
                int userId = data.readInt();
                IBinder callerToken = data.readStrongBinder();
                int res = this.checkUriPermission(uri, pid, uid, mode, userId, callerToken);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 78: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                IPackageDataObserver observer = IPackageDataObserver.Stub.asInterface(data.readStrongBinder());
                int userId = data.readInt();
                boolean res = this.clearApplicationUserData(packageName, observer, userId);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 55: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String targetPkg = data.readString();
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int mode = data.readInt();
                int userId = data.readInt();
                this.grantUriPermission(app, targetPkg, uri, mode, userId);
                reply.writeNoException();
                return true;
            }
            case 56: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int mode = data.readInt();
                int userId = data.readInt();
                this.revokeUriPermission(app, uri, mode, userId);
                reply.writeNoException();
                return true;
            }
            case 180: {
                data.enforceInterface("android.app.IActivityManager");
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int mode = data.readInt();
                int userId = data.readInt();
                this.takePersistableUriPermission(uri, mode, userId);
                reply.writeNoException();
                return true;
            }
            case 181: {
                data.enforceInterface("android.app.IActivityManager");
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int mode = data.readInt();
                int userId = data.readInt();
                this.releasePersistableUriPermission(uri, mode, userId);
                reply.writeNoException();
                return true;
            }
            case 182: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                boolean incoming = data.readInt() != 0;
                ParceledListSlice<UriPermission> perms = this.getPersistedUriPermissions(packageName, incoming);
                reply.writeNoException();
                perms.writeToParcel(reply, 1);
                return true;
            }
            case 58: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                boolean waiting = data.readInt() != 0;
                this.showWaitingForDebugger(app, waiting);
                reply.writeNoException();
                return true;
            }
            case 76: {
                data.enforceInterface("android.app.IActivityManager");
                ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
                this.getMemoryInfo(mi);
                reply.writeNoException();
                mi.writeToParcel(reply, 0);
                return true;
            }
            case 4: {
                data.enforceInterface("android.app.IActivityManager");
                this.unhandledBack();
                reply.writeNoException();
                return true;
            }
            case 5: {
                data.enforceInterface("android.app.IActivityManager");
                Uri uri = Uri.parse(data.readString());
                ParcelFileDescriptor pfd = this.openContentUri(uri);
                reply.writeNoException();
                if (pfd != null) {
                    reply.writeInt(1);
                    pfd.writeToParcel(reply, 1);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 148: {
                data.enforceInterface("android.app.IActivityManager");
                this.setLockScreenShown(data.readInt() != 0);
                reply.writeNoException();
                return true;
            }
            case 42: {
                data.enforceInterface("android.app.IActivityManager");
                String pn = data.readString();
                boolean wfd = data.readInt() != 0;
                boolean per = data.readInt() != 0;
                this.setDebugApp(pn, wfd, per);
                reply.writeNoException();
                return true;
            }
            case 43: {
                data.enforceInterface("android.app.IActivityManager");
                boolean enabled = data.readInt() != 0;
                this.setAlwaysFinish(enabled);
                reply.writeNoException();
                return true;
            }
            case 57: {
                data.enforceInterface("android.app.IActivityManager");
                IActivityController watcher = IActivityController.Stub.asInterface(data.readStrongBinder());
                this.setActivityController(watcher);
                reply.writeNoException();
                return true;
            }
            case 66: {
                data.enforceInterface("android.app.IActivityManager");
                this.enterSafeMode();
                reply.writeNoException();
                return true;
            }
            case 68: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender is = IIntentSender.Stub.asInterface(data.readStrongBinder());
                int sourceUid = data.readInt();
                String sourcePkg = data.readString();
                String tag = data.readString();
                this.noteWakeupAlarm(is, sourceUid, sourcePkg, tag);
                reply.writeNoException();
                return true;
            }
            case 292: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender is = IIntentSender.Stub.asInterface(data.readStrongBinder());
                int sourceUid = data.readInt();
                String tag = data.readString();
                this.noteAlarmStart(is, sourceUid, tag);
                reply.writeNoException();
                return true;
            }
            case 293: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender is = IIntentSender.Stub.asInterface(data.readStrongBinder());
                int sourceUid = data.readInt();
                String tag = data.readString();
                this.noteAlarmFinish(is, sourceUid, tag);
                reply.writeNoException();
                return true;
            }
            case 80: {
                data.enforceInterface("android.app.IActivityManager");
                int[] pids = data.createIntArray();
                String reason = data.readString();
                boolean secure = data.readInt() != 0;
                boolean res = this.killPids(pids, reason, secure);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 144: {
                data.enforceInterface("android.app.IActivityManager");
                String reason = data.readString();
                boolean res = this.killProcessesBelowForeground(reason);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 2: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder app = data.readStrongBinder();
                ApplicationErrorReport.CrashInfo ci = new ApplicationErrorReport.CrashInfo(data);
                this.handleApplicationCrash(app, ci);
                reply.writeNoException();
                return true;
            }
            case 102: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder app = data.readStrongBinder();
                String tag = data.readString();
                boolean system = data.readInt() != 0;
                ApplicationErrorReport.CrashInfo ci = new ApplicationErrorReport.CrashInfo(data);
                boolean res = this.handleApplicationWtf(app, tag, system, ci);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 110: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder app = data.readStrongBinder();
                int violationMask = data.readInt();
                StrictMode.ViolationInfo info = new StrictMode.ViolationInfo(data);
                this.handleApplicationStrictModeViolation(app, violationMask, info);
                reply.writeNoException();
                return true;
            }
            case 59: {
                data.enforceInterface("android.app.IActivityManager");
                int sig = data.readInt();
                this.signalPersistentProcesses(sig);
                reply.writeNoException();
                return true;
            }
            case 103: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                int userId = data.readInt();
                this.killBackgroundProcesses(packageName, userId);
                reply.writeNoException();
                return true;
            }
            case 140: {
                data.enforceInterface("android.app.IActivityManager");
                this.killAllBackgroundProcesses();
                reply.writeNoException();
                return true;
            }
            case 79: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                int userId = data.readInt();
                this.forceStopPackage(packageName, userId);
                reply.writeNoException();
                return true;
            }
            case 143: {
                data.enforceInterface("android.app.IActivityManager");
                ActivityManager.RunningAppProcessInfo info = new ActivityManager.RunningAppProcessInfo();
                this.getMyMemoryState(info);
                reply.writeNoException();
                info.writeToParcel(reply, 0);
                return true;
            }
            case 84: {
                data.enforceInterface("android.app.IActivityManager");
                ConfigurationInfo config = this.getDeviceConfigurationInfo();
                reply.writeNoException();
                config.writeToParcel(reply, 0);
                return true;
            }
            case 86: {
                data.enforceInterface("android.app.IActivityManager");
                String process = data.readString();
                int userId = data.readInt();
                boolean start = data.readInt() != 0;
                int profileType = data.readInt();
                ProfilerInfo profilerInfo = data.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(data) : null;
                boolean res = this.profileControl(process, userId, start, profilerInfo, profileType);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 87: {
                data.enforceInterface("android.app.IActivityManager");
                boolean res = this.shutdown(data.readInt());
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 88: {
                data.enforceInterface("android.app.IActivityManager");
                this.stopAppSwitches();
                reply.writeNoException();
                return true;
            }
            case 89: {
                data.enforceInterface("android.app.IActivityManager");
                this.resumeAppSwitches();
                reply.writeNoException();
                return true;
            }
            case 85: {
                data.enforceInterface("android.app.IActivityManager");
                Intent service = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                String callingPackage = data.readString();
                IBinder binder = this.peekService(service, resolvedType, callingPackage);
                reply.writeNoException();
                reply.writeStrongBinder(binder);
                return true;
            }
            case 90: {
                data.enforceInterface("android.app.IActivityManager");
                ApplicationInfo info = ApplicationInfo.CREATOR.createFromParcel(data);
                int backupRestoreMode = data.readInt();
                boolean success = this.bindBackupAgent(info, backupRestoreMode);
                reply.writeNoException();
                reply.writeInt(success ? 1 : 0);
                return true;
            }
            case 91: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                IBinder agent = data.readStrongBinder();
                this.backupAgentCreated(packageName, agent);
                reply.writeNoException();
                return true;
            }
            case 92: {
                data.enforceInterface("android.app.IActivityManager");
                ApplicationInfo info = ApplicationInfo.CREATOR.createFromParcel(data);
                this.unbindBackupAgent(info);
                reply.writeNoException();
                return true;
            }
            case 95: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                this.addPackageDependency(packageName);
                reply.writeNoException();
                return true;
            }
            case 96: {
                data.enforceInterface("android.app.IActivityManager");
                String pkg = data.readString();
                int appid = data.readInt();
                String reason = data.readString();
                this.killApplicationWithAppId(pkg, appid, reason);
                reply.writeNoException();
                return true;
            }
            case 97: {
                data.enforceInterface("android.app.IActivityManager");
                String reason = data.readString();
                this.closeSystemDialogs(reason);
                reply.writeNoException();
                return true;
            }
            case 98: {
                data.enforceInterface("android.app.IActivityManager");
                int[] pids = data.createIntArray();
                Parcelable[] res = this.getProcessMemoryInfo(pids);
                reply.writeNoException();
                reply.writeTypedArray(res, 1);
                return true;
            }
            case 99: {
                data.enforceInterface("android.app.IActivityManager");
                String processName = data.readString();
                int uid = data.readInt();
                this.killApplicationProcess(processName, uid);
                reply.writeNoException();
                return true;
            }
            case 101: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                String packageName = data.readString();
                int enterAnim = data.readInt();
                int exitAnim = data.readInt();
                this.overridePendingTransition(token, packageName, enterAnim, exitAnim);
                reply.writeNoException();
                return true;
            }
            case 104: {
                data.enforceInterface("android.app.IActivityManager");
                boolean areThey = this.isUserAMonkey();
                reply.writeNoException();
                reply.writeInt(areThey ? 1 : 0);
                return true;
            }
            case 166: {
                data.enforceInterface("android.app.IActivityManager");
                boolean monkey = data.readInt() == 1;
                this.setUserIsMonkey(monkey);
                reply.writeNoException();
                return true;
            }
            case 109: {
                data.enforceInterface("android.app.IActivityManager");
                this.finishHeavyWeightApp();
                reply.writeNoException();
                return true;
            }
            case 111: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean isit = this.isImmersive(token);
                reply.writeNoException();
                reply.writeInt(isit ? 1 : 0);
                return true;
            }
            case 225: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean isTopOfTask = this.isTopOfTask(token);
                reply.writeNoException();
                reply.writeInt(isTopOfTask ? 1 : 0);
                return true;
            }
            case 174: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean converted = this.convertFromTranslucent(token);
                reply.writeNoException();
                reply.writeInt(converted ? 1 : 0);
                return true;
            }
            case 175: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Bundle bundle = data.readInt() == 0 ? null : data.readBundle();
                ActivityOptions options = bundle == null ? null : new ActivityOptions(bundle);
                boolean converted = this.convertToTranslucent(token, options);
                reply.writeNoException();
                reply.writeInt(converted ? 1 : 0);
                return true;
            }
            case 220: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                ActivityOptions options = this.getActivityOptions(token);
                reply.writeNoException();
                reply.writeBundle(options == null ? null : options.toBundle());
                return true;
            }
            case 112: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean imm = data.readInt() == 1;
                this.setImmersive(token, imm);
                reply.writeNoException();
                return true;
            }
            case 113: {
                data.enforceInterface("android.app.IActivityManager");
                boolean isit = this.isTopActivityImmersive();
                reply.writeNoException();
                reply.writeInt(isit ? 1 : 0);
                return true;
            }
            case 114: {
                data.enforceInterface("android.app.IActivityManager");
                int uid = data.readInt();
                int initialPid = data.readInt();
                String packageName = data.readString();
                String message = data.readString();
                this.crashApplication(uid, initialPid, packageName, message);
                reply.writeNoException();
                return true;
            }
            case 115: {
                data.enforceInterface("android.app.IActivityManager");
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int userId = data.readInt();
                String type = this.getProviderMimeType(uri, userId);
                reply.writeNoException();
                reply.writeString(type);
                return true;
            }
            case 116: {
                data.enforceInterface("android.app.IActivityManager");
                String name = data.readString();
                IBinder perm = this.newUriPermissionOwner(name);
                reply.writeNoException();
                reply.writeStrongBinder(perm);
                return true;
            }
            case 117: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder owner = data.readStrongBinder();
                int fromUid = data.readInt();
                String targetPkg = data.readString();
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int mode = data.readInt();
                int sourceUserId = data.readInt();
                int targetUserId = data.readInt();
                this.grantUriPermissionFromOwner(owner, fromUid, targetPkg, uri, mode, sourceUserId, targetUserId);
                reply.writeNoException();
                return true;
            }
            case 118: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder owner = data.readStrongBinder();
                Uri uri = null;
                if (data.readInt() != 0) {
                    uri = Uri.CREATOR.createFromParcel(data);
                }
                int mode = data.readInt();
                int userId = data.readInt();
                this.revokeUriPermissionFromOwner(owner, uri, mode, userId);
                reply.writeNoException();
                return true;
            }
            case 119: {
                data.enforceInterface("android.app.IActivityManager");
                int callingUid = data.readInt();
                String targetPkg = data.readString();
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int modeFlags = data.readInt();
                int userId = data.readInt();
                int res = this.checkGrantUriPermission(callingUid, targetPkg, uri, modeFlags, userId);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 120: {
                data.enforceInterface("android.app.IActivityManager");
                String process = data.readString();
                int userId = data.readInt();
                boolean managed = data.readInt() != 0;
                String path = data.readString();
                ParcelFileDescriptor fd = data.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                boolean res = this.dumpHeap(process, userId, managed, path, fd);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 121: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String callingPackage = data.readString();
                Intent[] intents = data.createTypedArray(Intent.CREATOR);
                String[] resolvedTypes = data.createStringArray();
                IBinder resultTo = data.readStrongBinder();
                Bundle options = data.readInt() != 0 ? Bundle.CREATOR.createFromParcel(data) : null;
                int userId = data.readInt();
                int result = this.startActivities(app, callingPackage, intents, resolvedTypes, resultTo, options, userId);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 124: {
                data.enforceInterface("android.app.IActivityManager");
                int mode = this.getFrontActivityScreenCompatMode();
                reply.writeNoException();
                reply.writeInt(mode);
                return true;
            }
            case 125: {
                data.enforceInterface("android.app.IActivityManager");
                int mode = data.readInt();
                this.setFrontActivityScreenCompatMode(mode);
                reply.writeNoException();
                reply.writeInt(mode);
                return true;
            }
            case 126: {
                data.enforceInterface("android.app.IActivityManager");
                String pkg = data.readString();
                int mode = this.getPackageScreenCompatMode(pkg);
                reply.writeNoException();
                reply.writeInt(mode);
                return true;
            }
            case 127: {
                data.enforceInterface("android.app.IActivityManager");
                String pkg = data.readString();
                int mode = data.readInt();
                this.setPackageScreenCompatMode(pkg, mode);
                reply.writeNoException();
                return true;
            }
            case 130: {
                data.enforceInterface("android.app.IActivityManager");
                int userid = data.readInt();
                boolean result = this.switchUser(userid);
                reply.writeNoException();
                reply.writeInt(result ? 1 : 0);
                return true;
            }
            case 212: {
                data.enforceInterface("android.app.IActivityManager");
                int userid = data.readInt();
                boolean result = this.startUserInBackground(userid);
                reply.writeNoException();
                reply.writeInt(result ? 1 : 0);
                return true;
            }
            case 154: {
                data.enforceInterface("android.app.IActivityManager");
                int userid = data.readInt();
                IStopUserCallback callback = IStopUserCallback.Stub.asInterface(data.readStrongBinder());
                int result = this.stopUser(userid, callback);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 145: {
                data.enforceInterface("android.app.IActivityManager");
                UserInfo userInfo = this.getCurrentUser();
                reply.writeNoException();
                userInfo.writeToParcel(reply, 0);
                return true;
            }
            case 122: {
                data.enforceInterface("android.app.IActivityManager");
                int userid = data.readInt();
                boolean orStopping = data.readInt() != 0;
                boolean result = this.isUserRunning(userid, orStopping);
                reply.writeNoException();
                reply.writeInt(result ? 1 : 0);
                return true;
            }
            case 157: {
                data.enforceInterface("android.app.IActivityManager");
                int[] result = this.getRunningUserIds();
                reply.writeNoException();
                reply.writeIntArray(result);
                return true;
            }
            case 132: {
                data.enforceInterface("android.app.IActivityManager");
                int taskId = data.readInt();
                boolean result = this.removeTask(taskId);
                reply.writeNoException();
                reply.writeInt(result ? 1 : 0);
                return true;
            }
            case 133: {
                data.enforceInterface("android.app.IActivityManager");
                IProcessObserver observer = IProcessObserver.Stub.asInterface(data.readStrongBinder());
                this.registerProcessObserver(observer);
                return true;
            }
            case 134: {
                data.enforceInterface("android.app.IActivityManager");
                IProcessObserver observer = IProcessObserver.Stub.asInterface(data.readStrongBinder());
                this.unregisterProcessObserver(observer);
                return true;
            }
            case 298: {
                data.enforceInterface("android.app.IActivityManager");
                IUidObserver observer = IUidObserver.Stub.asInterface(data.readStrongBinder());
                this.registerUidObserver(observer);
                return true;
            }
            case 299: {
                data.enforceInterface("android.app.IActivityManager");
                IUidObserver observer = IUidObserver.Stub.asInterface(data.readStrongBinder());
                this.unregisterUidObserver(observer);
                return true;
            }
            case 128: {
                data.enforceInterface("android.app.IActivityManager");
                String pkg = data.readString();
                boolean ask = this.getPackageAskScreenCompat(pkg);
                reply.writeNoException();
                reply.writeInt(ask ? 1 : 0);
                return true;
            }
            case 129: {
                data.enforceInterface("android.app.IActivityManager");
                String pkg = data.readString();
                boolean ask = data.readInt() != 0;
                this.setPackageAskScreenCompat(pkg, ask);
                reply.writeNoException();
                return true;
            }
            case 135: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                boolean res = this.isIntentSenderTargetedToPackage(r);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 152: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                boolean res = this.isIntentSenderAnActivity(r);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 161: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                Intent intent = this.getIntentForIntentSender(r);
                reply.writeNoException();
                if (intent != null) {
                    reply.writeInt(1);
                    intent.writeToParcel(reply, 1);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 211: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                String prefix = data.readString();
                String tag = this.getTagForIntentSender(r, prefix);
                reply.writeNoException();
                reply.writeString(tag);
                return true;
            }
            case 136: {
                data.enforceInterface("android.app.IActivityManager");
                Configuration config = Configuration.CREATOR.createFromParcel(data);
                this.updatePersistentConfiguration(config);
                reply.writeNoException();
                return true;
            }
            case 137: {
                data.enforceInterface("android.app.IActivityManager");
                int[] pids = data.createIntArray();
                long[] pss = this.getProcessPss(pids);
                reply.writeNoException();
                reply.writeLongArray(pss);
                return true;
            }
            case 138: {
                data.enforceInterface("android.app.IActivityManager");
                CharSequence msg = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data);
                boolean always = data.readInt() != 0;
                this.showBootMessage(msg, always);
                reply.writeNoException();
                return true;
            }
            case 232: {
                data.enforceInterface("android.app.IActivityManager");
                this.keyguardWaitingForActivityDrawn();
                reply.writeNoException();
                return true;
            }
            case 297: {
                data.enforceInterface("android.app.IActivityManager");
                this.keyguardGoingAway(data.readInt() != 0, data.readInt() != 0);
                reply.writeNoException();
                return true;
            }
            case 146: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                String destAffinity = data.readString();
                boolean res = this.shouldUpRecreateTask(token, destAffinity);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 147: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Intent target = Intent.CREATOR.createFromParcel(data);
                int resultCode = data.readInt();
                Intent resultData = null;
                if (data.readInt() != 0) {
                    resultData = Intent.CREATOR.createFromParcel(data);
                }
                boolean res = this.navigateUpTo(token, target, resultCode, resultData);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 150: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int res = this.getLaunchedFromUid(token);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 164: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                String res = this.getLaunchedFromPackage(token);
                reply.writeNoException();
                reply.writeString(res);
                return true;
            }
            case 155: {
                data.enforceInterface("android.app.IActivityManager");
                IUserSwitchObserver observer = IUserSwitchObserver.Stub.asInterface(data.readStrongBinder());
                this.registerUserSwitchObserver(observer);
                reply.writeNoException();
                return true;
            }
            case 156: {
                data.enforceInterface("android.app.IActivityManager");
                IUserSwitchObserver observer = IUserSwitchObserver.Stub.asInterface(data.readStrongBinder());
                this.unregisterUserSwitchObserver(observer);
                reply.writeNoException();
                return true;
            }
            case 158: {
                data.enforceInterface("android.app.IActivityManager");
                this.requestBugReport();
                reply.writeNoException();
                return true;
            }
            case 159: {
                data.enforceInterface("android.app.IActivityManager");
                int pid = data.readInt();
                boolean aboveSystem = data.readInt() != 0;
                String reason = data.readString();
                long res = this.inputDispatchingTimedOut(pid, aboveSystem, reason);
                reply.writeNoException();
                reply.writeLong(res);
                return true;
            }
            case 162: {
                data.enforceInterface("android.app.IActivityManager");
                int requestType = data.readInt();
                Bundle res = this.getAssistContextExtras(requestType);
                reply.writeNoException();
                reply.writeBundle(res);
                return true;
            }
            case 285: {
                data.enforceInterface("android.app.IActivityManager");
                int requestType = data.readInt();
                IResultReceiver receiver = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                IBinder activityToken = data.readStrongBinder();
                boolean res = this.requestAssistContextExtras(requestType, receiver, activityToken);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 163: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Bundle extras = data.readBundle();
                AssistStructure structure = AssistStructure.CREATOR.createFromParcel(data);
                AssistContent content = AssistContent.CREATOR.createFromParcel(data);
                Uri referrer = data.readInt() != 0 ? Uri.CREATOR.createFromParcel(data) : null;
                this.reportAssistContextExtras(token, extras, structure, content, referrer);
                reply.writeNoException();
                return true;
            }
            case 240: {
                data.enforceInterface("android.app.IActivityManager");
                Intent intent = Intent.CREATOR.createFromParcel(data);
                int requestType = data.readInt();
                String hint = data.readString();
                int userHandle = data.readInt();
                Bundle args = data.readBundle();
                boolean res = this.launchAssistIntent(intent, requestType, hint, userHandle, args);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 300: {
                data.enforceInterface("android.app.IActivityManager");
                boolean res = this.isAssistDataAllowedOnCurrentActivity();
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 301: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Bundle args = data.readBundle();
                boolean res = this.showAssistFromActivity(token, args);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 165: {
                data.enforceInterface("android.app.IActivityManager");
                int appId = data.readInt();
                int userId = data.readInt();
                String reason = data.readString();
                this.killUid(appId, userId, reason);
                reply.writeNoException();
                return true;
            }
            case 167: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder who = data.readStrongBinder();
                boolean allowRestart = data.readInt() != 0;
                this.hang(who, allowRestart);
                reply.writeNoException();
                return true;
            }
            case 177: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.reportActivityFullyDrawn(token);
                reply.writeNoException();
                return true;
            }
            case 176: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.notifyActivityDrawn(token);
                reply.writeNoException();
                return true;
            }
            case 178: {
                data.enforceInterface("android.app.IActivityManager");
                this.restart();
                reply.writeNoException();
                return true;
            }
            case 179: {
                data.enforceInterface("android.app.IActivityManager");
                this.performIdleMaintenance();
                reply.writeNoException();
                return true;
            }
            case 168: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder parentActivityToken = data.readStrongBinder();
                IActivityContainerCallback callback = IActivityContainerCallback.Stub.asInterface(data.readStrongBinder());
                IActivityContainer activityContainer = this.createVirtualActivityContainer(parentActivityToken, callback);
                reply.writeNoException();
                if (activityContainer != null) {
                    reply.writeInt(1);
                    reply.writeStrongBinder(activityContainer.asBinder());
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 186: {
                data.enforceInterface("android.app.IActivityManager");
                IActivityContainer activityContainer = IActivityContainer.Stub.asInterface(data.readStrongBinder());
                this.deleteActivityContainer(activityContainer);
                reply.writeNoException();
                return true;
            }
            case 282: {
                data.enforceInterface("android.app.IActivityManager");
                int displayId = data.readInt();
                IActivityContainer activityContainer = this.createStackOnDisplay(displayId);
                reply.writeNoException();
                if (activityContainer != null) {
                    reply.writeInt(1);
                    reply.writeStrongBinder(activityContainer.asBinder());
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 185: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder activityToken = data.readStrongBinder();
                int displayId = this.getActivityDisplayId(activityToken);
                reply.writeNoException();
                reply.writeInt(displayId);
                return true;
            }
            case 214: {
                data.enforceInterface("android.app.IActivityManager");
                int taskId = data.readInt();
                this.startLockTaskMode(taskId);
                reply.writeNoException();
                return true;
            }
            case 215: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.startLockTaskMode(token);
                reply.writeNoException();
                return true;
            }
            case 222: {
                data.enforceInterface("android.app.IActivityManager");
                this.startLockTaskModeOnCurrent();
                reply.writeNoException();
                return true;
            }
            case 216: {
                data.enforceInterface("android.app.IActivityManager");
                this.stopLockTaskMode();
                reply.writeNoException();
                return true;
            }
            case 223: {
                data.enforceInterface("android.app.IActivityManager");
                this.stopLockTaskModeOnCurrent();
                reply.writeNoException();
                return true;
            }
            case 217: {
                data.enforceInterface("android.app.IActivityManager");
                boolean isInLockTaskMode = this.isInLockTaskMode();
                reply.writeNoException();
                reply.writeInt(isInLockTaskMode ? 1 : 0);
                return true;
            }
            case 287: {
                data.enforceInterface("android.app.IActivityManager");
                int lockTaskModeState = this.getLockTaskModeState();
                reply.writeNoException();
                reply.writeInt(lockTaskModeState);
                return true;
            }
            case 295: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.showLockTaskEscapeMessage(token);
                reply.writeNoException();
                return true;
            }
            case 218: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                ActivityManager.TaskDescription values = ActivityManager.TaskDescription.CREATOR.createFromParcel(data);
                this.setTaskDescription(token, values);
                reply.writeNoException();
                return true;
            }
            case 284: {
                data.enforceInterface("android.app.IActivityManager");
                int taskId = data.readInt();
                boolean resizeable = data.readInt() == 1;
                this.setTaskResizeable(taskId, resizeable);
                reply.writeNoException();
                return true;
            }
            case 286: {
                data.enforceInterface("android.app.IActivityManager");
                int taskId = data.readInt();
                Rect r = Rect.CREATOR.createFromParcel(data);
                this.resizeTask(taskId, r);
                reply.writeNoException();
                return true;
            }
            case 239: {
                data.enforceInterface("android.app.IActivityManager");
                String filename = data.readString();
                Bitmap icon = this.getTaskDescriptionIcon(filename);
                reply.writeNoException();
                if (icon == null) {
                    reply.writeInt(0);
                } else {
                    reply.writeInt(1);
                    icon.writeToParcel(reply, 0);
                }
                return true;
            }
            case 241: {
                data.enforceInterface("android.app.IActivityManager");
                Bundle bundle = data.readInt() == 0 ? null : data.readBundle();
                ActivityOptions options = bundle == null ? null : new ActivityOptions(bundle);
                this.startInPlaceAnimationOnFrontMostApplication(options);
                reply.writeNoException();
                return true;
            }
            case 226: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean enable = data.readInt() > 0;
                boolean success = this.requestVisibleBehind(token, enable);
                reply.writeNoException();
                reply.writeInt(success ? 1 : 0);
                return true;
            }
            case 227: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean enabled = this.isBackgroundVisibleBehind(token);
                reply.writeNoException();
                reply.writeInt(enabled ? 1 : 0);
                return true;
            }
            case 228: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.backgroundResourcesReleased(token);
                reply.writeNoException();
                return true;
            }
            case 229: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.notifyLaunchTaskBehindComplete(token);
                reply.writeNoException();
                return true;
            }
            case 231: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.notifyEnterAnimationComplete(token);
                reply.writeNoException();
                return true;
            }
            case 238: {
                data.enforceInterface("android.app.IActivityManager");
                this.bootAnimationComplete();
                reply.writeNoException();
                return true;
            }
            case 281: {
                data.enforceInterface("android.app.IActivityManager");
                int uid = data.readInt();
                byte[] firstPacket = data.createByteArray();
                this.notifyCleartextNetwork(uid, firstPacket);
                reply.writeNoException();
                return true;
            }
            case 288: {
                data.enforceInterface("android.app.IActivityManager");
                String procName = data.readString();
                int uid = data.readInt();
                long maxMemSize = data.readLong();
                String reportPackage = data.readString();
                this.setDumpHeapDebugLimit(procName, uid, maxMemSize, reportPackage);
                reply.writeNoException();
                return true;
            }
            case 289: {
                data.enforceInterface("android.app.IActivityManager");
                String path = data.readString();
                this.dumpHeapFinished(path);
                reply.writeNoException();
                return true;
            }
            case 290: {
                data.enforceInterface("android.app.IActivityManager");
                IVoiceInteractionSession session = IVoiceInteractionSession.Stub.asInterface(data.readStrongBinder());
                boolean keepAwake = data.readInt() != 0;
                this.setVoiceKeepAwake(session, keepAwake);
                reply.writeNoException();
                return true;
            }
            case 291: {
                data.enforceInterface("android.app.IActivityManager");
                int userId = data.readInt();
                String[] packages = data.readStringArray();
                this.updateLockTaskPackages(userId, packages);
                reply.writeNoException();
                return true;
            }
            case 296: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                this.updateDeviceOwner(packageName);
                reply.writeNoException();
                return true;
            }
            case 294: {
                data.enforceInterface("android.app.IActivityManager");
                String pkg = data.readString();
                String callingPackage = data.readString();
                int res = this.getPackageProcessState(pkg, callingPackage);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 187: {
                data.enforceInterface("android.app.IActivityManager");
                String process = data.readString();
                int userId = data.readInt();
                int level = data.readInt();
                boolean res = this.setProcessMemoryTrimLevel(process, userId, level);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 302: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean res = this.isRootVoiceInteraction(token);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
        }
        return super.onTransact(code, data, reply, flags);
    }

    @Override
    public IBinder asBinder() {
        return this;
    }
}

