/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.INotificationManager;
import android.app.Notification;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.UserHandle;
import android.service.notification.IConditionListener;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenModeConfig;
import android.util.ArraySet;
import android.util.Log;
import java.util.List;
import java.util.Objects;

public class NotificationManager {
    private static String TAG = "NotificationManager";
    private static boolean localLOGV = false;
    public static final String ACTION_EFFECTS_SUPPRESSOR_CHANGED = "android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED";
    public static final String ACTION_NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED = "android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED";
    public static final String ACTION_NOTIFICATION_POLICY_CHANGED = "android.app.action.NOTIFICATION_POLICY_CHANGED";
    public static final String ACTION_INTERRUPTION_FILTER_CHANGED = "android.app.action.INTERRUPTION_FILTER_CHANGED";
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    public static final int INTERRUPTION_FILTER_ALARMS = 4;
    public static final int INTERRUPTION_FILTER_UNKNOWN = 0;
    private static INotificationManager sService;
    private Context mContext;

    public static INotificationManager getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("notification");
        sService = INotificationManager.Stub.asInterface(b);
        return sService;
    }

    NotificationManager(Context context, Handler handler) {
        this.mContext = context;
    }

    public static NotificationManager from(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    public void notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    public void notify(String tag, int id2, Notification notification) {
        int[] idOut = new int[1];
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        this.fixLegacySmallIcon(notification, pkg);
        if (this.mContext.getApplicationInfo().targetSdkVersion > 22 && notification.getSmallIcon() == null) {
            throw new IllegalArgumentException("Invalid notification (no valid small icon): " + notification);
        }
        if (localLOGV) {
            Log.v(TAG, pkg + ": notify(" + id2 + ", " + notification + ")");
        }
        Notification stripped = notification.clone();
        Notification.Builder.stripForDelivery(stripped);
        try {
            service.enqueueNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, stripped, idOut, UserHandle.myUserId());
            if (id2 != idOut[0]) {
                Log.w(TAG, "notify: id corrupted: sent " + id2 + ", got back " + idOut[0]);
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void notifyAsUser(String tag, int id2, Notification notification, UserHandle user) {
        int[] idOut = new int[1];
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        this.fixLegacySmallIcon(notification, pkg);
        if (localLOGV) {
            Log.v(TAG, pkg + ": notify(" + id2 + ", " + notification + ")");
        }
        Notification stripped = notification.clone();
        Notification.Builder.stripForDelivery(stripped);
        try {
            service.enqueueNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, stripped, idOut, user.getIdentifier());
            if (id2 != idOut[0]) {
                Log.w(TAG, "notify: id corrupted: sent " + id2 + ", got back " + idOut[0]);
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void fixLegacySmallIcon(Notification n, String pkg) {
        if (n.getSmallIcon() == null && n.icon != 0) {
            n.setSmallIcon(Icon.createWithResource(pkg, n.icon));
        }
    }

    public void cancel(int id2) {
        this.cancel(null, id2);
    }

    public void cancel(String tag, int id2) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancel(" + id2 + ")");
        }
        try {
            service.cancelNotificationWithTag(pkg, tag, id2, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void cancelAsUser(String tag, int id2, UserHandle user) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancel(" + id2 + ")");
        }
        try {
            service.cancelNotificationWithTag(pkg, tag, id2, user.getIdentifier());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void cancelAll() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancelAll()");
        }
        try {
            service.cancelAllNotifications(pkg, UserHandle.myUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ComponentName getEffectsSuppressor() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEffectsSuppressor();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean matchesCallFilter(Bundle extras) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.matchesCallFilter(extras);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isSystemConditionProviderEnabled(String path) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isSystemConditionProviderEnabled(path);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setZenMode(int mode, Uri conditionId, String reason) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setZenMode(mode, conditionId, reason);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public boolean setZenModeConfig(ZenModeConfig config, String reason) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.setZenModeConfig(config, reason);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void requestZenModeConditions(IConditionListener listener, int relevance) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.requestZenModeConditions(listener, relevance);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public int getZenMode() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getZenMode();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public ZenModeConfig getZenModeConfig() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getZenModeConfig();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean isNotificationPolicyAccessGranted() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationPolicyAccessGranted(this.mContext.getOpPackageName());
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isNotificationPolicyAccessGrantedForPackage(String pkg) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationPolicyAccessGrantedForPackage(pkg);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public Policy getNotificationPolicy() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationPolicy(this.mContext.getOpPackageName());
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void setNotificationPolicy(Policy policy) {
        NotificationManager.checkRequired("policy", policy);
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationPolicy(this.mContext.getOpPackageName(), policy);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setNotificationPolicyAccessGranted(String pkg, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationPolicyAccessGranted(pkg, granted);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public ArraySet<String> getPackagesRequestingNotificationPolicyAccess() {
        INotificationManager service = NotificationManager.getService();
        try {
            String[] pkgs = service.getPackagesRequestingNotificationPolicyAccess();
            if (pkgs != null && pkgs.length > 0) {
                ArraySet<String> rt = new ArraySet<String>(pkgs.length);
                for (int i = 0; i < pkgs.length; ++i) {
                    rt.add(pkgs[i]);
                }
                return rt;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return new ArraySet<String>();
    }

    private static void checkRequired(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " is required");
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        try {
            ParceledListSlice parceledList = service.getAppActiveNotifications(pkg, UserHandle.myUserId());
            List<StatusBarNotification> list = parceledList.getList();
            return list.toArray(new StatusBarNotification[list.size()]);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to talk to notification manager. Woe!", e);
            return new StatusBarNotification[0];
        }
    }

    public final int getCurrentInterruptionFilter() {
        INotificationManager service = NotificationManager.getService();
        try {
            return NotificationManager.zenModeToInterruptionFilter(service.getZenMode());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to talk to notification manager. Woe!", e);
            return 0;
        }
    }

    public final void setInterruptionFilter(int interruptionFilter) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setInterruptionFilter(this.mContext.getOpPackageName(), interruptionFilter);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to talk to notification manager. Woe!", e);
        }
    }

    public static int zenModeToInterruptionFilter(int zen) {
        switch (zen) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    public static int zenModeFromInterruptionFilter(int interruptionFilter, int defValue) {
        switch (interruptionFilter) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return defValue;
    }

    public static class Policy
    implements Parcelable {
        public static final int PRIORITY_CATEGORY_REMINDERS = 1;
        public static final int PRIORITY_CATEGORY_EVENTS = 2;
        public static final int PRIORITY_CATEGORY_MESSAGES = 4;
        public static final int PRIORITY_CATEGORY_CALLS = 8;
        public static final int PRIORITY_CATEGORY_REPEAT_CALLERS = 16;
        private static final int[] ALL_PRIORITY_CATEGORIES = new int[]{1, 2, 4, 8, 16};
        public static final int PRIORITY_SENDERS_ANY = 0;
        public static final int PRIORITY_SENDERS_CONTACTS = 1;
        public static final int PRIORITY_SENDERS_STARRED = 2;
        public final int priorityCategories;
        public final int priorityCallSenders;
        public final int priorityMessageSenders;
        public static final Parcelable.Creator<Policy> CREATOR = new Parcelable.Creator<Policy>(){

            @Override
            public Policy createFromParcel(Parcel in) {
                return new Policy(in);
            }

            public Policy[] newArray(int size) {
                return new Policy[size];
            }
        };

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders) {
            this.priorityCategories = priorityCategories;
            this.priorityCallSenders = priorityCallSenders;
            this.priorityMessageSenders = priorityMessageSenders;
        }

        public Policy(Parcel source) {
            this(source.readInt(), source.readInt(), source.readInt());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.priorityCategories);
            dest.writeInt(this.priorityCallSenders);
            dest.writeInt(this.priorityMessageSenders);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int hashCode() {
            return Objects.hash(this.priorityCategories, this.priorityCallSenders, this.priorityMessageSenders);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Policy)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Policy other = (Policy)o;
            return other.priorityCategories == this.priorityCategories && other.priorityCallSenders == this.priorityCallSenders && other.priorityMessageSenders == this.priorityMessageSenders;
        }

        public String toString() {
            return "NotificationManager.Policy[priorityCategories=" + Policy.priorityCategoriesToString(this.priorityCategories) + ",priorityCallSenders=" + Policy.prioritySendersToString(this.priorityCallSenders) + ",priorityMessageSenders=" + Policy.prioritySendersToString(this.priorityMessageSenders) + "]";
        }

        public static String priorityCategoriesToString(int priorityCategories) {
            if (priorityCategories == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_PRIORITY_CATEGORIES.length; ++i) {
                int priorityCategory = ALL_PRIORITY_CATEGORIES[i];
                if ((priorityCategories & priorityCategory) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.priorityCategoryToString(priorityCategory));
                }
                priorityCategories &= ~priorityCategory;
            }
            if (priorityCategories != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("PRIORITY_CATEGORY_UNKNOWN_").append(priorityCategories);
            }
            return sb.toString();
        }

        private static String priorityCategoryToString(int priorityCategory) {
            switch (priorityCategory) {
                case 1: {
                    return "PRIORITY_CATEGORY_REMINDERS";
                }
                case 2: {
                    return "PRIORITY_CATEGORY_EVENTS";
                }
                case 4: {
                    return "PRIORITY_CATEGORY_MESSAGES";
                }
                case 8: {
                    return "PRIORITY_CATEGORY_CALLS";
                }
                case 16: {
                    return "PRIORITY_CATEGORY_REPEAT_CALLERS";
                }
            }
            return "PRIORITY_CATEGORY_UNKNOWN_" + priorityCategory;
        }

        public static String prioritySendersToString(int prioritySenders) {
            switch (prioritySenders) {
                case 0: {
                    return "PRIORITY_SENDERS_ANY";
                }
                case 1: {
                    return "PRIORITY_SENDERS_CONTACTS";
                }
                case 2: {
                    return "PRIORITY_SENDERS_STARRED";
                }
            }
            return "PRIORITY_SENDERS_UNKNOWN_" + prioritySenders;
        }
    }
}

