/*
 * Decompiled with CFR 0.152.
 */
package android.app.assist;

import android.app.Activity;
import android.content.ComponentName;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PooledStringReader;
import android.os.PooledStringWriter;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewStructure;
import android.view.WindowManagerGlobal;
import java.util.ArrayList;

public class AssistStructure
implements Parcelable {
    static final String TAG = "AssistStructure";
    static final boolean DEBUG_PARCEL = false;
    static final boolean DEBUG_PARCEL_CHILDREN = false;
    static final boolean DEBUG_PARCEL_TREE = false;
    static final int VALIDATE_WINDOW_TOKEN = 0x11111111;
    static final int VALIDATE_VIEW_TOKEN = 0x22222222;
    boolean mHaveData;
    ComponentName mActivityComponent;
    final ArrayList<WindowNode> mWindowNodes = new ArrayList();
    final ArrayList<ViewNodeBuilder> mPendingAsyncChildren = new ArrayList();
    SendChannel mSendChannel;
    IBinder mReceiveChannel;
    Rect mTmpRect = new Rect();
    static final int TRANSACTION_XFER = 2;
    static final String DESCRIPTOR = "android.app.AssistStructure";
    public static final Parcelable.Creator<AssistStructure> CREATOR = new Parcelable.Creator<AssistStructure>(){

        @Override
        public AssistStructure createFromParcel(Parcel in) {
            return new AssistStructure(in);
        }

        public AssistStructure[] newArray(int size) {
            return new AssistStructure[size];
        }
    };

    public AssistStructure(Activity activity) {
        this.mHaveData = true;
        this.mActivityComponent = activity.getComponentName();
        ArrayList<ViewRootImpl> views = WindowManagerGlobal.getInstance().getRootViews(activity.getActivityToken());
        for (int i = 0; i < views.size(); ++i) {
            ViewRootImpl root = views.get(i);
            this.mWindowNodes.add(new WindowNode(this, root));
        }
    }

    public AssistStructure() {
        this.mHaveData = true;
        this.mActivityComponent = null;
    }

    public AssistStructure(Parcel in) {
        this.mReceiveChannel = in.readStrongBinder();
    }

    public void dump() {
        Log.i(TAG, "Activity: " + this.mActivityComponent.flattenToShortString());
        int N = this.getWindowNodeCount();
        for (int i = 0; i < N; ++i) {
            WindowNode node = this.getWindowNodeAt(i);
            Log.i(TAG, "Window #" + i + " [" + node.getLeft() + "," + node.getTop() + " " + node.getWidth() + "x" + node.getHeight() + "]" + " " + node.getTitle());
            this.dump("  ", node.getRootViewNode());
        }
    }

    void dump(String prefix, ViewNode node) {
        int NCHILDREN;
        Bundle extras;
        String hint;
        CharSequence text;
        CharSequence contentDescription;
        float alpha;
        float elevation;
        Matrix matrix;
        Log.i(TAG, prefix + "View [" + node.getLeft() + "," + node.getTop() + " " + node.getWidth() + "x" + node.getHeight() + "]" + " " + node.getClassName());
        int id2 = node.getId();
        if (id2 != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            sb.append("  ID: #");
            sb.append(Integer.toHexString(id2));
            String entry = node.getIdEntry();
            if (entry != null) {
                String type = node.getIdType();
                String pkg = node.getIdPackage();
                sb.append(" ");
                sb.append(pkg);
                sb.append(":");
                sb.append(type);
                sb.append("/");
                sb.append(entry);
            }
            Log.i(TAG, sb.toString());
        }
        int scrollX = node.getScrollX();
        int scrollY = node.getScrollY();
        if (scrollX != 0 || scrollY != 0) {
            Log.i(TAG, prefix + "  Scroll: " + scrollX + "," + scrollY);
        }
        if ((matrix = node.getTransformation()) != null) {
            Log.i(TAG, prefix + "  Transformation: " + matrix);
        }
        if ((elevation = node.getElevation()) != 0.0f) {
            Log.i(TAG, prefix + "  Elevation: " + elevation);
        }
        if ((alpha = node.getAlpha()) != 0.0f) {
            Log.i(TAG, prefix + "  Alpha: " + elevation);
        }
        if ((contentDescription = node.getContentDescription()) != null) {
            Log.i(TAG, prefix + "  Content description: " + contentDescription);
        }
        if ((text = node.getText()) != null) {
            Log.i(TAG, prefix + "  Text (sel " + node.getTextSelectionStart() + "-" + node.getTextSelectionEnd() + "): " + text);
            Log.i(TAG, prefix + "  Text size: " + node.getTextSize() + " , style: #" + node.getTextStyle());
            Log.i(TAG, prefix + "  Text color fg: #" + Integer.toHexString(node.getTextColor()) + ", bg: #" + Integer.toHexString(node.getTextBackgroundColor()));
        }
        if ((hint = node.getHint()) != null) {
            Log.i(TAG, prefix + "  Hint: " + hint);
        }
        if ((extras = node.getExtras()) != null) {
            Log.i(TAG, prefix + "  Extras: " + extras);
        }
        if (node.isAssistBlocked()) {
            Log.i(TAG, prefix + "  BLOCKED");
        }
        if ((NCHILDREN = node.getChildCount()) > 0) {
            Log.i(TAG, prefix + "  Children:");
            String cprefix = prefix + "    ";
            for (int i = 0; i < NCHILDREN; ++i) {
                ViewNode cnode = node.getChildAt(i);
                this.dump(cprefix, cnode);
            }
        }
    }

    public ComponentName getActivityComponent() {
        this.ensureData();
        return this.mActivityComponent;
    }

    public int getWindowNodeCount() {
        this.ensureData();
        return this.mWindowNodes.size();
    }

    public WindowNode getWindowNodeAt(int index) {
        this.ensureData();
        return this.mWindowNodes.get(index);
    }

    public void ensureData() {
        if (this.mHaveData) {
            return;
        }
        this.mHaveData = true;
        ParcelTransferReader reader = new ParcelTransferReader(this.mReceiveChannel);
        reader.go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForReady() {
        boolean skipStructure = false;
        AssistStructure assistStructure = this;
        synchronized (assistStructure) {
            long now;
            long endTime = SystemClock.uptimeMillis() + 5000L;
            while (this.mPendingAsyncChildren.size() > 0 && (now = SystemClock.uptimeMillis()) < endTime) {
                try {
                    this.wait(endTime - now);
                }
                catch (InterruptedException e) {}
            }
            if (this.mPendingAsyncChildren.size() > 0) {
                Log.w(TAG, "Skipping assist structure, waiting too long for async children (have " + this.mPendingAsyncChildren.size() + " remaining");
                skipStructure = true;
            }
        }
        return !skipStructure;
    }

    public void clearSendChannel() {
        if (this.mSendChannel != null) {
            this.mSendChannel.mAssistStructure = null;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        if (this.mHaveData) {
            if (this.mSendChannel == null) {
                this.mSendChannel = new SendChannel(this);
            }
            out.writeStrongBinder(this.mSendChannel);
        } else {
            out.writeStrongBinder(this.mReceiveChannel);
        }
    }

    static class ViewNodeBuilder
    extends ViewStructure {
        final AssistStructure mAssist;
        final ViewNode mNode;
        final boolean mAsync;

        ViewNodeBuilder(AssistStructure assist, ViewNode node, boolean async) {
            this.mAssist = assist;
            this.mNode = node;
            this.mAsync = async;
        }

        @Override
        public void setId(int id2, String packageName, String typeName, String entryName) {
            this.mNode.mId = id2;
            this.mNode.mIdPackage = packageName;
            this.mNode.mIdType = typeName;
            this.mNode.mIdEntry = entryName;
        }

        @Override
        public void setDimens(int left, int top, int scrollX, int scrollY, int width, int height) {
            this.mNode.mX = left;
            this.mNode.mY = top;
            this.mNode.mScrollX = scrollX;
            this.mNode.mScrollY = scrollY;
            this.mNode.mWidth = width;
            this.mNode.mHeight = height;
        }

        @Override
        public void setTransformation(Matrix matrix) {
            this.mNode.mMatrix = matrix == null ? null : new Matrix(matrix);
        }

        @Override
        public void setElevation(float elevation) {
            this.mNode.mElevation = elevation;
        }

        @Override
        public void setAlpha(float alpha) {
            this.mNode.mAlpha = alpha;
        }

        @Override
        public void setVisibility(int visibility) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFF3 | visibility;
        }

        @Override
        public void setAssistBlocked(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFF7F | (state ? 128 : 0);
        }

        @Override
        public void setEnabled(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFE | (state ? 0 : 1);
        }

        @Override
        public void setClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFBFF | (state ? 1024 : 0);
        }

        @Override
        public void setLongClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFF7FF | (state ? 2048 : 0);
        }

        @Override
        public void setContextClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFBFFF | (state ? 16384 : 0);
        }

        @Override
        public void setFocusable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFEF | (state ? 16 : 0);
        }

        @Override
        public void setFocused(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFDF | (state ? 32 : 0);
        }

        @Override
        public void setAccessibilityFocused(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFEFFF | (state ? 4096 : 0);
        }

        @Override
        public void setCheckable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFEFF | (state ? 256 : 0);
        }

        @Override
        public void setChecked(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFDFF | (state ? 512 : 0);
        }

        @Override
        public void setSelected(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFBF | (state ? 64 : 0);
        }

        @Override
        public void setActivated(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFDFFF | (state ? 8192 : 0);
        }

        @Override
        public void setClassName(String className) {
            this.mNode.mClassName = className;
        }

        @Override
        public void setContentDescription(CharSequence contentDescription) {
            this.mNode.mContentDescription = contentDescription;
        }

        private final ViewNodeText getNodeText() {
            if (this.mNode.mText != null) {
                return this.mNode.mText;
            }
            this.mNode.mText = new ViewNodeText();
            return this.mNode.mText;
        }

        @Override
        public void setText(CharSequence text) {
            ViewNodeText t = this.getNodeText();
            t.mText = text;
            t.mTextSelectionEnd = -1;
            t.mTextSelectionStart = -1;
        }

        @Override
        public void setText(CharSequence text, int selectionStart, int selectionEnd) {
            ViewNodeText t = this.getNodeText();
            t.mText = text;
            t.mTextSelectionStart = selectionStart;
            t.mTextSelectionEnd = selectionEnd;
        }

        @Override
        public void setTextStyle(float size, int fgColor, int bgColor, int style2) {
            ViewNodeText t = this.getNodeText();
            t.mTextColor = fgColor;
            t.mTextBackgroundColor = bgColor;
            t.mTextSize = size;
            t.mTextStyle = style2;
        }

        @Override
        public void setTextLines(int[] charOffsets, int[] baselines) {
            ViewNodeText t = this.getNodeText();
            t.mLineCharOffsets = charOffsets;
            t.mLineBaselines = baselines;
        }

        @Override
        public void setHint(CharSequence hint) {
            this.getNodeText().mHint = hint != null ? hint.toString() : null;
        }

        @Override
        public CharSequence getText() {
            return this.mNode.mText != null ? this.mNode.mText.mText : null;
        }

        @Override
        public int getTextSelectionStart() {
            return this.mNode.mText != null ? this.mNode.mText.mTextSelectionStart : -1;
        }

        @Override
        public int getTextSelectionEnd() {
            return this.mNode.mText != null ? this.mNode.mText.mTextSelectionEnd : -1;
        }

        @Override
        public CharSequence getHint() {
            return this.mNode.mText != null ? this.mNode.mText.mHint : null;
        }

        @Override
        public Bundle getExtras() {
            if (this.mNode.mExtras != null) {
                return this.mNode.mExtras;
            }
            this.mNode.mExtras = new Bundle();
            return this.mNode.mExtras;
        }

        @Override
        public boolean hasExtras() {
            return this.mNode.mExtras != null;
        }

        @Override
        public void setChildCount(int num) {
            this.mNode.mChildren = new ViewNode[num];
        }

        @Override
        public int addChildCount(int num) {
            if (this.mNode.mChildren == null) {
                this.setChildCount(num);
                return 0;
            }
            int start = this.mNode.mChildren.length;
            ViewNode[] newArray = new ViewNode[start + num];
            System.arraycopy(this.mNode.mChildren, 0, newArray, 0, start);
            this.mNode.mChildren = newArray;
            return start;
        }

        @Override
        public int getChildCount() {
            return this.mNode.mChildren != null ? this.mNode.mChildren.length : 0;
        }

        @Override
        public ViewStructure newChild(int index) {
            ViewNode node;
            this.mNode.mChildren[index] = node = new ViewNode();
            return new ViewNodeBuilder(this.mAssist, node, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ViewStructure asyncNewChild(int index) {
            AssistStructure assistStructure = this.mAssist;
            synchronized (assistStructure) {
                ViewNode node;
                this.mNode.mChildren[index] = node = new ViewNode();
                ViewNodeBuilder builder = new ViewNodeBuilder(this.mAssist, node, true);
                this.mAssist.mPendingAsyncChildren.add(builder);
                return builder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncCommit() {
            AssistStructure assistStructure = this.mAssist;
            synchronized (assistStructure) {
                if (!this.mAsync) {
                    throw new IllegalStateException("Child " + this + " was not created with ViewStructure.asyncNewChild");
                }
                if (!this.mAssist.mPendingAsyncChildren.remove(this)) {
                    throw new IllegalStateException("Child " + this + " already committed");
                }
                this.mAssist.notifyAll();
            }
        }

        @Override
        public Rect getTempRect() {
            return this.mAssist.mTmpRect;
        }
    }

    public static class ViewNode {
        public static final int TEXT_COLOR_UNDEFINED = 1;
        public static final int TEXT_STYLE_BOLD = 1;
        public static final int TEXT_STYLE_ITALIC = 2;
        public static final int TEXT_STYLE_UNDERLINE = 4;
        public static final int TEXT_STYLE_STRIKE_THRU = 8;
        int mId = -1;
        String mIdPackage;
        String mIdType;
        String mIdEntry;
        int mX;
        int mY;
        int mScrollX;
        int mScrollY;
        int mWidth;
        int mHeight;
        Matrix mMatrix;
        float mElevation;
        float mAlpha = 1.0f;
        static final int FLAGS_DISABLED = 1;
        static final int FLAGS_VISIBILITY_MASK = 12;
        static final int FLAGS_FOCUSABLE = 16;
        static final int FLAGS_FOCUSED = 32;
        static final int FLAGS_SELECTED = 64;
        static final int FLAGS_ASSIST_BLOCKED = 128;
        static final int FLAGS_CHECKABLE = 256;
        static final int FLAGS_CHECKED = 512;
        static final int FLAGS_CLICKABLE = 1024;
        static final int FLAGS_LONG_CLICKABLE = 2048;
        static final int FLAGS_ACCESSIBILITY_FOCUSED = 4096;
        static final int FLAGS_ACTIVATED = 8192;
        static final int FLAGS_CONTEXT_CLICKABLE = 16384;
        static final int FLAGS_HAS_MATRIX = 0x40000000;
        static final int FLAGS_HAS_ALPHA = 0x20000000;
        static final int FLAGS_HAS_ELEVATION = 0x10000000;
        static final int FLAGS_HAS_SCROLL = 0x8000000;
        static final int FLAGS_HAS_LARGE_COORDS = 0x4000000;
        static final int FLAGS_HAS_CONTENT_DESCRIPTION = 0x2000000;
        static final int FLAGS_HAS_TEXT = 0x1000000;
        static final int FLAGS_HAS_COMPLEX_TEXT = 0x800000;
        static final int FLAGS_HAS_EXTRAS = 0x400000;
        static final int FLAGS_HAS_ID = 0x200000;
        static final int FLAGS_HAS_CHILDREN = 0x100000;
        static final int FLAGS_ALL_CONTROL = -1048576;
        int mFlags;
        String mClassName;
        CharSequence mContentDescription;
        ViewNodeText mText;
        Bundle mExtras;
        ViewNode[] mChildren;

        ViewNode() {
        }

        ViewNode(ParcelTransferReader reader, int nestingLevel) {
            Parcel in = reader.readParcel(0x22222222, nestingLevel);
            ++reader.mNumReadViews;
            PooledStringReader preader = reader.mStringReader;
            this.mClassName = preader.readString();
            int flags = this.mFlags = in.readInt();
            if ((flags & 0x200000) != 0) {
                this.mId = in.readInt();
                if (this.mId != 0) {
                    this.mIdEntry = preader.readString();
                    if (this.mIdEntry != null) {
                        this.mIdType = preader.readString();
                        this.mIdPackage = preader.readString();
                    }
                }
            }
            if ((flags & 0x4000000) != 0) {
                this.mX = in.readInt();
                this.mY = in.readInt();
                this.mWidth = in.readInt();
                this.mHeight = in.readInt();
            } else {
                int val = in.readInt();
                this.mX = val & Short.MAX_VALUE;
                this.mY = val >> 16 & Short.MAX_VALUE;
                val = in.readInt();
                this.mWidth = val & Short.MAX_VALUE;
                this.mHeight = val >> 16 & Short.MAX_VALUE;
            }
            if ((flags & 0x8000000) != 0) {
                this.mScrollX = in.readInt();
                this.mScrollY = in.readInt();
            }
            if ((flags & 0x40000000) != 0) {
                this.mMatrix = new Matrix();
                in.readFloatArray(reader.mTmpMatrix);
                this.mMatrix.setValues(reader.mTmpMatrix);
            }
            if ((flags & 0x10000000) != 0) {
                this.mElevation = in.readFloat();
            }
            if ((flags & 0x20000000) != 0) {
                this.mAlpha = in.readFloat();
            }
            if ((flags & 0x2000000) != 0) {
                this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
            if ((flags & 0x1000000) != 0) {
                this.mText = new ViewNodeText(in, (flags & 0x800000) == 0);
            }
            if ((flags & 0x400000) != 0) {
                this.mExtras = in.readBundle();
            }
            if ((flags & 0x100000) != 0) {
                int NCHILDREN = in.readInt();
                this.mChildren = new ViewNode[NCHILDREN];
                for (int i = 0; i < NCHILDREN; ++i) {
                    this.mChildren[i] = new ViewNode(reader, nestingLevel + 1);
                }
            }
        }

        int writeSelfToParcel(Parcel out, PooledStringWriter pwriter, float[] tmpMatrix) {
            int flags = this.mFlags & 0xFFFFF;
            if (this.mId != -1) {
                flags |= 0x200000;
            }
            if ((this.mX & Short.MIN_VALUE) != 0 || (this.mY & Short.MIN_VALUE) != 0 || (this.mWidth & Short.MIN_VALUE) != 0 | (this.mHeight & Short.MIN_VALUE) != 0) {
                flags |= 0x4000000;
            }
            if (this.mScrollX != 0 || this.mScrollY != 0) {
                flags |= 0x8000000;
            }
            if (this.mMatrix != null) {
                flags |= 0x40000000;
            }
            if (this.mElevation != 0.0f) {
                flags |= 0x10000000;
            }
            if (this.mAlpha != 1.0f) {
                flags |= 0x20000000;
            }
            if (this.mContentDescription != null) {
                flags |= 0x2000000;
            }
            if (this.mText != null) {
                flags |= 0x1000000;
                if (!this.mText.isSimple()) {
                    flags |= 0x800000;
                }
            }
            if (this.mExtras != null) {
                flags |= 0x400000;
            }
            if (this.mChildren != null) {
                flags |= 0x100000;
            }
            pwriter.writeString(this.mClassName);
            out.writeInt(flags);
            if ((flags & 0x200000) != 0) {
                out.writeInt(this.mId);
                if (this.mId != 0) {
                    pwriter.writeString(this.mIdEntry);
                    if (this.mIdEntry != null) {
                        pwriter.writeString(this.mIdType);
                        pwriter.writeString(this.mIdPackage);
                    }
                }
            }
            if ((flags & 0x4000000) != 0) {
                out.writeInt(this.mX);
                out.writeInt(this.mY);
                out.writeInt(this.mWidth);
                out.writeInt(this.mHeight);
            } else {
                out.writeInt(this.mY << 16 | this.mX);
                out.writeInt(this.mHeight << 16 | this.mWidth);
            }
            if ((flags & 0x8000000) != 0) {
                out.writeInt(this.mScrollX);
                out.writeInt(this.mScrollY);
            }
            if ((flags & 0x40000000) != 0) {
                this.mMatrix.getValues(tmpMatrix);
                out.writeFloatArray(tmpMatrix);
            }
            if ((flags & 0x10000000) != 0) {
                out.writeFloat(this.mElevation);
            }
            if ((flags & 0x20000000) != 0) {
                out.writeFloat(this.mAlpha);
            }
            if ((flags & 0x2000000) != 0) {
                TextUtils.writeToParcel(this.mContentDescription, out, 0);
            }
            if ((flags & 0x1000000) != 0) {
                this.mText.writeToParcel(out, (flags & 0x800000) == 0);
            }
            if ((flags & 0x400000) != 0) {
                out.writeBundle(this.mExtras);
            }
            return flags;
        }

        public int getId() {
            return this.mId;
        }

        public String getIdPackage() {
            return this.mIdPackage;
        }

        public String getIdType() {
            return this.mIdType;
        }

        public String getIdEntry() {
            return this.mIdEntry;
        }

        public int getLeft() {
            return this.mX;
        }

        public int getTop() {
            return this.mY;
        }

        public int getScrollX() {
            return this.mScrollX;
        }

        public int getScrollY() {
            return this.mScrollY;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public Matrix getTransformation() {
            return this.mMatrix;
        }

        public float getElevation() {
            return this.mElevation;
        }

        public float getAlpha() {
            return this.mAlpha;
        }

        public int getVisibility() {
            return this.mFlags & 0xC;
        }

        public boolean isAssistBlocked() {
            return (this.mFlags & 0x80) != 0;
        }

        public boolean isEnabled() {
            return (this.mFlags & 1) == 0;
        }

        public boolean isClickable() {
            return (this.mFlags & 0x400) != 0;
        }

        public boolean isFocusable() {
            return (this.mFlags & 0x10) != 0;
        }

        public boolean isFocused() {
            return (this.mFlags & 0x20) != 0;
        }

        public boolean isAccessibilityFocused() {
            return (this.mFlags & 0x1000) != 0;
        }

        public boolean isCheckable() {
            return (this.mFlags & 0x100) != 0;
        }

        public boolean isChecked() {
            return (this.mFlags & 0x200) != 0;
        }

        public boolean isSelected() {
            return (this.mFlags & 0x40) != 0;
        }

        public boolean isActivated() {
            return (this.mFlags & 0x2000) != 0;
        }

        public boolean isLongClickable() {
            return (this.mFlags & 0x800) != 0;
        }

        public boolean isContextClickable() {
            return (this.mFlags & 0x4000) != 0;
        }

        public String getClassName() {
            return this.mClassName;
        }

        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }

        public CharSequence getText() {
            return this.mText != null ? this.mText.mText : null;
        }

        public int getTextSelectionStart() {
            return this.mText != null ? this.mText.mTextSelectionStart : -1;
        }

        public int getTextSelectionEnd() {
            return this.mText != null ? this.mText.mTextSelectionEnd : -1;
        }

        public int getTextColor() {
            return this.mText != null ? this.mText.mTextColor : 1;
        }

        public int getTextBackgroundColor() {
            return this.mText != null ? this.mText.mTextBackgroundColor : 1;
        }

        public float getTextSize() {
            return this.mText != null ? this.mText.mTextSize : 0.0f;
        }

        public int getTextStyle() {
            return this.mText != null ? this.mText.mTextStyle : 0;
        }

        public int[] getTextLineCharOffsets() {
            return this.mText != null ? this.mText.mLineCharOffsets : null;
        }

        public int[] getTextLineBaselines() {
            return this.mText != null ? this.mText.mLineBaselines : null;
        }

        public String getHint() {
            return this.mText != null ? this.mText.mHint : null;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public int getChildCount() {
            return this.mChildren != null ? this.mChildren.length : 0;
        }

        public ViewNode getChildAt(int index) {
            return this.mChildren[index];
        }
    }

    public static class WindowNode {
        final int mX;
        final int mY;
        final int mWidth;
        final int mHeight;
        final CharSequence mTitle;
        final int mDisplayId;
        final ViewNode mRoot;

        WindowNode(AssistStructure assist, ViewRootImpl root) {
            View view = root.getView();
            Rect rect = new Rect();
            view.getBoundsOnScreen(rect);
            this.mX = rect.left - view.getLeft();
            this.mY = rect.top - view.getTop();
            this.mWidth = rect.width();
            this.mHeight = rect.height();
            this.mTitle = root.getTitle();
            this.mDisplayId = root.getDisplayId();
            this.mRoot = new ViewNode();
            ViewNodeBuilder builder = new ViewNodeBuilder(assist, this.mRoot, false);
            if ((root.getWindowFlags() & 0x2000) != 0) {
                view.onProvideStructure(builder);
                builder.setAssistBlocked(true);
                return;
            }
            view.dispatchProvideStructure(builder);
        }

        WindowNode(ParcelTransferReader reader) {
            Parcel in = reader.readParcel(0x11111111, 0);
            ++reader.mNumReadWindows;
            this.mX = in.readInt();
            this.mY = in.readInt();
            this.mWidth = in.readInt();
            this.mHeight = in.readInt();
            this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mDisplayId = in.readInt();
            this.mRoot = new ViewNode(reader, 0);
        }

        void writeSelfToParcel(Parcel out, PooledStringWriter pwriter, float[] tmpMatrix) {
            out.writeInt(this.mX);
            out.writeInt(this.mY);
            out.writeInt(this.mWidth);
            out.writeInt(this.mHeight);
            TextUtils.writeToParcel(this.mTitle, out, 0);
            out.writeInt(this.mDisplayId);
        }

        public int getLeft() {
            return this.mX;
        }

        public int getTop() {
            return this.mY;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public CharSequence getTitle() {
            return this.mTitle;
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        public ViewNode getRootViewNode() {
            return this.mRoot;
        }
    }

    static final class ViewNodeText {
        CharSequence mText;
        float mTextSize;
        int mTextStyle;
        int mTextColor = 1;
        int mTextBackgroundColor = 1;
        int mTextSelectionStart;
        int mTextSelectionEnd;
        int[] mLineCharOffsets;
        int[] mLineBaselines;
        String mHint;

        ViewNodeText() {
        }

        boolean isSimple() {
            return this.mTextBackgroundColor == 1 && this.mTextSelectionStart == 0 && this.mTextSelectionEnd == 0 && this.mLineCharOffsets == null && this.mLineBaselines == null && this.mHint == null;
        }

        ViewNodeText(Parcel in, boolean simple) {
            this.mText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mTextSize = in.readFloat();
            this.mTextStyle = in.readInt();
            this.mTextColor = in.readInt();
            if (!simple) {
                this.mTextBackgroundColor = in.readInt();
                this.mTextSelectionStart = in.readInt();
                this.mTextSelectionEnd = in.readInt();
                this.mLineCharOffsets = in.createIntArray();
                this.mLineBaselines = in.createIntArray();
                this.mHint = in.readString();
            }
        }

        void writeToParcel(Parcel out, boolean simple) {
            TextUtils.writeToParcel(this.mText, out, 0);
            out.writeFloat(this.mTextSize);
            out.writeInt(this.mTextStyle);
            out.writeInt(this.mTextColor);
            if (!simple) {
                out.writeInt(this.mTextBackgroundColor);
                out.writeInt(this.mTextSelectionStart);
                out.writeInt(this.mTextSelectionEnd);
                out.writeIntArray(this.mLineCharOffsets);
                out.writeIntArray(this.mLineBaselines);
                out.writeString(this.mHint);
            }
        }
    }

    final class ParcelTransferReader {
        final float[] mTmpMatrix = new float[9];
        PooledStringReader mStringReader;
        int mNumReadWindows;
        int mNumReadViews;
        private final IBinder mChannel;
        private IBinder mTransferToken;
        private Parcel mCurParcel;

        ParcelTransferReader(IBinder channel) {
            this.mChannel = channel;
        }

        void go() {
            this.fetchData();
            AssistStructure.this.mActivityComponent = ComponentName.readFromParcel(this.mCurParcel);
            int N = this.mCurParcel.readInt();
            if (N > 0) {
                this.mStringReader = new PooledStringReader(this.mCurParcel);
                for (int i = 0; i < N; ++i) {
                    AssistStructure.this.mWindowNodes.add(new WindowNode(this));
                }
            }
        }

        Parcel readParcel(int validateToken, int level) {
            int token = this.mCurParcel.readInt();
            if (token != 0) {
                if (token != validateToken) {
                    throw new BadParcelableException("Got token " + Integer.toHexString(token) + ", expected token " + Integer.toHexString(validateToken));
                }
                return this.mCurParcel;
            }
            this.mTransferToken = this.mCurParcel.readStrongBinder();
            if (this.mTransferToken == null) {
                throw new IllegalStateException("Reached end of partial data without transfer token");
            }
            this.fetchData();
            this.mStringReader = new PooledStringReader(this.mCurParcel);
            this.mCurParcel.readInt();
            return this.mCurParcel;
        }

        private void fetchData() {
            Parcel data = Parcel.obtain();
            data.writeInterfaceToken(AssistStructure.DESCRIPTOR);
            data.writeStrongBinder(this.mTransferToken);
            if (this.mCurParcel != null) {
                this.mCurParcel.recycle();
            }
            this.mCurParcel = Parcel.obtain();
            try {
                this.mChannel.transact(2, data, this.mCurParcel, 0);
            }
            catch (RemoteException e) {
                Log.w(AssistStructure.TAG, "Failure reading AssistStructure data", e);
                throw new IllegalStateException("Failure reading AssistStructure data: " + e);
            }
            data.recycle();
            this.mNumReadViews = 0;
            this.mNumReadWindows = 0;
        }
    }

    static final class ParcelTransferWriter
    extends Binder {
        final boolean mWriteStructure;
        int mCurWindow;
        int mNumWindows;
        final ArrayList<ViewStackEntry> mViewStack = new ArrayList();
        ViewStackEntry mCurViewStackEntry;
        int mCurViewStackPos;
        int mNumWrittenWindows;
        int mNumWrittenViews;
        final float[] mTmpMatrix = new float[9];

        ParcelTransferWriter(AssistStructure as, Parcel out) {
            this.mWriteStructure = as.waitForReady();
            ComponentName.writeToParcel(as.mActivityComponent, out);
            this.mNumWindows = as.mWindowNodes.size();
            if (this.mWriteStructure && this.mNumWindows > 0) {
                out.writeInt(this.mNumWindows);
            } else {
                out.writeInt(0);
            }
        }

        void writeToParcel(AssistStructure as, Parcel out) {
            int start = out.dataPosition();
            this.mNumWrittenWindows = 0;
            this.mNumWrittenViews = 0;
            boolean more = this.writeToParcelInner(as, out);
            Log.i(AssistStructure.TAG, "Flattened " + (more ? "partial" : "final") + " assist data: " + (out.dataPosition() - start) + " bytes, containing " + this.mNumWrittenWindows + " windows, " + this.mNumWrittenViews + " views");
        }

        boolean writeToParcelInner(AssistStructure as, Parcel out) {
            if (this.mNumWindows == 0) {
                return false;
            }
            PooledStringWriter pwriter = new PooledStringWriter(out);
            while (this.writeNextEntryToParcel(as, out, pwriter)) {
                if (out.dataSize() <= 65536) continue;
                out.writeInt(0);
                out.writeStrongBinder(this);
                pwriter.finish();
                return true;
            }
            pwriter.finish();
            this.mViewStack.clear();
            return false;
        }

        void pushViewStackEntry(ViewNode node, int pos) {
            ViewStackEntry entry;
            if (pos >= this.mViewStack.size()) {
                entry = new ViewStackEntry();
                this.mViewStack.add(entry);
            } else {
                entry = this.mViewStack.get(pos);
            }
            entry.node = node;
            entry.numChildren = node.getChildCount();
            entry.curChild = 0;
            this.mCurViewStackEntry = entry;
        }

        void writeView(ViewNode child, Parcel out, PooledStringWriter pwriter, int levelAdj) {
            out.writeInt(0x22222222);
            int flags = child.writeSelfToParcel(out, pwriter, this.mTmpMatrix);
            ++this.mNumWrittenViews;
            if ((flags & 0x100000) != 0) {
                out.writeInt(child.mChildren.length);
                int pos = ++this.mCurViewStackPos;
                this.pushViewStackEntry(child, pos);
            }
        }

        boolean writeNextEntryToParcel(AssistStructure as, Parcel out, PooledStringWriter pwriter) {
            int pos;
            if (this.mCurViewStackEntry != null) {
                if (this.mCurViewStackEntry.curChild < this.mCurViewStackEntry.numChildren) {
                    ViewNode child = this.mCurViewStackEntry.node.mChildren[this.mCurViewStackEntry.curChild];
                    ++this.mCurViewStackEntry.curChild;
                    this.writeView(child, out, pwriter, 1);
                    return true;
                }
                do {
                    int pos2;
                    if ((pos2 = --this.mCurViewStackPos) < 0) {
                        this.mCurViewStackEntry = null;
                        break;
                    }
                    this.mCurViewStackEntry = this.mViewStack.get(pos2);
                } while (this.mCurViewStackEntry.curChild >= this.mCurViewStackEntry.numChildren);
                return true;
            }
            if ((pos = this.mCurWindow++) < this.mNumWindows) {
                WindowNode win = as.mWindowNodes.get(pos);
                out.writeInt(0x11111111);
                win.writeSelfToParcel(out, pwriter, this.mTmpMatrix);
                ++this.mNumWrittenWindows;
                ViewNode root = win.mRoot;
                this.mCurViewStackPos = 0;
                this.writeView(root, out, pwriter, 0);
                return true;
            }
            return false;
        }
    }

    static final class ViewStackEntry {
        ViewNode node;
        int curChild;
        int numChildren;

        ViewStackEntry() {
        }
    }

    static final class SendChannel
    extends Binder {
        volatile AssistStructure mAssistStructure;

        SendChannel(AssistStructure as) {
            this.mAssistStructure = as;
        }

        @Override
        protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            if (code == 2) {
                AssistStructure as = this.mAssistStructure;
                if (as == null) {
                    return true;
                }
                data.enforceInterface(AssistStructure.DESCRIPTOR);
                IBinder token = data.readStrongBinder();
                if (token != null) {
                    if (token instanceof ParcelTransferWriter) {
                        ParcelTransferWriter xfer = (ParcelTransferWriter)token;
                        xfer.writeToParcel(as, reply);
                        return true;
                    }
                    Log.w(AssistStructure.TAG, "Caller supplied bad token type: " + token);
                    return true;
                }
                ParcelTransferWriter xfer = new ParcelTransferWriter(as, reply);
                xfer.writeToParcel(as, reply);
                return true;
            }
            return super.onTransact(code, data, reply, flags);
        }
    }
}

