/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.UserHandle;
import android.util.Log;

public class LauncherActivityInfo {
    private static final String TAG = "LauncherActivityInfo";
    private final PackageManager mPm;
    private ActivityInfo mActivityInfo;
    private ComponentName mComponentName;
    private ResolveInfo mResolveInfo;
    private UserHandle mUser;
    private long mFirstInstallTime;

    LauncherActivityInfo(Context context, ResolveInfo info, UserHandle user, long firstInstallTime) {
        this(context);
        this.mResolveInfo = info;
        this.mActivityInfo = info.activityInfo;
        this.mComponentName = LauncherApps.getComponentName(info);
        this.mUser = user;
        this.mFirstInstallTime = firstInstallTime;
    }

    LauncherActivityInfo(Context context) {
        this.mPm = context.getPackageManager();
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public UserHandle getUser() {
        return this.mUser;
    }

    public CharSequence getLabel() {
        return this.mResolveInfo.loadLabel(this.mPm);
    }

    public Drawable getIcon(int density) {
        int iconRes = this.mResolveInfo.getIconResource();
        Drawable icon = this.getDrawableForDensity(iconRes, density);
        if (icon == null) {
            icon = this.mResolveInfo.loadIcon(this.mPm);
        }
        return icon;
    }

    private Drawable getOriginalIcon(int density) {
        int iconRes = this.mResolveInfo.getIconResourceInternal();
        Drawable icon = this.getDrawableForDensity(iconRes, density);
        if (icon == null) {
            icon = this.mResolveInfo.loadIcon(this.mPm);
        }
        return icon;
    }

    private Drawable getDrawableForDensity(int iconRes, int density) {
        if (density != 0 && iconRes != 0) {
            try {
                Resources resources = this.mPm.getResourcesForApplication(this.mActivityInfo.applicationInfo);
                return resources.getDrawableForDensity(iconRes, density);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public int getApplicationFlags() {
        return this.mActivityInfo.applicationInfo.flags;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mActivityInfo.applicationInfo;
    }

    public long getFirstInstallTime() {
        return this.mFirstInstallTime;
    }

    public String getName() {
        return this.mActivityInfo.name;
    }

    public Drawable getBadgedIcon(int density) {
        Drawable originalIcon = this.getOriginalIcon(density);
        if (originalIcon instanceof BitmapDrawable) {
            return this.mPm.getUserBadgedIcon(originalIcon, this.mUser);
        }
        Log.e(TAG, "Unable to create badged icon for " + this.mActivityInfo);
        return originalIcon;
    }
}

