/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LauncherApps {
    static final String TAG = "LauncherApps";
    static final boolean DEBUG = false;
    private Context mContext;
    private ILauncherApps mService;
    private PackageManager mPm;
    private List<CallbackMessageHandler> mCallbacks = new ArrayList<CallbackMessageHandler>();
    private IOnAppsChangedListener.Stub mAppsChangedListener = new IOnAppsChangedListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageRemoved(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageRemoved(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageChanged(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageChanged(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageAdded(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageAdded(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesAvailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesAvailable(packageNames, user, replacing);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesUnavailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesUnavailable(packageNames, user, replacing);
                }
            }
        }
    };

    public LauncherApps(Context context, ILauncherApps service) {
        this.mContext = context;
        this.mService = service;
        this.mPm = context.getPackageManager();
    }

    public List<LauncherActivityInfo> getActivityList(String packageName, UserHandle user) {
        List<ResolveInfo> activities = null;
        try {
            activities = this.mService.getLauncherActivities(packageName, user);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Failed to call LauncherAppsService");
        }
        if (activities == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LauncherActivityInfo> lais = new ArrayList<LauncherActivityInfo>();
        int count = activities.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo ri = activities.get(i);
            long firstInstallTime = 0L;
            try {
                firstInstallTime = this.mPm.getPackageInfo((String)ri.activityInfo.packageName, (int)8192).firstInstallTime;
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                // empty catch block
            }
            LauncherActivityInfo lai = new LauncherActivityInfo(this.mContext, ri, user, firstInstallTime);
            lais.add(lai);
        }
        return lais;
    }

    static ComponentName getComponentName(ResolveInfo ri) {
        return new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
    }

    public LauncherActivityInfo resolveActivity(Intent intent, UserHandle user) {
        block4: {
            try {
                ResolveInfo ri = this.mService.resolveActivity(intent, user);
                if (ri == null) break block4;
                long firstInstallTime = 0L;
                try {
                    firstInstallTime = this.mPm.getPackageInfo((String)ri.activityInfo.packageName, (int)8192).firstInstallTime;
                }
                catch (PackageManager.NameNotFoundException nnfe) {
                    // empty catch block
                }
                LauncherActivityInfo info = new LauncherActivityInfo(this.mContext, ri, user, firstInstallTime);
                return info;
            }
            catch (RemoteException re) {
                throw new RuntimeException("Failed to call LauncherAppsService");
            }
        }
        return null;
    }

    public void startMainActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        try {
            this.mService.startActivityAsUser(component, sourceBounds, opts, user);
        }
        catch (RemoteException re) {
            // empty catch block
        }
    }

    public void startAppDetailsActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        try {
            this.mService.showAppDetailsAsUser(component, sourceBounds, opts, user);
        }
        catch (RemoteException re) {
            // empty catch block
        }
    }

    public boolean isPackageEnabled(String packageName, UserHandle user) {
        try {
            return this.mService.isPackageEnabled(packageName, user);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Failed to call LauncherAppsService");
        }
    }

    public boolean isActivityEnabled(ComponentName component, UserHandle user) {
        try {
            return this.mService.isActivityEnabled(component, user);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Failed to call LauncherAppsService");
        }
    }

    public void registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(Callback callback, Handler handler) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            if (callback != null && this.findCallbackLocked(callback) < 0) {
                boolean addedFirstCallback = this.mCallbacks.size() == 0;
                this.addCallbackLocked(callback, handler);
                if (addedFirstCallback) {
                    try {
                        this.mService.addOnAppsChangedListener(this.mAppsChangedListener);
                    }
                    catch (RemoteException re) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(Callback callback) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            this.removeCallbackLocked(callback);
            if (this.mCallbacks.size() == 0) {
                try {
                    this.mService.removeOnAppsChangedListener(this.mAppsChangedListener);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    private int findCallbackLocked(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        int size = this.mCallbacks.size();
        for (int i = 0; i < size; ++i) {
            if (this.mCallbacks.get(i).mCallback != callback) continue;
            return i;
        }
        return -1;
    }

    private void removeCallbackLocked(Callback callback) {
        int pos = this.findCallbackLocked(callback);
        if (pos >= 0) {
            this.mCallbacks.remove(pos);
        }
    }

    private void addCallbackLocked(Callback callback, Handler handler) {
        this.removeCallbackLocked(callback);
        if (handler == null) {
            handler = new Handler();
        }
        CallbackMessageHandler toAdd = new CallbackMessageHandler(handler.getLooper(), callback);
        this.mCallbacks.add(toAdd);
    }

    private static class CallbackMessageHandler
    extends Handler {
        private static final int MSG_ADDED = 1;
        private static final int MSG_REMOVED = 2;
        private static final int MSG_CHANGED = 3;
        private static final int MSG_AVAILABLE = 4;
        private static final int MSG_UNAVAILABLE = 5;
        private Callback mCallback;

        public CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message msg) {
            if (this.mCallback == null || !(msg.obj instanceof CallbackInfo)) {
                return;
            }
            CallbackInfo info = (CallbackInfo)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onPackageAdded(info.packageName, info.user);
                    break;
                }
                case 2: {
                    this.mCallback.onPackageRemoved(info.packageName, info.user);
                    break;
                }
                case 3: {
                    this.mCallback.onPackageChanged(info.packageName, info.user);
                    break;
                }
                case 4: {
                    this.mCallback.onPackagesAvailable(info.packageNames, info.user, info.replacing);
                    break;
                }
                case 5: {
                    this.mCallback.onPackagesUnavailable(info.packageNames, info.user, info.replacing);
                }
            }
        }

        public void postOnPackageAdded(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(1, info).sendToTarget();
        }

        public void postOnPackageRemoved(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(2, info).sendToTarget();
        }

        public void postOnPackageChanged(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(3, info).sendToTarget();
        }

        public void postOnPackagesAvailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(4, info).sendToTarget();
        }

        public void postOnPackagesUnavailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(5, info).sendToTarget();
        }

        private static class CallbackInfo {
            String[] packageNames;
            String packageName;
            boolean replacing;
            UserHandle user;

            private CallbackInfo() {
            }
        }
    }

    public static abstract class Callback {
        public abstract void onPackageRemoved(String var1, UserHandle var2);

        public abstract void onPackageAdded(String var1, UserHandle var2);

        public abstract void onPackageChanged(String var1, UserHandle var2);

        public abstract void onPackagesAvailable(String[] var1, UserHandle var2, boolean var3);

        public abstract void onPackagesUnavailable(String[] var1, UserHandle var2, boolean var3);
    }
}

