/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class PermissionInfo
extends PackageItemInfo
implements Parcelable {
    public static final int PROTECTION_NORMAL = 0;
    public static final int PROTECTION_DANGEROUS = 1;
    public static final int PROTECTION_SIGNATURE = 2;
    @Deprecated
    public static final int PROTECTION_SIGNATURE_OR_SYSTEM = 3;
    public static final int PROTECTION_FLAG_PRIVILEGED = 16;
    @Deprecated
    public static final int PROTECTION_FLAG_SYSTEM = 16;
    public static final int PROTECTION_FLAG_DEVELOPMENT = 32;
    public static final int PROTECTION_FLAG_APPOP = 64;
    public static final int PROTECTION_FLAG_PRE23 = 128;
    public static final int PROTECTION_FLAG_INSTALLER = 256;
    public static final int PROTECTION_FLAG_VERIFIER = 512;
    public static final int PROTECTION_FLAG_PREINSTALLED = 1024;
    public static final int PROTECTION_MASK_BASE = 15;
    public static final int PROTECTION_MASK_FLAGS = 4080;
    public int protectionLevel;
    public String group;
    public static final int FLAG_COSTS_MONEY = 1;
    public static final int FLAG_HIDDEN = 2;
    public static final int FLAG_INSTALLED = 0x40000000;
    public int flags;
    public int descriptionRes;
    public CharSequence nonLocalizedDescription;
    public static final Parcelable.Creator<PermissionInfo> CREATOR = new Parcelable.Creator<PermissionInfo>(){

        @Override
        public PermissionInfo createFromParcel(Parcel source) {
            return new PermissionInfo(source);
        }

        public PermissionInfo[] newArray(int size) {
            return new PermissionInfo[size];
        }
    };

    public static int fixProtectionLevel(int level) {
        if (level == 3) {
            level = 18;
        }
        return level;
    }

    public static String protectionToString(int level) {
        String protLevel = "????";
        switch (level & 0xF) {
            case 1: {
                protLevel = "dangerous";
                break;
            }
            case 0: {
                protLevel = "normal";
                break;
            }
            case 2: {
                protLevel = "signature";
                break;
            }
            case 3: {
                protLevel = "signatureOrSystem";
            }
        }
        if ((level & 0x10) != 0) {
            protLevel = protLevel + "|privileged";
        }
        if ((level & 0x20) != 0) {
            protLevel = protLevel + "|development";
        }
        if ((level & 0x40) != 0) {
            protLevel = protLevel + "|appop";
        }
        if ((level & 0x80) != 0) {
            protLevel = protLevel + "|pre23";
        }
        if ((level & 0x100) != 0) {
            protLevel = protLevel + "|installer";
        }
        if ((level & 0x200) != 0) {
            protLevel = protLevel + "|verifier";
        }
        if ((level & 0x400) != 0) {
            protLevel = protLevel + "|preinstalled";
        }
        return protLevel;
    }

    public PermissionInfo() {
    }

    public PermissionInfo(PermissionInfo orig) {
        super(orig);
        this.protectionLevel = orig.protectionLevel;
        this.flags = orig.flags;
        this.group = orig.group;
        this.descriptionRes = orig.descriptionRes;
        this.nonLocalizedDescription = orig.nonLocalizedDescription;
    }

    public CharSequence loadDescription(PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedDescription != null) {
            return this.nonLocalizedDescription;
        }
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, null)) != null) {
            return label;
        }
        return null;
    }

    public String toString() {
        return "PermissionInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeInt(this.protectionLevel);
        dest.writeInt(this.flags);
        dest.writeString(this.group);
        dest.writeInt(this.descriptionRes);
        TextUtils.writeToParcel(this.nonLocalizedDescription, dest, parcelableFlags);
    }

    private PermissionInfo(Parcel source) {
        super(source);
        this.protectionLevel = source.readInt();
        this.flags = source.readInt();
        this.group = source.readString();
        this.descriptionRes = source.readInt();
        this.nonLocalizedDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
    }
}

