/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Configuration;
import java.util.Objects;

public final class ResourcesKey {
    private final String mResDir;
    private final float mScale;
    private final int mHash;
    public final int mDisplayId;
    public final Configuration mOverrideConfiguration;

    public ResourcesKey(String resDir, int displayId, Configuration overrideConfiguration, float scale) {
        this.mResDir = resDir;
        this.mDisplayId = displayId;
        this.mOverrideConfiguration = overrideConfiguration != null ? overrideConfiguration : Configuration.EMPTY;
        this.mScale = scale;
        int hash = 17;
        hash = 31 * hash + (this.mResDir == null ? 0 : this.mResDir.hashCode());
        hash = 31 * hash + this.mDisplayId;
        hash = 31 * hash + this.mOverrideConfiguration.hashCode();
        this.mHash = hash = 31 * hash + Float.floatToIntBits(this.mScale);
    }

    public boolean hasOverrideConfiguration() {
        return !Configuration.EMPTY.equals(this.mOverrideConfiguration);
    }

    public int hashCode() {
        return this.mHash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourcesKey)) {
            return false;
        }
        ResourcesKey peer = (ResourcesKey)obj;
        if (!Objects.equals(this.mResDir, peer.mResDir)) {
            return false;
        }
        if (this.mDisplayId != peer.mDisplayId) {
            return false;
        }
        if (!this.mOverrideConfiguration.equals(peer.mOverrideConfiguration)) {
            return false;
        }
        return this.mScale == peer.mScale;
    }

    public String toString() {
        return Integer.toHexString(this.mHash);
    }
}

