/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;

public class VertexFrame
extends Frame {
    private int vertexFrameId = -1;

    VertexFrame(FrameFormat format, FrameManager frameManager) {
        super(format, frameManager);
        if (this.getFormat().getSize() <= 0) {
            throw new IllegalArgumentException("Initializing vertex frame with zero size!");
        }
        if (!this.nativeAllocate(this.getFormat().getSize())) {
            throw new RuntimeException("Could not allocate vertex frame!");
        }
    }

    @Override
    protected synchronized boolean hasNativeAllocation() {
        return this.vertexFrameId != -1;
    }

    @Override
    protected synchronized void releaseNativeAllocation() {
        this.nativeDeallocate();
        this.vertexFrameId = -1;
    }

    @Override
    public Object getObjectValue() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public void setInts(int[] ints) {
        this.assertFrameMutable();
        if (!this.setNativeInts(ints)) {
            throw new RuntimeException("Could not set int values for vertex frame!");
        }
    }

    @Override
    public int[] getInts() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public void setFloats(float[] floats) {
        this.assertFrameMutable();
        if (!this.setNativeFloats(floats)) {
            throw new RuntimeException("Could not set int values for vertex frame!");
        }
    }

    @Override
    public float[] getFloats() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public void setData(ByteBuffer buffer, int offset, int length) {
        this.assertFrameMutable();
        byte[] bytes = buffer.array();
        if (this.getFormat().getSize() != bytes.length) {
            throw new RuntimeException("Data size in setData does not match vertex frame size!");
        }
        if (!this.setNativeData(bytes, offset, length)) {
            throw new RuntimeException("Could not set vertex frame data!");
        }
    }

    @Override
    public ByteBuffer getData() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new RuntimeException("Unsupported: Cannot set vertex frame bitmap value!");
    }

    @Override
    public Bitmap getBitmap() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public void setDataFromFrame(Frame frame) {
        super.setDataFromFrame(frame);
    }

    public int getVboId() {
        return this.getNativeVboId();
    }

    public String toString() {
        return "VertexFrame (" + this.getFormat() + ") with VBO ID " + this.getVboId();
    }

    private native boolean nativeAllocate(int var1);

    private native boolean nativeDeallocate();

    private native boolean setNativeData(byte[] var1, int var2, int var3);

    private native boolean setNativeInts(int[] var1);

    private native boolean setNativeFloats(float[] var1);

    private native int getNativeVboId();

    static {
        System.loadLibrary("filterfw");
    }
}

