/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;

public final class LargeBitmap {
    private long mNativeLargeBitmap;
    private boolean mRecycled;

    private LargeBitmap(long nativeLbm) {
        this.mNativeLargeBitmap = nativeLbm;
        this.mRecycled = false;
    }

    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        this.checkRecycled("decodeRegion called on recycled large bitmap");
        if (rect.left < 0 || rect.top < 0 || rect.right > this.getWidth() || rect.bottom > this.getHeight()) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        return LargeBitmap.nativeDecodeRegion(this.mNativeLargeBitmap, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, options);
    }

    public int getWidth() {
        this.checkRecycled("getWidth called on recycled large bitmap");
        return LargeBitmap.nativeGetWidth(this.mNativeLargeBitmap);
    }

    public int getHeight() {
        this.checkRecycled("getHeight called on recycled large bitmap");
        return LargeBitmap.nativeGetHeight(this.mNativeLargeBitmap);
    }

    public void recycle() {
        if (!this.mRecycled) {
            LargeBitmap.nativeClean(this.mNativeLargeBitmap);
            this.mRecycled = true;
        }
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    private void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    protected void finalize() {
        this.recycle();
    }

    private static native Bitmap nativeDecodeRegion(long var0, int var2, int var3, int var4, int var5, BitmapFactory.Options var6);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native void nativeClean(long var0);
}

