/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.RectF;
import java.io.PrintWriter;

public class Matrix {
    public static final int MSCALE_X = 0;
    public static final int MSKEW_X = 1;
    public static final int MTRANS_X = 2;
    public static final int MSKEW_Y = 3;
    public static final int MSCALE_Y = 4;
    public static final int MTRANS_Y = 5;
    public static final int MPERSP_0 = 6;
    public static final int MPERSP_1 = 7;
    public static final int MPERSP_2 = 8;
    public static final Matrix IDENTITY_MATRIX = new Matrix(){

        void oops() {
            throw new IllegalStateException("Matrix can not be modified");
        }

        @Override
        public void set(Matrix src) {
            this.oops();
        }

        @Override
        public void reset() {
            this.oops();
        }

        @Override
        public void setTranslate(float dx, float dy) {
            this.oops();
        }

        @Override
        public void setScale(float sx, float sy, float px, float py) {
            this.oops();
        }

        @Override
        public void setScale(float sx, float sy) {
            this.oops();
        }

        @Override
        public void setRotate(float degrees, float px, float py) {
            this.oops();
        }

        @Override
        public void setRotate(float degrees) {
            this.oops();
        }

        @Override
        public void setSinCos(float sinValue, float cosValue, float px, float py) {
            this.oops();
        }

        @Override
        public void setSinCos(float sinValue, float cosValue) {
            this.oops();
        }

        @Override
        public void setSkew(float kx, float ky, float px, float py) {
            this.oops();
        }

        @Override
        public void setSkew(float kx, float ky) {
            this.oops();
        }

        @Override
        public boolean setConcat(Matrix a, Matrix b) {
            this.oops();
            return false;
        }

        @Override
        public boolean preTranslate(float dx, float dy) {
            this.oops();
            return false;
        }

        @Override
        public boolean preScale(float sx, float sy, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preScale(float sx, float sy) {
            this.oops();
            return false;
        }

        @Override
        public boolean preRotate(float degrees, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preRotate(float degrees) {
            this.oops();
            return false;
        }

        @Override
        public boolean preSkew(float kx, float ky, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preSkew(float kx, float ky) {
            this.oops();
            return false;
        }

        @Override
        public boolean preConcat(Matrix other) {
            this.oops();
            return false;
        }

        @Override
        public boolean postTranslate(float dx, float dy) {
            this.oops();
            return false;
        }

        @Override
        public boolean postScale(float sx, float sy, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postScale(float sx, float sy) {
            this.oops();
            return false;
        }

        @Override
        public boolean postRotate(float degrees, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postRotate(float degrees) {
            this.oops();
            return false;
        }

        @Override
        public boolean postSkew(float kx, float ky, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postSkew(float kx, float ky) {
            this.oops();
            return false;
        }

        @Override
        public boolean postConcat(Matrix other) {
            this.oops();
            return false;
        }

        @Override
        public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
            this.oops();
            return false;
        }

        @Override
        public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
            this.oops();
            return false;
        }

        @Override
        public void setValues(float[] values) {
            this.oops();
        }
    };
    public long native_instance;

    public Matrix() {
        this.native_instance = Matrix.native_create(0L);
    }

    public Matrix(Matrix src) {
        this.native_instance = Matrix.native_create(src != null ? src.native_instance : 0L);
    }

    public boolean isIdentity() {
        return Matrix.native_isIdentity(this.native_instance);
    }

    public boolean isAffine() {
        return Matrix.native_isAffine(this.native_instance);
    }

    public boolean rectStaysRect() {
        return Matrix.native_rectStaysRect(this.native_instance);
    }

    public void set(Matrix src) {
        if (src == null) {
            this.reset();
        } else {
            Matrix.native_set(this.native_instance, src.native_instance);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        return Matrix.native_equals(this.native_instance, ((Matrix)obj).native_instance);
    }

    public int hashCode() {
        return 44;
    }

    public void reset() {
        Matrix.native_reset(this.native_instance);
    }

    public void setTranslate(float dx, float dy) {
        Matrix.native_setTranslate(this.native_instance, dx, dy);
    }

    public void setScale(float sx, float sy, float px, float py) {
        Matrix.native_setScale(this.native_instance, sx, sy, px, py);
    }

    public void setScale(float sx, float sy) {
        Matrix.native_setScale(this.native_instance, sx, sy);
    }

    public void setRotate(float degrees, float px, float py) {
        Matrix.native_setRotate(this.native_instance, degrees, px, py);
    }

    public void setRotate(float degrees) {
        Matrix.native_setRotate(this.native_instance, degrees);
    }

    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        Matrix.native_setSinCos(this.native_instance, sinValue, cosValue, px, py);
    }

    public void setSinCos(float sinValue, float cosValue) {
        Matrix.native_setSinCos(this.native_instance, sinValue, cosValue);
    }

    public void setSkew(float kx, float ky, float px, float py) {
        Matrix.native_setSkew(this.native_instance, kx, ky, px, py);
    }

    public void setSkew(float kx, float ky) {
        Matrix.native_setSkew(this.native_instance, kx, ky);
    }

    public boolean setConcat(Matrix a, Matrix b) {
        Matrix.native_setConcat(this.native_instance, a.native_instance, b.native_instance);
        return true;
    }

    public boolean preTranslate(float dx, float dy) {
        Matrix.native_preTranslate(this.native_instance, dx, dy);
        return true;
    }

    public boolean preScale(float sx, float sy, float px, float py) {
        Matrix.native_preScale(this.native_instance, sx, sy, px, py);
        return true;
    }

    public boolean preScale(float sx, float sy) {
        Matrix.native_preScale(this.native_instance, sx, sy);
        return true;
    }

    public boolean preRotate(float degrees, float px, float py) {
        Matrix.native_preRotate(this.native_instance, degrees, px, py);
        return true;
    }

    public boolean preRotate(float degrees) {
        Matrix.native_preRotate(this.native_instance, degrees);
        return true;
    }

    public boolean preSkew(float kx, float ky, float px, float py) {
        Matrix.native_preSkew(this.native_instance, kx, ky, px, py);
        return true;
    }

    public boolean preSkew(float kx, float ky) {
        Matrix.native_preSkew(this.native_instance, kx, ky);
        return true;
    }

    public boolean preConcat(Matrix other) {
        Matrix.native_preConcat(this.native_instance, other.native_instance);
        return true;
    }

    public boolean postTranslate(float dx, float dy) {
        Matrix.native_postTranslate(this.native_instance, dx, dy);
        return true;
    }

    public boolean postScale(float sx, float sy, float px, float py) {
        Matrix.native_postScale(this.native_instance, sx, sy, px, py);
        return true;
    }

    public boolean postScale(float sx, float sy) {
        Matrix.native_postScale(this.native_instance, sx, sy);
        return true;
    }

    public boolean postRotate(float degrees, float px, float py) {
        Matrix.native_postRotate(this.native_instance, degrees, px, py);
        return true;
    }

    public boolean postRotate(float degrees) {
        Matrix.native_postRotate(this.native_instance, degrees);
        return true;
    }

    public boolean postSkew(float kx, float ky, float px, float py) {
        Matrix.native_postSkew(this.native_instance, kx, ky, px, py);
        return true;
    }

    public boolean postSkew(float kx, float ky) {
        Matrix.native_postSkew(this.native_instance, kx, ky);
        return true;
    }

    public boolean postConcat(Matrix other) {
        Matrix.native_postConcat(this.native_instance, other.native_instance);
        return true;
    }

    public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.native_setRectToRect(this.native_instance, src, dst, stf.nativeInt);
    }

    private static void checkPointArrays(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        int srcStop = srcIndex + (pointCount << 1);
        int dstStop = dstIndex + (pointCount << 1);
        if ((pointCount | srcIndex | dstIndex | srcStop | dstStop) < 0 || srcStop > src.length || dstStop > dst.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        if (pointCount > 4) {
            throw new IllegalArgumentException();
        }
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        return Matrix.native_setPolyToPoly(this.native_instance, src, srcIndex, dst, dstIndex, pointCount);
    }

    public boolean invert(Matrix inverse) {
        return Matrix.native_invert(this.native_instance, inverse.native_instance);
    }

    public void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        Matrix.native_mapPoints(this.native_instance, dst, dstIndex, src, srcIndex, pointCount, true);
    }

    public void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int vectorCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, vectorCount);
        Matrix.native_mapPoints(this.native_instance, dst, dstIndex, src, srcIndex, vectorCount, false);
    }

    public void mapPoints(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapPoints(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapVectors(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapVectors(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    public void mapVectors(float[] vecs) {
        this.mapVectors(vecs, 0, vecs, 0, vecs.length >> 1);
    }

    public boolean mapRect(RectF dst, RectF src) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.native_mapRect(this.native_instance, dst, src);
    }

    public boolean mapRect(RectF rect) {
        return this.mapRect(rect, rect);
    }

    public float mapRadius(float radius) {
        return Matrix.native_mapRadius(this.native_instance, radius);
    }

    public void getValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.native_getValues(this.native_instance, values);
    }

    public void setValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.native_setValues(this.native_instance, values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Matrix{");
        this.toShortString(sb);
        sb.append('}');
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(64);
        this.toShortString(sb);
        return sb.toString();
    }

    public void toShortString(StringBuilder sb) {
        float[] values = new float[9];
        this.getValues(values);
        sb.append('[');
        sb.append(values[0]);
        sb.append(", ");
        sb.append(values[1]);
        sb.append(", ");
        sb.append(values[2]);
        sb.append("][");
        sb.append(values[3]);
        sb.append(", ");
        sb.append(values[4]);
        sb.append(", ");
        sb.append(values[5]);
        sb.append("][");
        sb.append(values[6]);
        sb.append(", ");
        sb.append(values[7]);
        sb.append(", ");
        sb.append(values[8]);
        sb.append(']');
    }

    public void printShortString(PrintWriter pw) {
        float[] values = new float[9];
        this.getValues(values);
        pw.print('[');
        pw.print(values[0]);
        pw.print(", ");
        pw.print(values[1]);
        pw.print(", ");
        pw.print(values[2]);
        pw.print("][");
        pw.print(values[3]);
        pw.print(", ");
        pw.print(values[4]);
        pw.print(", ");
        pw.print(values[5]);
        pw.print("][");
        pw.print(values[6]);
        pw.print(", ");
        pw.print(values[7]);
        pw.print(", ");
        pw.print(values[8]);
        pw.print(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Matrix.finalizer(this.native_instance);
        }
        finally {
            super.finalize();
        }
    }

    final long ni() {
        return this.native_instance;
    }

    private static native long native_create(long var0);

    private static native boolean native_isIdentity(long var0);

    private static native boolean native_isAffine(long var0);

    private static native boolean native_rectStaysRect(long var0);

    private static native void native_reset(long var0);

    private static native void native_set(long var0, long var2);

    private static native void native_setTranslate(long var0, float var2, float var3);

    private static native void native_setScale(long var0, float var2, float var3, float var4, float var5);

    private static native void native_setScale(long var0, float var2, float var3);

    private static native void native_setRotate(long var0, float var2, float var3, float var4);

    private static native void native_setRotate(long var0, float var2);

    private static native void native_setSinCos(long var0, float var2, float var3, float var4, float var5);

    private static native void native_setSinCos(long var0, float var2, float var3);

    private static native void native_setSkew(long var0, float var2, float var3, float var4, float var5);

    private static native void native_setSkew(long var0, float var2, float var3);

    private static native void native_setConcat(long var0, long var2, long var4);

    private static native void native_preTranslate(long var0, float var2, float var3);

    private static native void native_preScale(long var0, float var2, float var3, float var4, float var5);

    private static native void native_preScale(long var0, float var2, float var3);

    private static native void native_preRotate(long var0, float var2, float var3, float var4);

    private static native void native_preRotate(long var0, float var2);

    private static native void native_preSkew(long var0, float var2, float var3, float var4, float var5);

    private static native void native_preSkew(long var0, float var2, float var3);

    private static native void native_preConcat(long var0, long var2);

    private static native void native_postTranslate(long var0, float var2, float var3);

    private static native void native_postScale(long var0, float var2, float var3, float var4, float var5);

    private static native void native_postScale(long var0, float var2, float var3);

    private static native void native_postRotate(long var0, float var2, float var3, float var4);

    private static native void native_postRotate(long var0, float var2);

    private static native void native_postSkew(long var0, float var2, float var3, float var4, float var5);

    private static native void native_postSkew(long var0, float var2, float var3);

    private static native void native_postConcat(long var0, long var2);

    private static native boolean native_setRectToRect(long var0, RectF var2, RectF var3, int var4);

    private static native boolean native_setPolyToPoly(long var0, float[] var2, int var3, float[] var4, int var5, int var6);

    private static native boolean native_invert(long var0, long var2);

    private static native void native_mapPoints(long var0, float[] var2, int var3, float[] var4, int var5, int var6, boolean var7);

    private static native boolean native_mapRect(long var0, RectF var2, RectF var3);

    private static native float native_mapRadius(long var0, float var2);

    private static native void native_getValues(long var0, float[] var2);

    private static native void native_setValues(long var0, float[] var2);

    private static native boolean native_equals(long var0, long var2);

    private static native void finalizer(long var0);

    public static enum ScaleToFit {
        FILL(0),
        START(1),
        CENTER(2),
        END(3);

        final int nativeInt;

        private ScaleToFit(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

