/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Movie {
    private final long mNativeMovie;

    private Movie(long nativeMovie) {
        if (nativeMovie == 0L) {
            throw new RuntimeException("native movie creation failed");
        }
        this.mNativeMovie = nativeMovie;
    }

    public native int width();

    public native int height();

    public native boolean isOpaque();

    public native int duration();

    public native boolean setTime(int var1);

    private native void nDraw(long var1, float var3, float var4, long var5);

    public void draw(Canvas canvas, float x, float y, Paint paint) {
        this.nDraw(canvas.getNativeCanvasWrapper(), x, y, paint != null ? paint.getNativeInstance() : 0L);
    }

    public void draw(Canvas canvas, float x, float y) {
        this.nDraw(canvas.getNativeCanvasWrapper(), x, y, 0L);
    }

    public static Movie decodeStream(InputStream is) {
        if (is == null) {
            return null;
        }
        if (is instanceof AssetManager.AssetInputStream) {
            long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
            return Movie.nativeDecodeAsset(asset);
        }
        return Movie.nativeDecodeStream(is);
    }

    private static native Movie nativeDecodeAsset(long var0);

    private static native Movie nativeDecodeStream(InputStream var0);

    public static native Movie decodeByteArray(byte[] var0, int var1, int var2);

    private static native void nativeDestructor(long var0);

    public static Movie decodeFile(String pathName) {
        FileInputStream is;
        try {
            is = new FileInputStream(pathName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return Movie.decodeTempStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Movie.nativeDestructor(this.mNativeMovie);
        }
        finally {
            super.finalize();
        }
    }

    private static Movie decodeTempStream(InputStream is) {
        Movie moov = null;
        try {
            moov = Movie.decodeStream(is);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return moov;
    }
}

