/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;

public class NinePatch {
    private final Bitmap mBitmap;
    public final long mNativeChunk;
    private Paint mPaint;
    private String mSrcName;

    public NinePatch(Bitmap bitmap, byte[] chunk) {
        this(bitmap, chunk, null);
    }

    public NinePatch(Bitmap bitmap, byte[] chunk, String srcName) {
        this.mBitmap = bitmap;
        this.mSrcName = srcName;
        this.mNativeChunk = NinePatch.validateNinePatchChunk(chunk);
    }

    public NinePatch(NinePatch patch) {
        this.mBitmap = patch.mBitmap;
        this.mSrcName = patch.mSrcName;
        if (patch.mPaint != null) {
            this.mPaint = new Paint(patch.mPaint);
        }
        this.mNativeChunk = patch.mNativeChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mNativeChunk != 0L) {
                NinePatch.nativeFinalize(this.mNativeChunk);
            }
        }
        finally {
            super.finalize();
        }
    }

    public String getName() {
        return this.mSrcName;
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void setPaint(Paint p) {
        this.mPaint = p;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void draw(Canvas canvas, RectF location) {
        canvas.drawPatch(this, location, this.mPaint);
    }

    public void draw(Canvas canvas, Rect location) {
        canvas.drawPatch(this, location, this.mPaint);
    }

    public void draw(Canvas canvas, Rect location, Paint paint) {
        canvas.drawPatch(this, location, paint);
    }

    void drawSoftware(Canvas canvas, RectF location, Paint paint) {
        NinePatch.nativeDraw(canvas.getNativeCanvasWrapper(), location, this.mBitmap, this.mNativeChunk, paint != null ? paint.getNativeInstance() : 0L, canvas.mDensity, this.mBitmap.mDensity);
    }

    void drawSoftware(Canvas canvas, Rect location, Paint paint) {
        NinePatch.nativeDraw(canvas.getNativeCanvasWrapper(), location, this.mBitmap, this.mNativeChunk, paint != null ? paint.getNativeInstance() : 0L, canvas.mDensity, this.mBitmap.mDensity);
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    public final boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public final Region getTransparentRegion(Rect bounds) {
        long r = NinePatch.nativeGetTransparentRegion(this.mBitmap, this.mNativeChunk, bounds);
        return r != 0L ? new Region(r) : null;
    }

    public static native boolean isNinePatchChunk(byte[] var0);

    private static native long validateNinePatchChunk(byte[] var0);

    private static native void nativeFinalize(long var0);

    private static native void nativeDraw(long var0, RectF var2, Bitmap var3, long var4, long var6, int var8, int var9);

    private static native void nativeDraw(long var0, Rect var2, Bitmap var3, long var4, long var6, int var8, int var9);

    private static native long nativeGetTransparentRegion(Bitmap var0, long var1, Rect var3);

    public static class InsetStruct {
        public final Rect opticalRect;
        public final Rect outlineRect;
        public final float outlineRadius;
        public final float outlineAlpha;

        InsetStruct(int opticalLeft, int opticalTop, int opticalRight, int opticalBottom, int outlineLeft, int outlineTop, int outlineRight, int outlineBottom, float outlineRadius, int outlineAlpha, float decodeScale) {
            this.opticalRect = new Rect(opticalLeft, opticalTop, opticalRight, opticalBottom);
            this.outlineRect = new Rect(outlineLeft, outlineTop, outlineRight, outlineBottom);
            if (decodeScale != 1.0f) {
                this.opticalRect.scale(decodeScale);
                this.outlineRect.scaleRoundIn(decodeScale);
            }
            this.outlineRadius = outlineRadius * decodeScale;
            this.outlineAlpha = (float)outlineAlpha / 255.0f;
        }
    }
}

