/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ClipDrawable
extends DrawableWrapper {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private static final int MAX_LEVEL = 10000;
    private final Rect mTmpRect = new Rect();
    private ClipState mState;

    ClipDrawable() {
        this(new ClipState(null), null);
    }

    public ClipDrawable(Drawable drawable2, int gravity, int orientation) {
        this(new ClipState(null), null);
        this.mState.mGravity = gravity;
        this.mState.mOrientation = orientation;
        this.setDrawable(drawable2);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = ClipDrawable.obtainAttributes(r, theme, attrs, R.styleable.ClipDrawable);
        this.updateStateFromTypedArray(a);
        this.inflateChildDrawable(r, parser, attrs, theme);
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <clip> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
        }
    }

    @Override
    void updateStateFromTypedArray(TypedArray a) {
        super.updateStateFromTypedArray(a);
        ClipState state = this.mState;
        state.mOrientation = a.getInt(2, state.mOrientation);
        state.mGravity = a.getInt(0, state.mGravity);
        Drawable dr = a.getDrawable(1);
        if (dr != null) {
            this.setDrawable(dr);
        }
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        ClipState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.ClipDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        super.applyTheme(t);
    }

    @Override
    protected boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.invalidateSelf();
        return true;
    }

    @Override
    public int getOpacity() {
        Drawable dr = this.getDrawable();
        int opacity = dr.getOpacity();
        if (opacity == -2 || dr.getLevel() == 0) {
            return -2;
        }
        int level = this.getLevel();
        if (level >= 10000) {
            return dr.getOpacity();
        }
        return -3;
    }

    @Override
    public void draw(Canvas canvas) {
        Drawable dr = this.getDrawable();
        if (dr.getLevel() == 0) {
            return;
        }
        Rect r = this.mTmpRect;
        Rect bounds = this.getBounds();
        int level = this.getLevel();
        int w = bounds.width();
        boolean iw = false;
        if ((this.mState.mOrientation & 1) != 0) {
            w -= (w - 0) * (10000 - level) / 10000;
        }
        int h = bounds.height();
        boolean ih = false;
        if ((this.mState.mOrientation & 2) != 0) {
            h -= (h - 0) * (10000 - level) / 10000;
        }
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(this.mState.mGravity, w, h, bounds, r, layoutDirection);
        if (w > 0 && h > 0) {
            canvas.save();
            canvas.clipRect(r);
            dr.draw(canvas);
            canvas.restore();
        }
    }

    private ClipDrawable(ClipState state, Resources res) {
        super(state, res);
        this.mState = state;
    }

    static final class ClipState
    extends DrawableWrapper.DrawableWrapperState {
        int mOrientation = 1;
        int mGravity = 3;

        ClipState(ClipState orig) {
            super(orig);
            if (orig != null) {
                this.mOrientation = orig.mOrientation;
                this.mGravity = orig.mGravity;
            }
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new ClipDrawable(this, res);
        }
    }
}

