/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.location.Location;
import android.media.Image;
import android.os.SystemClock;
import android.util.Size;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public final class DngCreator
implements AutoCloseable {
    private static final String TAG = "DngCreator";
    public static final int MAX_THUMBNAIL_DIMENSION = 256;
    private static final String GPS_LAT_REF_NORTH = "N";
    private static final String GPS_LAT_REF_SOUTH = "S";
    private static final String GPS_LONG_REF_EAST = "E";
    private static final String GPS_LONG_REF_WEST = "W";
    private static final String GPS_DATE_FORMAT_STR = "yyyy:MM:dd";
    private static final String TIFF_DATETIME_FORMAT = "yyyy:MM:dd kk:mm:ss";
    private static final DateFormat sExifGPSDateStamp = new SimpleDateFormat("yyyy:MM:dd");
    private static final DateFormat sDateTimeStampFormat = new SimpleDateFormat("yyyy:MM:dd kk:mm:ss");
    private final Calendar mGPSTimeStampCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final int DEFAULT_PIXEL_STRIDE = 2;
    private static final int BYTES_PER_RGB_PIX = 3;
    private long mNativeContext;

    public DngCreator(CameraCharacteristics characteristics, CaptureResult metadata) {
        if (characteristics == null || metadata == null) {
            throw new IllegalArgumentException("Null argument to DngCreator constructor");
        }
        long currentTime = System.currentTimeMillis();
        long bootTimeMillis = currentTime - SystemClock.elapsedRealtime();
        Long timestamp = metadata.get(CaptureResult.SENSOR_TIMESTAMP);
        long captureTime = currentTime;
        if (timestamp != null) {
            captureTime = timestamp / 1000000L + bootTimeMillis;
        }
        String formattedCaptureTime = sDateTimeStampFormat.format(captureTime);
        this.nativeInit(characteristics.getNativeCopy(), metadata.getNativeCopy(), formattedCaptureTime);
    }

    public DngCreator setOrientation(int orientation) {
        if (orientation < 0 || orientation > 8) {
            throw new IllegalArgumentException("Orientation " + orientation + " is not a valid EXIF orientation value");
        }
        this.nativeSetOrientation(orientation);
        return this;
    }

    public DngCreator setThumbnail(Bitmap pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("Null argument to setThumbnail");
        }
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        if (width > 256 || height > 256) {
            throw new IllegalArgumentException("Thumbnail dimensions width,height (" + width + "," + height + ") too large, dimensions must be smaller than " + 256);
        }
        ByteBuffer rgbBuffer = DngCreator.convertToRGB(pixels);
        this.nativeSetThumbnail(rgbBuffer, width, height);
        return this;
    }

    public DngCreator setThumbnail(Image pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("Null argument to setThumbnail");
        }
        int format = pixels.getFormat();
        if (format != 35) {
            throw new IllegalArgumentException("Unsupported Image format " + format);
        }
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        if (width > 256 || height > 256) {
            throw new IllegalArgumentException("Thumbnail dimensions width,height (" + width + "," + height + ") too large, dimensions must be smaller than " + 256);
        }
        ByteBuffer rgbBuffer = DngCreator.convertToRGB(pixels);
        this.nativeSetThumbnail(rgbBuffer, width, height);
        return this;
    }

    public DngCreator setLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location passed to setLocation");
        }
        double latitude = location.getLatitude();
        double longitude = location.getLongitude();
        long time = location.getTime();
        int[] latTag = DngCreator.toExifLatLong(latitude);
        int[] longTag = DngCreator.toExifLatLong(longitude);
        String latRef = latitude >= 0.0 ? GPS_LAT_REF_NORTH : GPS_LAT_REF_SOUTH;
        String longRef = longitude >= 0.0 ? GPS_LONG_REF_EAST : GPS_LONG_REF_WEST;
        String dateTag = sExifGPSDateStamp.format(time);
        this.mGPSTimeStampCalendar.setTimeInMillis(time);
        int[] timeTag = new int[]{this.mGPSTimeStampCalendar.get(11), 1, this.mGPSTimeStampCalendar.get(12), 1, this.mGPSTimeStampCalendar.get(13), 1};
        this.nativeSetGpsTags(latTag, latRef, longTag, longRef, dateTag, timeTag);
        return this;
    }

    public DngCreator setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Null description passed to setDescription.");
        }
        this.nativeSetDescription(description);
        return this;
    }

    public void writeInputStream(OutputStream dngOutput, Size size, InputStream pixels, long offset) throws IOException {
        if (dngOutput == null) {
            throw new IllegalArgumentException("Null dngOutput passed to writeInputStream");
        }
        if (size == null) {
            throw new IllegalArgumentException("Null size passed to writeInputStream");
        }
        if (pixels == null) {
            throw new IllegalArgumentException("Null pixels passed to writeInputStream");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Negative offset passed to writeInputStream");
        }
        int width = size.getWidth();
        int height = size.getHeight();
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Size with invalid width, height: (" + width + "," + height + ") passed to writeInputStream");
        }
        this.nativeWriteInputStream(dngOutput, pixels, width, height, offset);
    }

    public void writeByteBuffer(OutputStream dngOutput, Size size, ByteBuffer pixels, long offset) throws IOException {
        if (dngOutput == null) {
            throw new IllegalArgumentException("Null dngOutput passed to writeByteBuffer");
        }
        if (size == null) {
            throw new IllegalArgumentException("Null size passed to writeByteBuffer");
        }
        if (pixels == null) {
            throw new IllegalArgumentException("Null pixels passed to writeByteBuffer");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Negative offset passed to writeByteBuffer");
        }
        int width = size.getWidth();
        int height = size.getHeight();
        this.writeByteBuffer(width, height, pixels, dngOutput, 2, width * 2, offset);
    }

    public void writeImage(OutputStream dngOutput, Image pixels) throws IOException {
        if (dngOutput == null) {
            throw new IllegalArgumentException("Null dngOutput to writeImage");
        }
        if (pixels == null) {
            throw new IllegalArgumentException("Null pixels to writeImage");
        }
        int format = pixels.getFormat();
        if (format != 32) {
            throw new IllegalArgumentException("Unsupported image format " + format);
        }
        Image.Plane[] planes = pixels.getPlanes();
        if (planes == null || planes.length <= 0) {
            throw new IllegalArgumentException("Image with no planes passed to writeImage");
        }
        ByteBuffer buf = planes[0].getBuffer();
        this.writeByteBuffer(pixels.getWidth(), pixels.getHeight(), buf, dngOutput, planes[0].getPixelStride(), planes[0].getRowStride(), 0L);
    }

    @Override
    public void close() {
        this.nativeDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void writeByteBuffer(int width, int height, ByteBuffer pixels, OutputStream dngOutput, int pixelStride, int rowStride, long offset) throws IOException {
        long totalSize;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image with invalid width, height: (" + width + "," + height + ") passed to write");
        }
        long capacity = pixels.capacity();
        if (capacity < (totalSize = (long)rowStride * (long)height + offset)) {
            throw new IllegalArgumentException("Image size " + capacity + " is too small (must be larger than " + totalSize + ")");
        }
        int minRowStride = pixelStride * width;
        if (minRowStride > rowStride) {
            throw new IllegalArgumentException("Invalid image pixel stride, row byte width " + minRowStride + " is too large, expecting " + rowStride);
        }
        pixels.clear();
        this.nativeWriteImage(dngOutput, width, height, pixels, rowStride, pixelStride, offset, pixels.isDirect());
        pixels.clear();
    }

    private static void yuvToRgb(byte[] yuvData, int outOffset, byte[] rgbOut) {
        int COLOR_MAX = 255;
        float y = yuvData[0] & 0xFF;
        float cb = yuvData[1] & 0xFF;
        float cr = yuvData[2] & 0xFF;
        float r = y + 1.402f * (cr - 128.0f);
        float g = y - 0.34414f * (cb - 128.0f) - 0.71414f * (cr - 128.0f);
        float b = y + 1.772f * (cb - 128.0f);
        rgbOut[outOffset] = (byte)Math.max(0.0f, Math.min(255.0f, r));
        rgbOut[outOffset + 1] = (byte)Math.max(0.0f, Math.min(255.0f, g));
        rgbOut[outOffset + 2] = (byte)Math.max(0.0f, Math.min(255.0f, b));
    }

    private static void colorToRgb(int color2, int outOffset, byte[] rgbOut) {
        rgbOut[outOffset] = (byte)Color.red(color2);
        rgbOut[outOffset + 1] = (byte)Color.green(color2);
        rgbOut[outOffset + 2] = (byte)Color.blue(color2);
    }

    private static ByteBuffer convertToRGB(Image yuvImage) {
        int width = yuvImage.getWidth();
        int height = yuvImage.getHeight();
        ByteBuffer buf = ByteBuffer.allocateDirect(3 * width * height);
        Image.Plane yPlane = yuvImage.getPlanes()[0];
        Image.Plane uPlane = yuvImage.getPlanes()[1];
        Image.Plane vPlane = yuvImage.getPlanes()[2];
        ByteBuffer yBuf = yPlane.getBuffer();
        ByteBuffer uBuf = uPlane.getBuffer();
        ByteBuffer vBuf = vPlane.getBuffer();
        yBuf.rewind();
        uBuf.rewind();
        vBuf.rewind();
        int yRowStride = yPlane.getRowStride();
        int vRowStride = vPlane.getRowStride();
        int uRowStride = uPlane.getRowStride();
        int yPixStride = yPlane.getPixelStride();
        int vPixStride = vPlane.getPixelStride();
        int uPixStride = uPlane.getPixelStride();
        byte[] yuvPixel = new byte[]{0, 0, 0};
        byte[] yFullRow = new byte[yPixStride * (width - 1) + 1];
        byte[] uFullRow = new byte[uPixStride * (width / 2 - 1) + 1];
        byte[] vFullRow = new byte[vPixStride * (width / 2 - 1) + 1];
        byte[] finalRow = new byte[3 * width];
        for (int i = 0; i < height; ++i) {
            int halfH = i / 2;
            yBuf.position(yRowStride * i);
            yBuf.get(yFullRow);
            uBuf.position(uRowStride * halfH);
            uBuf.get(uFullRow);
            vBuf.position(vRowStride * halfH);
            vBuf.get(vFullRow);
            for (int j = 0; j < width; ++j) {
                int halfW = j / 2;
                yuvPixel[0] = yFullRow[yPixStride * j];
                yuvPixel[1] = uFullRow[uPixStride * halfW];
                yuvPixel[2] = vFullRow[vPixStride * halfW];
                DngCreator.yuvToRgb(yuvPixel, j * 3, finalRow);
            }
            buf.put(finalRow);
        }
        yBuf.rewind();
        uBuf.rewind();
        vBuf.rewind();
        buf.rewind();
        return buf;
    }

    private static ByteBuffer convertToRGB(Bitmap argbBitmap) {
        int width = argbBitmap.getWidth();
        int height = argbBitmap.getHeight();
        ByteBuffer buf = ByteBuffer.allocateDirect(3 * width * height);
        int[] pixelRow = new int[width];
        byte[] finalRow = new byte[3 * width];
        for (int i = 0; i < height; ++i) {
            argbBitmap.getPixels(pixelRow, 0, width, 0, i, width, 1);
            for (int j = 0; j < width; ++j) {
                DngCreator.colorToRgb(pixelRow[j], j * 3, finalRow);
            }
            buf.put(finalRow);
        }
        buf.rewind();
        return buf;
    }

    private static int[] toExifLatLong(double value) {
        value = Math.abs(value);
        int degrees = (int)value;
        value = (value - (double)degrees) * 60.0;
        int minutes = (int)value;
        value = (value - (double)minutes) * 6000.0;
        int seconds = (int)value;
        return new int[]{degrees, 1, minutes, 1, seconds, 100};
    }

    private static native void nativeClassInit();

    private synchronized native void nativeInit(CameraMetadataNative var1, CameraMetadataNative var2, String var3);

    private synchronized native void nativeDestroy();

    private synchronized native void nativeSetOrientation(int var1);

    private synchronized native void nativeSetDescription(String var1);

    private synchronized native void nativeSetGpsTags(int[] var1, String var2, int[] var3, String var4, String var5, int[] var6);

    private synchronized native void nativeSetThumbnail(ByteBuffer var1, int var2, int var3);

    private synchronized native void nativeWriteImage(OutputStream var1, int var2, int var3, ByteBuffer var4, int var5, int var6, long var7, boolean var9) throws IOException;

    private synchronized native void nativeWriteInputStream(OutputStream var1, InputStream var2, int var3, int var4, long var5) throws IOException;

    static {
        sDateTimeStampFormat.setTimeZone(TimeZone.getDefault());
        sExifGPSDateStamp.setTimeZone(TimeZone.getTimeZone("UTC"));
        DngCreator.nativeClassInit();
    }
}

