/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.utils.HashCodeHelpers;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;

public final class OutputConfiguration
implements Parcelable {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final Parcelable.Creator<OutputConfiguration> CREATOR = new Parcelable.Creator<OutputConfiguration>(){

        @Override
        public OutputConfiguration createFromParcel(Parcel source) {
            try {
                OutputConfiguration outputConfiguration = new OutputConfiguration(source);
                return outputConfiguration;
            }
            catch (Exception e) {
                Log.e(OutputConfiguration.TAG, "Exception creating OutputConfiguration from parcel", e);
                return null;
            }
        }

        public OutputConfiguration[] newArray(int size) {
            return new OutputConfiguration[size];
        }
    };
    private static final String TAG = "OutputConfiguration";
    private final Surface mSurface;
    private final int mRotation;

    public OutputConfiguration(Surface surface) {
        Preconditions.checkNotNull(surface, "Surface must not be null");
        this.mSurface = surface;
        this.mRotation = 0;
    }

    public OutputConfiguration(Surface surface, int rotation) {
        Preconditions.checkNotNull(surface, "Surface must not be null");
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurface = surface;
        this.mRotation = rotation;
    }

    private OutputConfiguration(Parcel source) {
        int rotation = source.readInt();
        Surface surface = Surface.CREATOR.createFromParcel(source);
        Preconditions.checkNotNull(surface, "Surface must not be null");
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurface = surface;
        this.mRotation = rotation;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public int getRotation() {
        return this.mRotation;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        dest.writeInt(this.mRotation);
        this.mSurface.writeToParcel(dest, flags);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof OutputConfiguration) {
            OutputConfiguration other = (OutputConfiguration)obj;
            return this.mSurface == other.mSurface && this.mRotation == other.mRotation;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mSurface.hashCode(), this.mRotation);
    }
}

