/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.GeofenceHardwareMonitorEvent;
import android.hardware.location.GeofenceHardwareRequestParcelable;
import android.hardware.location.IGeofenceHardwareCallback;
import android.hardware.location.IGeofenceHardwareMonitorCallback;
import android.location.IFusedGeofenceHardware;
import android.location.IGpsGeofenceHardware;
import android.location.Location;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Iterator;

public final class GeofenceHardwareImpl {
    private static final String TAG = "GeofenceHardwareImpl";
    private static final boolean DEBUG = Log.isLoggable("GeofenceHardwareImpl", 3);
    private static final int FIRST_VERSION_WITH_CAPABILITIES = 2;
    private final Context mContext;
    private static GeofenceHardwareImpl sInstance;
    private PowerManager.WakeLock mWakeLock;
    private final SparseArray<IGeofenceHardwareCallback> mGeofences = new SparseArray();
    private final ArrayList<IGeofenceHardwareMonitorCallback>[] mCallbacks = new ArrayList[2];
    private final ArrayList<Reaper> mReapers = new ArrayList();
    private IFusedGeofenceHardware mFusedService;
    private IGpsGeofenceHardware mGpsService;
    private int mCapabilities;
    private int mVersion = 1;
    private int[] mSupportedMonitorTypes = new int[2];
    private static final int GEOFENCE_TRANSITION_CALLBACK = 1;
    private static final int ADD_GEOFENCE_CALLBACK = 2;
    private static final int REMOVE_GEOFENCE_CALLBACK = 3;
    private static final int PAUSE_GEOFENCE_CALLBACK = 4;
    private static final int RESUME_GEOFENCE_CALLBACK = 5;
    private static final int GEOFENCE_CALLBACK_BINDER_DIED = 6;
    private static final int GEOFENCE_STATUS = 1;
    private static final int CALLBACK_ADD = 2;
    private static final int CALLBACK_REMOVE = 3;
    private static final int MONITOR_CALLBACK_BINDER_DIED = 4;
    private static final int REAPER_GEOFENCE_ADDED = 1;
    private static final int REAPER_MONITOR_CALLBACK_ADDED = 2;
    private static final int REAPER_REMOVED = 3;
    private static final int LOCATION_INVALID = 0;
    private static final int LOCATION_HAS_LAT_LONG = 1;
    private static final int LOCATION_HAS_ALTITUDE = 2;
    private static final int LOCATION_HAS_SPEED = 4;
    private static final int LOCATION_HAS_BEARING = 8;
    private static final int LOCATION_HAS_ACCURACY = 16;
    private static final int RESOLUTION_LEVEL_NONE = 1;
    private static final int RESOLUTION_LEVEL_COARSE = 2;
    private static final int RESOLUTION_LEVEL_FINE = 3;
    private static final int CAPABILITY_GNSS = 1;
    private Handler mGeofenceHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    IGeofenceHardwareCallback callback;
                    int geofenceId = msg.arg1;
                    SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                    synchronized (sparseArray) {
                        callback = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(geofenceId);
                    }
                    if (callback != null) {
                        try {
                            callback.onGeofenceAdd(geofenceId, msg.arg2);
                        }
                        catch (RemoteException e) {
                            Log.i(GeofenceHardwareImpl.TAG, "Remote Exception:" + e);
                        }
                    }
                    GeofenceHardwareImpl.this.releaseWakeLock();
                    break;
                }
                case 3: {
                    IGeofenceHardwareCallback callback;
                    int geofenceId = msg.arg1;
                    SparseArray e = GeofenceHardwareImpl.this.mGeofences;
                    synchronized (e) {
                        callback = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(geofenceId);
                    }
                    if (callback != null) {
                        try {
                            callback.onGeofenceRemove(geofenceId, msg.arg2);
                        }
                        catch (RemoteException e2) {
                            // empty catch block
                        }
                        IBinder callbackBinder = callback.asBinder();
                        boolean callbackInUse = false;
                        SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                        synchronized (sparseArray) {
                            GeofenceHardwareImpl.this.mGeofences.remove(geofenceId);
                            for (int i = 0; i < GeofenceHardwareImpl.this.mGeofences.size(); ++i) {
                                if (((IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.valueAt(i)).asBinder() != callbackBinder) continue;
                                callbackInUse = true;
                                break;
                            }
                        }
                        if (!callbackInUse) {
                            Iterator iterator = GeofenceHardwareImpl.this.mReapers.iterator();
                            while (iterator.hasNext()) {
                                Reaper reaper = (Reaper)iterator.next();
                                if (reaper.mCallback == null || reaper.mCallback.asBinder() != callbackBinder) continue;
                                iterator.remove();
                                reaper.unlinkToDeath();
                                if (!DEBUG) continue;
                                Log.d(GeofenceHardwareImpl.TAG, String.format("Removed reaper %s because binder %s is no longer needed.", reaper, callbackBinder));
                            }
                        }
                    }
                    GeofenceHardwareImpl.this.releaseWakeLock();
                    break;
                }
                case 4: {
                    IGeofenceHardwareCallback callback;
                    int geofenceId = msg.arg1;
                    SparseArray callbackBinder = GeofenceHardwareImpl.this.mGeofences;
                    synchronized (callbackBinder) {
                        callback = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(geofenceId);
                    }
                    if (callback != null) {
                        try {
                            callback.onGeofencePause(geofenceId, msg.arg2);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    GeofenceHardwareImpl.this.releaseWakeLock();
                    break;
                }
                case 5: {
                    IGeofenceHardwareCallback callback;
                    int geofenceId = msg.arg1;
                    SparseArray e = GeofenceHardwareImpl.this.mGeofences;
                    synchronized (e) {
                        callback = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(geofenceId);
                    }
                    if (callback != null) {
                        try {
                            callback.onGeofenceResume(geofenceId, msg.arg2);
                        }
                        catch (RemoteException e3) {
                            // empty catch block
                        }
                    }
                    GeofenceHardwareImpl.this.releaseWakeLock();
                    break;
                }
                case 1: {
                    IGeofenceHardwareCallback callback;
                    GeofenceTransition geofenceTransition = (GeofenceTransition)msg.obj;
                    SparseArray callbackInUse = GeofenceHardwareImpl.this.mGeofences;
                    synchronized (callbackInUse) {
                        callback = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(geofenceTransition.mGeofenceId);
                        if (DEBUG) {
                            Log.d(GeofenceHardwareImpl.TAG, "GeofenceTransistionCallback: GPS : GeofenceId: " + geofenceTransition.mGeofenceId + " Transition: " + geofenceTransition.mTransition + " Location: " + geofenceTransition.mLocation + ":" + GeofenceHardwareImpl.this.mGeofences);
                        }
                    }
                    if (callback != null) {
                        try {
                            callback.onGeofenceTransition(geofenceTransition.mGeofenceId, geofenceTransition.mTransition, geofenceTransition.mLocation, geofenceTransition.mTimestamp, geofenceTransition.mMonitoringType);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    GeofenceHardwareImpl.this.releaseWakeLock();
                    break;
                }
                case 6: {
                    IGeofenceHardwareCallback callback = (IGeofenceHardwareCallback)msg.obj;
                    if (DEBUG) {
                        Log.d(GeofenceHardwareImpl.TAG, "Geofence callback reaped:" + callback);
                    }
                    int monitoringType = msg.arg1;
                    SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                    synchronized (sparseArray) {
                        for (int i = 0; i < GeofenceHardwareImpl.this.mGeofences.size(); ++i) {
                            if (!((IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.valueAt(i)).equals(callback)) continue;
                            int geofenceId = GeofenceHardwareImpl.this.mGeofences.keyAt(i);
                            GeofenceHardwareImpl.this.removeGeofence(GeofenceHardwareImpl.this.mGeofences.keyAt(i), monitoringType);
                            GeofenceHardwareImpl.this.mGeofences.remove(geofenceId);
                        }
                        break;
                    }
                }
            }
        }
    };
    private Handler mCallbacksHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    GeofenceHardwareMonitorEvent event = (GeofenceHardwareMonitorEvent)msg.obj;
                    ArrayList callbackList = GeofenceHardwareImpl.this.mCallbacks[event.getMonitoringType()];
                    if (callbackList != null) {
                        if (DEBUG) {
                            Log.d(GeofenceHardwareImpl.TAG, "MonitoringSystemChangeCallback: " + event);
                        }
                        for (IGeofenceHardwareMonitorCallback c : callbackList) {
                            try {
                                c.onMonitoringSystemChange(event);
                            }
                            catch (RemoteException e) {
                                Log.d(GeofenceHardwareImpl.TAG, "Error reporting onMonitoringSystemChange.", e);
                            }
                        }
                    }
                    GeofenceHardwareImpl.this.releaseWakeLock();
                    break;
                }
                case 2: {
                    int monitoringType = msg.arg1;
                    IGeofenceHardwareMonitorCallback callback = (IGeofenceHardwareMonitorCallback)msg.obj;
                    ArrayList<IGeofenceHardwareMonitorCallback> callbackList = GeofenceHardwareImpl.this.mCallbacks[monitoringType];
                    if (callbackList == null) {
                        ((GeofenceHardwareImpl)GeofenceHardwareImpl.this).mCallbacks[monitoringType] = callbackList = new ArrayList<IGeofenceHardwareMonitorCallback>();
                    }
                    if (callbackList.contains(callback)) break;
                    callbackList.add(callback);
                    break;
                }
                case 3: {
                    int monitoringType = msg.arg1;
                    IGeofenceHardwareMonitorCallback callback = (IGeofenceHardwareMonitorCallback)msg.obj;
                    ArrayList callbackList = GeofenceHardwareImpl.this.mCallbacks[monitoringType];
                    if (callbackList == null) break;
                    callbackList.remove(callback);
                    break;
                }
                case 4: {
                    ArrayList callbackList;
                    IGeofenceHardwareMonitorCallback callback = (IGeofenceHardwareMonitorCallback)msg.obj;
                    if (DEBUG) {
                        Log.d(GeofenceHardwareImpl.TAG, "Monitor callback reaped:" + callback);
                    }
                    if ((callbackList = GeofenceHardwareImpl.this.mCallbacks[msg.arg1]) == null || !callbackList.contains(callback)) break;
                    callbackList.remove(callback);
                }
            }
        }
    };
    private Handler mReaperHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    IGeofenceHardwareCallback callback = (IGeofenceHardwareCallback)msg.obj;
                    int monitoringType = msg.arg1;
                    Reaper r = new Reaper(callback, monitoringType);
                    if (GeofenceHardwareImpl.this.mReapers.contains(r)) break;
                    GeofenceHardwareImpl.this.mReapers.add(r);
                    IBinder b = callback.asBinder();
                    try {
                        b.linkToDeath(r, 0);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 2: {
                    IGeofenceHardwareMonitorCallback monitorCallback = (IGeofenceHardwareMonitorCallback)msg.obj;
                    int monitoringType = msg.arg1;
                    Reaper r = new Reaper(monitorCallback, monitoringType);
                    if (GeofenceHardwareImpl.this.mReapers.contains(r)) break;
                    GeofenceHardwareImpl.this.mReapers.add(r);
                    IBinder b = monitorCallback.asBinder();
                    try {
                        b.linkToDeath(r, 0);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 3: {
                    Reaper r = (Reaper)msg.obj;
                    GeofenceHardwareImpl.this.mReapers.remove(r);
                }
            }
        }
    };

    public static synchronized GeofenceHardwareImpl getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new GeofenceHardwareImpl(context);
        }
        return sInstance;
    }

    private GeofenceHardwareImpl(Context context) {
        this.mContext = context;
        this.setMonitorAvailability(0, 2);
        this.setMonitorAvailability(1, 2);
    }

    private void acquireWakeLock() {
        if (this.mWakeLock == null) {
            PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
            this.mWakeLock = powerManager.newWakeLock(1, TAG);
        }
        this.mWakeLock.acquire();
    }

    private void releaseWakeLock() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    private void updateGpsHardwareAvailability() {
        boolean gpsSupported;
        try {
            gpsSupported = this.mGpsService.isHardwareGeofenceSupported();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Remote Exception calling LocationManagerService");
            gpsSupported = false;
        }
        if (gpsSupported) {
            this.setMonitorAvailability(0, 0);
        }
    }

    private void updateFusedHardwareAvailability() {
        boolean fusedSupported;
        try {
            boolean hasGnnsCapabilities;
            boolean bl = hasGnnsCapabilities = this.mVersion < 2 || (this.mCapabilities & 1) != 0;
            fusedSupported = this.mFusedService != null ? this.mFusedService.isSupported() && hasGnnsCapabilities : false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException calling LocationManagerService");
            fusedSupported = false;
        }
        if (fusedSupported) {
            this.setMonitorAvailability(1, 0);
        }
    }

    public void setGpsHardwareGeofence(IGpsGeofenceHardware service) {
        if (this.mGpsService == null) {
            this.mGpsService = service;
            this.updateGpsHardwareAvailability();
        } else if (service == null) {
            this.mGpsService = null;
            Log.w(TAG, "GPS Geofence Hardware service seems to have crashed");
        } else {
            Log.e(TAG, "Error: GpsService being set again.");
        }
    }

    public void onCapabilities(int capabilities) {
        this.mCapabilities = capabilities;
        this.updateFusedHardwareAvailability();
    }

    public void setVersion(int version) {
        this.mVersion = version;
        this.updateFusedHardwareAvailability();
    }

    public void setFusedGeofenceHardware(IFusedGeofenceHardware service) {
        if (this.mFusedService == null) {
            this.mFusedService = service;
            this.updateFusedHardwareAvailability();
        } else if (service == null) {
            this.mFusedService = null;
            Log.w(TAG, "Fused Geofence Hardware service seems to have crashed");
        } else {
            Log.e(TAG, "Error: FusedService being set again");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMonitoringTypes() {
        int[] nArray = this.mSupportedMonitorTypes;
        synchronized (this.mSupportedMonitorTypes) {
            boolean gpsSupported = this.mSupportedMonitorTypes[0] != 2;
            boolean fusedSupported = this.mSupportedMonitorTypes[1] != 2;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (gpsSupported) {
                if (fusedSupported) {
                    return new int[]{0, 1};
                }
                return new int[]{0};
            }
            if (fusedSupported) {
                return new int[]{1};
            }
            return new int[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatusOfMonitoringType(int monitoringType) {
        int[] nArray = this.mSupportedMonitorTypes;
        synchronized (this.mSupportedMonitorTypes) {
            if (monitoringType >= this.mSupportedMonitorTypes.length || monitoringType < 0) {
                throw new IllegalArgumentException("Unknown monitoring type");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mSupportedMonitorTypes[monitoringType];
        }
    }

    public int getCapabilitiesForMonitoringType(int monitoringType) {
        switch (this.mSupportedMonitorTypes[monitoringType]) {
            case 0: {
                switch (monitoringType) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        if (this.mVersion >= 2) {
                            return this.mCapabilities;
                        }
                        return 1;
                    }
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCircularFence(int monitoringType, GeofenceHardwareRequestParcelable request, IGeofenceHardwareCallback callback) {
        boolean result;
        int geofenceId = request.getId();
        if (DEBUG) {
            String message = String.format("addCircularFence: monitoringType=%d, %s", monitoringType, request);
            Log.d(TAG, message);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            this.mGeofences.put(geofenceId, callback);
        }
        switch (monitoringType) {
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    result = this.mGpsService.addCircularHardwareGeofence(request.getId(), request.getLatitude(), request.getLongitude(), request.getRadius(), request.getLastTransition(), request.getMonitorTransitions(), request.getNotificationResponsiveness(), request.getUnknownTimer());
                }
                catch (RemoteException e) {
                    Log.e(TAG, "AddGeofence: Remote Exception calling LocationManagerService");
                    result = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.addGeofences(new GeofenceHardwareRequestParcelable[]{request});
                    result = true;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "AddGeofence: RemoteException calling LocationManagerService");
                    result = false;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        if (result) {
            Message m = this.mReaperHandler.obtainMessage(1, callback);
            m.arg1 = monitoringType;
            this.mReaperHandler.sendMessage(m);
        } else {
            sparseArray = this.mGeofences;
            synchronized (sparseArray) {
                this.mGeofences.remove(geofenceId);
            }
        }
        if (DEBUG) {
            Log.d(TAG, "addCircularFence: Result is: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGeofence(int geofenceId, int monitoringType) {
        if (DEBUG) {
            Log.d(TAG, "Remove Geofence: GeofenceId: " + geofenceId);
        }
        boolean result = false;
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(geofenceId) == null) {
                throw new IllegalArgumentException("Geofence " + geofenceId + " not registered.");
            }
        }
        switch (monitoringType) {
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    result = this.mGpsService.removeHardwareGeofence(geofenceId);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "RemoveGeofence: Remote Exception calling LocationManagerService");
                    result = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.removeGeofences(new int[]{geofenceId});
                    result = true;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "RemoveGeofence: RemoteException calling LocationManagerService");
                    result = false;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        if (DEBUG) {
            Log.d(TAG, "removeGeofence: Result is: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseGeofence(int geofenceId, int monitoringType) {
        boolean result;
        if (DEBUG) {
            Log.d(TAG, "Pause Geofence: GeofenceId: " + geofenceId);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(geofenceId) == null) {
                throw new IllegalArgumentException("Geofence " + geofenceId + " not registered.");
            }
        }
        switch (monitoringType) {
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    result = this.mGpsService.pauseHardwareGeofence(geofenceId);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "PauseGeofence: Remote Exception calling LocationManagerService");
                    result = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.pauseMonitoringGeofence(geofenceId);
                    result = true;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "PauseGeofence: RemoteException calling LocationManagerService");
                    result = false;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        if (DEBUG) {
            Log.d(TAG, "pauseGeofence: Result is: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeGeofence(int geofenceId, int monitoringType, int monitorTransition) {
        boolean result;
        if (DEBUG) {
            Log.d(TAG, "Resume Geofence: GeofenceId: " + geofenceId);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(geofenceId) == null) {
                throw new IllegalArgumentException("Geofence " + geofenceId + " not registered.");
            }
        }
        switch (monitoringType) {
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    result = this.mGpsService.resumeHardwareGeofence(geofenceId, monitorTransition);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "ResumeGeofence: Remote Exception calling LocationManagerService");
                    result = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.resumeMonitoringGeofence(geofenceId, monitorTransition);
                    result = true;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "ResumeGeofence: RemoteException calling LocationManagerService");
                    result = false;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        if (DEBUG) {
            Log.d(TAG, "resumeGeofence: Result is: " + result);
        }
        return result;
    }

    public boolean registerForMonitorStateChangeCallback(int monitoringType, IGeofenceHardwareMonitorCallback callback) {
        Message reaperMessage = this.mReaperHandler.obtainMessage(2, callback);
        reaperMessage.arg1 = monitoringType;
        this.mReaperHandler.sendMessage(reaperMessage);
        Message m = this.mCallbacksHandler.obtainMessage(2, callback);
        m.arg1 = monitoringType;
        this.mCallbacksHandler.sendMessage(m);
        return true;
    }

    public boolean unregisterForMonitorStateChangeCallback(int monitoringType, IGeofenceHardwareMonitorCallback callback) {
        Message m = this.mCallbacksHandler.obtainMessage(3, callback);
        m.arg1 = monitoringType;
        this.mCallbacksHandler.sendMessage(m);
        return true;
    }

    public void reportGeofenceTransition(int geofenceId, Location location, int transition2, long transitionTimestamp, int monitoringType, int sourcesUsed) {
        if (location == null) {
            Log.e(TAG, String.format("Invalid Geofence Transition: location=null", new Object[0]));
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "GeofenceTransition| " + location + ", transition:" + transition2 + ", transitionTimestamp:" + transitionTimestamp + ", monitoringType:" + monitoringType + ", sourcesUsed:" + sourcesUsed);
        }
        GeofenceTransition geofenceTransition = new GeofenceTransition(geofenceId, transition2, transitionTimestamp, location, monitoringType, sourcesUsed);
        this.acquireWakeLock();
        Message message = this.mGeofenceHandler.obtainMessage(1, geofenceTransition);
        message.sendToTarget();
    }

    public void reportGeofenceMonitorStatus(int monitoringType, int monitoringStatus, Location location, int source) {
        this.setMonitorAvailability(monitoringType, monitoringStatus);
        this.acquireWakeLock();
        GeofenceHardwareMonitorEvent event = new GeofenceHardwareMonitorEvent(monitoringType, monitoringStatus, source, location);
        Message message = this.mCallbacksHandler.obtainMessage(1, event);
        message.sendToTarget();
    }

    private void reportGeofenceOperationStatus(int operation, int geofenceId, int operationStatus) {
        this.acquireWakeLock();
        Message message = this.mGeofenceHandler.obtainMessage(operation);
        message.arg1 = geofenceId;
        message.arg2 = operationStatus;
        message.sendToTarget();
    }

    public void reportGeofenceAddStatus(int geofenceId, int status) {
        if (DEBUG) {
            Log.d(TAG, "AddCallback| id:" + geofenceId + ", status:" + status);
        }
        this.reportGeofenceOperationStatus(2, geofenceId, status);
    }

    public void reportGeofenceRemoveStatus(int geofenceId, int status) {
        if (DEBUG) {
            Log.d(TAG, "RemoveCallback| id:" + geofenceId + ", status:" + status);
        }
        this.reportGeofenceOperationStatus(3, geofenceId, status);
    }

    public void reportGeofencePauseStatus(int geofenceId, int status) {
        if (DEBUG) {
            Log.d(TAG, "PauseCallbac| id:" + geofenceId + ", status" + status);
        }
        this.reportGeofenceOperationStatus(4, geofenceId, status);
    }

    public void reportGeofenceResumeStatus(int geofenceId, int status) {
        if (DEBUG) {
            Log.d(TAG, "ResumeCallback| id:" + geofenceId + ", status:" + status);
        }
        this.reportGeofenceOperationStatus(5, geofenceId, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMonitorAvailability(int monitor, int val) {
        int[] nArray = this.mSupportedMonitorTypes;
        synchronized (this.mSupportedMonitorTypes) {
            this.mSupportedMonitorTypes[monitor] = val;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    int getMonitoringResolutionLevel(int monitoringType) {
        switch (monitoringType) {
            case 0: {
                return 3;
            }
            case 1: {
                return 3;
            }
        }
        return 1;
    }

    int getAllowedResolutionLevel(int pid, int uid) {
        if (this.mContext.checkPermission("android.permission.ACCESS_FINE_LOCATION", pid, uid) == 0) {
            return 3;
        }
        if (this.mContext.checkPermission("android.permission.ACCESS_COARSE_LOCATION", pid, uid) == 0) {
            return 2;
        }
        return 1;
    }

    class Reaper
    implements IBinder.DeathRecipient {
        private IGeofenceHardwareMonitorCallback mMonitorCallback;
        private IGeofenceHardwareCallback mCallback;
        private int mMonitoringType;

        Reaper(IGeofenceHardwareCallback c, int monitoringType) {
            this.mCallback = c;
            this.mMonitoringType = monitoringType;
        }

        Reaper(IGeofenceHardwareMonitorCallback c, int monitoringType) {
            this.mMonitorCallback = c;
            this.mMonitoringType = monitoringType;
        }

        @Override
        public void binderDied() {
            if (this.mCallback != null) {
                Message m = GeofenceHardwareImpl.this.mGeofenceHandler.obtainMessage(6, this.mCallback);
                m.arg1 = this.mMonitoringType;
                GeofenceHardwareImpl.this.mGeofenceHandler.sendMessage(m);
            } else if (this.mMonitorCallback != null) {
                Message m = GeofenceHardwareImpl.this.mCallbacksHandler.obtainMessage(4, this.mMonitorCallback);
                m.arg1 = this.mMonitoringType;
                GeofenceHardwareImpl.this.mCallbacksHandler.sendMessage(m);
            }
            Message reaperMessage = GeofenceHardwareImpl.this.mReaperHandler.obtainMessage(3, this);
            GeofenceHardwareImpl.this.mReaperHandler.sendMessage(reaperMessage);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.mCallback != null ? this.mCallback.asBinder().hashCode() : 0);
            result = 31 * result + (this.mMonitorCallback != null ? this.mMonitorCallback.asBinder().hashCode() : 0);
            result = 31 * result + this.mMonitoringType;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Reaper rhs = (Reaper)obj;
            return this.binderEquals(rhs.mCallback, this.mCallback) && this.binderEquals(rhs.mMonitorCallback, this.mMonitorCallback) && rhs.mMonitoringType == this.mMonitoringType;
        }

        private boolean binderEquals(IInterface left, IInterface right) {
            if (left == null) {
                return right == null;
            }
            return right == null ? false : left.asBinder() == right.asBinder();
        }

        private boolean unlinkToDeath() {
            if (this.mMonitorCallback != null) {
                return this.mMonitorCallback.asBinder().unlinkToDeath(this, 0);
            }
            if (this.mCallback != null) {
                return this.mCallback.asBinder().unlinkToDeath(this, 0);
            }
            return true;
        }

        private boolean callbackEquals(IGeofenceHardwareCallback cb) {
            return this.mCallback != null && this.mCallback.asBinder() == cb.asBinder();
        }
    }

    private class GeofenceTransition {
        private int mGeofenceId;
        private int mTransition;
        private long mTimestamp;
        private Location mLocation;
        private int mMonitoringType;
        private int mSourcesUsed;

        GeofenceTransition(int geofenceId, int transition2, long timestamp, Location location, int monitoringType, int sourcesUsed) {
            this.mGeofenceId = geofenceId;
            this.mTransition = transition2;
            this.mTimestamp = timestamp;
            this.mLocation = location;
            this.mMonitoringType = monitoringType;
            this.mSourcesUsed = sourcesUsed;
        }
    }
}

