/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.WeakReference;

public class RadioModule
extends RadioTuner {
    private long mNativeContext = 0L;
    private int mId;
    private NativeEventHandlerDelegate mEventHandlerDelegate;
    static final int EVENT_HW_FAILURE = 0;
    static final int EVENT_CONFIG = 1;
    static final int EVENT_ANTENNA = 2;
    static final int EVENT_TUNED = 3;
    static final int EVENT_METADATA = 4;
    static final int EVENT_TA = 5;
    static final int EVENT_AF_SWITCH = 6;
    static final int EVENT_CONTROL = 100;
    static final int EVENT_SERVER_DIED = 101;

    RadioModule(int moduleId, RadioManager.BandConfig config, boolean withAudio, RadioTuner.Callback callback, Handler handler) {
        this.mId = moduleId;
        this.mEventHandlerDelegate = new NativeEventHandlerDelegate(callback, handler);
        this.native_setup(new WeakReference<RadioModule>(this), config, withAudio);
    }

    private native void native_setup(Object var1, RadioManager.BandConfig var2, boolean var3);

    protected void finalize() {
        this.native_finalize();
    }

    private native void native_finalize();

    boolean initCheck() {
        return this.mNativeContext != 0L;
    }

    @Override
    public native void close();

    @Override
    public native int setConfiguration(RadioManager.BandConfig var1);

    @Override
    public native int getConfiguration(RadioManager.BandConfig[] var1);

    @Override
    public native int setMute(boolean var1);

    @Override
    public native boolean getMute();

    @Override
    public native int step(int var1, boolean var2);

    @Override
    public native int scan(int var1, boolean var2);

    @Override
    public native int tune(int var1, int var2);

    @Override
    public native int cancel();

    @Override
    public native int getProgramInformation(RadioManager.ProgramInfo[] var1);

    @Override
    public native boolean isAntennaConnected();

    @Override
    public native boolean hasControl();

    private static void postEventFromNative(Object module_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        RadioModule module = (RadioModule)((WeakReference)module_ref).get();
        if (module == null) {
            return;
        }
        NativeEventHandlerDelegate delegate = module.mEventHandlerDelegate;
        if (delegate != null && (handler = delegate.handler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private class NativeEventHandlerDelegate {
        private final Handler mHandler;

        NativeEventHandlerDelegate(final RadioTuner.Callback callback, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : Looper.getMainLooper();
            this.mHandler = looper != null ? new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    block0 : switch (msg.what) {
                        case 0: {
                            if (callback == null) break;
                            callback.onError(0);
                            break;
                        }
                        case 1: {
                            RadioManager.BandConfig config = (RadioManager.BandConfig)msg.obj;
                            switch (msg.arg1) {
                                case 0: {
                                    if (callback == null) break block0;
                                    callback.onConfigurationChanged(config);
                                    break;
                                }
                                default: {
                                    if (callback == null) break block0;
                                    callback.onError(4);
                                    break;
                                }
                            }
                            break;
                        }
                        case 2: {
                            if (callback == null) break;
                            callback.onAntennaState(msg.arg2 == 1);
                            break;
                        }
                        case 3: 
                        case 6: {
                            RadioManager.ProgramInfo info = (RadioManager.ProgramInfo)msg.obj;
                            switch (msg.arg1) {
                                case 0: {
                                    if (callback == null) break block0;
                                    callback.onProgramInfoChanged(info);
                                    break;
                                }
                                case -110: {
                                    if (callback == null) break block0;
                                    callback.onError(3);
                                    break;
                                }
                                default: {
                                    if (callback == null) break block0;
                                    callback.onError(2);
                                    break;
                                }
                            }
                            break;
                        }
                        case 4: {
                            RadioMetadata metadata = (RadioMetadata)msg.obj;
                            if (callback == null) break;
                            callback.onMetadataChanged(metadata);
                            break;
                        }
                        case 5: {
                            if (callback == null) break;
                            callback.onTrafficAnnouncement(msg.arg2 == 1);
                            break;
                        }
                        case 100: {
                            if (callback == null) break;
                            callback.onControlChanged(msg.arg2 == 1);
                            break;
                        }
                        case 101: {
                            if (callback == null) break;
                            callback.onError(1);
                            break;
                        }
                    }
                }
            } : null;
        }

        Handler handler() {
            return this.mHandler;
        }
    }
}

