/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbInterface;
import android.os.Parcel;
import android.os.Parcelable;

public class UsbDevice
implements Parcelable {
    private static final String TAG = "UsbDevice";
    private static final boolean DEBUG = false;
    private final String mName;
    private final String mManufacturerName;
    private final String mProductName;
    private final String mVersion;
    private final String mSerialNumber;
    private final int mVendorId;
    private final int mProductId;
    private final int mClass;
    private final int mSubclass;
    private final int mProtocol;
    private Parcelable[] mConfigurations;
    private UsbInterface[] mInterfaces;
    public static final Parcelable.Creator<UsbDevice> CREATOR = new Parcelable.Creator<UsbDevice>(){

        @Override
        public UsbDevice createFromParcel(Parcel in) {
            String name = in.readString();
            int vendorId = in.readInt();
            int productId = in.readInt();
            int clasz = in.readInt();
            int subClass = in.readInt();
            int protocol = in.readInt();
            String manufacturerName = in.readString();
            String productName = in.readString();
            String version = in.readString();
            String serialNumber = in.readString();
            Parcelable[] configurations = in.readParcelableArray(UsbInterface.class.getClassLoader());
            UsbDevice device = new UsbDevice(name, vendorId, productId, clasz, subClass, protocol, manufacturerName, productName, version, serialNumber);
            device.setConfigurations(configurations);
            return device;
        }

        public UsbDevice[] newArray(int size) {
            return new UsbDevice[size];
        }
    };

    public UsbDevice(String name, int vendorId, int productId, int Class2, int subClass, int protocol, String manufacturerName, String productName, String version, String serialNumber) {
        this.mName = name;
        this.mVendorId = vendorId;
        this.mProductId = productId;
        this.mClass = Class2;
        this.mSubclass = subClass;
        this.mProtocol = protocol;
        this.mManufacturerName = manufacturerName;
        this.mProductName = productName;
        this.mVersion = version;
        this.mSerialNumber = serialNumber;
    }

    public String getDeviceName() {
        return this.mName;
    }

    public String getManufacturerName() {
        return this.mManufacturerName;
    }

    public String getProductName() {
        return this.mProductName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    public int getDeviceId() {
        return UsbDevice.getDeviceId(this.mName);
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    public int getProductId() {
        return this.mProductId;
    }

    public int getDeviceClass() {
        return this.mClass;
    }

    public int getDeviceSubclass() {
        return this.mSubclass;
    }

    public int getDeviceProtocol() {
        return this.mProtocol;
    }

    public int getConfigurationCount() {
        return this.mConfigurations.length;
    }

    public UsbConfiguration getConfiguration(int index) {
        return (UsbConfiguration)this.mConfigurations[index];
    }

    private UsbInterface[] getInterfaceList() {
        if (this.mInterfaces == null) {
            int configurationCount = this.mConfigurations.length;
            int interfaceCount = 0;
            for (int i = 0; i < configurationCount; ++i) {
                UsbConfiguration configuration = (UsbConfiguration)this.mConfigurations[i];
                interfaceCount += configuration.getInterfaceCount();
            }
            this.mInterfaces = new UsbInterface[interfaceCount];
            int offset = 0;
            for (int i = 0; i < configurationCount; ++i) {
                UsbConfiguration configuration = (UsbConfiguration)this.mConfigurations[i];
                interfaceCount = configuration.getInterfaceCount();
                for (int j = 0; j < interfaceCount; ++j) {
                    this.mInterfaces[offset++] = configuration.getInterface(j);
                }
            }
        }
        return this.mInterfaces;
    }

    public int getInterfaceCount() {
        return this.getInterfaceList().length;
    }

    public UsbInterface getInterface(int index) {
        return this.getInterfaceList()[index];
    }

    public void setConfigurations(Parcelable[] configuration) {
        this.mConfigurations = configuration;
    }

    public boolean equals(Object o) {
        if (o instanceof UsbDevice) {
            return ((UsbDevice)o).mName.equals(this.mName);
        }
        if (o instanceof String) {
            return ((String)o).equals(this.mName);
        }
        return false;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsbDevice[mName=" + this.mName + ",mVendorId=" + this.mVendorId + ",mProductId=" + this.mProductId + ",mClass=" + this.mClass + ",mSubclass=" + this.mSubclass + ",mProtocol=" + this.mProtocol + ",mManufacturerName=" + this.mManufacturerName + ",mProductName=" + this.mProductName + ",mVersion=" + this.mVersion + ",mSerialNumber=" + this.mSerialNumber + ",mConfigurations=[");
        for (int i = 0; i < this.mConfigurations.length; ++i) {
            builder.append("\n");
            builder.append(this.mConfigurations[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mName);
        parcel.writeInt(this.mVendorId);
        parcel.writeInt(this.mProductId);
        parcel.writeInt(this.mClass);
        parcel.writeInt(this.mSubclass);
        parcel.writeInt(this.mProtocol);
        parcel.writeString(this.mManufacturerName);
        parcel.writeString(this.mProductName);
        parcel.writeString(this.mVersion);
        parcel.writeString(this.mSerialNumber);
        parcel.writeParcelableArray(this.mConfigurations, 0);
    }

    public static int getDeviceId(String name) {
        return UsbDevice.native_get_device_id(name);
    }

    public static String getDeviceName(int id2) {
        return UsbDevice.native_get_device_name(id2);
    }

    private static native int native_get_device_id(String var0);

    private static native String native_get_device_name(int var0);
}

