/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CalendarData;
import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.lang.UCharacter;
import android.icu.text.BreakIterator;
import android.icu.text.DisplayContext;
import android.icu.text.MessageFormat;
import android.icu.text.NumberFormat;
import android.icu.text.PluralRules;
import android.icu.text.QuantityFormatter;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import java.text.FieldPosition;
import java.util.EnumMap;
import java.util.Locale;

public final class RelativeDateTimeFormatter {
    private final EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap;
    private final EnumMap<Style, EnumMap<RelativeUnit, QuantityFormatter[]>> quantitativeUnitMap;
    private final MessageFormat combinedDateAndTime;
    private final PluralRules pluralRules;
    private final NumberFormat numberFormat;
    private final Style style;
    private final DisplayContext capitalizationContext;
    private final BreakIterator breakIterator;
    private final ULocale locale;
    private static final Cache cache = new Cache();

    public static RelativeDateTimeFormatter getInstance() {
        return RelativeDateTimeFormatter.getInstance(ULocale.getDefault(), null, Style.LONG, DisplayContext.CAPITALIZATION_NONE);
    }

    public static RelativeDateTimeFormatter getInstance(ULocale locale) {
        return RelativeDateTimeFormatter.getInstance(locale, null, Style.LONG, DisplayContext.CAPITALIZATION_NONE);
    }

    public static RelativeDateTimeFormatter getInstance(Locale locale) {
        return RelativeDateTimeFormatter.getInstance(ULocale.forLocale(locale));
    }

    public static RelativeDateTimeFormatter getInstance(ULocale locale, NumberFormat nf) {
        return RelativeDateTimeFormatter.getInstance(locale, nf, Style.LONG, DisplayContext.CAPITALIZATION_NONE);
    }

    public static RelativeDateTimeFormatter getInstance(ULocale locale, NumberFormat nf, Style style2, DisplayContext capitalizationContext) {
        RelativeDateTimeFormatterData data = cache.get(locale);
        nf = nf == null ? NumberFormat.getInstance(locale) : (NumberFormat)nf.clone();
        return new RelativeDateTimeFormatter(data.qualitativeUnitMap, data.quantitativeUnitMap, new MessageFormat(data.dateTimePattern), PluralRules.forLocale(locale), nf, style2, capitalizationContext, capitalizationContext == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE ? BreakIterator.getSentenceInstance(locale) : null, locale);
    }

    public static RelativeDateTimeFormatter getInstance(Locale locale, NumberFormat nf) {
        return RelativeDateTimeFormatter.getInstance(ULocale.forLocale(locale), nf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(double quantity, Direction direction, RelativeUnit unit) {
        String result;
        if (direction != Direction.LAST && direction != Direction.NEXT) {
            throw new IllegalArgumentException("direction must be NEXT or LAST");
        }
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            result = this.getQuantity(unit, direction == Direction.NEXT).format(quantity, this.numberFormat, this.pluralRules);
        }
        return this.adjustForContext(result);
    }

    public String format(Direction direction, AbsoluteUnit unit) {
        if (unit == AbsoluteUnit.NOW && direction != Direction.PLAIN) {
            throw new IllegalArgumentException("NOW can only accept direction PLAIN.");
        }
        String result = this.qualitativeUnitMap.get((Object)this.style).get((Object)unit).get((Object)direction);
        return result != null ? this.adjustForContext(result) : null;
    }

    public String combineDateAndTime(String relativeDateString, String timeString) {
        return this.combinedDateAndTime.format(new Object[]{timeString, relativeDateString}, new StringBuffer(), (FieldPosition)null).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberFormat getNumberFormat() {
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            return (NumberFormat)this.numberFormat.clone();
        }
    }

    public DisplayContext getCapitalizationContext() {
        return this.capitalizationContext;
    }

    public Style getFormatStyle() {
        return this.style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String adjustForContext(String originalFormattedString) {
        if (this.breakIterator == null || originalFormattedString.length() == 0 || !UCharacter.isLowerCase(UCharacter.codePointAt(originalFormattedString, 0))) {
            return originalFormattedString;
        }
        BreakIterator breakIterator = this.breakIterator;
        synchronized (breakIterator) {
            return UCharacter.toTitleCase(this.locale, originalFormattedString, this.breakIterator, 768);
        }
    }

    private static void addQualitativeUnit(EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnits, AbsoluteUnit unit, String current) {
        EnumMap<Direction, String> unitStrings = new EnumMap<Direction, String>(Direction.class);
        unitStrings.put(Direction.PLAIN, current);
        qualitativeUnits.put(unit, unitStrings);
    }

    private static void addQualitativeUnit(EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnits, AbsoluteUnit unit, ICUResourceBundle bundle, String plain) {
        EnumMap<Direction, String> unitStrings = new EnumMap<Direction, String>(Direction.class);
        unitStrings.put(Direction.LAST, bundle.getStringWithFallback("-1"));
        unitStrings.put(Direction.THIS, bundle.getStringWithFallback("0"));
        unitStrings.put(Direction.NEXT, bundle.getStringWithFallback("1"));
        RelativeDateTimeFormatter.addOptionalDirection(unitStrings, Direction.LAST_2, bundle, "-2");
        RelativeDateTimeFormatter.addOptionalDirection(unitStrings, Direction.NEXT_2, bundle, "2");
        unitStrings.put(Direction.PLAIN, plain);
        qualitativeUnits.put(unit, unitStrings);
    }

    private static void addOptionalDirection(EnumMap<Direction, String> unitStrings, Direction direction, ICUResourceBundle bundle, String key) {
        String s = bundle.findStringWithFallback(key);
        if (s != null) {
            unitStrings.put(direction, s);
        }
    }

    private RelativeDateTimeFormatter(EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap, EnumMap<Style, EnumMap<RelativeUnit, QuantityFormatter[]>> quantitativeUnitMap, MessageFormat combinedDateAndTime, PluralRules pluralRules, NumberFormat numberFormat, Style style2, DisplayContext capitalizationContext, BreakIterator breakIterator, ULocale locale) {
        this.qualitativeUnitMap = qualitativeUnitMap;
        this.quantitativeUnitMap = quantitativeUnitMap;
        this.combinedDateAndTime = combinedDateAndTime;
        this.pluralRules = pluralRules;
        this.numberFormat = numberFormat;
        this.style = style2;
        if (capitalizationContext.type() != DisplayContext.Type.CAPITALIZATION) {
            throw new IllegalArgumentException(capitalizationContext.toString());
        }
        this.capitalizationContext = capitalizationContext;
        this.breakIterator = breakIterator;
        this.locale = locale;
    }

    private QuantityFormatter getQuantity(RelativeUnit unit, boolean isFuture) {
        QuantityFormatter[] quantities = this.quantitativeUnitMap.get((Object)this.style).get((Object)unit);
        return isFuture ? quantities[1] : quantities[0];
    }

    private static class Loader {
        private final ULocale ulocale;

        public Loader(ULocale ulocale) {
            this.ulocale = ulocale;
        }

        public RelativeDateTimeFormatterData load() {
            EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap = new EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>>(Style.class);
            EnumMap<Style, EnumMap<RelativeUnit, QuantityFormatter[]>> quantitativeUnitMap = new EnumMap<Style, EnumMap<RelativeUnit, QuantityFormatter[]>>(Style.class);
            for (Style style2 : Style.values()) {
                qualitativeUnitMap.put(style2, new EnumMap(AbsoluteUnit.class));
                quantitativeUnitMap.put(style2, new EnumMap(RelativeUnit.class));
            }
            ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt55b", this.ulocale);
            this.addTimeUnits(r, "fields/day", "fields/day-short", "fields/day-narrow", RelativeUnit.DAYS, AbsoluteUnit.DAY, quantitativeUnitMap, qualitativeUnitMap);
            this.addTimeUnits(r, "fields/week", "fields/week-short", "fields/week-narrow", RelativeUnit.WEEKS, AbsoluteUnit.WEEK, quantitativeUnitMap, qualitativeUnitMap);
            this.addTimeUnits(r, "fields/month", "fields/month-short", "fields/month-narrow", RelativeUnit.MONTHS, AbsoluteUnit.MONTH, quantitativeUnitMap, qualitativeUnitMap);
            this.addTimeUnits(r, "fields/year", "fields/year-short", "fields/year-narrow", RelativeUnit.YEARS, AbsoluteUnit.YEAR, quantitativeUnitMap, qualitativeUnitMap);
            this.initRelativeUnits(r, "fields/second", "fields/second-short", "fields/second-narrow", RelativeUnit.SECONDS, quantitativeUnitMap);
            this.initRelativeUnits(r, "fields/minute", "fields/minute-short", "fields/minute-narrow", RelativeUnit.MINUTES, quantitativeUnitMap);
            this.initRelativeUnits(r, "fields/hour", "fields/hour-short", "fields/hour-narrow", RelativeUnit.HOURS, quantitativeUnitMap);
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap.get((Object)Style.LONG), AbsoluteUnit.NOW, r.getStringWithFallback("fields/second/relative/0"));
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap.get((Object)Style.SHORT), AbsoluteUnit.NOW, r.getStringWithFallback("fields/second-short/relative/0"));
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap.get((Object)Style.NARROW), AbsoluteUnit.NOW, r.getStringWithFallback("fields/second-narrow/relative/0"));
            EnumMap<Style, EnumMap<AbsoluteUnit, String>> dayOfWeekMap = new EnumMap<Style, EnumMap<AbsoluteUnit, String>>(Style.class);
            dayOfWeekMap.put(Style.LONG, Loader.readDaysOfWeek(r.getWithFallback("calendar/gregorian/dayNames/stand-alone/wide")));
            dayOfWeekMap.put(Style.SHORT, Loader.readDaysOfWeek(r.getWithFallback("calendar/gregorian/dayNames/stand-alone/short")));
            dayOfWeekMap.put(Style.NARROW, Loader.readDaysOfWeek(r.getWithFallback("calendar/gregorian/dayNames/stand-alone/narrow")));
            this.addWeekDays(r, "fields/mon/relative", "fields/mon-short/relative", "fields/mon-narrow/relative", dayOfWeekMap, AbsoluteUnit.MONDAY, qualitativeUnitMap);
            this.addWeekDays(r, "fields/tue/relative", "fields/tue-short/relative", "fields/tue-narrow/relative", dayOfWeekMap, AbsoluteUnit.TUESDAY, qualitativeUnitMap);
            this.addWeekDays(r, "fields/wed/relative", "fields/wed-short/relative", "fields/wed-narrow/relative", dayOfWeekMap, AbsoluteUnit.WEDNESDAY, qualitativeUnitMap);
            this.addWeekDays(r, "fields/thu/relative", "fields/thu-short/relative", "fields/thu-narrow/relative", dayOfWeekMap, AbsoluteUnit.THURSDAY, qualitativeUnitMap);
            this.addWeekDays(r, "fields/fri/relative", "fields/fri-short/relative", "fields/fri-narrow/relative", dayOfWeekMap, AbsoluteUnit.FRIDAY, qualitativeUnitMap);
            this.addWeekDays(r, "fields/sat/relative", "fields/sat-short/relative", "fields/sat-narrow/relative", dayOfWeekMap, AbsoluteUnit.SATURDAY, qualitativeUnitMap);
            this.addWeekDays(r, "fields/sun/relative", "fields/sun-short/relative", "fields/sun-narrow/relative", dayOfWeekMap, AbsoluteUnit.SUNDAY, qualitativeUnitMap);
            CalendarData calData = new CalendarData(this.ulocale, r.getStringWithFallback("calendar/default"));
            return new RelativeDateTimeFormatterData(qualitativeUnitMap, quantitativeUnitMap, calData.getDateTimePattern());
        }

        private void addTimeUnits(ICUResourceBundle r, String path, String pathShort, String pathNarrow, RelativeUnit relativeUnit, AbsoluteUnit absoluteUnit, EnumMap<Style, EnumMap<RelativeUnit, QuantityFormatter[]>> quantitativeUnitMap, EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap) {
            this.addTimeUnit(r.getWithFallback(path), relativeUnit, absoluteUnit, quantitativeUnitMap.get((Object)Style.LONG), qualitativeUnitMap.get((Object)Style.LONG));
            this.addTimeUnit(r.getWithFallback(pathShort), relativeUnit, absoluteUnit, quantitativeUnitMap.get((Object)Style.SHORT), qualitativeUnitMap.get((Object)Style.SHORT));
            this.addTimeUnit(r.getWithFallback(pathNarrow), relativeUnit, absoluteUnit, quantitativeUnitMap.get((Object)Style.NARROW), qualitativeUnitMap.get((Object)Style.NARROW));
        }

        private void addTimeUnit(ICUResourceBundle timeUnitBundle, RelativeUnit relativeUnit, AbsoluteUnit absoluteUnit, EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap, EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnitMap) {
            Loader.addTimeUnit(timeUnitBundle, relativeUnit, quantitativeUnitMap);
            String unitName = timeUnitBundle.getStringWithFallback("dn");
            if (this.ulocale.getLanguage().equals("en")) {
                unitName = unitName.toLowerCase();
            }
            timeUnitBundle = timeUnitBundle.getWithFallback("relative");
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap, absoluteUnit, timeUnitBundle, unitName);
        }

        private void initRelativeUnits(ICUResourceBundle r, String path, String pathShort, String pathNarrow, RelativeUnit relativeUnit, EnumMap<Style, EnumMap<RelativeUnit, QuantityFormatter[]>> quantitativeUnitMap) {
            Loader.addTimeUnit(r.getWithFallback(path), relativeUnit, quantitativeUnitMap.get((Object)Style.LONG));
            Loader.addTimeUnit(r.getWithFallback(pathShort), relativeUnit, quantitativeUnitMap.get((Object)Style.SHORT));
            Loader.addTimeUnit(r.getWithFallback(pathNarrow), relativeUnit, quantitativeUnitMap.get((Object)Style.NARROW));
        }

        private static void addTimeUnit(ICUResourceBundle timeUnitBundle, RelativeUnit relativeUnit, EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap) {
            QuantityFormatter.Builder future = new QuantityFormatter.Builder();
            QuantityFormatter.Builder past = new QuantityFormatter.Builder();
            timeUnitBundle = timeUnitBundle.getWithFallback("relativeTime");
            Loader.addTimeUnit(timeUnitBundle.getWithFallback("future"), future);
            Loader.addTimeUnit(timeUnitBundle.getWithFallback("past"), past);
            quantitativeUnitMap.put(relativeUnit, new QuantityFormatter[]{past.build(), future.build()});
        }

        private static void addTimeUnit(ICUResourceBundle pastOrFuture, QuantityFormatter.Builder builder) {
            int size = pastOrFuture.getSize();
            for (int i = 0; i < size; ++i) {
                UResourceBundle r = pastOrFuture.get(i);
                builder.add(r.getKey(), r.getString());
            }
        }

        private void addWeekDays(ICUResourceBundle r, String path, String pathShort, String pathNarrow, EnumMap<Style, EnumMap<AbsoluteUnit, String>> dayOfWeekMap, AbsoluteUnit weekDay, EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap) {
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap.get((Object)Style.LONG), weekDay, r.findWithFallback(path), dayOfWeekMap.get((Object)Style.LONG).get((Object)weekDay));
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap.get((Object)Style.SHORT), weekDay, r.findWithFallback(pathShort), dayOfWeekMap.get((Object)Style.SHORT).get((Object)weekDay));
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap.get((Object)Style.NARROW), weekDay, r.findWithFallback(pathNarrow), dayOfWeekMap.get((Object)Style.NARROW).get((Object)weekDay));
        }

        private static EnumMap<AbsoluteUnit, String> readDaysOfWeek(ICUResourceBundle daysOfWeekBundle) {
            EnumMap<AbsoluteUnit, String> dayOfWeekMap = new EnumMap<AbsoluteUnit, String>(AbsoluteUnit.class);
            if (daysOfWeekBundle.getSize() != 7) {
                throw new IllegalStateException(String.format("Expect 7 days in a week, got %d", daysOfWeekBundle.getSize()));
            }
            int idx = 0;
            dayOfWeekMap.put(AbsoluteUnit.SUNDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.MONDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.TUESDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.WEDNESDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.THURSDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.FRIDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.SATURDAY, daysOfWeekBundle.getString(idx++));
            return dayOfWeekMap;
        }
    }

    private static class Cache {
        private final ICUCache<String, RelativeDateTimeFormatterData> cache = new SimpleCache<String, RelativeDateTimeFormatterData>();

        private Cache() {
        }

        public RelativeDateTimeFormatterData get(ULocale locale) {
            String key = locale.toString();
            RelativeDateTimeFormatterData result = this.cache.get(key);
            if (result == null) {
                result = new Loader(locale).load();
                this.cache.put(key, result);
            }
            return result;
        }
    }

    private static class RelativeDateTimeFormatterData {
        public final EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap;
        public final EnumMap<Style, EnumMap<RelativeUnit, QuantityFormatter[]>> quantitativeUnitMap;
        public final String dateTimePattern;

        public RelativeDateTimeFormatterData(EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap, EnumMap<Style, EnumMap<RelativeUnit, QuantityFormatter[]>> quantitativeUnitMap, String dateTimePattern) {
            this.qualitativeUnitMap = qualitativeUnitMap;
            this.quantitativeUnitMap = quantitativeUnitMap;
            this.dateTimePattern = dateTimePattern;
        }
    }

    public static enum Direction {
        LAST_2,
        LAST,
        THIS,
        NEXT,
        NEXT_2,
        PLAIN;

    }

    public static enum AbsoluteUnit {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        NOW;

    }

    public static enum RelativeUnit {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        WEEKS,
        MONTHS,
        YEARS;

    }

    public static enum Style {
        LONG,
        SHORT,
        NARROW;

    }
}

