/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.GpsSatellite;
import android.util.SparseArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class GpsStatus {
    private static final int NUM_SATELLITES = 255;
    private int mTimeToFirstFix;
    private final SparseArray<GpsSatellite> mSatellites = new SparseArray();
    private Iterable<GpsSatellite> mSatelliteList = new Iterable<GpsSatellite>(){

        @Override
        public Iterator<GpsSatellite> iterator() {
            return new SatelliteIterator(GpsStatus.this.mSatellites);
        }
    };
    public static final int GPS_EVENT_STARTED = 1;
    public static final int GPS_EVENT_STOPPED = 2;
    public static final int GPS_EVENT_FIRST_FIX = 3;
    public static final int GPS_EVENT_SATELLITE_STATUS = 4;

    GpsStatus() {
    }

    synchronized void setStatus(int svCount, int[] prns, float[] snrs, float[] elevations, float[] azimuths, int ephemerisMask, int almanacMask, int usedInFixMask) {
        this.clearSatellites();
        for (int i = 0; i < svCount; ++i) {
            int prn = prns[i];
            int prnShift = 1 << prn - 1;
            if (prn <= 0 || prn > 255) continue;
            GpsSatellite satellite = this.mSatellites.get(prn);
            if (satellite == null) {
                satellite = new GpsSatellite(prn);
                this.mSatellites.put(prn, satellite);
            }
            satellite.mValid = true;
            satellite.mSnr = snrs[i];
            satellite.mElevation = elevations[i];
            satellite.mAzimuth = azimuths[i];
            satellite.mHasEphemeris = (ephemerisMask & prnShift) != 0;
            satellite.mHasAlmanac = (almanacMask & prnShift) != 0;
            satellite.mUsedInFix = (usedInFixMask & prnShift) != 0;
        }
    }

    void setStatus(GpsStatus status) {
        this.mTimeToFirstFix = status.getTimeToFirstFix();
        this.clearSatellites();
        SparseArray<GpsSatellite> otherSatellites = status.mSatellites;
        int otherSatellitesCount = otherSatellites.size();
        int satelliteIndex = 0;
        for (int i = 0; i < otherSatellitesCount; ++i) {
            GpsSatellite satellite;
            GpsSatellite otherSatellite = otherSatellites.valueAt(i);
            int otherSatellitePrn = otherSatellite.getPrn();
            int satellitesCount = this.mSatellites.size();
            while (satelliteIndex < satellitesCount && this.mSatellites.valueAt(satelliteIndex).getPrn() < otherSatellitePrn) {
                ++satelliteIndex;
            }
            if (satelliteIndex < this.mSatellites.size()) {
                satellite = this.mSatellites.valueAt(satelliteIndex);
                if (satellite.getPrn() == otherSatellitePrn) {
                    satellite.setStatus(otherSatellite);
                    continue;
                }
                satellite = new GpsSatellite(otherSatellitePrn);
                satellite.setStatus(otherSatellite);
                this.mSatellites.put(otherSatellitePrn, satellite);
                continue;
            }
            satellite = new GpsSatellite(otherSatellitePrn);
            satellite.setStatus(otherSatellite);
            this.mSatellites.append(otherSatellitePrn, satellite);
        }
    }

    void setTimeToFirstFix(int ttff) {
        this.mTimeToFirstFix = ttff;
    }

    public int getTimeToFirstFix() {
        return this.mTimeToFirstFix;
    }

    public Iterable<GpsSatellite> getSatellites() {
        return this.mSatelliteList;
    }

    public int getMaxSatellites() {
        return 255;
    }

    private void clearSatellites() {
        int satellitesCount = this.mSatellites.size();
        for (int i = 0; i < satellitesCount; ++i) {
            GpsSatellite satellite = this.mSatellites.valueAt(i);
            satellite.mValid = false;
        }
    }

    public static interface NmeaListener {
        public void onNmeaReceived(long var1, String var3);
    }

    public static interface Listener {
        public void onGpsStatusChanged(int var1);
    }

    private final class SatelliteIterator
    implements Iterator<GpsSatellite> {
        private final SparseArray<GpsSatellite> mSatellites;
        private final int mSatellitesCount;
        private int mIndex = 0;

        SatelliteIterator(SparseArray<GpsSatellite> satellites) {
            this.mSatellites = satellites;
            this.mSatellitesCount = satellites.size();
        }

        @Override
        public boolean hasNext() {
            while (this.mIndex < this.mSatellitesCount) {
                GpsSatellite satellite = this.mSatellites.valueAt(this.mIndex);
                if (satellite.mValid) {
                    return true;
                }
                ++this.mIndex;
            }
            return false;
        }

        @Override
        public GpsSatellite next() {
            while (this.mIndex < this.mSatellitesCount) {
                GpsSatellite satellite = this.mSatellites.valueAt(this.mIndex);
                ++this.mIndex;
                if (!satellite.mValid) continue;
                return satellite;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

