/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public final class MediaCodecList {
    private static final String TAG = "MediaCodecList";
    private static Object sInitLock = new Object();
    private static MediaCodecInfo[] sAllCodecInfos;
    private static MediaCodecInfo[] sRegularCodecInfos;
    private static Map<String, Object> sGlobalSettings;
    public static final int REGULAR_CODECS = 0;
    public static final int ALL_CODECS = 1;
    private MediaCodecInfo[] mCodecInfos;

    public static final int getCodecCount() {
        MediaCodecList.initCodecList();
        return sRegularCodecInfos.length;
    }

    private static final native int native_getCodecCount();

    public static final MediaCodecInfo getCodecInfoAt(int index) {
        MediaCodecList.initCodecList();
        if (index < 0 || index > sRegularCodecInfos.length) {
            throw new IllegalArgumentException();
        }
        return sRegularCodecInfos[index];
    }

    static final Map<String, Object> getGlobalSettings() {
        return sGlobalSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void initCodecList() {
        Object object = sInitLock;
        synchronized (object) {
            if (sRegularCodecInfos == null) {
                sGlobalSettings = MediaCodecList.native_getGlobalSettings();
                int count = MediaCodecList.native_getCodecCount();
                ArrayList<MediaCodecInfo> regulars = new ArrayList<MediaCodecInfo>();
                ArrayList<MediaCodecInfo> all = new ArrayList<MediaCodecInfo>();
                for (int index = 0; index < count; ++index) {
                    try {
                        MediaCodecInfo info = MediaCodecList.getNewCodecInfoAt(index);
                        all.add(info);
                        info = info.makeRegular();
                        if (info == null) continue;
                        regulars.add(info);
                        continue;
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Could not get codec capabilities", e);
                    }
                }
                sRegularCodecInfos = regulars.toArray(new MediaCodecInfo[regulars.size()]);
                sAllCodecInfos = all.toArray(new MediaCodecInfo[all.size()]);
            }
        }
    }

    private static MediaCodecInfo getNewCodecInfoAt(int index) {
        String[] supportedTypes = MediaCodecList.getSupportedTypes(index);
        MediaCodecInfo.CodecCapabilities[] caps = new MediaCodecInfo.CodecCapabilities[supportedTypes.length];
        int typeIx = 0;
        for (String type : supportedTypes) {
            caps[typeIx++] = MediaCodecList.getCodecCapabilities(index, type);
        }
        return new MediaCodecInfo(MediaCodecList.getCodecName(index), MediaCodecList.isEncoder(index), caps);
    }

    static final native String getCodecName(int var0);

    static final native boolean isEncoder(int var0);

    static final native String[] getSupportedTypes(int var0);

    static final native MediaCodecInfo.CodecCapabilities getCodecCapabilities(int var0, String var1);

    static final native Map<String, Object> native_getGlobalSettings();

    static final native int findCodecByName(String var0);

    public static MediaCodecInfo getInfoFor(String codec) {
        MediaCodecList.initCodecList();
        return sAllCodecInfos[MediaCodecList.findCodecByName(codec)];
    }

    private static final native void native_init();

    private MediaCodecList() {
        this(0);
    }

    public MediaCodecList(int kind) {
        MediaCodecList.initCodecList();
        this.mCodecInfos = kind == 0 ? sRegularCodecInfos : sAllCodecInfos;
    }

    public final MediaCodecInfo[] getCodecInfos() {
        return Arrays.copyOf(this.mCodecInfos, this.mCodecInfos.length);
    }

    public final String findDecoderForFormat(MediaFormat format) {
        return this.findCodecForFormat(false, format);
    }

    public final String findEncoderForFormat(MediaFormat format) {
        return this.findCodecForFormat(true, format);
    }

    private String findCodecForFormat(boolean encoder, MediaFormat format) {
        String mime = format.getString("mime");
        for (MediaCodecInfo info : this.mCodecInfos) {
            if (info.isEncoder() != encoder) continue;
            try {
                MediaCodecInfo.CodecCapabilities caps = info.getCapabilitiesForType(mime);
                if (caps == null || !caps.isFormatSupported(format)) continue;
                return info.getName();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        System.loadLibrary("media_jni");
        MediaCodecList.native_init();
    }
}

