/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaCodec;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;

public class MediaRecorder {
    private static final String TAG = "MediaRecorder";
    private long mNativeContext;
    private Surface mSurface;
    private String mPath;
    private FileDescriptor mFd;
    private EventHandler mEventHandler;
    private OnErrorListener mOnErrorListener;
    private OnInfoListener mOnInfoListener;
    public static final int MEDIA_RECORDER_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_RECORDER_INFO_UNKNOWN = 1;
    public static final int MEDIA_RECORDER_INFO_MAX_DURATION_REACHED = 800;
    public static final int MEDIA_RECORDER_INFO_MAX_FILESIZE_REACHED = 801;
    public static final int MEDIA_RECORDER_TRACK_INFO_LIST_START = 1000;
    public static final int MEDIA_RECORDER_TRACK_INFO_COMPLETION_STATUS = 1000;
    public static final int MEDIA_RECORDER_TRACK_INFO_PROGRESS_IN_TIME = 1001;
    public static final int MEDIA_RECORDER_TRACK_INFO_TYPE = 1002;
    public static final int MEDIA_RECORDER_TRACK_INFO_DURATION_MS = 1003;
    public static final int MEDIA_RECORDER_TRACK_INFO_MAX_CHUNK_DUR_MS = 1004;
    public static final int MEDIA_RECORDER_TRACK_INFO_ENCODED_FRAMES = 1005;
    public static final int MEDIA_RECORDER_TRACK_INTER_CHUNK_TIME_MS = 1006;
    public static final int MEDIA_RECORDER_TRACK_INFO_INITIAL_DELAY_MS = 1007;
    public static final int MEDIA_RECORDER_TRACK_INFO_START_OFFSET_MS = 1008;
    public static final int MEDIA_RECORDER_TRACK_INFO_DATA_KBYTES = 1009;
    public static final int MEDIA_RECORDER_TRACK_INFO_LIST_END = 2000;

    public MediaRecorder() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        String packageName = ActivityThread.currentPackageName();
        this.native_setup(new WeakReference<MediaRecorder>(this), packageName, ActivityThread.currentOpPackageName());
    }

    @Deprecated
    public native void setCamera(Camera var1);

    public native Surface getSurface();

    public void setInputSurface(Surface surface) {
        if (!(surface instanceof MediaCodec.PersistentSurface)) {
            throw new IllegalArgumentException("not a PersistentSurface");
        }
        this.native_setInputSurface(surface);
    }

    private final native void native_setInputSurface(Surface var1);

    public void setPreviewDisplay(Surface sv) {
        this.mSurface = sv;
    }

    public native void setAudioSource(int var1) throws IllegalStateException;

    public static final int getAudioSourceMax() {
        return 8;
    }

    public native void setVideoSource(int var1) throws IllegalStateException;

    public void setProfile(CamcorderProfile profile) {
        this.setOutputFormat(profile.fileFormat);
        this.setVideoFrameRate(profile.videoFrameRate);
        this.setVideoSize(profile.videoFrameWidth, profile.videoFrameHeight);
        this.setVideoEncodingBitRate(profile.videoBitRate);
        this.setVideoEncoder(profile.videoCodec);
        if (profile.quality < 1000 || profile.quality > 1007) {
            this.setAudioEncodingBitRate(profile.audioBitRate);
            this.setAudioChannels(profile.audioChannels);
            this.setAudioSamplingRate(profile.audioSampleRate);
            this.setAudioEncoder(profile.audioCodec);
        }
    }

    public void setCaptureRate(double fps) {
        this.setParameter("time-lapse-enable=1");
        this.setParameter("time-lapse-fps=" + fps);
    }

    public void setOrientationHint(int degrees) {
        if (degrees != 0 && degrees != 90 && degrees != 180 && degrees != 270) {
            throw new IllegalArgumentException("Unsupported angle: " + degrees);
        }
        this.setParameter("video-param-rotation-angle-degrees=" + degrees);
    }

    public void setLocation(float latitude, float longitude) {
        int latitudex10000 = (int)((double)(latitude * 10000.0f) + 0.5);
        int longitudex10000 = (int)((double)(longitude * 10000.0f) + 0.5);
        if (latitudex10000 > 900000 || latitudex10000 < -900000) {
            String msg = "Latitude: " + latitude + " out of range.";
            throw new IllegalArgumentException(msg);
        }
        if (longitudex10000 > 1800000 || longitudex10000 < -1800000) {
            String msg = "Longitude: " + longitude + " out of range";
            throw new IllegalArgumentException(msg);
        }
        this.setParameter("param-geotag-latitude=" + latitudex10000);
        this.setParameter("param-geotag-longitude=" + longitudex10000);
    }

    public native void setOutputFormat(int var1) throws IllegalStateException;

    public native void setVideoSize(int var1, int var2) throws IllegalStateException;

    public native void setVideoFrameRate(int var1) throws IllegalStateException;

    public native void setMaxDuration(int var1) throws IllegalArgumentException;

    public native void setMaxFileSize(long var1) throws IllegalArgumentException;

    public native void setAudioEncoder(int var1) throws IllegalStateException;

    public native void setVideoEncoder(int var1) throws IllegalStateException;

    public void setAudioSamplingRate(int samplingRate) {
        if (samplingRate <= 0) {
            throw new IllegalArgumentException("Audio sampling rate is not positive");
        }
        this.setParameter("audio-param-sampling-rate=" + samplingRate);
    }

    public void setAudioChannels(int numChannels) {
        if (numChannels <= 0) {
            throw new IllegalArgumentException("Number of channels is not positive");
        }
        this.setParameter("audio-param-number-of-channels=" + numChannels);
    }

    public void setAudioEncodingBitRate(int bitRate) {
        if (bitRate <= 0) {
            throw new IllegalArgumentException("Audio encoding bit rate is not positive");
        }
        this.setParameter("audio-param-encoding-bitrate=" + bitRate);
    }

    public void setVideoEncodingBitRate(int bitRate) {
        if (bitRate <= 0) {
            throw new IllegalArgumentException("Video encoding bit rate is not positive");
        }
        this.setParameter("video-param-encoding-bitrate=" + bitRate);
    }

    public void setAuxiliaryOutputFile(FileDescriptor fd) {
        Log.w(TAG, "setAuxiliaryOutputFile(FileDescriptor) is no longer supported.");
    }

    public void setAuxiliaryOutputFile(String path) {
        Log.w(TAG, "setAuxiliaryOutputFile(String) is no longer supported.");
    }

    public void setOutputFile(FileDescriptor fd) throws IllegalStateException {
        this.mPath = null;
        this.mFd = fd;
    }

    public void setOutputFile(String path) throws IllegalStateException {
        this.mFd = null;
        this.mPath = path;
    }

    private native void _setOutputFile(FileDescriptor var1, long var2, long var4) throws IllegalStateException, IOException;

    private native void _prepare() throws IllegalStateException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws IllegalStateException, IOException {
        if (this.mPath != null) {
            try (RandomAccessFile file = new RandomAccessFile(this.mPath, "rws");){
                this._setOutputFile(file.getFD(), 0L, 0L);
            }
        } else if (this.mFd != null) {
            this._setOutputFile(this.mFd, 0L, 0L);
        } else {
            throw new IOException("No valid output file");
        }
        this._prepare();
    }

    public native void start() throws IllegalStateException;

    public native void stop() throws IllegalStateException;

    public void reset() {
        this.native_reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
    }

    private native void native_reset();

    public native int getMaxAmplitude() throws IllegalStateException;

    public void setOnErrorListener(OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    private static void postEventFromNative(Object mediarecorder_ref, int what, int arg1, int arg2, Object obj) {
        MediaRecorder mr = (MediaRecorder)((WeakReference)mediarecorder_ref).get();
        if (mr == null) {
            return;
        }
        if (mr.mEventHandler != null) {
            Message m = mr.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mr.mEventHandler.sendMessage(m);
        }
    }

    public native void release();

    private static final native void native_init();

    private final native void native_setup(Object var1, String var2, String var3) throws IllegalStateException;

    private final native void native_finalize();

    private native void setParameter(String var1);

    protected void finalize() {
        this.native_finalize();
    }

    static {
        System.loadLibrary("media_jni");
        MediaRecorder.native_init();
    }

    private class EventHandler
    extends Handler {
        private MediaRecorder mMediaRecorder;
        private static final int MEDIA_RECORDER_EVENT_LIST_START = 1;
        private static final int MEDIA_RECORDER_EVENT_ERROR = 1;
        private static final int MEDIA_RECORDER_EVENT_INFO = 2;
        private static final int MEDIA_RECORDER_EVENT_LIST_END = 99;
        private static final int MEDIA_RECORDER_TRACK_EVENT_LIST_START = 100;
        private static final int MEDIA_RECORDER_TRACK_EVENT_ERROR = 100;
        private static final int MEDIA_RECORDER_TRACK_EVENT_INFO = 101;
        private static final int MEDIA_RECORDER_TRACK_EVENT_LIST_END = 1000;

        public EventHandler(MediaRecorder mr, Looper looper) {
            super(looper);
            this.mMediaRecorder = mr;
        }

        @Override
        public void handleMessage(Message msg) {
            if (this.mMediaRecorder.mNativeContext == 0L) {
                Log.w(MediaRecorder.TAG, "mediarecorder went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: 
                case 100: {
                    if (MediaRecorder.this.mOnErrorListener != null) {
                        MediaRecorder.this.mOnErrorListener.onError(this.mMediaRecorder, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 2: 
                case 101: {
                    if (MediaRecorder.this.mOnInfoListener != null) {
                        MediaRecorder.this.mOnInfoListener.onInfo(this.mMediaRecorder, msg.arg1, msg.arg2);
                    }
                    return;
                }
            }
            Log.e(MediaRecorder.TAG, "Unknown message type " + msg.what);
        }
    }

    public static interface OnInfoListener {
        public void onInfo(MediaRecorder var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public void onError(MediaRecorder var1, int var2, int var3);
    }

    public final class VideoEncoder {
        public static final int DEFAULT = 0;
        public static final int H263 = 1;
        public static final int H264 = 2;
        public static final int MPEG_4_SP = 3;
        public static final int VP8 = 4;

        private VideoEncoder() {
        }
    }

    public final class AudioEncoder {
        public static final int DEFAULT = 0;
        public static final int AMR_NB = 1;
        public static final int AMR_WB = 2;
        public static final int AAC = 3;
        public static final int HE_AAC = 4;
        public static final int AAC_ELD = 5;
        public static final int VORBIS = 6;

        private AudioEncoder() {
        }
    }

    public final class OutputFormat {
        public static final int DEFAULT = 0;
        public static final int THREE_GPP = 1;
        public static final int MPEG_4 = 2;
        public static final int RAW_AMR = 3;
        public static final int AMR_NB = 3;
        public static final int AMR_WB = 4;
        public static final int AAC_ADIF = 5;
        public static final int AAC_ADTS = 6;
        public static final int OUTPUT_FORMAT_RTP_AVP = 7;
        public static final int OUTPUT_FORMAT_MPEG2TS = 8;
        public static final int WEBM = 9;

        private OutputFormat() {
        }
    }

    public final class VideoSource {
        public static final int DEFAULT = 0;
        public static final int CAMERA = 1;
        public static final int SURFACE = 2;

        private VideoSource() {
        }
    }

    public final class AudioSource {
        public static final int AUDIO_SOURCE_INVALID = -1;
        public static final int DEFAULT = 0;
        public static final int MIC = 1;
        public static final int VOICE_UPLINK = 2;
        public static final int VOICE_DOWNLINK = 3;
        public static final int VOICE_CALL = 4;
        public static final int CAMCORDER = 5;
        public static final int VOICE_RECOGNITION = 6;
        public static final int VOICE_COMMUNICATION = 7;
        public static final int REMOTE_SUBMIX = 8;
        public static final int RADIO_TUNER = 1998;
        public static final int HOTWORD = 1999;

        private AudioSource() {
        }
    }
}

