/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioTrack;
import android.media.MediaTimestamp;
import android.media.PlaybackParams;
import android.media.SyncParams;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class MediaSync {
    public static final int MEDIASYNC_ERROR_AUDIOTRACK_FAIL = 1;
    public static final int MEDIASYNC_ERROR_SURFACE_FAIL = 2;
    private static final String TAG = "MediaSync";
    private static final int EVENT_CALLBACK = 1;
    private static final int EVENT_SET_CALLBACK = 2;
    private static final int CB_RETURN_AUDIO_BUFFER = 1;
    private final Object mCallbackLock = new Object();
    private Handler mCallbackHandler = null;
    private Callback mCallback = null;
    private final Object mOnErrorListenerLock = new Object();
    private Handler mOnErrorListenerHandler = null;
    private OnErrorListener mOnErrorListener = null;
    private Thread mAudioThread = null;
    private Handler mAudioHandler = null;
    private Looper mAudioLooper = null;
    private final Object mAudioLock = new Object();
    private AudioTrack mAudioTrack = null;
    private List<AudioBuffer> mAudioBuffers = new LinkedList<AudioBuffer>();
    private float mPlaybackRate = 0.0f;
    private long mNativeContext;

    public MediaSync() {
        this.native_setup();
    }

    private final native void native_setup();

    protected void finalize() {
        this.native_finalize();
    }

    private final native void native_finalize();

    public final void release() {
        this.returnAudioBuffers();
        if (this.mAudioThread != null && this.mAudioLooper != null) {
            this.mAudioLooper.quit();
        }
        this.setCallback(null, null);
        this.native_release();
    }

    private final native void native_release();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback cb, Handler handler) {
        Object object = this.mCallbackLock;
        synchronized (object) {
            if (handler != null) {
                this.mCallbackHandler = handler;
            } else {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    looper = Looper.getMainLooper();
                }
                this.mCallbackHandler = looper == null ? null : new Handler(looper);
            }
            this.mCallback = cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnErrorListener(OnErrorListener listener, Handler handler) {
        Object object = this.mOnErrorListenerLock;
        synchronized (object) {
            if (handler != null) {
                this.mOnErrorListenerHandler = handler;
            } else {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    looper = Looper.getMainLooper();
                }
                this.mOnErrorListenerHandler = looper == null ? null : new Handler(looper);
            }
            this.mOnErrorListener = listener;
        }
    }

    public void setSurface(Surface surface) {
        this.native_setSurface(surface);
    }

    private final native void native_setSurface(Surface var1);

    public void setAudioTrack(AudioTrack audioTrack) {
        this.native_setAudioTrack(audioTrack);
        this.mAudioTrack = audioTrack;
        if (audioTrack != null && this.mAudioThread == null) {
            this.createAudioThread();
        }
    }

    private final native void native_setAudioTrack(AudioTrack var1);

    public final native Surface createInputSurface();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackParams(PlaybackParams params) {
        Object object = this.mAudioLock;
        synchronized (object) {
            this.mPlaybackRate = this.native_setPlaybackParams(params);
        }
        if ((double)this.mPlaybackRate != 0.0 && this.mAudioThread != null) {
            this.postRenderAudio(0L);
        }
    }

    public native PlaybackParams getPlaybackParams();

    private native float native_setPlaybackParams(PlaybackParams var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncParams(SyncParams params) {
        Object object = this.mAudioLock;
        synchronized (object) {
            this.mPlaybackRate = this.native_setSyncParams(params);
        }
        if ((double)this.mPlaybackRate != 0.0 && this.mAudioThread != null) {
            this.postRenderAudio(0L);
        }
    }

    private native float native_setSyncParams(SyncParams var1);

    public native SyncParams getSyncParams();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mAudioLock;
        synchronized (object) {
            this.mAudioBuffers.clear();
            this.mCallbackHandler.removeCallbacksAndMessages(null);
        }
        if (this.mAudioTrack != null) {
            this.mAudioTrack.pause();
            this.mAudioTrack.flush();
            this.mAudioTrack.stop();
        }
        this.native_flush();
    }

    private final native void native_flush();

    public MediaTimestamp getTimestamp() {
        try {
            MediaTimestamp timestamp = new MediaTimestamp();
            if (this.native_getTimestamp(timestamp)) {
                return timestamp;
            }
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private final native boolean native_getTimestamp(MediaTimestamp var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAudio(ByteBuffer audioData, int bufferId, long presentationTimeUs) {
        if (this.mAudioTrack == null || this.mAudioThread == null) {
            throw new IllegalStateException("AudioTrack is NOT set or audio thread is not created");
        }
        Object object = this.mAudioLock;
        synchronized (object) {
            this.mAudioBuffers.add(new AudioBuffer(audioData, bufferId, presentationTimeUs));
        }
        if ((double)this.mPlaybackRate != 0.0) {
            this.postRenderAudio(0L);
        }
    }

    private void postRenderAudio(long delayMillis) {
        this.mAudioHandler.postDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = MediaSync.this.mAudioLock;
                synchronized (object) {
                    int sizeWritten;
                    if ((double)MediaSync.this.mPlaybackRate == 0.0) {
                        return;
                    }
                    if (MediaSync.this.mAudioBuffers.isEmpty()) {
                        return;
                    }
                    AudioBuffer audioBuffer = (AudioBuffer)MediaSync.this.mAudioBuffers.get(0);
                    int size = audioBuffer.mByteBuffer.remaining();
                    if (size > 0 && MediaSync.this.mAudioTrack.getPlayState() != 3) {
                        try {
                            MediaSync.this.mAudioTrack.play();
                        }
                        catch (IllegalStateException e) {
                            Log.w(MediaSync.TAG, "could not start audio track");
                        }
                    }
                    if ((sizeWritten = MediaSync.this.mAudioTrack.write(audioBuffer.mByteBuffer, size, 1)) > 0) {
                        if (audioBuffer.mPresentationTimeUs != -1L) {
                            MediaSync.this.native_updateQueuedAudioData(size, audioBuffer.mPresentationTimeUs);
                            audioBuffer.mPresentationTimeUs = -1L;
                        }
                        if (sizeWritten == size) {
                            MediaSync.this.postReturnByteBuffer(audioBuffer);
                            MediaSync.this.mAudioBuffers.remove(0);
                            if (!MediaSync.this.mAudioBuffers.isEmpty()) {
                                MediaSync.this.postRenderAudio(0L);
                            }
                            return;
                        }
                    }
                    long pendingTimeMs = TimeUnit.MICROSECONDS.toMillis(MediaSync.this.native_getPlayTimeForPendingAudioFrames());
                    MediaSync.this.postRenderAudio(pendingTimeMs / 2L);
                }
            }
        }, delayMillis);
    }

    private final native void native_updateQueuedAudioData(int var1, long var2);

    private final native long native_getPlayTimeForPendingAudioFrames();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postReturnByteBuffer(final AudioBuffer audioBuffer) {
        Object object = this.mCallbackLock;
        synchronized (object) {
            if (this.mCallbackHandler != null) {
                final MediaSync sync = this;
                this.mCallbackHandler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Callback callback;
                        Object object = MediaSync.this.mCallbackLock;
                        synchronized (object) {
                            callback = MediaSync.this.mCallback;
                            if (MediaSync.this.mCallbackHandler == null || MediaSync.this.mCallbackHandler.getLooper().getThread() != Thread.currentThread()) {
                                return;
                            }
                        }
                        if (callback != null) {
                            callback.onAudioBufferConsumed(sync, audioBuffer.mByteBuffer, audioBuffer.mBufferIndex);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void returnAudioBuffers() {
        Object object = this.mAudioLock;
        synchronized (object) {
            for (AudioBuffer audioBuffer : this.mAudioBuffers) {
                this.postReturnByteBuffer(audioBuffer);
            }
            this.mAudioBuffers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAudioThread() {
        this.mAudioThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Looper.prepare();
                Object object = MediaSync.this.mAudioLock;
                synchronized (object) {
                    MediaSync.this.mAudioLooper = Looper.myLooper();
                    MediaSync.this.mAudioHandler = new Handler();
                    MediaSync.this.mAudioLock.notify();
                }
                Looper.loop();
            }
        };
        this.mAudioThread.start();
        Object object = this.mAudioLock;
        synchronized (object) {
            try {
                this.mAudioLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static final native void native_init();

    static {
        System.loadLibrary("media_jni");
        MediaSync.native_init();
    }

    private static class AudioBuffer {
        public ByteBuffer mByteBuffer;
        public int mBufferIndex;
        long mPresentationTimeUs;

        public AudioBuffer(ByteBuffer byteBuffer, int bufferId, long presentationTimeUs) {
            this.mByteBuffer = byteBuffer;
            this.mBufferIndex = bufferId;
            this.mPresentationTimeUs = presentationTimeUs;
        }
    }

    public static interface OnErrorListener {
        public void onError(MediaSync var1, int var2, int var3);
    }

    public static abstract class Callback {
        public abstract void onAudioBufferConsumed(MediaSync var1, ByteBuffer var2, int var3);
    }
}

