/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioAttributes;
import android.os.Parcel;
import java.util.ArrayList;
import java.util.Objects;

public class AudioMixingRule {
    public static final int RULE_MATCH_ATTRIBUTE_USAGE = 1;
    public static final int RULE_MATCH_ATTRIBUTE_CAPTURE_PRESET = 2;
    private static final int RULE_EXCLUSION_MASK = 32768;
    public static final int RULE_EXCLUDE_ATTRIBUTE_USAGE = 32769;
    public static final int RULE_EXCLUDE_ATTRIBUTE_CAPTURE_PRESET = 32770;
    private final int mTargetMixType;
    private final ArrayList<AttributeMatchCriterion> mCriteria;

    private AudioMixingRule(int mixType, ArrayList<AttributeMatchCriterion> criteria) {
        this.mCriteria = criteria;
        this.mTargetMixType = mixType;
    }

    int getTargetMixType() {
        return this.mTargetMixType;
    }

    ArrayList<AttributeMatchCriterion> getCriteria() {
        return this.mCriteria;
    }

    public int hashCode() {
        return Objects.hash(this.mTargetMixType, this.mCriteria);
    }

    private static boolean isValidSystemApiRule(int rule) {
        switch (rule) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidIntRule(int rule) {
        switch (rule) {
            case 1: 
            case 2: 
            case 32769: 
            case 32770: {
                return true;
            }
        }
        return false;
    }

    private static boolean isPlayerRule(int rule) {
        return rule == 1 || rule == 32769;
    }

    public static class Builder {
        private ArrayList<AttributeMatchCriterion> mCriteria = new ArrayList();
        private int mTargetMixType = -1;

        public Builder addRule(AudioAttributes attrToMatch, int rule) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.addRuleInt(attrToMatch, rule);
        }

        public Builder excludeRule(AudioAttributes attrToMatch, int rule) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.addRuleInt(attrToMatch, rule | 0x8000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Builder addRuleInt(AudioAttributes attrToMatch, int rule) throws IllegalArgumentException {
            if (attrToMatch == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            if (!AudioMixingRule.isValidIntRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            if (this.mTargetMixType == -1) {
                this.mTargetMixType = AudioMixingRule.isPlayerRule(rule) ? 0 : 1;
            } else if (this.mTargetMixType == 0 && !AudioMixingRule.isPlayerRule(rule) || this.mTargetMixType == 1 && AudioMixingRule.isPlayerRule(rule)) {
                throw new IllegalArgumentException("Incompatible rule for mix");
            }
            ArrayList<AttributeMatchCriterion> arrayList = this.mCriteria;
            synchronized (arrayList) {
                for (AttributeMatchCriterion criterion : this.mCriteria) {
                    if (rule == 1 || rule == 32769) {
                        if (criterion.mAttr.getUsage() != attrToMatch.getUsage()) continue;
                        if (criterion.mRule == rule) {
                            return this;
                        }
                        throw new IllegalArgumentException("Contradictory rule exists for " + attrToMatch);
                    }
                    if (rule != 2 && rule != 32770 || criterion.mAttr.getCapturePreset() != attrToMatch.getCapturePreset()) continue;
                    if (criterion.mRule == rule) {
                        return this;
                    }
                    throw new IllegalArgumentException("Contradictory rule exists for " + attrToMatch);
                }
                this.mCriteria.add(new AttributeMatchCriterion(attrToMatch, rule));
            }
            return this;
        }

        Builder addRuleFromParcel(Parcel in) throws IllegalArgumentException {
            AudioAttributes attr2;
            int rule = in.readInt();
            if (rule == 1 || rule == 32769) {
                int usage = in.readInt();
                attr2 = new AudioAttributes.Builder().setUsage(usage).build();
            } else if (rule == 2 || rule == 32770) {
                int preset = in.readInt();
                attr2 = new AudioAttributes.Builder().setInternalCapturePreset(preset).build();
            } else {
                in.readInt();
                throw new IllegalArgumentException("Illegal rule value " + rule + " in parcel");
            }
            return this.addRuleInt(attr2, rule);
        }

        public AudioMixingRule build() {
            return new AudioMixingRule(this.mTargetMixType, this.mCriteria);
        }
    }

    static final class AttributeMatchCriterion {
        AudioAttributes mAttr;
        int mRule;

        AttributeMatchCriterion(AudioAttributes attributes, int rule) {
            this.mAttr = attributes;
            this.mRule = rule;
        }

        public int hashCode() {
            return Objects.hash(this.mAttr, this.mRule);
        }

        void writeToParcel(Parcel dest) {
            dest.writeInt(this.mRule);
            if (this.mRule == 1 || this.mRule == 32769) {
                dest.writeInt(this.mAttr.getUsage());
            } else {
                dest.writeInt(this.mAttr.getCapturePreset());
            }
        }
    }
}

