/*
 * Decompiled with CFR 0.152.
 */
package android.media.effect;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterFactory;
import android.filterfw.core.FilterFunction;
import android.filterfw.core.Frame;
import android.media.effect.EffectContext;
import android.media.effect.FilterEffect;

public class SingleFilterEffect
extends FilterEffect {
    protected FilterFunction mFunction;
    protected String mInputName;
    protected String mOutputName;

    public SingleFilterEffect(EffectContext context, String name, Class filterClass, String inputName, String outputName, Object ... finalParameters) {
        super(context, name);
        this.mInputName = inputName;
        this.mOutputName = outputName;
        String filterName = filterClass.getSimpleName();
        FilterFactory factory = FilterFactory.sharedFactory();
        Filter filter = factory.createFilterByClass(filterClass, filterName);
        filter.initWithAssignmentList(finalParameters);
        this.mFunction = new FilterFunction(this.getFilterContext(), filter);
    }

    @Override
    public void apply(int inputTexId, int width, int height, int outputTexId) {
        this.beginGLEffect();
        Frame inputFrame = this.frameFromTexture(inputTexId, width, height);
        Frame outputFrame = this.frameFromTexture(outputTexId, width, height);
        Frame resultFrame = this.mFunction.executeWithArgList(this.mInputName, inputFrame);
        outputFrame.setDataFromFrame(resultFrame);
        inputFrame.release();
        outputFrame.release();
        resultFrame.release();
        this.endGLEffect();
    }

    @Override
    public void setParameter(String parameterKey, Object value) {
        this.mFunction.setInputValue(parameterKey, value);
    }

    @Override
    public void release() {
        this.mFunction.tearDown();
        this.mFunction = null;
    }
}

