/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.tv.TvInputHardwareInfo;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public final class TvInputInfo
implements Parcelable {
    private static final boolean DEBUG = false;
    private static final String TAG = "TvInputInfo";
    public static final int TYPE_TUNER = 0;
    public static final int TYPE_OTHER = 1000;
    public static final int TYPE_COMPOSITE = 1001;
    public static final int TYPE_SVIDEO = 1002;
    public static final int TYPE_SCART = 1003;
    public static final int TYPE_COMPONENT = 1004;
    public static final int TYPE_VGA = 1005;
    public static final int TYPE_DVI = 1006;
    public static final int TYPE_HDMI = 1007;
    public static final int TYPE_DISPLAY_PORT = 1008;
    public static final String EXTRA_INPUT_ID = "android.media.tv.extra.INPUT_ID";
    private static final SparseIntArray sHardwareTypeToTvInputType = new SparseIntArray();
    private static final String XML_START_TAG_NAME = "tv-input";
    private static final String DELIMITER_INFO_IN_ID = "/";
    private static final String PREFIX_HDMI_DEVICE = "HDMI";
    private static final String PREFIX_HARDWARE_DEVICE = "HW";
    private static final int LENGTH_HDMI_PHYSICAL_ADDRESS = 4;
    private static final int LENGTH_HDMI_DEVICE_ID = 2;
    private final ResolveInfo mService;
    private final String mId;
    private final String mParentId;
    private final int mType;
    private final boolean mIsHardwareInput;
    private String mSetupActivity;
    private String mSettingsActivity;
    private HdmiDeviceInfo mHdmiDeviceInfo;
    private int mLabelRes;
    private String mLabel;
    private Icon mIcon;
    private Uri mIconUri;
    private boolean mIsConnectedToHdmiSwitch;
    public static final Parcelable.Creator<TvInputInfo> CREATOR;

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
        return TvInputInfo.createTvInputInfo(context, service, TvInputInfo.generateInputIdForComponentName(new ComponentName(service.serviceInfo.packageName, service.serviceInfo.name)), null, 0, false, 0, null, null, null, false);
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo service, HdmiDeviceInfo hdmiDeviceInfo, String parentId, String label, Uri iconUri) throws XmlPullParserException, IOException {
        boolean isConnectedToHdmiSwitch = (hdmiDeviceInfo.getPhysicalAddress() & 0xFFF) != 0;
        TvInputInfo input = TvInputInfo.createTvInputInfo(context, service, TvInputInfo.generateInputIdForHdmiDevice(new ComponentName(service.serviceInfo.packageName, service.serviceInfo.name), hdmiDeviceInfo), parentId, 1007, true, 0, label, null, iconUri, isConnectedToHdmiSwitch);
        input.mHdmiDeviceInfo = hdmiDeviceInfo;
        return input;
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo service, HdmiDeviceInfo hdmiDeviceInfo, String parentId, int labelRes, Icon icon) throws XmlPullParserException, IOException {
        boolean isConnectedToHdmiSwitch = (hdmiDeviceInfo.getPhysicalAddress() & 0xFFF) != 0;
        TvInputInfo input = TvInputInfo.createTvInputInfo(context, service, TvInputInfo.generateInputIdForHdmiDevice(new ComponentName(service.serviceInfo.packageName, service.serviceInfo.name), hdmiDeviceInfo), parentId, 1007, true, labelRes, null, icon, null, isConnectedToHdmiSwitch);
        input.mHdmiDeviceInfo = hdmiDeviceInfo;
        return input;
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo service, TvInputHardwareInfo hardwareInfo, String label, Uri iconUri) throws XmlPullParserException, IOException {
        int inputType = sHardwareTypeToTvInputType.get(hardwareInfo.getType(), 0);
        return TvInputInfo.createTvInputInfo(context, service, TvInputInfo.generateInputIdForHardware(new ComponentName(service.serviceInfo.packageName, service.serviceInfo.name), hardwareInfo), null, inputType, true, 0, label, null, iconUri, false);
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo service, TvInputHardwareInfo hardwareInfo, int labelRes, Icon icon) throws XmlPullParserException, IOException {
        int inputType = sHardwareTypeToTvInputType.get(hardwareInfo.getType(), 0);
        return TvInputInfo.createTvInputInfo(context, service, TvInputInfo.generateInputIdForHardware(new ComponentName(service.serviceInfo.packageName, service.serviceInfo.name), hardwareInfo), null, inputType, true, labelRes, null, icon, null, false);
    }

    private static TvInputInfo createTvInputInfo(Context context, ResolveInfo service, String id2, String parentId, int inputType, boolean isHardwareInput, int labelRes, String label, Icon icon, Uri iconUri, boolean isConnectedToHdmiSwitch) throws XmlPullParserException, IOException {
        ServiceInfo si = service.serviceInfo;
        PackageManager pm = context.getPackageManager();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.media.tv.input");
            if (parser == null) {
                throw new XmlPullParserException("No android.media.tv.input meta-data for " + si.name);
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!XML_START_TAG_NAME.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with tv-input-service tag in " + si.name);
            }
            TvInputInfo input = new TvInputInfo(service, id2, parentId, inputType, isHardwareInput);
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.TvInputService);
            input.mSetupActivity = sa.getString(1);
            if (inputType == 0 && TextUtils.isEmpty(input.mSetupActivity)) {
                throw new XmlPullParserException("Setup activity not found in " + si.name);
            }
            input.mSettingsActivity = sa.getString(0);
            sa.recycle();
            input.mLabelRes = labelRes;
            input.mLabel = label;
            input.mIcon = icon;
            input.mIconUri = iconUri;
            input.mIsConnectedToHdmiSwitch = isConnectedToHdmiSwitch;
            TvInputInfo tvInputInfo = input;
            return tvInputInfo;
        }
    }

    private TvInputInfo(ResolveInfo service, String id2, String parentId, int type, boolean isHardwareInput) {
        this.mService = service;
        this.mId = id2;
        this.mParentId = parentId;
        this.mType = type;
        this.mIsHardwareInput = isHardwareInput;
    }

    public String getId() {
        return this.mId;
    }

    public String getParentId() {
        return this.mParentId;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public Intent createSetupIntent() {
        if (!TextUtils.isEmpty(this.mSetupActivity)) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mService.serviceInfo.packageName, this.mSetupActivity);
            intent.putExtra(EXTRA_INPUT_ID, this.getId());
            return intent;
        }
        return null;
    }

    public Intent createSettingsIntent() {
        if (!TextUtils.isEmpty(this.mSettingsActivity)) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mService.serviceInfo.packageName, this.mSettingsActivity);
            intent.putExtra(EXTRA_INPUT_ID, this.getId());
            return intent;
        }
        return null;
    }

    public int getType() {
        return this.mType;
    }

    public HdmiDeviceInfo getHdmiDeviceInfo() {
        if (this.mType == 1007) {
            return this.mHdmiDeviceInfo;
        }
        return null;
    }

    public boolean isPassthroughInput() {
        return this.mType != 0;
    }

    public boolean isHardwareInput() {
        return this.mIsHardwareInput;
    }

    public boolean isConnectedToHdmiSwitch() {
        return this.mIsConnectedToHdmiSwitch;
    }

    public boolean isHidden(Context context) {
        return TvInputSettings.isHidden(context, this.mId, UserHandle.myUserId());
    }

    public CharSequence loadLabel(Context context) {
        if (this.mLabelRes != 0) {
            return context.getPackageManager().getText(this.mService.serviceInfo.packageName, this.mLabelRes, null);
        }
        if (!TextUtils.isEmpty(this.mLabel)) {
            return this.mLabel;
        }
        return this.mService.loadLabel(context.getPackageManager());
    }

    public CharSequence loadCustomLabel(Context context) {
        return TvInputSettings.getCustomLabel(context, this.mId, UserHandle.myUserId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Drawable loadIcon(Context context) {
        if (this.mIcon != null) {
            return this.mIcon.loadDrawable(context);
        }
        if (this.mIconUri == null) return this.loadServiceIcon(context);
        try (InputStream is = context.getContentResolver().openInputStream(this.mIconUri);){
            Drawable drawable3 = Drawable.createFromStream(is, null);
            if (drawable3 == null) return this.loadServiceIcon(context);
            Drawable drawable2 = drawable3;
            return drawable2;
        }
        catch (IOException e) {
            Log.w(TAG, "Loading the default icon due to a failure on loading " + this.mIconUri, e);
        }
        return this.loadServiceIcon(context);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TvInputInfo)) {
            return false;
        }
        TvInputInfo obj = (TvInputInfo)o;
        return this.mId.equals(obj.mId);
    }

    public String toString() {
        return "TvInputInfo{id=" + this.mId + ", pkg=" + this.mService.serviceInfo.packageName + ", service=" + this.mService.serviceInfo.name + "}";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeString(this.mParentId);
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mSetupActivity);
        dest.writeString(this.mSettingsActivity);
        dest.writeInt(this.mType);
        dest.writeByte(this.mIsHardwareInput ? (byte)1 : 0);
        dest.writeParcelable(this.mHdmiDeviceInfo, flags);
        dest.writeParcelable(this.mIcon, flags);
        dest.writeParcelable(this.mIconUri, flags);
        dest.writeInt(this.mLabelRes);
        dest.writeString(this.mLabel);
        dest.writeByte(this.mIsConnectedToHdmiSwitch ? (byte)1 : 0);
    }

    private Drawable loadServiceIcon(Context context) {
        if (this.mService.serviceInfo.icon == 0 && this.mService.serviceInfo.applicationInfo.icon == 0) {
            return null;
        }
        return this.mService.serviceInfo.loadIcon(context.getPackageManager());
    }

    private static String generateInputIdForComponentName(ComponentName name) {
        return name.flattenToShortString();
    }

    private static String generateInputIdForHdmiDevice(ComponentName name, HdmiDeviceInfo deviceInfo) {
        String format = "/HDMI%04X%02X";
        return name.flattenToShortString() + String.format(Locale.ENGLISH, format, deviceInfo.getPhysicalAddress(), deviceInfo.getId());
    }

    private static String generateInputIdForHardware(ComponentName name, TvInputHardwareInfo hardwareInfo) {
        return name.flattenToShortString() + DELIMITER_INFO_IN_ID + PREFIX_HARDWARE_DEVICE + hardwareInfo.getDeviceId();
    }

    private TvInputInfo(Parcel in) {
        this.mId = in.readString();
        this.mParentId = in.readString();
        this.mService = ResolveInfo.CREATOR.createFromParcel(in);
        this.mSetupActivity = in.readString();
        this.mSettingsActivity = in.readString();
        this.mType = in.readInt();
        this.mIsHardwareInput = in.readByte() == 1;
        this.mHdmiDeviceInfo = (HdmiDeviceInfo)in.readParcelable(null);
        this.mIcon = (Icon)in.readParcelable(null);
        this.mIconUri = (Uri)in.readParcelable(null);
        this.mLabelRes = in.readInt();
        this.mLabel = in.readString();
        this.mIsConnectedToHdmiSwitch = in.readByte() == 1;
    }

    static {
        sHardwareTypeToTvInputType.put(1, 1000);
        sHardwareTypeToTvInputType.put(2, 0);
        sHardwareTypeToTvInputType.put(3, 1001);
        sHardwareTypeToTvInputType.put(4, 1002);
        sHardwareTypeToTvInputType.put(5, 1003);
        sHardwareTypeToTvInputType.put(6, 1004);
        sHardwareTypeToTvInputType.put(7, 1005);
        sHardwareTypeToTvInputType.put(8, 1006);
        sHardwareTypeToTvInputType.put(9, 1007);
        sHardwareTypeToTvInputType.put(10, 1008);
        CREATOR = new Parcelable.Creator<TvInputInfo>(){

            @Override
            public TvInputInfo createFromParcel(Parcel in) {
                return new TvInputInfo(in);
            }

            public TvInputInfo[] newArray(int size) {
                return new TvInputInfo[size];
            }
        };
    }

    public static final class TvInputSettings {
        private static final String TV_INPUT_SEPARATOR = ":";
        private static final String CUSTOM_NAME_SEPARATOR = ",";

        private TvInputSettings() {
        }

        private static boolean isHidden(Context context, String inputId, int userId) {
            return TvInputSettings.getHiddenTvInputIds(context, userId).contains(inputId);
        }

        private static String getCustomLabel(Context context, String inputId, int userId) {
            return TvInputSettings.getCustomLabels(context, userId).get(inputId);
        }

        public static Set<String> getHiddenTvInputIds(Context context, int userId) {
            String[] ids;
            String hiddenIdsString = Settings.Secure.getStringForUser(context.getContentResolver(), "tv_input_hidden_inputs", userId);
            HashSet<String> set = new HashSet<String>();
            if (TextUtils.isEmpty(hiddenIdsString)) {
                return set;
            }
            for (String id2 : ids = hiddenIdsString.split(TV_INPUT_SEPARATOR)) {
                set.add(Uri.decode(id2));
            }
            return set;
        }

        public static Map<String, String> getCustomLabels(Context context, int userId) {
            String[] pairs;
            String labelsString = Settings.Secure.getStringForUser(context.getContentResolver(), "tv_input_custom_labels", userId);
            HashMap<String, String> map = new HashMap<String, String>();
            if (TextUtils.isEmpty(labelsString)) {
                return map;
            }
            for (String pairString : pairs = labelsString.split(TV_INPUT_SEPARATOR)) {
                String[] pair = pairString.split(CUSTOM_NAME_SEPARATOR);
                map.put(Uri.decode(pair[0]), Uri.decode(pair[1]));
            }
            return map;
        }

        public static void putHiddenTvInputs(Context context, Set<String> hiddenInputIds, int userId) {
            StringBuilder builder = new StringBuilder();
            boolean firstItem = true;
            for (String inputId : hiddenInputIds) {
                TvInputSettings.ensureValidField(inputId);
                if (firstItem) {
                    firstItem = false;
                } else {
                    builder.append(TV_INPUT_SEPARATOR);
                }
                builder.append(Uri.encode(inputId));
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "tv_input_hidden_inputs", builder.toString(), userId);
        }

        public static void putCustomLabels(Context context, Map<String, String> customLabels, int userId) {
            StringBuilder builder = new StringBuilder();
            boolean firstItem = true;
            for (Map.Entry<String, String> entry : customLabels.entrySet()) {
                TvInputSettings.ensureValidField(entry.getKey());
                TvInputSettings.ensureValidField(entry.getValue());
                if (firstItem) {
                    firstItem = false;
                } else {
                    builder.append(TV_INPUT_SEPARATOR);
                }
                builder.append(Uri.encode(entry.getKey()));
                builder.append(CUSTOM_NAME_SEPARATOR);
                builder.append(Uri.encode(entry.getValue()));
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "tv_input_custom_labels", builder.toString(), userId);
        }

        private static void ensureValidField(String value) {
            if (TextUtils.isEmpty(value)) {
                throw new IllegalArgumentException(value + " should not empty ");
            }
        }
    }
}

