/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.content.Context;
import android.net.IConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkUtils;
import android.net.Proxy;
import android.net.ProxyInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkActivityListener;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import com.android.internal.util.Preconditions;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.net.event.NetworkEventDispatcher;

public class ConnectivityManager {
    private static final String TAG = "ConnectivityManager";
    public static final String CONNECTIVITY_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    public static final String ACTION_CAPTIVE_PORTAL_SIGN_IN = "android.net.conn.CAPTIVE_PORTAL";
    @Deprecated
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_NETWORK_TYPE = "networkType";
    public static final String EXTRA_IS_FAILOVER = "isFailover";
    public static final String EXTRA_OTHER_NETWORK_INFO = "otherNetwork";
    public static final String EXTRA_NO_CONNECTIVITY = "noConnectivity";
    public static final String EXTRA_REASON = "reason";
    public static final String EXTRA_EXTRA_INFO = "extraInfo";
    public static final String EXTRA_INET_CONDITION = "inetCondition";
    public static final String EXTRA_CAPTIVE_PORTAL = "android.net.extra.CAPTIVE_PORTAL";
    public static final String ACTION_DATA_ACTIVITY_CHANGE = "android.net.conn.DATA_ACTIVITY_CHANGE";
    public static final String EXTRA_DEVICE_TYPE = "deviceType";
    public static final String EXTRA_IS_ACTIVE = "isActive";
    public static final String EXTRA_REALTIME_NS = "tsNanos";
    @Deprecated
    public static final String ACTION_BACKGROUND_DATA_SETTING_CHANGED = "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED";
    public static final String INET_CONDITION_ACTION = "android.net.conn.INET_CONDITION_ACTION";
    public static final String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";
    public static final String EXTRA_AVAILABLE_TETHER = "availableArray";
    public static final String EXTRA_ACTIVE_TETHER = "activeArray";
    public static final String EXTRA_ERRORED_TETHER = "erroredArray";
    public static final String ACTION_CAPTIVE_PORTAL_TEST_COMPLETED = "android.net.conn.CAPTIVE_PORTAL_TEST_COMPLETED";
    public static final String EXTRA_IS_CAPTIVE_PORTAL = "captivePortal";
    public static final String ACTION_PROMPT_UNVALIDATED = "android.net.conn.PROMPT_UNVALIDATED";
    public static final int TYPE_NONE = -1;
    public static final int TYPE_MOBILE = 0;
    public static final int TYPE_WIFI = 1;
    public static final int TYPE_MOBILE_MMS = 2;
    public static final int TYPE_MOBILE_SUPL = 3;
    public static final int TYPE_MOBILE_DUN = 4;
    public static final int TYPE_MOBILE_HIPRI = 5;
    public static final int TYPE_WIMAX = 6;
    public static final int TYPE_BLUETOOTH = 7;
    public static final int TYPE_DUMMY = 8;
    public static final int TYPE_ETHERNET = 9;
    public static final int TYPE_MOBILE_FOTA = 10;
    public static final int TYPE_MOBILE_IMS = 11;
    public static final int TYPE_MOBILE_CBS = 12;
    public static final int TYPE_WIFI_P2P = 13;
    public static final int TYPE_MOBILE_IA = 14;
    public static final int TYPE_MOBILE_EMERGENCY = 15;
    public static final int TYPE_PROXY = 16;
    public static final int TYPE_VPN = 17;
    public static final int MAX_RADIO_TYPE = 17;
    public static final int MAX_NETWORK_TYPE = 17;
    @Deprecated
    public static final int DEFAULT_NETWORK_PREFERENCE = 1;
    public static final int REQUEST_ID_UNSET = 0;
    public static final int NETID_UNSET = 0;
    private final IConnectivityManager mService;
    private static ConnectivityManager sInstance;
    private final Context mContext;
    private INetworkManagementService mNMService;
    private static HashMap<NetworkCapabilities, LegacyRequest> sLegacyRequests;
    private final ArrayMap<OnNetworkActiveListener, INetworkActivityListener> mNetworkActivityListeners = new ArrayMap();
    public static final int TETHER_ERROR_NO_ERROR = 0;
    public static final int TETHER_ERROR_UNKNOWN_IFACE = 1;
    public static final int TETHER_ERROR_SERVICE_UNAVAIL = 2;
    public static final int TETHER_ERROR_UNSUPPORTED = 3;
    public static final int TETHER_ERROR_UNAVAIL_IFACE = 4;
    public static final int TETHER_ERROR_MASTER_ERROR = 5;
    public static final int TETHER_ERROR_TETHER_IFACE_ERROR = 6;
    public static final int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7;
    public static final int TETHER_ERROR_ENABLE_NAT_ERROR = 8;
    public static final int TETHER_ERROR_DISABLE_NAT_ERROR = 9;
    public static final int TETHER_ERROR_IFACE_CFG_ERROR = 10;
    private static final int BASE = 524288;
    public static final int CALLBACK_PRECHECK = 524289;
    public static final int CALLBACK_AVAILABLE = 524290;
    public static final int CALLBACK_LOSING = 524291;
    public static final int CALLBACK_LOST = 524292;
    public static final int CALLBACK_UNAVAIL = 524293;
    public static final int CALLBACK_CAP_CHANGED = 524294;
    public static final int CALLBACK_IP_CHANGED = 524295;
    public static final int CALLBACK_RELEASED = 524296;
    public static final int CALLBACK_EXIT = 524297;
    private static final int EXPIRE_LEGACY_REQUEST = 524298;
    public static final int CALLBACK_SUSPENDED = 524299;
    public static final int CALLBACK_RESUMED = 524300;
    static final HashMap<NetworkRequest, NetworkCallback> sNetworkCallback;
    static final AtomicInteger sCallbackRefCount;
    static CallbackHandler sCallbackHandler;
    private static final int LISTEN = 1;
    private static final int REQUEST = 2;
    public static final int MAX_NETWORK_REQUEST_TIMEOUT_MS = 6000000;
    public static final String EXTRA_NETWORK = "android.net.extra.NETWORK";
    public static final String EXTRA_NETWORK_REQUEST = "android.net.extra.NETWORK_REQUEST";

    public static boolean isNetworkTypeValid(int networkType) {
        return networkType >= 0 && networkType <= 17;
    }

    public static String getNetworkTypeName(int type) {
        switch (type) {
            case 0: {
                return "MOBILE";
            }
            case 1: {
                return "WIFI";
            }
            case 2: {
                return "MOBILE_MMS";
            }
            case 3: {
                return "MOBILE_SUPL";
            }
            case 4: {
                return "MOBILE_DUN";
            }
            case 5: {
                return "MOBILE_HIPRI";
            }
            case 6: {
                return "WIMAX";
            }
            case 7: {
                return "BLUETOOTH";
            }
            case 8: {
                return "DUMMY";
            }
            case 9: {
                return "ETHERNET";
            }
            case 10: {
                return "MOBILE_FOTA";
            }
            case 11: {
                return "MOBILE_IMS";
            }
            case 12: {
                return "MOBILE_CBS";
            }
            case 13: {
                return "WIFI_P2P";
            }
            case 14: {
                return "MOBILE_IA";
            }
            case 15: {
                return "MOBILE_EMERGENCY";
            }
            case 16: {
                return "PROXY";
            }
            case 17: {
                return "VPN";
            }
        }
        return Integer.toString(type);
    }

    public static boolean isNetworkTypeMobile(int networkType) {
        switch (networkType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNetworkTypeWifi(int networkType) {
        switch (networkType) {
            case 1: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public void setNetworkPreference(int preference) {
    }

    public int getNetworkPreference() {
        return -1;
    }

    public NetworkInfo getActiveNetworkInfo() {
        try {
            return this.mService.getActiveNetworkInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public Network getActiveNetwork() {
        try {
            return this.mService.getActiveNetwork();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NetworkInfo getActiveNetworkInfoForUid(int uid) {
        try {
            return this.mService.getActiveNetworkInfoForUid(uid);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NetworkInfo getNetworkInfo(int networkType) {
        try {
            return this.mService.getNetworkInfo(networkType);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NetworkInfo getNetworkInfo(Network network) {
        try {
            return this.mService.getNetworkInfoForNetwork(network);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NetworkInfo[] getAllNetworkInfo() {
        try {
            return this.mService.getAllNetworkInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public Network getNetworkForType(int networkType) {
        try {
            return this.mService.getNetworkForType(networkType);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public Network[] getAllNetworks() {
        try {
            return this.mService.getAllNetworks();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NetworkCapabilities[] getDefaultNetworkCapabilitiesForUser(int userId) {
        try {
            return this.mService.getDefaultNetworkCapabilitiesForUser(userId);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public LinkProperties getActiveLinkProperties() {
        try {
            return this.mService.getActiveLinkProperties();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public LinkProperties getLinkProperties(int networkType) {
        try {
            return this.mService.getLinkPropertiesForType(networkType);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public LinkProperties getLinkProperties(Network network) {
        try {
            return this.mService.getLinkProperties(network);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NetworkCapabilities getNetworkCapabilities(Network network) {
        try {
            return this.mService.getNetworkCapabilities(network);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startUsingNetworkFeature(int networkType, String feature) {
        this.checkLegacyRoutingApiAccess();
        NetworkCapabilities netCap = this.networkCapabilitiesForFeature(networkType, feature);
        if (netCap == null) {
            Log.d(TAG, "Can't satisfy startUsingNetworkFeature for " + networkType + ", " + feature);
            return 3;
        }
        NetworkRequest request = null;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l != null) {
                Log.d(TAG, "renewing startUsingNetworkFeature request " + l.networkRequest);
                this.renewRequestLocked(l);
                if (l.currentNetwork != null) {
                    return 0;
                }
                return 1;
            }
            request = this.requestNetworkForFeatureLocked(netCap);
        }
        if (request != null) {
            Log.d(TAG, "starting startUsingNetworkFeature for request " + request);
            return 1;
        }
        Log.d(TAG, " request Failed");
        return 3;
    }

    public int stopUsingNetworkFeature(int networkType, String feature) {
        this.checkLegacyRoutingApiAccess();
        NetworkCapabilities netCap = this.networkCapabilitiesForFeature(networkType, feature);
        if (netCap == null) {
            Log.d(TAG, "Can't satisfy stopUsingNetworkFeature for " + networkType + ", " + feature);
            return -1;
        }
        if (this.removeRequestForFeature(netCap)) {
            Log.d(TAG, "stopUsingNetworkFeature for " + networkType + ", " + feature);
        }
        return 1;
    }

    private NetworkCapabilities networkCapabilitiesForFeature(int networkType, String feature) {
        if (networkType == 0) {
            int cap = -1;
            if ("enableMMS".equals(feature)) {
                cap = 0;
            } else if ("enableSUPL".equals(feature)) {
                cap = 1;
            } else if ("enableDUN".equals(feature) || "enableDUNAlways".equals(feature)) {
                cap = 2;
            } else if ("enableHIPRI".equals(feature)) {
                cap = 12;
            } else if ("enableFOTA".equals(feature)) {
                cap = 3;
            } else if ("enableIMS".equals(feature)) {
                cap = 4;
            } else if ("enableCBS".equals(feature)) {
                cap = 5;
            } else {
                return null;
            }
            NetworkCapabilities netCap = new NetworkCapabilities();
            netCap.addTransportType(0).addCapability(cap);
            netCap.maybeMarkCapabilitiesRestricted();
            return netCap;
        }
        if (networkType == 1 && "p2p".equals(feature)) {
            NetworkCapabilities netCap = new NetworkCapabilities();
            netCap.addTransportType(1);
            netCap.addCapability(6);
            netCap.maybeMarkCapabilitiesRestricted();
            return netCap;
        }
        return null;
    }

    private int inferLegacyTypeForNetworkCapabilities(NetworkCapabilities netCap) {
        NetworkCapabilities testCap;
        if (netCap == null) {
            return -1;
        }
        if (!netCap.hasTransport(0)) {
            return -1;
        }
        String type = null;
        int result = -1;
        if (netCap.hasCapability(5)) {
            type = "enableCBS";
            result = 12;
        } else if (netCap.hasCapability(4)) {
            type = "enableIMS";
            result = 11;
        } else if (netCap.hasCapability(3)) {
            type = "enableFOTA";
            result = 10;
        } else if (netCap.hasCapability(2)) {
            type = "enableDUN";
            result = 4;
        } else if (netCap.hasCapability(1)) {
            type = "enableSUPL";
            result = 3;
        } else if (netCap.hasCapability(12)) {
            type = "enableHIPRI";
            result = 5;
        }
        if (type != null && (testCap = this.networkCapabilitiesForFeature(0, type)).equalsNetCapabilities(netCap) && testCap.equalsTransportTypes(netCap)) {
            return result;
        }
        return -1;
    }

    private int legacyTypeForNetworkCapabilities(NetworkCapabilities netCap) {
        if (netCap == null) {
            return -1;
        }
        if (netCap.hasCapability(5)) {
            return 12;
        }
        if (netCap.hasCapability(4)) {
            return 11;
        }
        if (netCap.hasCapability(3)) {
            return 10;
        }
        if (netCap.hasCapability(2)) {
            return 4;
        }
        if (netCap.hasCapability(1)) {
            return 3;
        }
        if (netCap.hasCapability(0)) {
            return 2;
        }
        if (netCap.hasCapability(12)) {
            return 5;
        }
        if (netCap.hasCapability(6)) {
            return 13;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkRequest findRequestForFeature(NetworkCapabilities netCap) {
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l != null) {
                return l.networkRequest;
            }
        }
        return null;
    }

    private void renewRequestLocked(LegacyRequest l) {
        ++l.expireSequenceNumber;
        Log.d(TAG, "renewing request to seqNum " + l.expireSequenceNumber);
        this.sendExpireMsgForFeature(l.networkCapabilities, l.expireSequenceNumber, l.delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireRequest(NetworkCapabilities netCap, int sequenceNum) {
        int ourSeqNum = -1;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l == null) {
                return;
            }
            ourSeqNum = l.expireSequenceNumber;
            if (l.expireSequenceNumber == sequenceNum) {
                this.removeRequestForFeature(netCap);
            }
        }
        Log.d(TAG, "expireRequest with " + ourSeqNum + ", " + sequenceNum);
    }

    private NetworkRequest requestNetworkForFeatureLocked(NetworkCapabilities netCap) {
        int delay = -1;
        int type = this.legacyTypeForNetworkCapabilities(netCap);
        try {
            delay = this.mService.getRestoreDefaultNetworkDelay(type);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        LegacyRequest l = new LegacyRequest();
        l.networkCapabilities = netCap;
        l.delay = delay;
        l.expireSequenceNumber = 0;
        l.networkRequest = this.sendRequestForNetwork(netCap, l.networkCallback, 0, 2, type);
        if (l.networkRequest == null) {
            return null;
        }
        sLegacyRequests.put(netCap, l);
        this.sendExpireMsgForFeature(netCap, l.expireSequenceNumber, delay);
        return l.networkRequest;
    }

    private void sendExpireMsgForFeature(NetworkCapabilities netCap, int seqNum, int delay) {
        if (delay >= 0) {
            Log.d(TAG, "sending expire msg with seqNum " + seqNum + " and delay " + delay);
            Message msg = sCallbackHandler.obtainMessage(524298, seqNum, 0, netCap);
            sCallbackHandler.sendMessageDelayed(msg, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRequestForFeature(NetworkCapabilities netCap) {
        LegacyRequest l;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            l = sLegacyRequests.remove(netCap);
        }
        if (l == null) {
            return false;
        }
        this.unregisterNetworkCallback(l.networkCallback);
        l.clearDnsBinding();
        return true;
    }

    public boolean requestRouteToHost(int networkType, int hostAddress) {
        return this.requestRouteToHostAddress(networkType, NetworkUtils.intToInetAddress(hostAddress));
    }

    public boolean requestRouteToHostAddress(int networkType, InetAddress hostAddress) {
        this.checkLegacyRoutingApiAccess();
        try {
            return this.mService.requestRouteToHostAddress(networkType, hostAddress.getAddress());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Deprecated
    public boolean getBackgroundDataSetting() {
        return true;
    }

    @Deprecated
    public void setBackgroundDataSetting(boolean allowBackgroundData) {
    }

    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        try {
            return this.mService.getActiveNetworkQuotaInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean getMobileDataEnabled() {
        IBinder b = ServiceManager.getService("phone");
        if (b != null) {
            try {
                ITelephony it = ITelephony.Stub.asInterface(b);
                int subId = SubscriptionManager.getDefaultDataSubId();
                Log.d(TAG, "getMobileDataEnabled()+ subId=" + subId);
                boolean retVal = it.getDataEnabled(subId);
                Log.d(TAG, "getMobileDataEnabled()- subId=" + subId + " retVal=" + retVal);
                return retVal;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        Log.d(TAG, "getMobileDataEnabled()- remote exception retVal=false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INetworkManagementService getNetworkManagementService() {
        ConnectivityManager connectivityManager = this;
        synchronized (connectivityManager) {
            if (this.mNMService != null) {
                return this.mNMService;
            }
            IBinder b = ServiceManager.getService("network_management");
            this.mNMService = INetworkManagementService.Stub.asInterface(b);
            return this.mNMService;
        }
    }

    public void addDefaultNetworkActiveListener(final OnNetworkActiveListener l) {
        INetworkActivityListener.Stub rl = new INetworkActivityListener.Stub(){

            @Override
            public void onNetworkActive() throws RemoteException {
                l.onNetworkActive();
            }
        };
        try {
            this.getNetworkManagementService().registerNetworkActivityListener(rl);
            this.mNetworkActivityListeners.put(l, rl);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void removeDefaultNetworkActiveListener(OnNetworkActiveListener l) {
        INetworkActivityListener rl = this.mNetworkActivityListeners.get(l);
        if (rl == null) {
            throw new IllegalArgumentException("Listener not registered: " + l);
        }
        try {
            this.getNetworkManagementService().unregisterNetworkActivityListener(rl);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean isDefaultNetworkActive() {
        try {
            return this.getNetworkManagementService().isNetworkActive();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public ConnectivityManager(Context context, IConnectivityManager service) {
        this.mContext = Preconditions.checkNotNull(context, "missing context");
        this.mService = Preconditions.checkNotNull(service, "missing IConnectivityManager");
        sInstance = this;
    }

    public static ConnectivityManager from(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    public static final void enforceTetherChangePermission(Context context) {
        if (context.getResources().getStringArray(17235989).length == 2) {
            context.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", "ConnectivityService");
        } else {
            int uid = Binder.getCallingUid();
            Settings.checkAndNoteChangeNetworkStateOperation(context, uid, Settings.getPackageNameForUid(context, uid), true);
        }
    }

    static ConnectivityManager getInstanceOrNull() {
        return sInstance;
    }

    private static ConnectivityManager getInstance() {
        if (ConnectivityManager.getInstanceOrNull() == null) {
            throw new IllegalStateException("No ConnectivityManager yet constructed");
        }
        return ConnectivityManager.getInstanceOrNull();
    }

    public String[] getTetherableIfaces() {
        try {
            return this.mService.getTetherableIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetheredIfaces() {
        try {
            return this.mService.getTetheredIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetheringErroredIfaces() {
        try {
            return this.mService.getTetheringErroredIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetheredDhcpRanges() {
        try {
            return this.mService.getTetheredDhcpRanges();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public int tether(String iface) {
        try {
            return this.mService.tether(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    public int untether(String iface) {
        try {
            return this.mService.untether(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    public boolean isTetheringSupported() {
        try {
            return this.mService.isTetheringSupported();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public String[] getTetherableUsbRegexs() {
        try {
            return this.mService.getTetherableUsbRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetherableWifiRegexs() {
        try {
            return this.mService.getTetherableWifiRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetherableBluetoothRegexs() {
        try {
            return this.mService.getTetherableBluetoothRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public int setUsbTethering(boolean enable) {
        try {
            return this.mService.setUsbTethering(enable);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    public int getLastTetherError(String iface) {
        try {
            return this.mService.getLastTetherError(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    public void reportInetCondition(int networkType, int percentage) {
        try {
            this.mService.reportInetCondition(networkType, percentage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void reportBadNetwork(Network network) {
        try {
            this.mService.reportNetworkConnectivity(network, true);
            this.mService.reportNetworkConnectivity(network, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void reportNetworkConnectivity(Network network, boolean hasConnectivity) {
        try {
            this.mService.reportNetworkConnectivity(network, hasConnectivity);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setGlobalProxy(ProxyInfo p) {
        try {
            this.mService.setGlobalProxy(p);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ProxyInfo getGlobalProxy() {
        try {
            return this.mService.getGlobalProxy();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ProxyInfo getProxyForNetwork(Network network) {
        try {
            return this.mService.getProxyForNetwork(network);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ProxyInfo getDefaultProxy() {
        return this.getProxyForNetwork(this.getBoundNetworkForProcess());
    }

    public boolean isNetworkSupported(int networkType) {
        try {
            return this.mService.isNetworkSupported(networkType);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isActiveNetworkMetered() {
        try {
            return this.mService.isActiveNetworkMetered();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean updateLockdownVpn() {
        try {
            return this.mService.updateLockdownVpn();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public int checkMobileProvisioning(int suggestedTimeOutMs) {
        int timeOutMs = -1;
        try {
            timeOutMs = this.mService.checkMobileProvisioning(suggestedTimeOutMs);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return timeOutMs;
    }

    public String getMobileProvisioningUrl() {
        try {
            return this.mService.getMobileProvisioningUrl();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void setProvisioningNotificationVisible(boolean visible, int networkType, String action) {
        try {
            this.mService.setProvisioningNotificationVisible(visible, networkType, action);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void setAirplaneMode(boolean enable) {
        try {
            this.mService.setAirplaneMode(enable);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void registerNetworkFactory(Messenger messenger, String name) {
        try {
            this.mService.registerNetworkFactory(messenger, name);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void unregisterNetworkFactory(Messenger messenger) {
        try {
            this.mService.unregisterNetworkFactory(messenger);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int registerNetworkAgent(Messenger messenger, NetworkInfo ni, LinkProperties lp, NetworkCapabilities nc, int score, NetworkMisc misc) {
        try {
            return this.mService.registerNetworkAgent(messenger, ni, lp, nc, score, misc);
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incCallbackHandlerRefCount() {
        AtomicInteger atomicInteger = sCallbackRefCount;
        synchronized (atomicInteger) {
            if (sCallbackRefCount.incrementAndGet() == 1) {
                HandlerThread callbackThread = new HandlerThread(TAG);
                callbackThread.start();
                sCallbackHandler = new CallbackHandler(callbackThread.getLooper(), sNetworkCallback, sCallbackRefCount, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decCallbackHandlerRefCount() {
        AtomicInteger atomicInteger = sCallbackRefCount;
        synchronized (atomicInteger) {
            if (sCallbackRefCount.decrementAndGet() == 0) {
                sCallbackHandler.obtainMessage(524297).sendToTarget();
                sCallbackHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkRequest sendRequestForNetwork(NetworkCapabilities need, NetworkCallback networkCallback, int timeoutSec, int action, int legacyType) {
        if (networkCallback == null) {
            throw new IllegalArgumentException("null NetworkCallback");
        }
        if (need == null) {
            throw new IllegalArgumentException("null NetworkCapabilities");
        }
        try {
            this.incCallbackHandlerRefCount();
            HashMap<NetworkRequest, NetworkCallback> hashMap = sNetworkCallback;
            synchronized (hashMap) {
                if (action == 1) {
                    networkCallback.networkRequest = this.mService.listenForNetwork(need, new Messenger(ConnectivityManager.sCallbackHandler), new Binder());
                } else {
                    networkCallback.networkRequest = this.mService.requestNetwork(need, new Messenger(ConnectivityManager.sCallbackHandler), timeoutSec, new Binder(), legacyType);
                }
                if (networkCallback.networkRequest != null) {
                    sNetworkCallback.put(networkCallback.networkRequest, networkCallback);
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (networkCallback.networkRequest == null) {
            this.decCallbackHandlerRefCount();
        }
        return networkCallback.networkRequest;
    }

    public void requestNetwork(NetworkRequest request, NetworkCallback networkCallback) {
        this.sendRequestForNetwork(request.networkCapabilities, networkCallback, 0, 2, this.inferLegacyTypeForNetworkCapabilities(request.networkCapabilities));
    }

    public void requestNetwork(NetworkRequest request, NetworkCallback networkCallback, int timeoutMs) {
        this.sendRequestForNetwork(request.networkCapabilities, networkCallback, timeoutMs, 2, this.inferLegacyTypeForNetworkCapabilities(request.networkCapabilities));
    }

    public void requestNetwork(NetworkRequest request, PendingIntent operation) {
        this.checkPendingIntent(operation);
        try {
            this.mService.pendingRequestForNetwork(request.networkCapabilities, operation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void releaseNetworkRequest(PendingIntent operation) {
        this.checkPendingIntent(operation);
        try {
            this.mService.releasePendingNetworkRequest(operation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void checkPendingIntent(PendingIntent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("PendingIntent cannot be null.");
        }
    }

    public void registerNetworkCallback(NetworkRequest request, NetworkCallback networkCallback) {
        this.sendRequestForNetwork(request.networkCapabilities, networkCallback, 0, 1, -1);
    }

    public void registerNetworkCallback(NetworkRequest request, PendingIntent operation) {
        this.checkPendingIntent(operation);
        try {
            this.mService.pendingListenForNetwork(request.networkCapabilities, operation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean requestBandwidthUpdate(Network network) {
        try {
            return this.mService.requestBandwidthUpdate(network);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void unregisterNetworkCallback(NetworkCallback networkCallback) {
        if (networkCallback == null || networkCallback.networkRequest == null || ((NetworkCallback)networkCallback).networkRequest.requestId == 0) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        try {
            this.mService.releaseNetworkRequest(networkCallback.networkRequest);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void unregisterNetworkCallback(PendingIntent operation) {
        this.releaseNetworkRequest(operation);
    }

    public void setAcceptUnvalidated(Network network, boolean accept, boolean always) {
        try {
            this.mService.setAcceptUnvalidated(network, accept, always);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void factoryReset() {
        try {
            this.mService.factoryReset();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean bindProcessToNetwork(Network network) {
        return ConnectivityManager.setProcessDefaultNetwork(network);
    }

    public static boolean setProcessDefaultNetwork(Network network) {
        int netId;
        int n = netId = network == null ? 0 : network.netId;
        if (netId == NetworkUtils.getBoundNetworkForProcess()) {
            return true;
        }
        if (NetworkUtils.bindProcessToNetwork(netId)) {
            try {
                Proxy.setHttpProxySystemProperty(ConnectivityManager.getInstance().getDefaultProxy());
            }
            catch (SecurityException e) {
                Log.e(TAG, "Can't set proxy properties", e);
            }
            InetAddress.clearDnsCache();
            NetworkEventDispatcher.getInstance().onNetworkConfigurationChanged();
            return true;
        }
        return false;
    }

    public Network getBoundNetworkForProcess() {
        return ConnectivityManager.getProcessDefaultNetwork();
    }

    public static Network getProcessDefaultNetwork() {
        int netId = NetworkUtils.getBoundNetworkForProcess();
        if (netId == 0) {
            return null;
        }
        return new Network(netId);
    }

    private void unsupportedStartingFrom(int version) {
        if (Process.myUid() == 1000) {
            return;
        }
        if (this.mContext.getApplicationInfo().targetSdkVersion >= version) {
            throw new UnsupportedOperationException("This method is not supported in target SDK version " + version + " and above");
        }
    }

    private void checkLegacyRoutingApiAccess() {
        if (this.mContext.checkCallingOrSelfPermission("com.android.permission.INJECT_OMADM_SETTINGS") == 0) {
            return;
        }
        this.unsupportedStartingFrom(23);
    }

    public static boolean setProcessDefaultNetworkForHostResolution(Network network) {
        return NetworkUtils.bindProcessToNetworkForHostResolution(network == null ? 0 : network.netId);
    }

    static {
        sLegacyRequests = new HashMap();
        sNetworkCallback = new HashMap();
        sCallbackRefCount = new AtomicInteger(0);
        sCallbackHandler = null;
    }

    private class CallbackHandler
    extends Handler {
        private final HashMap<NetworkRequest, NetworkCallback> mCallbackMap;
        private final AtomicInteger mRefCount;
        private static final String TAG = "ConnectivityManager.CallbackHandler";
        private final ConnectivityManager mCm;

        CallbackHandler(Looper looper, HashMap<NetworkRequest, NetworkCallback> callbackMap, AtomicInteger refCount, ConnectivityManager cm) {
            super(looper);
            this.mCallbackMap = callbackMap;
            this.mRefCount = refCount;
            this.mCm = cm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            Log.d(TAG, "CM callback handler got msg " + message.what);
            NetworkRequest request = (NetworkRequest)this.getObject(message, NetworkRequest.class);
            Network network = (Network)this.getObject(message, Network.class);
            switch (message.what) {
                case 524289: {
                    NetworkCallback callback = this.getCallback(request, "PRECHECK");
                    if (callback == null) break;
                    callback.onPreCheck(network);
                    break;
                }
                case 524290: {
                    NetworkCallback callback = this.getCallback(request, "AVAILABLE");
                    if (callback == null) break;
                    callback.onAvailable(network);
                    break;
                }
                case 524291: {
                    NetworkCallback callback = this.getCallback(request, "LOSING");
                    if (callback == null) break;
                    callback.onLosing(network, message.arg1);
                    break;
                }
                case 524292: {
                    NetworkCallback callback = this.getCallback(request, "LOST");
                    if (callback == null) break;
                    callback.onLost(network);
                    break;
                }
                case 524293: {
                    NetworkCallback callback = this.getCallback(request, "UNAVAIL");
                    if (callback == null) break;
                    callback.onUnavailable();
                    break;
                }
                case 524294: {
                    NetworkCallback callback = this.getCallback(request, "CAP_CHANGED");
                    if (callback == null) break;
                    NetworkCapabilities cap = (NetworkCapabilities)this.getObject(message, NetworkCapabilities.class);
                    callback.onCapabilitiesChanged(network, cap);
                    break;
                }
                case 524295: {
                    NetworkCallback callback = this.getCallback(request, "IP_CHANGED");
                    if (callback == null) break;
                    LinkProperties lp = (LinkProperties)this.getObject(message, LinkProperties.class);
                    callback.onLinkPropertiesChanged(network, lp);
                    break;
                }
                case 524299: {
                    NetworkCallback callback = this.getCallback(request, "SUSPENDED");
                    if (callback == null) break;
                    callback.onNetworkSuspended(network);
                    break;
                }
                case 524300: {
                    NetworkCallback callback = this.getCallback(request, "RESUMED");
                    if (callback == null) break;
                    callback.onNetworkResumed(network);
                    break;
                }
                case 524296: {
                    NetworkCallback callback = null;
                    Serializable serializable = this.mCallbackMap;
                    synchronized (serializable) {
                        callback = this.mCallbackMap.remove(request);
                    }
                    if (callback != null) {
                        serializable = this.mRefCount;
                        synchronized (serializable) {
                            if (this.mRefCount.decrementAndGet() == 0) {
                                this.getLooper().quit();
                            }
                            break;
                        }
                    }
                    Log.e(TAG, "callback not found for RELEASED message");
                    break;
                }
                case 524297: {
                    Log.d(TAG, "Listener quitting");
                    this.getLooper().quit();
                    break;
                }
                case 524298: {
                    ConnectivityManager.this.expireRequest((NetworkCapabilities)message.obj, message.arg1);
                }
            }
        }

        private Object getObject(Message msg, Class c) {
            return msg.getData().getParcelable(c.getSimpleName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NetworkCallback getCallback(NetworkRequest req, String name) {
            NetworkCallback callback;
            HashMap<NetworkRequest, NetworkCallback> hashMap = this.mCallbackMap;
            synchronized (hashMap) {
                callback = this.mCallbackMap.get(req);
            }
            if (callback == null) {
                Log.e(TAG, "callback not found for " + name + " message");
            }
            return callback;
        }
    }

    public static class NetworkCallback {
        private NetworkRequest networkRequest;

        public void onPreCheck(Network network) {
        }

        public void onAvailable(Network network) {
        }

        public void onLosing(Network network, int maxMsToLive) {
        }

        public void onLost(Network network) {
        }

        public void onUnavailable() {
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
        }

        public void onNetworkSuspended(Network network) {
        }

        public void onNetworkResumed(Network network) {
        }
    }

    public static interface OnNetworkActiveListener {
        public void onNetworkActive();
    }

    private static class LegacyRequest {
        NetworkCapabilities networkCapabilities;
        NetworkRequest networkRequest;
        int expireSequenceNumber;
        Network currentNetwork;
        int delay = -1;
        NetworkCallback networkCallback = new NetworkCallback(){

            @Override
            public void onAvailable(Network network) {
                LegacyRequest.this.currentNetwork = network;
                Log.d(ConnectivityManager.TAG, "startUsingNetworkFeature got Network:" + network);
                ConnectivityManager.setProcessDefaultNetworkForHostResolution(network);
            }

            @Override
            public void onLost(Network network) {
                if (network.equals(LegacyRequest.this.currentNetwork)) {
                    LegacyRequest.this.clearDnsBinding();
                }
                Log.d(ConnectivityManager.TAG, "startUsingNetworkFeature lost Network:" + network);
            }
        };

        private LegacyRequest() {
        }

        private void clearDnsBinding() {
            if (this.currentNetwork != null) {
                this.currentNetwork = null;
                ConnectivityManager.setProcessDefaultNetworkForHostResolution(null);
            }
        }
    }
}

