/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkProperties;
import android.net.RouteInfo;
import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.NetlinkMessage;
import android.net.netlink.NetlinkSocket;
import android.net.netlink.RtNetlinkNeighborMessage;
import android.net.netlink.StructNdMsg;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IpReachabilityMonitor {
    private static final String TAG = "IpReachabilityMonitor";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final Object mLock = new Object();
    private final String mInterfaceName;
    private final int mInterfaceIndex;
    private final Callback mCallback;
    private final NetlinkSocketObserver mNetlinkSocketObserver;
    private final Thread mObserverThread;
    @GuardedBy(value="mLock")
    private LinkProperties mLinkProperties = new LinkProperties();
    @GuardedBy(value="mLock")
    private Map<InetAddress, Short> mIpWatchList = new HashMap<InetAddress, Short>();
    @GuardedBy(value="mLock")
    private int mIpWatchListVersion;
    @GuardedBy(value="mLock")
    private boolean mRunning;

    public static boolean probeNeighbor(int ifIndex, InetAddress ip) {
        long IO_TIMEOUT = 300L;
        String msgSnippet = "probing ip=" + ip.getHostAddress() + "%" + ifIndex;
        Log.d(TAG, msgSnippet);
        byte[] msg = RtNetlinkNeighborMessage.newNewNeighborMessage(1, ip, (short)16, ifIndex, null);
        boolean returnValue = false;
        try (NetlinkSocket nlSocket = new NetlinkSocket(OsConstants.NETLINK_ROUTE);){
            nlSocket.connectToKernel();
            nlSocket.sendMessage(msg, 0, msg.length, 300L);
            ByteBuffer bytes = nlSocket.recvMessage(300L);
            NetlinkMessage response = NetlinkMessage.parse(bytes);
            if (response != null && response instanceof NetlinkErrorMessage && ((NetlinkErrorMessage)response).getNlMsgError() != null && ((NetlinkErrorMessage)response).getNlMsgError().error == 0) {
                returnValue = true;
            } else {
                String errmsg;
                if (bytes == null) {
                    errmsg = "null recvMessage";
                } else if (response == null) {
                    bytes.position(0);
                    errmsg = "raw bytes: " + NetlinkConstants.hexify(bytes);
                } else {
                    errmsg = response.toString();
                }
                Log.e(TAG, "Error " + msgSnippet + ", errmsg=" + errmsg);
            }
        }
        catch (ErrnoException | InterruptedIOException | SocketException e) {
            Log.d(TAG, "Error " + msgSnippet, e);
        }
        return returnValue;
    }

    public IpReachabilityMonitor(String ifName, Callback callback) throws IllegalArgumentException {
        this.mInterfaceName = ifName;
        int ifIndex = -1;
        try {
            NetworkInterface netIf = NetworkInterface.getByName(ifName);
            this.mInterfaceIndex = netIf.getIndex();
        }
        catch (NullPointerException | SocketException e) {
            throw new IllegalArgumentException("invalid interface '" + ifName + "': ", e);
        }
        this.mCallback = callback;
        this.mNetlinkSocketObserver = new NetlinkSocketObserver();
        this.mObserverThread = new Thread(this.mNetlinkSocketObserver);
        this.mObserverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.mRunning = false;
        }
        this.clearLinkProperties();
        this.mNetlinkSocketObserver.clearNetlinkSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String describeWatchList() {
        String delimiter = ", ";
        StringBuilder sb = new StringBuilder();
        Object object = this.mLock;
        synchronized (object) {
            sb.append("iface{" + this.mInterfaceName + "/" + this.mInterfaceIndex + "}, ");
            sb.append("v{" + this.mIpWatchListVersion + "}, ");
            sb.append("ntable=[");
            boolean firstTime = true;
            for (Map.Entry<InetAddress, Short> entry : this.mIpWatchList.entrySet()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(", ");
                }
                sb.append(entry.getKey().getHostAddress() + "/" + StructNdMsg.stringForNudState(entry.getValue()));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWatching(InetAddress ip) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunning && this.mIpWatchList.containsKey(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stillRunning() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunning;
        }
    }

    private static boolean isOnLink(List<RouteInfo> routes, InetAddress ip) {
        for (RouteInfo route : routes) {
            if (route.hasGateway() || !route.matches(ip)) continue;
            return true;
        }
        return false;
    }

    private short getNeighborStateLocked(InetAddress ip) {
        if (this.mIpWatchList.containsKey(ip)) {
            return this.mIpWatchList.get(ip);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLinkProperties(LinkProperties lp) {
        if (!this.mInterfaceName.equals(lp.getInterfaceName())) {
            Log.wtf(TAG, "requested LinkProperties interface '" + lp.getInterfaceName() + "' does not match: " + this.mInterfaceName);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLinkProperties = new LinkProperties(lp);
            HashMap<InetAddress, Short> newIpWatchList = new HashMap<InetAddress, Short>();
            List<RouteInfo> routes = this.mLinkProperties.getRoutes();
            for (RouteInfo route : routes) {
                InetAddress gw;
                if (!route.hasGateway() || !IpReachabilityMonitor.isOnLink(routes, gw = route.getGateway())) continue;
                newIpWatchList.put(gw, this.getNeighborStateLocked(gw));
            }
            for (InetAddress nameserver : lp.getDnsServers()) {
                if (!IpReachabilityMonitor.isOnLink(routes, nameserver)) continue;
                newIpWatchList.put(nameserver, this.getNeighborStateLocked(nameserver));
            }
            this.mIpWatchList = newIpWatchList;
            ++this.mIpWatchListVersion;
        }
        Log.d(TAG, "watch: " + this.describeWatchList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLinkProperties() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLinkProperties.clear();
            this.mIpWatchList.clear();
            ++this.mIpWatchListVersion;
        }
        Log.d(TAG, "clear: " + this.describeWatchList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNeighborLost(String msg) {
        LinkProperties.ProvisioningChange delta;
        InetAddress ip = null;
        Object object = this.mLock;
        synchronized (object) {
            LinkProperties whatIfLp = new LinkProperties(this.mLinkProperties);
            for (Map.Entry<InetAddress, Short> entry : this.mIpWatchList.entrySet()) {
                if (entry.getValue() != 32) continue;
                ip = entry.getKey();
                for (RouteInfo route : this.mLinkProperties.getRoutes()) {
                    if (!ip.equals(route.getGateway())) continue;
                    whatIfLp.removeRoute(route);
                }
                whatIfLp.removeDnsServer(ip);
            }
            delta = LinkProperties.compareProvisioning(this.mLinkProperties, whatIfLp);
        }
        if (delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING) {
            String logMsg = "FAILURE: LOST_PROVISIONING, " + msg;
            Log.w(TAG, logMsg);
            if (this.mCallback != null) {
                this.mCallback.notifyLost(ip, logMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void probeAll() {
        HashSet<InetAddress> ipProbeList = new HashSet<InetAddress>();
        Object object = this.mLock;
        synchronized (object) {
            ipProbeList.addAll(this.mIpWatchList.keySet());
        }
        for (InetAddress target : ipProbeList) {
            if (!this.stillRunning()) break;
            IpReachabilityMonitor.probeNeighbor(this.mInterfaceIndex, target);
        }
    }

    private final class NetlinkSocketObserver
    implements Runnable {
        private static final String TAG = "NetlinkSocketObserver";
        private NetlinkSocket mSocket;

        private NetlinkSocketObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = IpReachabilityMonitor.this.mLock;
            synchronized (object) {
                IpReachabilityMonitor.this.mRunning = true;
            }
            try {
                this.setupNetlinkSocket();
            }
            catch (ErrnoException | SocketException e) {
                Log.e(TAG, "Failed to suitably initialize a netlink socket", e);
                Object object2 = IpReachabilityMonitor.this.mLock;
                synchronized (object2) {
                    IpReachabilityMonitor.this.mRunning = false;
                }
            }
            while (IpReachabilityMonitor.this.stillRunning()) {
                ByteBuffer byteBuffer;
                try {
                    byteBuffer = this.recvKernelReply();
                }
                catch (ErrnoException e) {
                    Log.w(TAG, "ErrnoException: ", e);
                    break;
                }
                long whenMs = SystemClock.elapsedRealtime();
                if (byteBuffer == null) continue;
                this.parseNetlinkMessageBuffer(byteBuffer, whenMs);
            }
            this.clearNetlinkSocket();
            Object object3 = IpReachabilityMonitor.this.mLock;
            synchronized (object3) {
                IpReachabilityMonitor.this.mRunning = false;
            }
        }

        private void clearNetlinkSocket() {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }

        private void setupNetlinkSocket() throws ErrnoException, SocketException {
            this.clearNetlinkSocket();
            this.mSocket = new NetlinkSocket(OsConstants.NETLINK_ROUTE);
            NetlinkSocketAddress listenAddr = new NetlinkSocketAddress(0, OsConstants.RTMGRP_NEIGH);
            this.mSocket.bind(listenAddr);
        }

        private ByteBuffer recvKernelReply() throws ErrnoException {
            block3: {
                try {
                    return this.mSocket.recvMessage(0L);
                }
                catch (InterruptedIOException e) {
                }
                catch (ErrnoException e) {
                    if (e.errno == OsConstants.EAGAIN) break block3;
                    throw e;
                }
            }
            return null;
        }

        private void parseNetlinkMessageBuffer(ByteBuffer byteBuffer, long whenMs) {
            while (byteBuffer.remaining() > 0) {
                int position = byteBuffer.position();
                NetlinkMessage nlMsg = NetlinkMessage.parse(byteBuffer);
                if (nlMsg == null || nlMsg.getHeader() == null) {
                    byteBuffer.position(position);
                    Log.e(TAG, "unparsable netlink msg: " + NetlinkConstants.hexify(byteBuffer));
                    break;
                }
                int srcPortId = nlMsg.getHeader().nlmsg_pid;
                if (srcPortId != 0) {
                    Log.e(TAG, "non-kernel source portId: " + (long)(srcPortId & 0xFFFFFFFF));
                    break;
                }
                if (nlMsg instanceof NetlinkErrorMessage) {
                    Log.e(TAG, "netlink error: " + nlMsg);
                    continue;
                }
                if (!(nlMsg instanceof RtNetlinkNeighborMessage)) {
                    Log.d(TAG, "non-rtnetlink neighbor msg: " + nlMsg);
                    continue;
                }
                this.evaluateRtNetlinkNeighborMessage((RtNetlinkNeighborMessage)nlMsg, whenMs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evaluateRtNetlinkNeighborMessage(RtNetlinkNeighborMessage neighMsg, long whenMs) {
            StructNdMsg ndMsg = neighMsg.getNdHeader();
            if (ndMsg == null || ndMsg.ndm_ifindex != IpReachabilityMonitor.this.mInterfaceIndex) {
                return;
            }
            InetAddress destination = neighMsg.getDestination();
            if (!IpReachabilityMonitor.this.isWatching(destination)) {
                return;
            }
            short msgType = neighMsg.getHeader().nlmsg_type;
            short nudState = ndMsg.ndm_state;
            String eventMsg = "NeighborEvent{elapsedMs=" + whenMs + ", " + destination.getHostAddress() + ", " + "[" + NetlinkConstants.hexify(neighMsg.getLinkLayerAddress()) + "], " + NetlinkConstants.stringForNlMsgType(msgType) + ", " + StructNdMsg.stringForNudState(nudState) + "}";
            Log.d(TAG, eventMsg);
            Object object = IpReachabilityMonitor.this.mLock;
            synchronized (object) {
                if (IpReachabilityMonitor.this.mIpWatchList.containsKey(destination)) {
                    short value = msgType == 29 ? (short)0 : nudState;
                    IpReachabilityMonitor.this.mIpWatchList.put(destination, value);
                }
            }
            if (nudState == 32) {
                Log.w(TAG, "ALERT: " + eventMsg);
                IpReachabilityMonitor.this.handleNeighborLost(eventMsg);
            }
        }
    }

    public static interface Callback {
        public void notifyLost(InetAddress var1, String var2);
    }
}

