/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;

public final class LinkProperties
implements Parcelable {
    private String mIfaceName;
    private ArrayList<LinkAddress> mLinkAddresses = new ArrayList();
    private ArrayList<InetAddress> mDnses = new ArrayList();
    private String mDomains;
    private ArrayList<RouteInfo> mRoutes = new ArrayList();
    private ProxyInfo mHttpProxy;
    private int mMtu;
    private String mTcpBufferSizes;
    private static final int MIN_MTU = 68;
    private static final int MIN_MTU_V6 = 1280;
    private static final int MAX_MTU = 10000;
    private Hashtable<String, LinkProperties> mStackedLinks = new Hashtable();
    public static final Parcelable.Creator<LinkProperties> CREATOR = new Parcelable.Creator<LinkProperties>(){

        @Override
        public LinkProperties createFromParcel(Parcel in) {
            int i;
            LinkProperties netProp = new LinkProperties();
            String iface = in.readString();
            if (iface != null) {
                netProp.setInterfaceName(iface);
            }
            int addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                netProp.addLinkAddress((LinkAddress)in.readParcelable(null));
            }
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                try {
                    netProp.addDnsServer(InetAddress.getByAddress(in.createByteArray()));
                    continue;
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            netProp.setDomains(in.readString());
            netProp.setMtu(in.readInt());
            netProp.setTcpBufferSizes(in.readString());
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                netProp.addRoute((RouteInfo)in.readParcelable(null));
            }
            if (in.readByte() == 1) {
                netProp.setHttpProxy((ProxyInfo)in.readParcelable(null));
            }
            ArrayList stackedLinks = new ArrayList();
            in.readList(stackedLinks, LinkProperties.class.getClassLoader());
            for (LinkProperties stackedLink : stackedLinks) {
                netProp.addStackedLink(stackedLink);
            }
            return netProp;
        }

        public LinkProperties[] newArray(int size) {
            return new LinkProperties[size];
        }
    };

    public static ProvisioningChange compareProvisioning(LinkProperties before, LinkProperties after) {
        if (before.isProvisioned() && after.isProvisioned()) {
            if (before.isIPv4Provisioned() && !after.isIPv4Provisioned()) {
                return ProvisioningChange.LOST_PROVISIONING;
            }
            return ProvisioningChange.STILL_PROVISIONED;
        }
        if (before.isProvisioned() && !after.isProvisioned()) {
            return ProvisioningChange.LOST_PROVISIONING;
        }
        if (!before.isProvisioned() && after.isProvisioned()) {
            return ProvisioningChange.GAINED_PROVISIONING;
        }
        return ProvisioningChange.STILL_NOT_PROVISIONED;
    }

    public LinkProperties() {
    }

    public LinkProperties(LinkProperties source) {
        if (source != null) {
            this.mIfaceName = source.getInterfaceName();
            for (LinkAddress linkAddress : source.getLinkAddresses()) {
                this.mLinkAddresses.add(linkAddress);
            }
            for (InetAddress inetAddress : source.getDnsServers()) {
                this.mDnses.add(inetAddress);
            }
            this.mDomains = source.getDomains();
            for (RouteInfo routeInfo : source.getRoutes()) {
                this.mRoutes.add(routeInfo);
            }
            this.mHttpProxy = source.getHttpProxy() == null ? null : new ProxyInfo(source.getHttpProxy());
            for (LinkProperties linkProperties : source.mStackedLinks.values()) {
                this.addStackedLink(linkProperties);
            }
            this.setMtu(source.getMtu());
            this.mTcpBufferSizes = source.mTcpBufferSizes;
        }
    }

    public void setInterfaceName(String iface) {
        this.mIfaceName = iface;
        ArrayList<RouteInfo> newRoutes = new ArrayList<RouteInfo>(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            newRoutes.add(this.routeWithInterface(route));
        }
        this.mRoutes = newRoutes;
    }

    public String getInterfaceName() {
        return this.mIfaceName;
    }

    public List<String> getAllInterfaceNames() {
        ArrayList<String> interfaceNames = new ArrayList<String>(this.mStackedLinks.size() + 1);
        if (this.mIfaceName != null) {
            interfaceNames.add(new String(this.mIfaceName));
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            interfaceNames.addAll(stacked.getAllInterfaceNames());
        }
        return interfaceNames;
    }

    public List<InetAddress> getAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        return Collections.unmodifiableList(addresses);
    }

    public List<InetAddress> getAllAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            addresses.addAll(stacked.getAllAddresses());
        }
        return addresses;
    }

    private int findLinkAddressIndex(LinkAddress address) {
        for (int i = 0; i < this.mLinkAddresses.size(); ++i) {
            if (!this.mLinkAddresses.get(i).isSameAddressAs(address)) continue;
            return i;
        }
        return -1;
    }

    public boolean addLinkAddress(LinkAddress address) {
        if (address == null) {
            return false;
        }
        int i = this.findLinkAddressIndex(address);
        if (i < 0) {
            this.mLinkAddresses.add(address);
            return true;
        }
        if (this.mLinkAddresses.get(i).equals(address)) {
            return false;
        }
        this.mLinkAddresses.set(i, address);
        return true;
    }

    public boolean removeLinkAddress(LinkAddress toRemove) {
        int i = this.findLinkAddressIndex(toRemove);
        if (i >= 0) {
            this.mLinkAddresses.remove(i);
            return true;
        }
        return false;
    }

    public List<LinkAddress> getLinkAddresses() {
        return Collections.unmodifiableList(this.mLinkAddresses);
    }

    public List<LinkAddress> getAllLinkAddresses() {
        ArrayList<LinkAddress> addresses = new ArrayList<LinkAddress>();
        addresses.addAll(this.mLinkAddresses);
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            addresses.addAll(stacked.getAllLinkAddresses());
        }
        return addresses;
    }

    public void setLinkAddresses(Collection<LinkAddress> addresses) {
        this.mLinkAddresses.clear();
        for (LinkAddress address : addresses) {
            this.addLinkAddress(address);
        }
    }

    public boolean addDnsServer(InetAddress dnsServer) {
        if (dnsServer != null && !this.mDnses.contains(dnsServer)) {
            this.mDnses.add(dnsServer);
            return true;
        }
        return false;
    }

    public boolean removeDnsServer(InetAddress dnsServer) {
        if (dnsServer != null) {
            return this.mDnses.remove(dnsServer);
        }
        return false;
    }

    public void setDnsServers(Collection<InetAddress> dnsServers) {
        this.mDnses.clear();
        for (InetAddress dnsServer : dnsServers) {
            this.addDnsServer(dnsServer);
        }
    }

    public List<InetAddress> getDnsServers() {
        return Collections.unmodifiableList(this.mDnses);
    }

    public void setDomains(String domains) {
        this.mDomains = domains;
    }

    public String getDomains() {
        return this.mDomains;
    }

    public void setMtu(int mtu) {
        this.mMtu = mtu;
    }

    public int getMtu() {
        return this.mMtu;
    }

    public void setTcpBufferSizes(String tcpBufferSizes) {
        this.mTcpBufferSizes = tcpBufferSizes;
    }

    public String getTcpBufferSizes() {
        return this.mTcpBufferSizes;
    }

    private RouteInfo routeWithInterface(RouteInfo route) {
        return new RouteInfo(route.getDestination(), route.getGateway(), this.mIfaceName, route.getType());
    }

    public boolean addRoute(RouteInfo route) {
        if (route != null) {
            String routeIface = route.getInterface();
            if (routeIface != null && !routeIface.equals(this.mIfaceName)) {
                throw new IllegalArgumentException("Route added with non-matching interface: " + routeIface + " vs. " + this.mIfaceName);
            }
            if (!this.mRoutes.contains(route = this.routeWithInterface(route))) {
                this.mRoutes.add(route);
                return true;
            }
        }
        return false;
    }

    public boolean removeRoute(RouteInfo route) {
        return route != null && Objects.equals(this.mIfaceName, route.getInterface()) && this.mRoutes.remove(route);
    }

    public List<RouteInfo> getRoutes() {
        return Collections.unmodifiableList(this.mRoutes);
    }

    public List<RouteInfo> getAllRoutes() {
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        routes.addAll(this.mRoutes);
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            routes.addAll(stacked.getAllRoutes());
        }
        return routes;
    }

    public void setHttpProxy(ProxyInfo proxy) {
        this.mHttpProxy = proxy;
    }

    public ProxyInfo getHttpProxy() {
        return this.mHttpProxy;
    }

    public boolean addStackedLink(LinkProperties link) {
        if (link != null && link.getInterfaceName() != null) {
            this.mStackedLinks.put(link.getInterfaceName(), link);
            return true;
        }
        return false;
    }

    public boolean removeStackedLink(String iface) {
        if (iface != null) {
            LinkProperties removed = this.mStackedLinks.remove(iface);
            return removed != null;
        }
        return false;
    }

    public List<LinkProperties> getStackedLinks() {
        if (this.mStackedLinks.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LinkProperties> stacked = new ArrayList<LinkProperties>();
        for (LinkProperties link : this.mStackedLinks.values()) {
            stacked.add(new LinkProperties(link));
        }
        return Collections.unmodifiableList(stacked);
    }

    public void clear() {
        this.mIfaceName = null;
        this.mLinkAddresses.clear();
        this.mDnses.clear();
        this.mDomains = null;
        this.mRoutes.clear();
        this.mHttpProxy = null;
        this.mStackedLinks.clear();
        this.mMtu = 0;
        this.mTcpBufferSizes = null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String ifaceName = this.mIfaceName == null ? "" : "InterfaceName: " + this.mIfaceName + " ";
        String linkAddresses = "LinkAddresses: [";
        for (LinkAddress addr : this.mLinkAddresses) {
            linkAddresses = linkAddresses + addr.toString() + ",";
        }
        linkAddresses = linkAddresses + "] ";
        String dns = "DnsAddresses: [";
        for (InetAddress addr : this.mDnses) {
            dns = dns + addr.getHostAddress() + ",";
        }
        dns = dns + "] ";
        String domainName = "Domains: " + this.mDomains;
        String mtu = " MTU: " + this.mMtu;
        String tcpBuffSizes = "";
        if (this.mTcpBufferSizes != null) {
            tcpBuffSizes = " TcpBufferSizes: " + this.mTcpBufferSizes;
        }
        String routes = " Routes: [";
        for (RouteInfo route : this.mRoutes) {
            routes = routes + route.toString() + ",";
        }
        routes = routes + "] ";
        String proxy = this.mHttpProxy == null ? "" : " HttpProxy: " + this.mHttpProxy.toString() + " ";
        String stacked = "";
        if (this.mStackedLinks.values().size() > 0) {
            stacked = stacked + " Stacked: [";
            for (LinkProperties link : this.mStackedLinks.values()) {
                stacked = stacked + " [" + link.toString() + " ],";
            }
            stacked = stacked + "] ";
        }
        return "{" + ifaceName + linkAddresses + routes + dns + domainName + mtu + tcpBuffSizes + proxy + stacked + "}";
    }

    public boolean hasIPv4Address() {
        for (LinkAddress address : this.mLinkAddresses) {
            if (!(address.getAddress() instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    private boolean hasIPv4AddressOnInterface(String iface) {
        return this.mIfaceName.equals(iface) && this.hasIPv4Address() || iface != null && this.mStackedLinks.containsKey(iface) && this.mStackedLinks.get(iface).hasIPv4Address();
    }

    public boolean hasGlobalIPv6Address() {
        for (LinkAddress address : this.mLinkAddresses) {
            if (!(address.getAddress() instanceof Inet6Address) || !address.isGlobalPreferred()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv4DefaultRoute() {
        for (RouteInfo r : this.mRoutes) {
            if (!r.isIPv4Default()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv6DefaultRoute() {
        for (RouteInfo r : this.mRoutes) {
            if (!r.isIPv6Default()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv4DnsServer() {
        for (InetAddress ia : this.mDnses) {
            if (!(ia instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv6DnsServer() {
        for (InetAddress ia : this.mDnses) {
            if (!(ia instanceof Inet6Address)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPv4Provisioned() {
        return this.hasIPv4Address() && this.hasIPv4DefaultRoute() && this.hasIPv4DnsServer();
    }

    public boolean isIPv6Provisioned() {
        return this.hasGlobalIPv6Address() && this.hasIPv6DefaultRoute() && this.hasIPv6DnsServer();
    }

    public boolean isProvisioned() {
        return this.isIPv4Provisioned() || this.isIPv6Provisioned();
    }

    public boolean isReachable(InetAddress ip) {
        List<RouteInfo> allRoutes = this.getAllRoutes();
        RouteInfo bestRoute = RouteInfo.selectBestRoute(allRoutes, ip);
        if (bestRoute == null) {
            return false;
        }
        if (ip instanceof Inet4Address) {
            return this.hasIPv4AddressOnInterface(bestRoute.getInterface());
        }
        if (ip instanceof Inet6Address) {
            if (ip.isLinkLocalAddress()) {
                return ((Inet6Address)ip).getScopeId() != 0;
            }
            return !bestRoute.hasGateway() || this.hasGlobalIPv6Address();
        }
        return false;
    }

    public boolean isIdenticalInterfaceName(LinkProperties target) {
        return TextUtils.equals(this.getInterfaceName(), target.getInterfaceName());
    }

    public boolean isIdenticalAddresses(LinkProperties target) {
        List<InetAddress> targetAddresses = target.getAddresses();
        List<InetAddress> sourceAddresses = this.getAddresses();
        return sourceAddresses.size() == targetAddresses.size() ? sourceAddresses.containsAll(targetAddresses) : false;
    }

    public boolean isIdenticalDnses(LinkProperties target) {
        List<InetAddress> targetDnses = target.getDnsServers();
        String targetDomains = target.getDomains();
        if (this.mDomains == null ? targetDomains != null : !this.mDomains.equals(targetDomains)) {
            return false;
        }
        return this.mDnses.size() == targetDnses.size() ? this.mDnses.containsAll(targetDnses) : false;
    }

    public boolean isIdenticalRoutes(LinkProperties target) {
        List<RouteInfo> targetRoutes = target.getRoutes();
        return this.mRoutes.size() == targetRoutes.size() ? this.mRoutes.containsAll(targetRoutes) : false;
    }

    public boolean isIdenticalHttpProxy(LinkProperties target) {
        return this.getHttpProxy() == null ? target.getHttpProxy() == null : this.getHttpProxy().equals(target.getHttpProxy());
    }

    public boolean isIdenticalStackedLinks(LinkProperties target) {
        if (!this.mStackedLinks.keySet().equals(target.mStackedLinks.keySet())) {
            return false;
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            String iface;
            if (stacked.equals(target.mStackedLinks.get(iface = stacked.getInterfaceName()))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdenticalMtu(LinkProperties target) {
        return this.getMtu() == target.getMtu();
    }

    public boolean isIdenticalTcpBufferSizes(LinkProperties target) {
        return Objects.equals(this.mTcpBufferSizes, target.mTcpBufferSizes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkProperties)) {
            return false;
        }
        LinkProperties target = (LinkProperties)obj;
        return this.isIdenticalInterfaceName(target) && this.isIdenticalAddresses(target) && this.isIdenticalDnses(target) && this.isIdenticalRoutes(target) && this.isIdenticalHttpProxy(target) && this.isIdenticalStackedLinks(target) && this.isIdenticalMtu(target) && this.isIdenticalTcpBufferSizes(target);
    }

    public CompareResult<LinkAddress> compareAddresses(LinkProperties target) {
        CompareResult<LinkAddress> result = new CompareResult<LinkAddress>();
        result.removed = new ArrayList<LinkAddress>(this.mLinkAddresses);
        result.added.clear();
        if (target != null) {
            for (LinkAddress newAddress : target.getLinkAddresses()) {
                if (result.removed.remove(newAddress)) continue;
                result.added.add(newAddress);
            }
        }
        return result;
    }

    public CompareResult<InetAddress> compareDnses(LinkProperties target) {
        CompareResult<InetAddress> result = new CompareResult<InetAddress>();
        result.removed = new ArrayList<InetAddress>(this.mDnses);
        result.added.clear();
        if (target != null) {
            for (InetAddress newAddress : target.getDnsServers()) {
                if (result.removed.remove(newAddress)) continue;
                result.added.add(newAddress);
            }
        }
        return result;
    }

    public CompareResult<RouteInfo> compareAllRoutes(LinkProperties target) {
        CompareResult<RouteInfo> result = new CompareResult<RouteInfo>();
        result.removed = this.getAllRoutes();
        result.added.clear();
        if (target != null) {
            for (RouteInfo r : target.getAllRoutes()) {
                if (result.removed.remove(r)) continue;
                result.added.add(r);
            }
        }
        return result;
    }

    public CompareResult<String> compareAllInterfaceNames(LinkProperties target) {
        CompareResult<String> result = new CompareResult<String>();
        result.removed = this.getAllInterfaceNames();
        result.added.clear();
        if (target != null) {
            for (String r : target.getAllInterfaceNames()) {
                if (result.removed.remove(r)) continue;
                result.added.add(r);
            }
        }
        return result;
    }

    public int hashCode() {
        return (null == this.mIfaceName ? 0 : this.mIfaceName.hashCode() + this.mLinkAddresses.size() * 31 + this.mDnses.size() * 37 + (null == this.mDomains ? 0 : this.mDomains.hashCode()) + this.mRoutes.size() * 41 + (null == this.mHttpProxy ? 0 : this.mHttpProxy.hashCode()) + this.mStackedLinks.hashCode() * 47) + this.mMtu * 51 + (null == this.mTcpBufferSizes ? 0 : this.mTcpBufferSizes.hashCode());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getInterfaceName());
        dest.writeInt(this.mLinkAddresses.size());
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            dest.writeParcelable(linkAddress, flags);
        }
        dest.writeInt(this.mDnses.size());
        for (InetAddress d : this.mDnses) {
            dest.writeByteArray(d.getAddress());
        }
        dest.writeString(this.mDomains);
        dest.writeInt(this.mMtu);
        dest.writeString(this.mTcpBufferSizes);
        dest.writeInt(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            dest.writeParcelable(route, flags);
        }
        if (this.mHttpProxy != null) {
            dest.writeByte((byte)1);
            dest.writeParcelable(this.mHttpProxy, flags);
        } else {
            dest.writeByte((byte)0);
        }
        ArrayList<LinkProperties> stackedLinks = new ArrayList<LinkProperties>(this.mStackedLinks.values());
        dest.writeList(stackedLinks);
    }

    public static boolean isValidMtu(int mtu, boolean ipv6) {
        return ipv6 ? mtu >= 1280 && mtu <= 10000 : mtu >= 68 && mtu <= 10000;
    }

    public static enum ProvisioningChange {
        STILL_NOT_PROVISIONED,
        LOST_PROVISIONING,
        GAINED_PROVISIONING,
        STILL_PROVISIONED;

    }

    public static class CompareResult<T> {
        public List<T> removed = new ArrayList<T>();
        public List<T> added = new ArrayList<T>();

        public String toString() {
            String retVal = "removed=[";
            for (T addr : this.removed) {
                retVal = retVal + addr.toString() + ",";
            }
            retVal = retVal + "] added=[";
            for (T addr : this.added) {
                retVal = retVal + addr.toString() + ",";
            }
            retVal = retVal + "]";
            return retVal;
        }
    }
}

