/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import java.net.Inet4Address;
import java.nio.ByteBuffer;

class DhcpAckPacket
extends DhcpPacket {
    private final Inet4Address mSrcIp;

    DhcpAckPacket(int transId, short secs, boolean broadcast, Inet4Address serverAddress, Inet4Address clientIp, Inet4Address yourIp, byte[] clientMac) {
        super(transId, secs, clientIp, yourIp, serverAddress, INADDR_ANY, clientMac, broadcast);
        this.mBroadcast = broadcast;
        this.mSrcIp = serverAddress;
    }

    @Override
    public String toString() {
        String s = super.toString();
        String dnsServers = " DNS servers: ";
        for (Inet4Address dnsServer : this.mDnsServers) {
            dnsServers = dnsServers + dnsServer.toString() + " ";
        }
        return s + " ACK: your new IP " + this.mYourIp + ", netmask " + this.mSubnetMask + ", gateway " + this.mGateway + dnsServers + ", lease time " + this.mLeaseTime;
    }

    @Override
    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        Inet4Address destIp = this.mBroadcast ? INADDR_BROADCAST : this.mYourIp;
        Inet4Address srcIp = this.mBroadcast ? INADDR_ANY : this.mSrcIp;
        this.fillInPacket(encap, destIp, srcIp, destUdp, srcUdp, result, (byte)2, this.mBroadcast);
        result.flip();
        return result;
    }

    @Override
    void finishPacket(ByteBuffer buffer) {
        DhcpAckPacket.addTlv(buffer, (byte)53, (byte)5);
        DhcpAckPacket.addTlv(buffer, (byte)54, this.mServerIdentifier);
        DhcpAckPacket.addTlv(buffer, (byte)51, this.mLeaseTime);
        if (this.mLeaseTime != null) {
            DhcpAckPacket.addTlv(buffer, (byte)58, this.mLeaseTime / 2);
        }
        DhcpAckPacket.addTlv(buffer, (byte)1, this.mSubnetMask);
        DhcpAckPacket.addTlv(buffer, (byte)3, this.mGateway);
        DhcpAckPacket.addTlv(buffer, (byte)15, this.mDomainName);
        DhcpAckPacket.addTlv(buffer, (byte)28, this.mBroadcastAddress);
        DhcpAckPacket.addTlv(buffer, (byte)6, this.mDnsServers);
        DhcpAckPacket.addTlvEnd(buffer);
    }

    private static final int getInt(Integer v) {
        if (v == null) {
            return 0;
        }
        return v;
    }
}

