/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.BaseDhcpStateMachine;
import android.net.DhcpResults;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.dhcp.DhcpAckPacket;
import android.net.dhcp.DhcpNakPacket;
import android.net.dhcp.DhcpOfferPacket;
import android.net.dhcp.DhcpPacket;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.util.HexDump;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import libcore.io.IoBridge;

public class DhcpClient
extends BaseDhcpStateMachine {
    private static final String TAG = "DhcpClient";
    private static final boolean DBG = true;
    private static final boolean STATE_DBG = false;
    private static final boolean MSG_DBG = false;
    private static final boolean PACKET_DBG = true;
    private static final int SECONDS = 1000;
    private static final int FIRST_TIMEOUT_MS = 2000;
    private static final int MAX_TIMEOUT_MS = 128000;
    private static final int DHCP_TIMEOUT_MS = 36000;
    private static final int BASE = 196708;
    private static final int CMD_KICK = 196709;
    private static final int CMD_RECEIVED_PACKET = 196710;
    private static final int CMD_TIMEOUT = 196711;
    private static final int CMD_ONESHOT_TIMEOUT = 196712;
    private static final byte[] REQUESTED_PARAMS = new byte[]{1, 3, 6, 15, 26, 28, 51, 58, 59};
    private static final boolean DO_UNICAST = false;
    private final Context mContext;
    private final AlarmManager mAlarmManager;
    private final Random mRandom;
    private final INetworkManagementService mNMService;
    private FileDescriptor mPacketSock;
    private FileDescriptor mUdpSock;
    private ReceiveThread mReceiveThread;
    private final StateMachine mController;
    private final PendingIntent mKickIntent;
    private final PendingIntent mTimeoutIntent;
    private final PendingIntent mRenewIntent;
    private final PendingIntent mOneshotTimeoutIntent;
    private final String mIfaceName;
    private boolean mRegisteredForPreDhcpNotification;
    private NetworkInterface mIface;
    private byte[] mHwAddr;
    private PacketSocketAddress mInterfaceBroadcastAddr;
    private int mTransactionId;
    private long mTransactionStartMillis;
    private DhcpResults mDhcpLease;
    private long mDhcpLeaseExpiry;
    private DhcpResults mOffer;
    private State mStoppedState = new StoppedState();
    private State mDhcpState = new DhcpState();
    private State mDhcpInitState = new DhcpInitState();
    private State mDhcpSelectingState = new DhcpSelectingState();
    private State mDhcpRequestingState = new DhcpRequestingState();
    private State mDhcpHaveAddressState = new DhcpHaveAddressState();
    private State mDhcpBoundState = new DhcpBoundState();
    private State mDhcpRenewingState = new DhcpRenewingState();
    private State mDhcpRebindingState = new DhcpRebindingState();
    private State mDhcpInitRebootState = new DhcpInitRebootState();
    private State mDhcpRebootingState = new DhcpRebootingState();
    private State mWaitBeforeStartState = new WaitBeforeStartState(this.mDhcpInitState);
    private State mWaitBeforeRenewalState = new WaitBeforeRenewalState(this.mDhcpRenewingState);

    private DhcpClient(Context context, StateMachine controller, String iface) {
        super(TAG);
        this.mContext = context;
        this.mController = controller;
        this.mIfaceName = iface;
        this.addState(this.mStoppedState);
        this.addState(this.mDhcpState);
        this.addState(this.mDhcpInitState, this.mDhcpState);
        this.addState(this.mWaitBeforeStartState, this.mDhcpState);
        this.addState(this.mDhcpSelectingState, this.mDhcpState);
        this.addState(this.mDhcpRequestingState, this.mDhcpState);
        this.addState(this.mDhcpHaveAddressState, this.mDhcpState);
        this.addState(this.mDhcpBoundState, this.mDhcpHaveAddressState);
        this.addState(this.mWaitBeforeRenewalState, this.mDhcpHaveAddressState);
        this.addState(this.mDhcpRenewingState, this.mDhcpHaveAddressState);
        this.addState(this.mDhcpRebindingState, this.mDhcpHaveAddressState);
        this.addState(this.mDhcpInitRebootState, this.mDhcpState);
        this.addState(this.mDhcpRebootingState, this.mDhcpState);
        this.setInitialState(this.mStoppedState);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        IBinder b = ServiceManager.getService("network_management");
        this.mNMService = INetworkManagementService.Stub.asInterface(b);
        this.mRandom = new Random();
        this.mKickIntent = this.createStateMachineCommandIntent("KICK", 196709);
        this.mTimeoutIntent = this.createStateMachineCommandIntent("TIMEOUT", 196711);
        this.mRenewIntent = this.createStateMachineCommandIntent("RENEW", 196611);
        this.mOneshotTimeoutIntent = this.createStateMachineCommandIntent("ONESHOT_TIMEOUT", 196712);
    }

    @Override
    public void registerForPreDhcpNotification() {
        this.mRegisteredForPreDhcpNotification = true;
    }

    public static BaseDhcpStateMachine makeDhcpStateMachine(Context context, StateMachine controller, String intf) {
        DhcpClient client = new DhcpClient(context, controller, intf);
        client.start();
        return client;
    }

    private PendingIntent createStateMachineCommandIntent(String cmdName, final int cmd) {
        String action = DhcpClient.class.getName() + "." + this.mIfaceName + "." + cmdName;
        Intent intent = new Intent(action, null).addFlags(0x4000000);
        intent.setPackage(this.mContext.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, cmd, intent, 0);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                DhcpClient.this.sendMessage(cmd);
            }
        }, new IntentFilter(action), "android.permission.CONNECTIVITY_INTERNAL", null);
        return pendingIntent;
    }

    private boolean initInterface() {
        try {
            this.mIface = NetworkInterface.getByName(this.mIfaceName);
            this.mHwAddr = this.mIface.getHardwareAddress();
            this.mInterfaceBroadcastAddr = new PacketSocketAddress(this.mIface.getIndex(), DhcpPacket.ETHER_BROADCAST);
            return true;
        }
        catch (SocketException e) {
            Log.wtf(TAG, "Can't determine ifindex or MAC address for " + this.mIfaceName);
            return false;
        }
    }

    private void startNewTransaction() {
        this.mTransactionId = this.mRandom.nextInt();
        this.mTransactionStartMillis = SystemClock.elapsedRealtime();
    }

    private boolean initSockets() {
        try {
            this.mPacketSock = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, OsConstants.ETH_P_IP);
            PacketSocketAddress addr = new PacketSocketAddress((short)OsConstants.ETH_P_IP, this.mIface.getIndex());
            Os.bind(this.mPacketSock, addr);
            NetworkUtils.attachDhcpFilter(this.mPacketSock);
        }
        catch (ErrnoException | SocketException e) {
            Log.e(TAG, "Error creating packet socket", e);
            return false;
        }
        try {
            this.mUdpSock = Os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
            Os.setsockoptInt(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR, 1);
            Os.setsockoptIfreq(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_BINDTODEVICE, this.mIfaceName);
            Os.setsockoptInt(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST, 1);
            Os.bind(this.mUdpSock, Inet4Address.ANY, 68);
            NetworkUtils.protectFromVpn(this.mUdpSock);
        }
        catch (ErrnoException | SocketException e) {
            Log.e(TAG, "Error creating UDP socket", e);
            return false;
        }
        return true;
    }

    private static void closeQuietly(FileDescriptor fd) {
        try {
            IoBridge.closeAndSignalBlockedThreads(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeSockets() {
        DhcpClient.closeQuietly(this.mUdpSock);
        DhcpClient.closeQuietly(this.mPacketSock);
    }

    private boolean setIpAddress(LinkAddress address) {
        InterfaceConfiguration ifcg = new InterfaceConfiguration();
        ifcg.setLinkAddress(address);
        try {
            this.mNMService.setInterfaceConfig(this.mIfaceName, ifcg);
        }
        catch (RemoteException | IllegalStateException e) {
            Log.e(TAG, "Error configuring IP address : " + e);
            return false;
        }
        return true;
    }

    private short getSecs() {
        return (short)((SystemClock.elapsedRealtime() - this.mTransactionStartMillis) / 1000L);
    }

    private boolean transmitPacket(ByteBuffer buf, String description, Inet4Address to) {
        try {
            if (to.equals(DhcpPacket.INADDR_BROADCAST)) {
                this.maybeLog("Broadcasting " + description);
                Os.sendto(this.mPacketSock, buf.array(), 0, buf.limit(), 0, this.mInterfaceBroadcastAddr);
            } else {
                this.maybeLog("Unicasting " + description + " to " + to.getHostAddress());
                Os.sendto(this.mUdpSock, buf, 0, to, 67);
            }
        }
        catch (ErrnoException | IOException e) {
            Log.e(TAG, "Can't send packet: ", e);
            return false;
        }
        return true;
    }

    private boolean sendDiscoverPacket() {
        ByteBuffer packet = DhcpPacket.buildDiscoverPacket(0, this.mTransactionId, this.getSecs(), this.mHwAddr, false, REQUESTED_PARAMS);
        return this.transmitPacket(packet, "DHCPDISCOVER", DhcpPacket.INADDR_BROADCAST);
    }

    private boolean sendRequestPacket(Inet4Address clientAddress, Inet4Address requestedAddress, Inet4Address serverAddress, Inet4Address to) {
        int encap = to.equals(DhcpPacket.INADDR_BROADCAST) ? 0 : 2;
        ByteBuffer packet = DhcpPacket.buildRequestPacket(encap, this.mTransactionId, this.getSecs(), clientAddress, false, this.mHwAddr, requestedAddress, serverAddress, REQUESTED_PARAMS, null);
        String description = "DHCPREQUEST ciaddr=" + clientAddress.getHostAddress() + " request=" + requestedAddress.getHostAddress() + " to=" + serverAddress.getHostAddress();
        return this.transmitPacket(packet, description, to);
    }

    private void scheduleRenew() {
        this.mAlarmManager.cancel(this.mRenewIntent);
        if (this.mDhcpLeaseExpiry != 0L) {
            long now = SystemClock.elapsedRealtime();
            long alarmTime = (now + this.mDhcpLeaseExpiry) / 2L;
            this.mAlarmManager.setExact(2, alarmTime, this.mRenewIntent);
            Log.d(TAG, "Scheduling renewal in " + (alarmTime - now) / 1000L + "s");
        } else {
            Log.d(TAG, "Infinite lease, no renewal needed");
        }
    }

    private void notifySuccess() {
        this.mController.sendMessage(196613, 1, 0, new DhcpResults(this.mDhcpLease));
    }

    private void notifyFailure() {
        this.mController.sendMessage(196613, 2, 0, null);
    }

    private void clearDhcpState() {
        this.mDhcpLease = null;
        this.mDhcpLeaseExpiry = 0L;
        this.mOffer = null;
    }

    @Override
    public void doQuit() {
        Log.d(TAG, "doQuit");
        this.quit();
    }

    @Override
    protected void onQuitting() {
        Log.d(TAG, "onQuitting");
        this.mController.sendMessage(196614);
    }

    private void maybeLog(String msg) {
        Log.d(TAG, msg);
    }

    private void scheduleOneshotTimeout() {
        long alarmTime = SystemClock.elapsedRealtime() + 36000L;
        this.mAlarmManager.setExact(2, alarmTime, this.mOneshotTimeoutIntent);
    }

    private void cancelOneshotTimeout() {
        this.mAlarmManager.cancel(this.mOneshotTimeoutIntent);
    }

    public boolean isValidPacket(DhcpPacket packet) {
        int xid = packet.getTransactionId();
        if (xid != this.mTransactionId) {
            Log.d(TAG, "Unexpected transaction ID " + xid + ", expected " + this.mTransactionId);
            return false;
        }
        if (!Arrays.equals(packet.getClientMac(), this.mHwAddr)) {
            Log.d(TAG, "MAC addr mismatch: got " + HexDump.toHexString(packet.getClientMac()) + ", expected " + HexDump.toHexString(packet.getClientMac()));
            return false;
        }
        return true;
    }

    public void setDhcpLeaseExpiry(DhcpPacket packet) {
        long leaseTimeMillis = packet.getLeaseTimeMillis();
        this.mDhcpLeaseExpiry = leaseTimeMillis > 0L ? SystemClock.elapsedRealtime() + leaseTimeMillis : 0L;
    }

    class DhcpRebootingState
    extends LoggingState {
        DhcpRebootingState() {
        }
    }

    class DhcpInitRebootState
    extends LoggingState {
        DhcpInitRebootState() {
        }
    }

    class DhcpRebindingState
    extends LoggingState {
        DhcpRebindingState() {
        }
    }

    class DhcpRenewingState
    extends PacketRetransmittingState {
        public DhcpRenewingState() {
            this.mTimeout = 36000;
        }

        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.startNewTransaction();
        }

        @Override
        protected boolean sendPacket() {
            return DhcpClient.this.sendRequestPacket((Inet4Address)((DhcpClient)DhcpClient.this).mDhcpLease.ipAddress.getAddress(), DhcpPacket.INADDR_ANY, DhcpPacket.INADDR_ANY, (Inet4Address)((DhcpClient)DhcpClient.this).mDhcpLease.serverAddress);
        }

        @Override
        protected void receivePacket(DhcpPacket packet) {
            if (!DhcpClient.this.isValidPacket(packet)) {
                return;
            }
            if (packet instanceof DhcpAckPacket) {
                DhcpClient.this.setDhcpLeaseExpiry(packet);
                DhcpClient.this.transitionTo(DhcpClient.this.mDhcpBoundState);
            } else if (packet instanceof DhcpNakPacket) {
                DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
            }
        }

        @Override
        protected void timeout() {
            DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
            DhcpClient.this.sendMessage(196712);
        }
    }

    class DhcpBoundState
    extends LoggingState {
        DhcpBoundState() {
        }

        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.cancelOneshotTimeout();
            DhcpClient.this.notifySuccess();
            DhcpClient.this.scheduleRenew();
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196611: {
                    if (DhcpClient.this.mRegisteredForPreDhcpNotification) {
                        DhcpClient.this.transitionTo(DhcpClient.this.mWaitBeforeRenewalState);
                    } else {
                        DhcpClient.this.transitionTo(DhcpClient.this.mDhcpRenewingState);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class DhcpHaveAddressState
    extends LoggingState {
        DhcpHaveAddressState() {
        }

        @Override
        public void enter() {
            super.enter();
            if (DhcpClient.this.setIpAddress(((DhcpClient)DhcpClient.this).mDhcpLease.ipAddress)) {
                DhcpClient.this.maybeLog("Configured IP address " + ((DhcpClient)DhcpClient.this).mDhcpLease.ipAddress);
            } else {
                Log.e(DhcpClient.TAG, "Failed to configure IP address " + ((DhcpClient)DhcpClient.this).mDhcpLease.ipAddress);
                DhcpClient.this.notifyFailure();
                DhcpClient.this.transitionTo(DhcpClient.this.mStoppedState);
            }
        }

        @Override
        public void exit() {
            DhcpClient.this.maybeLog("Clearing IP address");
            DhcpClient.this.setIpAddress(new LinkAddress("0.0.0.0/0"));
        }
    }

    class DhcpRequestingState
    extends PacketRetransmittingState {
        public DhcpRequestingState() {
            this.mTimeout = 18000;
        }

        @Override
        protected boolean sendPacket() {
            return DhcpClient.this.sendRequestPacket(DhcpPacket.INADDR_ANY, (Inet4Address)((DhcpClient)DhcpClient.this).mOffer.ipAddress.getAddress(), (Inet4Address)((DhcpClient)DhcpClient.this).mOffer.serverAddress, DhcpPacket.INADDR_BROADCAST);
        }

        @Override
        protected void receivePacket(DhcpPacket packet) {
            if (!DhcpClient.this.isValidPacket(packet)) {
                return;
            }
            if (packet instanceof DhcpAckPacket) {
                DhcpResults results = packet.toDhcpResults();
                if (results != null) {
                    DhcpClient.this.mDhcpLease = results;
                    DhcpClient.this.mOffer = null;
                    Log.d(DhcpClient.TAG, "Confirmed lease: " + DhcpClient.this.mDhcpLease);
                    DhcpClient.this.setDhcpLeaseExpiry(packet);
                    DhcpClient.this.transitionTo(DhcpClient.this.mDhcpBoundState);
                }
            } else if (packet instanceof DhcpNakPacket) {
                Log.d(DhcpClient.TAG, "Received NAK, returning to INIT");
                DhcpClient.this.mOffer = null;
                DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
            }
        }

        @Override
        protected void timeout() {
            DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
        }
    }

    class DhcpSelectingState
    extends LoggingState {
        DhcpSelectingState() {
        }
    }

    class DhcpInitState
    extends PacketRetransmittingState {
        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.startNewTransaction();
        }

        @Override
        protected boolean sendPacket() {
            return DhcpClient.this.sendDiscoverPacket();
        }

        @Override
        protected void receivePacket(DhcpPacket packet) {
            if (!DhcpClient.this.isValidPacket(packet)) {
                return;
            }
            if (!(packet instanceof DhcpOfferPacket)) {
                return;
            }
            DhcpClient.this.mOffer = packet.toDhcpResults();
            if (DhcpClient.this.mOffer != null) {
                Log.d(DhcpClient.TAG, "Got pending lease: " + DhcpClient.this.mOffer);
                DhcpClient.this.transitionTo(DhcpClient.this.mDhcpRequestingState);
            }
        }
    }

    abstract class PacketRetransmittingState
    extends LoggingState {
        private int mTimer;
        protected int mTimeout;

        PacketRetransmittingState() {
            this.mTimeout = 0;
        }

        @Override
        public void enter() {
            super.enter();
            this.initTimer();
            this.maybeInitTimeout();
            DhcpClient.this.sendMessage(196709);
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196709: {
                    this.sendPacket();
                    this.scheduleKick();
                    return true;
                }
                case 196710: {
                    this.receivePacket((DhcpPacket)message.obj);
                    return true;
                }
                case 196711: {
                    this.timeout();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            DhcpClient.this.mAlarmManager.cancel(DhcpClient.this.mKickIntent);
            DhcpClient.this.mAlarmManager.cancel(DhcpClient.this.mTimeoutIntent);
        }

        protected abstract boolean sendPacket();

        protected abstract void receivePacket(DhcpPacket var1);

        protected void timeout() {
        }

        protected void initTimer() {
            this.mTimer = 2000;
        }

        protected int jitterTimer(int baseTimer) {
            int maxJitter = baseTimer / 10;
            int jitter = DhcpClient.this.mRandom.nextInt(2 * maxJitter) - maxJitter;
            return baseTimer + jitter;
        }

        protected void scheduleKick() {
            long now = SystemClock.elapsedRealtime();
            long timeout = this.jitterTimer(this.mTimer);
            long alarmTime = now + timeout;
            DhcpClient.this.mAlarmManager.cancel(DhcpClient.this.mKickIntent);
            DhcpClient.this.mAlarmManager.setExact(2, alarmTime, DhcpClient.this.mKickIntent);
            this.mTimer *= 2;
            if (this.mTimer > 128000) {
                this.mTimer = 128000;
            }
        }

        protected void maybeInitTimeout() {
            if (this.mTimeout > 0) {
                long alarmTime = SystemClock.elapsedRealtime() + (long)this.mTimeout;
                DhcpClient.this.mAlarmManager.setExact(2, alarmTime, DhcpClient.this.mTimeoutIntent);
            }
        }
    }

    class DhcpState
    extends LoggingState {
        DhcpState() {
        }

        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.clearDhcpState();
            if (DhcpClient.this.initInterface() && DhcpClient.this.initSockets()) {
                DhcpClient.this.mReceiveThread = new ReceiveThread();
                DhcpClient.this.mReceiveThread.start();
            } else {
                DhcpClient.this.notifyFailure();
                DhcpClient.this.transitionTo(DhcpClient.this.mStoppedState);
            }
        }

        @Override
        public void exit() {
            DhcpClient.this.cancelOneshotTimeout();
            if (DhcpClient.this.mReceiveThread != null) {
                DhcpClient.this.mReceiveThread.halt();
                DhcpClient.this.mReceiveThread = null;
            }
            DhcpClient.this.clearDhcpState();
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196610: {
                    DhcpClient.this.transitionTo(DhcpClient.this.mStoppedState);
                    return true;
                }
                case 196712: {
                    DhcpClient.this.maybeLog("Timed out");
                    DhcpClient.this.notifyFailure();
                    return true;
                }
            }
            return false;
        }
    }

    class WaitBeforeRenewalState
    extends WaitBeforeOtherState {
        public WaitBeforeRenewalState(State otherState) {
            this.mOtherState = otherState;
        }
    }

    class WaitBeforeStartState
    extends WaitBeforeOtherState {
        public WaitBeforeStartState(State otherState) {
            this.mOtherState = otherState;
        }
    }

    class StoppedState
    extends LoggingState {
        StoppedState() {
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196609: {
                    DhcpClient.this.scheduleOneshotTimeout();
                    if (DhcpClient.this.mRegisteredForPreDhcpNotification) {
                        DhcpClient.this.transitionTo(DhcpClient.this.mWaitBeforeStartState);
                    } else {
                        DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    abstract class WaitBeforeOtherState
    extends LoggingState {
        protected State mOtherState;

        WaitBeforeOtherState() {
        }

        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.mController.sendMessage(196612);
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196615: {
                    DhcpClient.this.transitionTo(this.mOtherState);
                    return true;
                }
            }
            return false;
        }
    }

    abstract class LoggingState
    extends State {
        LoggingState() {
        }

        @Override
        public void enter() {
        }

        private String messageName(int what) {
            switch (what) {
                case 196609: {
                    return "CMD_START_DHCP";
                }
                case 196610: {
                    return "CMD_STOP_DHCP";
                }
                case 196611: {
                    return "CMD_RENEW_DHCP";
                }
                case 196612: {
                    return "CMD_PRE_DHCP_ACTION";
                }
                case 196615: {
                    return "CMD_PRE_DHCP_ACTION_COMPLETE";
                }
                case 196613: {
                    return "CMD_POST_DHCP_ACTION";
                }
                case 196709: {
                    return "CMD_KICK";
                }
                case 196710: {
                    return "CMD_RECEIVED_PACKET";
                }
                case 196711: {
                    return "CMD_TIMEOUT";
                }
                case 196712: {
                    return "CMD_ONESHOT_TIMEOUT";
                }
            }
            return Integer.toString(what);
        }

        private String messageToString(Message message) {
            long now = SystemClock.uptimeMillis();
            StringBuilder b = new StringBuilder(" ");
            TimeUtils.formatDuration(message.getWhen() - now, b);
            b.append(" ").append(this.messageName(message.what)).append(" ").append(message.arg1).append(" ").append(message.arg2).append(" ").append(message.obj);
            return b.toString();
        }

        @Override
        public boolean processMessage(Message message) {
            return false;
        }
    }

    class ReceiveThread
    extends Thread {
        private final byte[] mPacket = new byte[1500];
        private boolean stopped = false;

        ReceiveThread() {
        }

        public void halt() {
            this.stopped = true;
            DhcpClient.this.closeSockets();
        }

        @Override
        public void run() {
            DhcpClient.this.maybeLog("Receive thread started");
            while (!this.stopped) {
                try {
                    int length = Os.read(DhcpClient.this.mPacketSock, this.mPacket, 0, this.mPacket.length);
                    DhcpPacket packet = null;
                    packet = DhcpPacket.decodeFullPacket(this.mPacket, length, 0);
                    if (packet != null) {
                        DhcpClient.this.maybeLog("Received packet: " + packet);
                        DhcpClient.this.sendMessage(196710, packet);
                        continue;
                    }
                    Log.d(DhcpClient.TAG, "Can't parse packet" + HexDump.dumpHexString(this.mPacket, 0, length));
                }
                catch (ErrnoException | IOException e) {
                    if (this.stopped) continue;
                    Log.e(DhcpClient.TAG, "Read error", e);
                }
            }
            DhcpClient.this.maybeLog("Receive thread stopped");
        }
    }
}

