/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import java.net.Inet4Address;
import java.nio.ByteBuffer;

class DhcpOfferPacket
extends DhcpPacket {
    private final Inet4Address mSrcIp;

    DhcpOfferPacket(int transId, short secs, boolean broadcast, Inet4Address serverAddress, Inet4Address clientIp, Inet4Address yourIp, byte[] clientMac) {
        super(transId, secs, clientIp, yourIp, INADDR_ANY, INADDR_ANY, clientMac, broadcast);
        this.mSrcIp = serverAddress;
    }

    @Override
    public String toString() {
        String s = super.toString();
        String dnsServers = ", DNS servers: ";
        if (this.mDnsServers != null) {
            for (Inet4Address dnsServer : this.mDnsServers) {
                dnsServers = dnsServers + dnsServer + " ";
            }
        }
        return s + " OFFER, ip " + this.mYourIp + ", mask " + this.mSubnetMask + dnsServers + ", gateway " + this.mGateway + " lease time " + this.mLeaseTime + ", domain " + this.mDomainName;
    }

    @Override
    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        Inet4Address destIp = this.mBroadcast ? INADDR_BROADCAST : this.mYourIp;
        Inet4Address srcIp = this.mBroadcast ? INADDR_ANY : this.mSrcIp;
        this.fillInPacket(encap, destIp, srcIp, destUdp, srcUdp, result, (byte)2, this.mBroadcast);
        result.flip();
        return result;
    }

    @Override
    void finishPacket(ByteBuffer buffer) {
        DhcpOfferPacket.addTlv(buffer, (byte)53, (byte)2);
        DhcpOfferPacket.addTlv(buffer, (byte)54, this.mServerIdentifier);
        DhcpOfferPacket.addTlv(buffer, (byte)51, this.mLeaseTime);
        if (this.mLeaseTime != null) {
            DhcpOfferPacket.addTlv(buffer, (byte)58, this.mLeaseTime / 2);
        }
        DhcpOfferPacket.addTlv(buffer, (byte)1, this.mSubnetMask);
        DhcpOfferPacket.addTlv(buffer, (byte)3, this.mGateway);
        DhcpOfferPacket.addTlv(buffer, (byte)15, this.mDomainName);
        DhcpOfferPacket.addTlv(buffer, (byte)28, this.mBroadcastAddress);
        DhcpOfferPacket.addTlv(buffer, (byte)6, this.mDnsServers);
        DhcpOfferPacket.addTlvEnd(buffer);
    }
}

