/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.DhcpResults;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.dhcp.DhcpAckPacket;
import android.net.dhcp.DhcpDeclinePacket;
import android.net.dhcp.DhcpDiscoverPacket;
import android.net.dhcp.DhcpInformPacket;
import android.net.dhcp.DhcpNakPacket;
import android.net.dhcp.DhcpOfferPacket;
import android.net.dhcp.DhcpRequestPacket;
import android.os.Build;
import android.os.SystemProperties;
import android.system.OsConstants;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

abstract class DhcpPacket {
    protected static final String TAG = "DhcpPacket";
    public static final int MINIMUM_LEASE = 60;
    public static final int INFINITE_LEASE = -1;
    public static final Inet4Address INADDR_ANY = (Inet4Address)Inet4Address.ANY;
    public static final Inet4Address INADDR_BROADCAST = (Inet4Address)Inet4Address.ALL;
    public static final byte[] ETHER_BROADCAST = new byte[]{-1, -1, -1, -1, -1, -1};
    public static final int ENCAP_L2 = 0;
    public static final int ENCAP_L3 = 1;
    public static final int ENCAP_BOOTP = 2;
    public static final int MIN_PACKET_LENGTH_BOOTP = 236;
    public static final int MIN_PACKET_LENGTH_L3 = 264;
    public static final int MIN_PACKET_LENGTH_L2 = 278;
    public static final int HWADDR_LEN = 16;
    public static final int MAX_OPTION_LEN = 255;
    private static final byte IP_TYPE_UDP = 17;
    private static final byte IP_VERSION_HEADER_LEN = 69;
    private static final short IP_FLAGS_OFFSET = 16384;
    private static final byte IP_TOS_LOWDELAY = 16;
    private static final byte IP_TTL = 64;
    static final short DHCP_CLIENT = 68;
    static final short DHCP_SERVER = 67;
    protected static final byte DHCP_BOOTREQUEST = 1;
    protected static final byte DHCP_BOOTREPLY = 2;
    protected static final byte CLIENT_ID_ETHER = 1;
    protected static final int MAX_LENGTH = 1500;
    protected static final byte DHCP_SUBNET_MASK = 1;
    protected Inet4Address mSubnetMask;
    protected static final byte DHCP_ROUTER = 3;
    protected Inet4Address mGateway;
    protected static final byte DHCP_DNS_SERVER = 6;
    protected List<Inet4Address> mDnsServers;
    protected static final byte DHCP_HOST_NAME = 12;
    protected String mHostName;
    protected static final byte DHCP_DOMAIN_NAME = 15;
    protected String mDomainName;
    protected static final byte DHCP_MTU = 26;
    protected Short mMtu;
    protected static final byte DHCP_BROADCAST_ADDRESS = 28;
    protected Inet4Address mBroadcastAddress;
    protected static final byte DHCP_VENDOR_INFO = 43;
    protected String mVendorInfo;
    protected static final byte DHCP_REQUESTED_IP = 50;
    protected Inet4Address mRequestedIp;
    protected static final byte DHCP_LEASE_TIME = 51;
    protected Integer mLeaseTime;
    protected static final byte DHCP_MESSAGE_TYPE = 53;
    protected static final byte DHCP_MESSAGE_TYPE_DISCOVER = 1;
    protected static final byte DHCP_MESSAGE_TYPE_OFFER = 2;
    protected static final byte DHCP_MESSAGE_TYPE_REQUEST = 3;
    protected static final byte DHCP_MESSAGE_TYPE_DECLINE = 4;
    protected static final byte DHCP_MESSAGE_TYPE_ACK = 5;
    protected static final byte DHCP_MESSAGE_TYPE_NAK = 6;
    protected static final byte DHCP_MESSAGE_TYPE_INFORM = 8;
    protected static final byte DHCP_SERVER_IDENTIFIER = 54;
    protected Inet4Address mServerIdentifier;
    protected static final byte DHCP_PARAMETER_LIST = 55;
    protected byte[] mRequestedParams;
    protected static final byte DHCP_MESSAGE = 56;
    protected String mMessage;
    protected static final byte DHCP_MAX_MESSAGE_SIZE = 57;
    protected Short mMaxMessageSize;
    protected static final byte DHCP_RENEWAL_TIME = 58;
    protected Integer mT1;
    protected static final byte DHCP_REBINDING_TIME = 59;
    protected Integer mT2;
    protected static final byte DHCP_VENDOR_CLASS_ID = 60;
    protected String mVendorId;
    protected static final byte DHCP_CLIENT_IDENTIFIER = 61;
    protected static final byte DHCP_OPTION_PAD = 0;
    protected static final byte DHCP_OPTION_END = -1;
    protected final int mTransId;
    protected final short mSecs;
    protected final Inet4Address mClientIp;
    protected final Inet4Address mYourIp;
    private final Inet4Address mNextIp;
    private final Inet4Address mRelayIp;
    protected boolean mBroadcast;
    protected final byte[] mClientMac;

    public abstract ByteBuffer buildPacket(int var1, short var2, short var3);

    abstract void finishPacket(ByteBuffer var1);

    protected DhcpPacket(int transId, short secs, Inet4Address clientIp, Inet4Address yourIp, Inet4Address nextIp, Inet4Address relayIp, byte[] clientMac, boolean broadcast) {
        this.mTransId = transId;
        this.mSecs = secs;
        this.mClientIp = clientIp;
        this.mYourIp = yourIp;
        this.mNextIp = nextIp;
        this.mRelayIp = relayIp;
        this.mClientMac = clientMac;
        this.mBroadcast = broadcast;
    }

    public int getTransactionId() {
        return this.mTransId;
    }

    public byte[] getClientMac() {
        return this.mClientMac;
    }

    public byte[] getClientId() {
        byte[] clientId = new byte[this.mClientMac.length + 1];
        clientId[0] = 1;
        System.arraycopy((byte[])this.mClientMac, (int)0, (byte[])clientId, (int)1, (int)this.mClientMac.length);
        return clientId;
    }

    protected void fillInPacket(int encap, Inet4Address destIp, Inet4Address srcIp, short destUdp, short srcUdp, ByteBuffer buf, byte requestCode, boolean broadcast) {
        byte[] destIpArray = destIp.getAddress();
        byte[] srcIpArray = srcIp.getAddress();
        int ipHeaderOffset = 0;
        int ipLengthOffset = 0;
        int ipChecksumOffset = 0;
        int endIpHeader = 0;
        int udpHeaderOffset = 0;
        int udpLengthOffset = 0;
        int udpChecksumOffset = 0;
        buf.clear();
        buf.order(ByteOrder.BIG_ENDIAN);
        if (encap == 0) {
            buf.put(ETHER_BROADCAST);
            buf.put(this.mClientMac);
            buf.putShort((short)OsConstants.ETH_P_IP);
        }
        if (encap <= 1) {
            ipHeaderOffset = buf.position();
            buf.put((byte)69);
            buf.put((byte)16);
            ipLengthOffset = buf.position();
            buf.putShort((short)0);
            buf.putShort((short)0);
            buf.putShort((short)16384);
            buf.put((byte)64);
            buf.put((byte)17);
            ipChecksumOffset = buf.position();
            buf.putShort((short)0);
            buf.put(srcIpArray);
            buf.put(destIpArray);
            endIpHeader = buf.position();
            udpHeaderOffset = buf.position();
            buf.putShort(srcUdp);
            buf.putShort(destUdp);
            udpLengthOffset = buf.position();
            buf.putShort((short)0);
            udpChecksumOffset = buf.position();
            buf.putShort((short)0);
        }
        buf.put(requestCode);
        buf.put((byte)1);
        buf.put((byte)this.mClientMac.length);
        buf.put((byte)0);
        buf.putInt(this.mTransId);
        buf.putShort(this.mSecs);
        if (broadcast) {
            buf.putShort((short)Short.MIN_VALUE);
        } else {
            buf.putShort((short)0);
        }
        buf.put(this.mClientIp.getAddress());
        buf.put(this.mYourIp.getAddress());
        buf.put(this.mNextIp.getAddress());
        buf.put(this.mRelayIp.getAddress());
        buf.put(this.mClientMac);
        buf.position(buf.position() + (16 - this.mClientMac.length) + 64 + 128);
        buf.putInt(1669485411);
        this.finishPacket(buf);
        if ((buf.position() & 1) == 1) {
            buf.put((byte)0);
        }
        if (encap <= 1) {
            short udpLen = (short)(buf.position() - udpHeaderOffset);
            buf.putShort(udpLengthOffset, udpLen);
            int udpSeed = 0;
            udpSeed += DhcpPacket.intAbs(buf.getShort(ipChecksumOffset + 2));
            udpSeed += DhcpPacket.intAbs(buf.getShort(ipChecksumOffset + 4));
            udpSeed += DhcpPacket.intAbs(buf.getShort(ipChecksumOffset + 6));
            udpSeed += DhcpPacket.intAbs(buf.getShort(ipChecksumOffset + 8));
            udpSeed += 17;
            buf.putShort(udpChecksumOffset, (short)this.checksum(buf, udpSeed += udpLen, udpHeaderOffset, buf.position()));
            buf.putShort(ipLengthOffset, (short)(buf.position() - ipHeaderOffset));
            buf.putShort(ipChecksumOffset, (short)this.checksum(buf, 0, ipHeaderOffset, endIpHeader));
        }
    }

    private static int intAbs(short v) {
        return v & 0xFFFF;
    }

    private int checksum(ByteBuffer buf, int seed, int start, int end) {
        int sum = seed;
        int bufPosition = buf.position();
        buf.position(start);
        ShortBuffer shortBuf = buf.asShortBuffer();
        buf.position(bufPosition);
        short[] shortArray = new short[(end - start) / 2];
        shortBuf.get(shortArray);
        for (short s : shortArray) {
            sum += DhcpPacket.intAbs(s);
        }
        if (end != (start += shortArray.length * 2)) {
            short b = buf.get(start);
            if (b < 0) {
                b = (short)(b + 256);
            }
            sum += b * 256;
        }
        sum = (sum >> 16 & 0xFFFF) + (sum & 0xFFFF);
        sum = sum + (sum >> 16 & 0xFFFF) & 0xFFFF;
        int negated = ~sum;
        return DhcpPacket.intAbs((short)negated);
    }

    protected static void addTlv(ByteBuffer buf, byte type, byte value) {
        buf.put(type);
        buf.put((byte)1);
        buf.put(value);
    }

    protected static void addTlv(ByteBuffer buf, byte type, byte[] payload) {
        if (payload != null) {
            if (payload.length > 255) {
                throw new IllegalArgumentException("DHCP option too long: " + payload.length + " vs. " + 255);
            }
            buf.put(type);
            buf.put((byte)payload.length);
            buf.put(payload);
        }
    }

    protected static void addTlv(ByteBuffer buf, byte type, Inet4Address addr) {
        if (addr != null) {
            DhcpPacket.addTlv(buf, type, addr.getAddress());
        }
    }

    protected static void addTlv(ByteBuffer buf, byte type, List<Inet4Address> addrs) {
        if (addrs == null || addrs.size() == 0) {
            return;
        }
        int optionLen = 4 * addrs.size();
        if (optionLen > 255) {
            throw new IllegalArgumentException("DHCP option too long: " + optionLen + " vs. " + 255);
        }
        buf.put(type);
        buf.put((byte)optionLen);
        for (Inet4Address addr : addrs) {
            buf.put(addr.getAddress());
        }
    }

    protected static void addTlv(ByteBuffer buf, byte type, Short value) {
        if (value != null) {
            buf.put(type);
            buf.put((byte)2);
            buf.putShort(value);
        }
    }

    protected static void addTlv(ByteBuffer buf, byte type, Integer value) {
        if (value != null) {
            buf.put(type);
            buf.put((byte)4);
            buf.putInt(value);
        }
    }

    protected static void addTlv(ByteBuffer buf, byte type, String str) {
        try {
            DhcpPacket.addTlv(buf, type, str.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("String is not US-ASCII: " + str);
        }
    }

    protected static void addTlvEnd(ByteBuffer buf) {
        buf.put((byte)-1);
    }

    protected void addCommonClientTlvs(ByteBuffer buf) {
        DhcpPacket.addTlv(buf, (byte)57, (short)1500);
        DhcpPacket.addTlv(buf, (byte)60, "android-dhcp-" + Build.VERSION.RELEASE);
        DhcpPacket.addTlv(buf, (byte)12, SystemProperties.get("net.hostname"));
    }

    public static String macToString(byte[] mac) {
        String macAddr = "";
        for (int i = 0; i < mac.length; ++i) {
            String hexString = "0" + Integer.toHexString(mac[i]);
            macAddr = macAddr + hexString.substring(hexString.length() - 2);
            if (i == mac.length - 1) continue;
            macAddr = macAddr + ":";
        }
        return macAddr;
    }

    public String toString() {
        String macAddr = DhcpPacket.macToString(this.mClientMac);
        return macAddr;
    }

    private static Inet4Address readIpAddress(ByteBuffer packet) {
        Inet4Address result = null;
        byte[] ipAddr = new byte[4];
        packet.get(ipAddr);
        try {
            result = (Inet4Address)Inet4Address.getByAddress(ipAddr);
        }
        catch (UnknownHostException ex) {
            result = null;
        }
        return result;
    }

    private static String readAsciiString(ByteBuffer buf, int byteCount, boolean nullOk) {
        byte[] bytes = new byte[byteCount];
        buf.get(bytes);
        int length = bytes.length;
        if (!nullOk) {
            for (length = 0; length < bytes.length && bytes[length] != 0; ++length) {
            }
        }
        return new String(bytes, 0, length, StandardCharsets.US_ASCII);
    }

    public static DhcpPacket decodeFullPacket(ByteBuffer packet, int pktType) {
        DhcpPacket newPacket;
        Inet4Address relayIp;
        Inet4Address nextIp;
        Inet4Address yourIp;
        Inet4Address clientIp;
        ArrayList<Inet4Address> dnsServers = new ArrayList<Inet4Address>();
        Inet4Address gateway = null;
        Inet4Address serverIdentifier = null;
        Inet4Address netMask = null;
        String message = null;
        String vendorId = null;
        String vendorInfo = null;
        byte[] expectedParams = null;
        String hostName = null;
        String domainName = null;
        Inet4Address ipSrc = null;
        Inet4Address ipDst = null;
        Inet4Address bcAddr = null;
        Inet4Address requestedIp = null;
        Short mtu = null;
        Short maxMessageSize = null;
        Integer leaseTime = null;
        Integer T1 = null;
        Integer T2 = null;
        int dhcpType = -1;
        packet.order(ByteOrder.BIG_ENDIAN);
        if (pktType == 0) {
            if (packet.remaining() < 278) {
                return null;
            }
            byte[] l2dst = new byte[6];
            byte[] l2src = new byte[6];
            packet.get(l2dst);
            packet.get(l2src);
            short l2type = packet.getShort();
            if (l2type != OsConstants.ETH_P_IP) {
                return null;
            }
        }
        if (pktType <= 1) {
            if (packet.remaining() < 264) {
                return null;
            }
            byte ipTypeAndLength = packet.get();
            int ipVersion = (ipTypeAndLength & 0xF0) >> 4;
            if (ipVersion != 4) {
                return null;
            }
            byte ipDiffServicesField = packet.get();
            short ipTotalLength = packet.getShort();
            short ipIdentification = packet.getShort();
            byte ipFlags = packet.get();
            byte ipFragOffset = packet.get();
            byte ipTTL = packet.get();
            byte ipProto = packet.get();
            short ipChksm = packet.getShort();
            ipSrc = DhcpPacket.readIpAddress(packet);
            ipDst = DhcpPacket.readIpAddress(packet);
            if (ipProto != 17) {
                return null;
            }
            int optionWords = (ipTypeAndLength & 0xF) - 5;
            for (int i = 0; i < optionWords; ++i) {
                packet.getInt();
            }
            short udpSrcPort = packet.getShort();
            short udpDstPort = packet.getShort();
            short udpLen = packet.getShort();
            short udpChkSum = packet.getShort();
            if (udpSrcPort != 67 && udpSrcPort != 68) {
                return null;
            }
        }
        if (pktType > 2 || packet.remaining() < 236) {
            return null;
        }
        byte type = packet.get();
        byte hwType = packet.get();
        int addrLen = packet.get() & 0xFF;
        byte hops = packet.get();
        int transactionId = packet.getInt();
        short secs = packet.getShort();
        short bootpFlags = packet.getShort();
        boolean broadcast = (bootpFlags & 0x8000) != 0;
        byte[] ipv4addr = new byte[4];
        try {
            packet.get(ipv4addr);
            clientIp = (Inet4Address)Inet4Address.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            yourIp = (Inet4Address)Inet4Address.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            nextIp = (Inet4Address)Inet4Address.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            relayIp = (Inet4Address)Inet4Address.getByAddress(ipv4addr);
        }
        catch (UnknownHostException ex) {
            return null;
        }
        if (addrLen > 16) {
            addrLen = ETHER_BROADCAST.length;
        }
        byte[] clientMac = new byte[addrLen];
        packet.get(clientMac);
        packet.position(packet.position() + (16 - addrLen) + 64 + 128);
        int dhcpMagicCookie = packet.getInt();
        if (dhcpMagicCookie != 1669485411) {
            return null;
        }
        boolean notFinishedOptions = true;
        while (packet.position() < packet.limit() && notFinishedOptions) {
            try {
                byte optionType = packet.get();
                if (optionType == -1) {
                    notFinishedOptions = false;
                    continue;
                }
                if (optionType == 0) continue;
                int optionLen = packet.get() & 0xFF;
                int expectedLen = 0;
                switch (optionType) {
                    case 1: {
                        netMask = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 3: {
                        gateway = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 6: {
                        for (expectedLen = 0; expectedLen < optionLen; expectedLen += 4) {
                            dnsServers.add(DhcpPacket.readIpAddress(packet));
                        }
                        break;
                    }
                    case 12: {
                        expectedLen = optionLen;
                        hostName = DhcpPacket.readAsciiString(packet, optionLen, false);
                        break;
                    }
                    case 26: {
                        expectedLen = 2;
                        mtu = packet.getShort();
                        break;
                    }
                    case 15: {
                        expectedLen = optionLen;
                        domainName = DhcpPacket.readAsciiString(packet, optionLen, false);
                        break;
                    }
                    case 28: {
                        bcAddr = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 50: {
                        requestedIp = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 51: {
                        leaseTime = packet.getInt();
                        expectedLen = 4;
                        break;
                    }
                    case 53: {
                        dhcpType = packet.get();
                        expectedLen = 1;
                        break;
                    }
                    case 54: {
                        serverIdentifier = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 55: {
                        expectedParams = new byte[optionLen];
                        packet.get(expectedParams);
                        expectedLen = optionLen;
                        break;
                    }
                    case 56: {
                        expectedLen = optionLen;
                        message = DhcpPacket.readAsciiString(packet, optionLen, false);
                        break;
                    }
                    case 57: {
                        expectedLen = 2;
                        maxMessageSize = packet.getShort();
                        break;
                    }
                    case 58: {
                        expectedLen = 4;
                        T1 = packet.getInt();
                        break;
                    }
                    case 59: {
                        expectedLen = 4;
                        T2 = packet.getInt();
                        break;
                    }
                    case 60: {
                        expectedLen = optionLen;
                        vendorId = DhcpPacket.readAsciiString(packet, optionLen, true);
                        break;
                    }
                    case 61: {
                        byte[] id2 = new byte[optionLen];
                        packet.get(id2);
                        expectedLen = optionLen;
                        break;
                    }
                    case 43: {
                        expectedLen = optionLen;
                        vendorInfo = DhcpPacket.readAsciiString(packet, optionLen, true);
                        break;
                    }
                    default: {
                        for (int i = 0; i < optionLen; ++i) {
                            ++expectedLen;
                            byte throwaway = packet.get();
                        }
                    }
                }
                if (expectedLen == optionLen) continue;
                return null;
            }
            catch (BufferUnderflowException e) {
                return null;
            }
        }
        switch (dhcpType) {
            case -1: {
                return null;
            }
            case 1: {
                newPacket = new DhcpDiscoverPacket(transactionId, secs, clientMac, broadcast);
                break;
            }
            case 2: {
                newPacket = new DhcpOfferPacket(transactionId, secs, broadcast, ipSrc, clientIp, yourIp, clientMac);
                break;
            }
            case 3: {
                newPacket = new DhcpRequestPacket(transactionId, secs, clientIp, clientMac, broadcast);
                break;
            }
            case 4: {
                newPacket = new DhcpDeclinePacket(transactionId, secs, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            case 5: {
                newPacket = new DhcpAckPacket(transactionId, secs, broadcast, ipSrc, clientIp, yourIp, clientMac);
                break;
            }
            case 6: {
                newPacket = new DhcpNakPacket(transactionId, secs, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            case 8: {
                newPacket = new DhcpInformPacket(transactionId, secs, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            default: {
                System.out.println("Unimplemented type: " + dhcpType);
                return null;
            }
        }
        newPacket.mBroadcastAddress = bcAddr;
        newPacket.mDnsServers = dnsServers;
        newPacket.mDomainName = domainName;
        newPacket.mGateway = gateway;
        newPacket.mHostName = hostName;
        newPacket.mLeaseTime = leaseTime;
        newPacket.mMessage = message;
        newPacket.mMtu = mtu;
        newPacket.mRequestedIp = requestedIp;
        newPacket.mRequestedParams = expectedParams;
        newPacket.mServerIdentifier = serverIdentifier;
        newPacket.mSubnetMask = netMask;
        newPacket.mMaxMessageSize = maxMessageSize;
        newPacket.mT1 = T1;
        newPacket.mT2 = T2;
        newPacket.mVendorId = vendorId;
        newPacket.mVendorInfo = vendorInfo;
        return newPacket;
    }

    public static DhcpPacket decodeFullPacket(byte[] packet, int length, int pktType) {
        ByteBuffer buffer = ByteBuffer.wrap(packet, 0, length).order(ByteOrder.BIG_ENDIAN);
        return DhcpPacket.decodeFullPacket(buffer, pktType);
    }

    public DhcpResults toDhcpResults() {
        int prefixLength;
        Inet4Address ipAddress = this.mYourIp;
        if (ipAddress.equals(Inet4Address.ANY) && (ipAddress = this.mClientIp).equals(Inet4Address.ANY)) {
            return null;
        }
        if (this.mSubnetMask != null) {
            try {
                prefixLength = NetworkUtils.netmaskToPrefixLength(this.mSubnetMask);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        } else {
            prefixLength = NetworkUtils.getImplicitNetmask(ipAddress);
        }
        DhcpResults results = new DhcpResults();
        try {
            results.ipAddress = new LinkAddress(ipAddress, prefixLength);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        results.gateway = this.mGateway;
        results.dnsServers.addAll(this.mDnsServers);
        results.domains = this.mDomainName;
        results.serverAddress = this.mServerIdentifier;
        results.vendorInfo = this.mVendorInfo;
        results.leaseDuration = this.mLeaseTime != null ? this.mLeaseTime : -1;
        return results;
    }

    public long getLeaseTimeMillis() {
        if (this.mLeaseTime == null || this.mLeaseTime == -1) {
            return 0L;
        }
        if (0 <= this.mLeaseTime && this.mLeaseTime < 60) {
            return 60000L;
        }
        return ((long)this.mLeaseTime.intValue() & 0xFFFFFFFFL) * 1000L;
    }

    public static ByteBuffer buildDiscoverPacket(int encap, int transactionId, short secs, byte[] clientMac, boolean broadcast, byte[] expectedParams) {
        DhcpDiscoverPacket pkt = new DhcpDiscoverPacket(transactionId, secs, clientMac, broadcast);
        pkt.mRequestedParams = expectedParams;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)67, (short)68);
    }

    public static ByteBuffer buildOfferPacket(int encap, int transactionId, boolean broadcast, Inet4Address serverIpAddr, Inet4Address clientIpAddr, byte[] mac, Integer timeout, Inet4Address netMask, Inet4Address bcAddr, Inet4Address gateway, List<Inet4Address> dnsServers, Inet4Address dhcpServerIdentifier, String domainName) {
        DhcpOfferPacket pkt = new DhcpOfferPacket(transactionId, 0, broadcast, serverIpAddr, INADDR_ANY, clientIpAddr, mac);
        pkt.mGateway = gateway;
        pkt.mDnsServers = dnsServers;
        pkt.mLeaseTime = timeout;
        pkt.mDomainName = domainName;
        pkt.mServerIdentifier = dhcpServerIdentifier;
        pkt.mSubnetMask = netMask;
        pkt.mBroadcastAddress = bcAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    public static ByteBuffer buildAckPacket(int encap, int transactionId, boolean broadcast, Inet4Address serverIpAddr, Inet4Address clientIpAddr, byte[] mac, Integer timeout, Inet4Address netMask, Inet4Address bcAddr, Inet4Address gateway, List<Inet4Address> dnsServers, Inet4Address dhcpServerIdentifier, String domainName) {
        DhcpAckPacket pkt = new DhcpAckPacket(transactionId, 0, broadcast, serverIpAddr, INADDR_ANY, clientIpAddr, mac);
        pkt.mGateway = gateway;
        pkt.mDnsServers = dnsServers;
        pkt.mLeaseTime = timeout;
        pkt.mDomainName = domainName;
        pkt.mSubnetMask = netMask;
        pkt.mServerIdentifier = dhcpServerIdentifier;
        pkt.mBroadcastAddress = bcAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    public static ByteBuffer buildNakPacket(int encap, int transactionId, Inet4Address serverIpAddr, Inet4Address clientIpAddr, byte[] mac) {
        DhcpNakPacket pkt = new DhcpNakPacket(transactionId, 0, clientIpAddr, serverIpAddr, serverIpAddr, serverIpAddr, mac);
        pkt.mMessage = "requested address not available";
        pkt.mRequestedIp = clientIpAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    public static ByteBuffer buildRequestPacket(int encap, int transactionId, short secs, Inet4Address clientIp, boolean broadcast, byte[] clientMac, Inet4Address requestedIpAddress, Inet4Address serverIdentifier, byte[] requestedParams, String hostName) {
        DhcpRequestPacket pkt = new DhcpRequestPacket(transactionId, secs, clientIp, clientMac, broadcast);
        pkt.mRequestedIp = requestedIpAddress;
        pkt.mServerIdentifier = serverIdentifier;
        pkt.mHostName = hostName;
        pkt.mRequestedParams = requestedParams;
        ByteBuffer result = ((DhcpPacket)pkt).buildPacket(encap, (short)67, (short)68);
        return result;
    }
}

