/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import java.net.Inet4Address;
import java.nio.ByteBuffer;

class DhcpRequestPacket
extends DhcpPacket {
    DhcpRequestPacket(int transId, short secs, Inet4Address clientIp, byte[] clientMac, boolean broadcast) {
        super(transId, secs, clientIp, INADDR_ANY, INADDR_ANY, INADDR_ANY, clientMac, broadcast);
    }

    @Override
    public String toString() {
        String s = super.toString();
        return s + " REQUEST, desired IP " + this.mRequestedIp + " from host '" + this.mHostName + "', param list length " + (this.mRequestedParams == null ? 0 : this.mRequestedParams.length);
    }

    @Override
    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        this.fillInPacket(encap, INADDR_BROADCAST, INADDR_ANY, destUdp, srcUdp, result, (byte)1, this.mBroadcast);
        result.flip();
        return result;
    }

    @Override
    void finishPacket(ByteBuffer buffer) {
        DhcpRequestPacket.addTlv(buffer, (byte)53, (byte)3);
        DhcpRequestPacket.addTlv(buffer, (byte)61, this.getClientId());
        if (!INADDR_ANY.equals(this.mRequestedIp)) {
            DhcpRequestPacket.addTlv(buffer, (byte)50, this.mRequestedIp);
        }
        if (!INADDR_ANY.equals(this.mServerIdentifier)) {
            DhcpRequestPacket.addTlv(buffer, (byte)54, this.mServerIdentifier);
        }
        this.addCommonClientTlvs(buffer);
        DhcpRequestPacket.addTlv(buffer, (byte)55, this.mRequestedParams);
        DhcpRequestPacket.addTlvEnd(buffer);
    }
}

