/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class WifiP2pUpnpServiceInfo
extends WifiP2pServiceInfo {
    public static final int VERSION_1_0 = 16;

    private WifiP2pUpnpServiceInfo(List<String> queryList) {
        super(queryList);
    }

    public static WifiP2pUpnpServiceInfo newInstance(String uuid, String device, List<String> services) {
        if (uuid == null || device == null) {
            throw new IllegalArgumentException("uuid or device cannnot be null");
        }
        UUID.fromString(uuid);
        ArrayList<String> info = new ArrayList<String>();
        info.add(WifiP2pUpnpServiceInfo.createSupplicantQuery(uuid, null));
        info.add(WifiP2pUpnpServiceInfo.createSupplicantQuery(uuid, "upnp:rootdevice"));
        info.add(WifiP2pUpnpServiceInfo.createSupplicantQuery(uuid, device));
        if (services != null) {
            for (String service : services) {
                info.add(WifiP2pUpnpServiceInfo.createSupplicantQuery(uuid, service));
            }
        }
        return new WifiP2pUpnpServiceInfo(info);
    }

    private static String createSupplicantQuery(String uuid, String data) {
        StringBuffer sb = new StringBuffer();
        sb.append("upnp ");
        sb.append(String.format(Locale.US, "%02x ", 16));
        sb.append("uuid:");
        sb.append(uuid);
        if (data != null) {
            sb.append("::");
            sb.append(data);
        }
        return sb.toString();
    }
}

