/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.passpoint;

import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.passpoint.WifiPasspointDmTree;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WifiPasspointCredential
implements Parcelable {
    private static final String TAG = "PasspointCredential";
    private static final boolean DBG = true;
    private String mWifiSpFqdn;
    private String mCredentialName;
    private String mSubscriptionUpdateInterval;
    private String mSubscriptionUpdateMethod;
    private String mSubscriptionUpdateRestriction;
    private String mSubscriptionUpdateURI;
    private String mSubscriptionUpdateUsername;
    private String mSubscriptionUpdatePassword;
    private String mHomeSpFqdn;
    private String mFriendlyName;
    private Collection<WifiPasspointDmTree.HomeOIList> mHomeOIList;
    private Collection<WifiPasspointDmTree.OtherHomePartners> mOtherHomePartnerList;
    private String mCreationDate;
    private String mExpirationDate;
    private String mType;
    private String mInnerMethod;
    private String mCertType;
    private String mCertSha256Fingerprint;
    private String mUpdateIdentifier;
    private String mUsername;
    private String mPasswd;
    private String mRealm;
    private String mImsi;
    private String mMcc;
    private String mMnc;
    private String mCaRootCert;
    private String mClientCert;
    private boolean mCheckAaaServerCertStatus;
    private String mPolicyUpdateUri;
    private String mPolicyUpdateInterval;
    private String mPolicyUpdateUsername;
    private String mPolicyUpdatePassword;
    private String mPolicyUpdateRestriction;
    private String mPolicyUpdateMethod;
    private Collection<WifiPasspointDmTree.PreferredRoamingPartnerList> mPreferredRoamingPartnerList;
    private Collection<WifiPasspointDmTree.MinBackhaulThresholdNetwork> mMinBackhaulThresholdNetwork;
    private Collection<WifiPasspointDmTree.SPExclusionList> mSpExclusionList;
    private Collection<WifiPasspointDmTree.RequiredProtoPortTuple> mRequiredProtoPortTuple;
    private String mMaxBssLoad;
    private int mCrednetialPriority;
    private String mAaaCertUrl;
    private String mAaaSha256Fingerprint;
    private boolean mIsMachineRemediation;
    private boolean mUserPreferred = false;
    private String mWifiTreePath;
    private WifiEnterpriseConfig mEnterpriseConfig;
    public static final Parcelable.Creator<WifiPasspointCredential> CREATOR = new Parcelable.Creator<WifiPasspointCredential>(){

        @Override
        public WifiPasspointCredential createFromParcel(Parcel in) {
            WifiPasspointCredential pc = new WifiPasspointCredential();
            pc.mWifiSpFqdn = in.readString();
            pc.mCredentialName = in.readString();
            pc.mType = in.readString();
            pc.mCrednetialPriority = in.readInt();
            pc.mHomeSpFqdn = in.readString();
            pc.mRealm = in.readString();
            return pc;
        }

        public WifiPasspointCredential[] newArray(int size) {
            return new WifiPasspointCredential[size];
        }
    };

    public WifiPasspointCredential() {
    }

    public WifiPasspointCredential(String realm, String fqdn, WifiEnterpriseConfig config) {
        this.mRealm = realm;
        switch (config.getEapMethod()) {
            case 1: 
            case 2: {
                this.mEnterpriseConfig = new WifiEnterpriseConfig(config);
                break;
            }
        }
    }

    public WifiPasspointCredential(String type, String caroot, String clientcert, String mcc, String mnc, WifiPasspointDmTree.SpFqdn sp, WifiPasspointDmTree.CredentialInfo credinfo) {
        if (credinfo == null) {
            return;
        }
        this.mType = type;
        this.mCaRootCert = caroot;
        this.mClientCert = clientcert;
        this.mWifiSpFqdn = sp.nodeName;
        this.mUpdateIdentifier = sp.perProviderSubscription.UpdateIdentifier;
        this.mCredentialName = credinfo.nodeName;
        this.mOtherHomePartnerList = credinfo.homeSP.otherHomePartners.values();
        Set<Map.Entry<String, WifiPasspointDmTree.AAAServerTrustRoot>> set = credinfo.aAAServerTrustRoot.entrySet();
        Iterator<Map.Entry<String, WifiPasspointDmTree.AAAServerTrustRoot>> i = set.iterator();
        if (i.hasNext()) {
            Map.Entry<String, WifiPasspointDmTree.AAAServerTrustRoot> entry3 = i.next();
            WifiPasspointDmTree.AAAServerTrustRoot aaa = entry3.getValue();
            this.mAaaCertUrl = aaa.CertURL;
            this.mAaaSha256Fingerprint = aaa.CertSHA256Fingerprint;
        }
        this.mCertType = credinfo.credential.digitalCertificate.CertificateType;
        this.mCertSha256Fingerprint = credinfo.credential.digitalCertificate.CertSHA256Fingerprint;
        this.mUsername = credinfo.credential.usernamePassword.Username;
        this.mPasswd = credinfo.credential.usernamePassword.Password;
        this.mIsMachineRemediation = credinfo.credential.usernamePassword.MachineManaged;
        this.mInnerMethod = credinfo.credential.usernamePassword.eAPMethod.InnerMethod;
        this.mImsi = credinfo.credential.sim.IMSI;
        this.mMcc = mcc;
        this.mMnc = mnc;
        this.mCreationDate = credinfo.credential.CreationDate;
        this.mExpirationDate = credinfo.credential.ExpirationDate;
        this.mRealm = credinfo.credential.Realm;
        this.mCrednetialPriority = credinfo.credentialPriority == null ? 128 : Integer.parseInt(credinfo.credentialPriority);
        this.mHomeSpFqdn = credinfo.homeSP.FQDN;
        this.mSubscriptionUpdateInterval = credinfo.subscriptionUpdate.UpdateInterval;
        this.mSubscriptionUpdateMethod = credinfo.subscriptionUpdate.UpdateMethod;
        this.mSubscriptionUpdateRestriction = credinfo.subscriptionUpdate.Restriction;
        this.mSubscriptionUpdateURI = credinfo.subscriptionUpdate.URI;
        this.mSubscriptionUpdateUsername = credinfo.subscriptionUpdate.usernamePassword.Username;
        this.mSubscriptionUpdatePassword = credinfo.subscriptionUpdate.usernamePassword.Password;
        this.mPolicyUpdateUri = credinfo.policy.policyUpdate.URI;
        this.mPolicyUpdateInterval = credinfo.policy.policyUpdate.UpdateInterval;
        this.mPolicyUpdateUsername = credinfo.policy.policyUpdate.usernamePassword.Username;
        this.mPolicyUpdatePassword = credinfo.policy.policyUpdate.usernamePassword.Password;
        this.mPolicyUpdateRestriction = credinfo.policy.policyUpdate.Restriction;
        this.mPolicyUpdateMethod = credinfo.policy.policyUpdate.UpdateMethod;
        this.mPreferredRoamingPartnerList = credinfo.policy.preferredRoamingPartnerList.values();
        this.mMinBackhaulThresholdNetwork = credinfo.policy.minBackhaulThreshold.values();
        this.mRequiredProtoPortTuple = credinfo.policy.requiredProtoPortTuple.values();
        this.mMaxBssLoad = credinfo.policy.maximumBSSLoadValue;
        this.mSpExclusionList = credinfo.policy.sPExclusionList.values();
        this.mHomeOIList = credinfo.homeSP.homeOIList.values();
        this.mFriendlyName = credinfo.homeSP.FriendlyName;
        this.mCheckAaaServerCertStatus = credinfo.credential.CheckAAAServerCertStatus;
    }

    public String getUpdateIdentifier() {
        return this.mUpdateIdentifier;
    }

    public String getUpdateMethod() {
        return this.mSubscriptionUpdateMethod;
    }

    public void setUpdateMethod(String method) {
        this.mSubscriptionUpdateMethod = method;
    }

    public String getWifiSpFqdn() {
        return this.mWifiSpFqdn;
    }

    public String getCredName() {
        return this.mCredentialName;
    }

    public String getType() {
        return this.mType;
    }

    public WifiEnterpriseConfig getEnterpriseConfig() {
        return new WifiEnterpriseConfig(this.mEnterpriseConfig);
    }

    public void setEnterpriseConfig(WifiEnterpriseConfig config) {
    }

    public String getCertType() {
        return this.mCertType;
    }

    public String getCertSha256Fingerprint() {
        return this.mCertSha256Fingerprint;
    }

    public String getUserName() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPasswd;
    }

    public String getImsi() {
        return this.mImsi;
    }

    public String getMcc() {
        return this.mMcc;
    }

    public String getMnc() {
        return this.mMnc;
    }

    public String getCaRootCertPath() {
        return this.mCaRootCert;
    }

    public String getClientCertPath() {
        return this.mClientCert;
    }

    public String getRealm() {
        return this.mRealm;
    }

    public void setRealm(String realm) {
        this.mRealm = realm;
    }

    public int getPriority() {
        if (this.mUserPreferred) {
            return 0;
        }
        return this.mCrednetialPriority;
    }

    public String getHomeSpFqdn() {
        return this.mHomeSpFqdn;
    }

    public void setHomeFqdn(String fqdn) {
        this.mHomeSpFqdn = fqdn;
    }

    public Collection<WifiPasspointDmTree.OtherHomePartners> getOtherHomePartnerList() {
        return this.mOtherHomePartnerList;
    }

    public String getSubscriptionUpdateUsername() {
        return this.mSubscriptionUpdateUsername;
    }

    public String getSubscriptionUpdatePassword() {
        return this.mSubscriptionUpdatePassword;
    }

    public String getPolicyUpdateUri() {
        return this.mPolicyUpdateUri;
    }

    public String getPolicyUpdateInterval() {
        return this.mPolicyUpdateInterval;
    }

    public String getPolicyUpdateUsername() {
        return this.mPolicyUpdateUsername;
    }

    public String getPolicyUpdatePassword() {
        return this.mPolicyUpdatePassword;
    }

    public String getPolicyUpdateRestriction() {
        return this.mPolicyUpdateRestriction;
    }

    public String getPolicyUpdateMethod() {
        return this.mPolicyUpdateMethod;
    }

    public String getCreationDate() {
        return this.mCreationDate;
    }

    public String getExpirationDate() {
        return this.mExpirationDate;
    }

    public void setExpirationDate(String expirationdate) {
        this.mExpirationDate = expirationdate;
    }

    public Collection<WifiPasspointDmTree.PreferredRoamingPartnerList> getPreferredRoamingPartnerList() {
        return this.mPreferredRoamingPartnerList;
    }

    public Collection<WifiPasspointDmTree.HomeOIList> getHomeOiList() {
        return this.mHomeOIList;
    }

    public Collection<WifiPasspointDmTree.MinBackhaulThresholdNetwork> getBackhaulThresholdList() {
        return this.mMinBackhaulThresholdNetwork;
    }

    public Collection<WifiPasspointDmTree.RequiredProtoPortTuple> getRequiredProtoPortList() {
        return this.mRequiredProtoPortTuple;
    }

    public Collection<WifiPasspointDmTree.SPExclusionList> getSPExclusionList() {
        return this.mSpExclusionList;
    }

    public boolean getIsMachineRemediation() {
        return this.mIsMachineRemediation;
    }

    public String getAaaCertUrl() {
        return this.mAaaCertUrl;
    }

    public String getAaaSha256Fingerprint() {
        return this.mAaaSha256Fingerprint;
    }

    public String getSubscriptionUpdateRestriction() {
        return this.mSubscriptionUpdateRestriction;
    }

    public String getSubscriptionUpdateURI() {
        return this.mSubscriptionUpdateURI;
    }

    public String getSubscriptionUpdateInterval() {
        return this.mSubscriptionUpdateInterval;
    }

    public String getFriendlyName() {
        return this.mFriendlyName;
    }

    public String getMaxBssLoad() {
        return this.mMaxBssLoad;
    }

    public boolean getUserPreference() {
        return this.mUserPreferred;
    }

    public boolean getCheckAaaServerCertStatus() {
        return this.mCheckAaaServerCertStatus;
    }

    public void setUserPreference(boolean value) {
        this.mUserPreferred = value;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof WifiPasspointCredential) {
            WifiPasspointCredential other = (WifiPasspointCredential)obj;
            if (this.mType.equals(other.mType)) {
                if (this.mType.equals("TTLS")) {
                    boolean bl = result = this.mUsername.equals(other.mUsername) && this.mPasswd.equals(other.mPasswd) && this.mRealm.equals(other.mRealm) && this.mHomeSpFqdn.equals(other.mHomeSpFqdn);
                }
                if (this.mType.equals("TLS")) {
                    boolean bl = result = this.mRealm.equals(other.mRealm) && this.mHomeSpFqdn.equals(other.mHomeSpFqdn) && this.mClientCert.equals(other.mClientCert);
                }
                if (this.mType.equals("SIM")) {
                    result = this.mMcc.equals(other.mMcc) && this.mMnc.equals(other.mMnc) && this.mImsi.equals(other.mImsi) && this.mHomeSpFqdn.equals(other.mHomeSpFqdn);
                }
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append(", UpdateIdentifier: ").append(this.mUpdateIdentifier == null ? none : this.mUpdateIdentifier).append(", SubscriptionUpdateMethod: ").append(this.mSubscriptionUpdateMethod == null ? none : this.mSubscriptionUpdateMethod).append(", Type: ").append(this.mType == null ? none : this.mType).append(", Username: ").append(this.mUsername == null ? none : this.mUsername).append(", Passwd: ").append(this.mPasswd == null ? none : this.mPasswd).append(", SubDMAccUsername: ").append(this.mSubscriptionUpdateUsername == null ? none : this.mSubscriptionUpdateUsername).append(", SubDMAccPassword: ").append(this.mSubscriptionUpdatePassword == null ? none : this.mSubscriptionUpdatePassword).append(", PolDMAccUsername: ").append(this.mPolicyUpdateUsername == null ? none : this.mPolicyUpdateUsername).append(", PolDMAccPassword: ").append(this.mPolicyUpdatePassword == null ? none : this.mPolicyUpdatePassword).append(", Imsi: ").append(this.mImsi == null ? none : this.mImsi).append(", Mcc: ").append(this.mMcc == null ? none : this.mMcc).append(", Mnc: ").append(this.mMnc == null ? none : this.mMnc).append(", CaRootCert: ").append(this.mCaRootCert == null ? none : this.mCaRootCert).append(", Realm: ").append(this.mRealm == null ? none : this.mRealm).append(", Priority: ").append(this.mCrednetialPriority).append(", Fqdn: ").append(this.mHomeSpFqdn == null ? none : this.mHomeSpFqdn).append(", Otherhomepartners: ").append(this.mOtherHomePartnerList == null ? none : this.mOtherHomePartnerList).append(", ExpirationDate: ").append(this.mExpirationDate == null ? none : this.mExpirationDate).append(", MaxBssLoad: ").append(this.mMaxBssLoad == null ? none : this.mMaxBssLoad).append(", SPExclusionList: ").append(this.mSpExclusionList);
        if (this.mPreferredRoamingPartnerList != null) {
            sb.append("PreferredRoamingPartnerList:");
            for (WifiPasspointDmTree.PreferredRoamingPartnerList prpListItem : this.mPreferredRoamingPartnerList) {
                sb.append("[fqdnmatch:").append(prpListItem.FQDN_Match).append(", priority:").append(prpListItem.Priority).append(", country:").append(prpListItem.Country).append("]");
            }
        }
        if (this.mHomeOIList != null) {
            sb.append("HomeOIList:");
            for (WifiPasspointDmTree.HomeOIList HomeOIListItem : this.mHomeOIList) {
                sb.append("[HomeOI:").append(HomeOIListItem.HomeOI).append(", HomeOIRequired:").append(HomeOIListItem.HomeOIRequired).append("]");
            }
        }
        if (this.mMinBackhaulThresholdNetwork != null) {
            sb.append("BackHaulThreshold:");
            for (WifiPasspointDmTree.MinBackhaulThresholdNetwork BhtListItem : this.mMinBackhaulThresholdNetwork) {
                sb.append("[networkType:").append(BhtListItem.NetworkType).append(", dlBandwidth:").append(BhtListItem.DLBandwidth).append(", ulBandwidth:").append(BhtListItem.ULBandwidth).append("]");
            }
        }
        if (this.mRequiredProtoPortTuple != null) {
            sb.append("WifiMORequiredProtoPortTupleList:");
            for (WifiPasspointDmTree.RequiredProtoPortTuple RpptListItem : this.mRequiredProtoPortTuple) {
                sb.append("[IPProtocol:").append(RpptListItem.IPProtocol).append(", PortNumber:").append(RpptListItem.PortNumber).append("]");
            }
        }
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mWifiSpFqdn);
        dest.writeString(this.mCredentialName);
        dest.writeString(this.mType);
        dest.writeInt(this.mCrednetialPriority);
        dest.writeString(this.mHomeSpFqdn);
        dest.writeString(this.mRealm);
    }

    public void readFromParcel(Parcel in) {
        this.mWifiSpFqdn = in.readString();
        this.mCredentialName = in.readString();
        this.mType = in.readString();
        this.mCrednetialPriority = in.readInt();
        this.mHomeSpFqdn = in.readString();
        this.mRealm = in.readString();
    }

    public int compareTo(WifiPasspointCredential another) {
        if (this.mCrednetialPriority < another.mCrednetialPriority) {
            return -1;
        }
        if (this.mCrednetialPriority == another.mCrednetialPriority) {
            return this.mType.compareTo(another.mType);
        }
        return 1;
    }

    public int hashCode() {
        int hash = 208;
        if (this.mType != null) {
            hash += this.mType.hashCode();
        }
        if (this.mRealm != null) {
            hash += this.mRealm.hashCode();
        }
        if (this.mHomeSpFqdn != null) {
            hash += this.mHomeSpFqdn.hashCode();
        }
        if (this.mUsername != null) {
            hash += this.mUsername.hashCode();
        }
        if (this.mPasswd != null) {
            hash += this.mPasswd.hashCode();
        }
        return hash;
    }
}

