/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.passpoint;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;

public class WifiPasspointDmTree
implements Parcelable {
    private static final String TAG = "WifiTree";
    public int PpsMoId;
    public HashMap<String, SpFqdn> spFqdn = new HashMap();
    public static final Parcelable.Creator<WifiPasspointDmTree> CREATOR = new Parcelable.Creator<WifiPasspointDmTree>(){

        @Override
        public WifiPasspointDmTree createFromParcel(Parcel in) {
            return new WifiPasspointDmTree(in);
        }

        public WifiPasspointDmTree[] newArray(int size) {
            return new WifiPasspointDmTree[size];
        }
    };

    public SpFqdn createSpFqdn(String name) {
        SpFqdn obj = new SpFqdn(name);
        this.spFqdn.put(name, obj);
        return obj;
    }

    public WifiPasspointDmTree() {
    }

    public WifiPasspointDmTree(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeMap(this.spFqdn);
    }

    public void readFromParcel(Parcel in) {
        if (in != null) {
            in.readMap(this.spFqdn, SpFqdn.class.getClassLoader());
        }
    }

    public static class Extension {
        public String empty;
    }

    public static class SIM
    implements Parcelable {
        public String IMSI;
        public String EAPType;
        public static final Parcelable.Creator<SIM> CREATOR = new Parcelable.Creator<SIM>(){

            @Override
            public SIM createFromParcel(Parcel in) {
                return new SIM(in);
            }

            public SIM[] newArray(int size) {
                return new SIM[size];
            }
        };

        public SIM() {
        }

        public SIM(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.IMSI);
            out.writeString(this.EAPType);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.IMSI = in.readString();
                this.EAPType = in.readString();
            }
        }
    }

    public static class DigitalCertificate
    implements Parcelable {
        public String CertificateType;
        public String CertSHA256Fingerprint;
        public static final Parcelable.Creator<DigitalCertificate> CREATOR = new Parcelable.Creator<DigitalCertificate>(){

            @Override
            public DigitalCertificate createFromParcel(Parcel in) {
                return new DigitalCertificate(in);
            }

            public DigitalCertificate[] newArray(int size) {
                return new DigitalCertificate[size];
            }
        };

        public DigitalCertificate() {
        }

        public DigitalCertificate(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.CertificateType);
            out.writeString(this.CertSHA256Fingerprint);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.CertificateType = in.readString();
                this.CertSHA256Fingerprint = in.readString();
            }
        }
    }

    public static class Credential
    implements Parcelable {
        public String CreationDate;
        public String ExpirationDate;
        public UsernamePassword usernamePassword = new UsernamePassword();
        public DigitalCertificate digitalCertificate = new DigitalCertificate();
        public String Realm;
        public boolean CheckAAAServerCertStatus;
        public SIM sim = new SIM();
        public static final Parcelable.Creator<Credential> CREATOR = new Parcelable.Creator<Credential>(){

            @Override
            public Credential createFromParcel(Parcel in) {
                return new Credential(in);
            }

            public Credential[] newArray(int size) {
                return new Credential[size];
            }
        };

        public Credential() {
        }

        public Credential(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.CreationDate);
            out.writeString(this.ExpirationDate);
            out.writeParcelable(this.usernamePassword, flags);
            out.writeParcelable(this.digitalCertificate, flags);
            out.writeString(this.Realm);
            out.writeInt(this.CheckAAAServerCertStatus ? 1 : 0);
            out.writeParcelable(this.sim, flags);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.CreationDate = in.readString();
                this.ExpirationDate = in.readString();
                this.usernamePassword = (UsernamePassword)in.readParcelable(UsernamePassword.class.getClassLoader());
                this.digitalCertificate = (DigitalCertificate)in.readParcelable(DigitalCertificate.class.getClassLoader());
                this.Realm = in.readString();
                this.CheckAAAServerCertStatus = in.readInt() == 1;
                this.sim = (SIM)in.readParcelable(SIM.class.getClassLoader());
            }
        }
    }

    public static class UsageLimits
    implements Parcelable {
        public String DataLimit;
        public String StartDate;
        public String TimeLimit;
        public String UsageTimePeriod;
        public static final Parcelable.Creator<UsageLimits> CREATOR = new Parcelable.Creator<UsageLimits>(){

            @Override
            public UsageLimits createFromParcel(Parcel in) {
                return new UsageLimits(in);
            }

            public UsageLimits[] newArray(int size) {
                return new UsageLimits[size];
            }
        };

        public UsageLimits() {
        }

        public UsageLimits(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.DataLimit);
            out.writeString(this.StartDate);
            out.writeString(this.TimeLimit);
            out.writeString(this.UsageTimePeriod);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.DataLimit = in.readString();
                this.StartDate = in.readString();
                this.TimeLimit = in.readString();
                this.UsageTimePeriod = in.readString();
            }
        }
    }

    public static class SubscriptionParameters
    implements Parcelable {
        public String CreationDate;
        public String ExpirationDate;
        public String TypeOfSubscription;
        public UsageLimits usageLimits = new UsageLimits();
        public static final Parcelable.Creator<SubscriptionParameters> CREATOR = new Parcelable.Creator<SubscriptionParameters>(){

            @Override
            public SubscriptionParameters createFromParcel(Parcel in) {
                return new SubscriptionParameters(in);
            }

            public SubscriptionParameters[] newArray(int size) {
                return new SubscriptionParameters[size];
            }
        };

        public SubscriptionParameters() {
        }

        public SubscriptionParameters(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.CreationDate);
            out.writeString(this.ExpirationDate);
            out.writeString(this.TypeOfSubscription);
            out.writeParcelable(this.usageLimits, flags);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.CreationDate = in.readString();
                this.ExpirationDate = in.readString();
                this.TypeOfSubscription = in.readString();
                this.usageLimits = (UsageLimits)in.readParcelable(UsageLimits.class.getClassLoader());
            }
        }
    }

    public static class OtherHomePartners
    implements Parcelable {
        public String nodeName;
        public String FQDN;
        public static final Parcelable.Creator<OtherHomePartners> CREATOR = new Parcelable.Creator<OtherHomePartners>(){

            @Override
            public OtherHomePartners createFromParcel(Parcel in) {
                return new OtherHomePartners(in);
            }

            public OtherHomePartners[] newArray(int size) {
                return new OtherHomePartners[size];
            }
        };

        public OtherHomePartners(String nn, String f) {
            this.nodeName = nn;
            this.FQDN = f;
        }

        public OtherHomePartners() {
        }

        public OtherHomePartners(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeString(this.FQDN);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.FQDN = in.readString();
            }
        }
    }

    public static class HomeOIList
    implements Parcelable {
        public String nodeName;
        public String HomeOI;
        public boolean HomeOIRequired;
        public static final Parcelable.Creator<HomeOIList> CREATOR = new Parcelable.Creator<HomeOIList>(){

            @Override
            public HomeOIList createFromParcel(Parcel in) {
                return new HomeOIList(in);
            }

            public HomeOIList[] newArray(int size) {
                return new HomeOIList[size];
            }
        };

        public HomeOIList(String nn, String h, boolean r) {
            this.nodeName = nn;
            this.HomeOI = h;
            this.HomeOIRequired = r;
        }

        public HomeOIList() {
        }

        public HomeOIList(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeString(this.HomeOI);
            out.writeInt(this.HomeOIRequired ? 1 : 0);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.HomeOI = in.readString();
                this.HomeOIRequired = in.readInt() == 1;
            }
        }
    }

    public static class NetworkID
    implements Parcelable {
        public String nodeName;
        public String SSID;
        public String HESSID;
        public static final Parcelable.Creator<NetworkID> CREATOR = new Parcelable.Creator<NetworkID>(){

            @Override
            public NetworkID createFromParcel(Parcel in) {
                return new NetworkID(in);
            }

            public NetworkID[] newArray(int size) {
                return new NetworkID[size];
            }
        };

        public NetworkID(String nn, String s, String h) {
            this.nodeName = nn;
            this.SSID = s;
            this.HESSID = h;
        }

        public NetworkID() {
        }

        public NetworkID(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeString(this.SSID);
            out.writeString(this.HESSID);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.SSID = in.readString();
                this.HESSID = in.readString();
            }
        }
    }

    public static class HomeSP
    implements Parcelable {
        public HashMap<String, NetworkID> networkID = new HashMap();
        public String FriendlyName;
        public String IconURL;
        public String FQDN;
        public HashMap<String, HomeOIList> homeOIList = new HashMap();
        public HashMap<String, OtherHomePartners> otherHomePartners = new HashMap();
        public String RoamingConsortiumOI;
        public static final Parcelable.Creator<HomeSP> CREATOR = new Parcelable.Creator<HomeSP>(){

            @Override
            public HomeSP createFromParcel(Parcel in) {
                return new HomeSP(in);
            }

            public HomeSP[] newArray(int size) {
                return new HomeSP[size];
            }
        };

        public NetworkID createNetworkID(String name, String ssid, String hessid) {
            NetworkID obj = new NetworkID(name, ssid, hessid);
            this.networkID.put(name, obj);
            return obj;
        }

        public HomeOIList createHomeOIList(String name, String homeoi, boolean required) {
            HomeOIList obj = new HomeOIList(name, homeoi, required);
            this.homeOIList.put(name, obj);
            return obj;
        }

        public OtherHomePartners createOtherHomePartners(String name, String fqdn) {
            OtherHomePartners obj = new OtherHomePartners(name, fqdn);
            this.otherHomePartners.put(name, obj);
            return obj;
        }

        public HomeSP() {
        }

        public HomeSP(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeMap(this.networkID);
            out.writeString(this.FriendlyName);
            out.writeString(this.IconURL);
            out.writeString(this.FQDN);
            out.writeMap(this.homeOIList);
            out.writeMap(this.otherHomePartners);
            out.writeString(this.RoamingConsortiumOI);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                in.readMap(this.networkID, NetworkID.class.getClassLoader());
                this.FriendlyName = in.readString();
                this.IconURL = in.readString();
                this.FQDN = in.readString();
                in.readMap(this.homeOIList, HomeOIList.class.getClassLoader());
                in.readMap(this.otherHomePartners, OtherHomePartners.class.getClassLoader());
                this.RoamingConsortiumOI = in.readString();
            }
        }
    }

    public static class EAPMethod
    implements Parcelable {
        public String EAPType;
        public String VendorId;
        public String VendorType;
        public String InnerEAPType;
        public String InnerVendorId;
        public String InnerVendorType;
        public String InnerMethod;
        public static final Parcelable.Creator<EAPMethod> CREATOR = new Parcelable.Creator<EAPMethod>(){

            @Override
            public EAPMethod createFromParcel(Parcel in) {
                return new EAPMethod(in);
            }

            public EAPMethod[] newArray(int size) {
                return new EAPMethod[size];
            }
        };

        public EAPMethod() {
        }

        public EAPMethod(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.EAPType);
            out.writeString(this.VendorId);
            out.writeString(this.VendorType);
            out.writeString(this.InnerEAPType);
            out.writeString(this.InnerVendorId);
            out.writeString(this.InnerVendorType);
            out.writeString(this.InnerMethod);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.EAPType = in.readString();
                this.VendorId = in.readString();
                this.VendorType = in.readString();
                this.InnerEAPType = in.readString();
                this.InnerVendorId = in.readString();
                this.InnerVendorType = in.readString();
                this.InnerMethod = in.readString();
            }
        }
    }

    public static class UsernamePassword
    implements Parcelable {
        public String Username;
        public String Password;
        public boolean MachineManaged;
        public String SoftTokenApp;
        public String AbleToShare;
        public EAPMethod eAPMethod = new EAPMethod();
        public static final Parcelable.Creator<UsernamePassword> CREATOR = new Parcelable.Creator<UsernamePassword>(){

            @Override
            public UsernamePassword createFromParcel(Parcel in) {
                return new UsernamePassword(in);
            }

            public UsernamePassword[] newArray(int size) {
                return new UsernamePassword[size];
            }
        };

        public UsernamePassword() {
        }

        public UsernamePassword(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.Username);
            out.writeString(this.Password);
            out.writeInt(this.MachineManaged ? 1 : 0);
            out.writeString(this.SoftTokenApp);
            out.writeString(this.AbleToShare);
            out.writeParcelable(this.eAPMethod, flags);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.Username = in.readString();
                this.Password = in.readString();
                this.MachineManaged = in.readInt() == 1;
                this.SoftTokenApp = in.readString();
                this.AbleToShare = in.readString();
                this.eAPMethod = (EAPMethod)in.readParcelable(EAPMethod.class.getClassLoader());
            }
        }
    }

    public static class TrustRoot
    implements Parcelable {
        public String CertURL;
        public String CertSHA256Fingerprint;
        public static final Parcelable.Creator<TrustRoot> CREATOR = new Parcelable.Creator<TrustRoot>(){

            @Override
            public TrustRoot createFromParcel(Parcel in) {
                return new TrustRoot(in);
            }

            public TrustRoot[] newArray(int size) {
                return new TrustRoot[size];
            }
        };

        public TrustRoot() {
        }

        public TrustRoot(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.CertURL);
            out.writeString(this.CertSHA256Fingerprint);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.CertURL = in.readString();
                this.CertSHA256Fingerprint = in.readString();
            }
        }
    }

    public static class SubscriptionUpdate
    implements Parcelable {
        public String UpdateInterval;
        public String UpdateMethod;
        public String Restriction;
        public String URI;
        public UsernamePassword usernamePassword = new UsernamePassword();
        public String Other;
        public TrustRoot trustRoot = new TrustRoot();
        public static final Parcelable.Creator<SubscriptionUpdate> CREATOR = new Parcelable.Creator<SubscriptionUpdate>(){

            @Override
            public SubscriptionUpdate createFromParcel(Parcel in) {
                return new SubscriptionUpdate(in);
            }

            public SubscriptionUpdate[] newArray(int size) {
                return new SubscriptionUpdate[size];
            }
        };

        public SubscriptionUpdate() {
        }

        public SubscriptionUpdate(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.UpdateInterval);
            out.writeString(this.UpdateMethod);
            out.writeString(this.Restriction);
            out.writeString(this.URI);
            out.writeParcelable(this.usernamePassword, flags);
            out.writeString(this.Other);
            out.writeParcelable(this.trustRoot, flags);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.UpdateInterval = in.readString();
                this.UpdateMethod = in.readString();
                this.Restriction = in.readString();
                this.URI = in.readString();
                this.usernamePassword = (UsernamePassword)in.readParcelable(UsernamePassword.class.getClassLoader());
                this.Other = in.readString();
                this.trustRoot = (TrustRoot)in.readParcelable(TrustRoot.class.getClassLoader());
            }
        }
    }

    public static class AAAServerTrustRoot
    implements Parcelable {
        public String nodeName;
        public String CertURL;
        public String CertSHA256Fingerprint;
        public static final Parcelable.Creator<AAAServerTrustRoot> CREATOR = new Parcelable.Creator<AAAServerTrustRoot>(){

            @Override
            public AAAServerTrustRoot createFromParcel(Parcel in) {
                return new AAAServerTrustRoot(in);
            }

            public AAAServerTrustRoot[] newArray(int size) {
                return new AAAServerTrustRoot[size];
            }
        };

        public AAAServerTrustRoot(String nn, String url, String fp) {
            this.nodeName = nn;
            this.CertURL = url;
            this.CertSHA256Fingerprint = fp;
        }

        public AAAServerTrustRoot() {
        }

        public AAAServerTrustRoot(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeString(this.CertURL);
            out.writeString(this.CertSHA256Fingerprint);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.CertURL = in.readString();
                this.CertSHA256Fingerprint = in.readString();
            }
        }
    }

    public static class RequiredProtoPortTuple
    implements Parcelable {
        public String nodeName;
        public String IPProtocol;
        public String PortNumber;
        public static final Parcelable.Creator<RequiredProtoPortTuple> CREATOR = new Parcelable.Creator<RequiredProtoPortTuple>(){

            @Override
            public RequiredProtoPortTuple createFromParcel(Parcel in) {
                return new RequiredProtoPortTuple(in);
            }

            public RequiredProtoPortTuple[] newArray(int size) {
                return new RequiredProtoPortTuple[size];
            }
        };

        public RequiredProtoPortTuple() {
        }

        public RequiredProtoPortTuple(String nn, String protocol, String port) {
            this.nodeName = nn;
            this.IPProtocol = protocol;
            this.PortNumber = port;
        }

        public RequiredProtoPortTuple(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeString(this.IPProtocol);
            out.writeString(this.PortNumber);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.IPProtocol = in.readString();
                this.PortNumber = in.readString();
            }
        }
    }

    public static class SPExclusionList
    implements Parcelable {
        public String nodeName;
        public String SSID;
        public static final Parcelable.Creator<SPExclusionList> CREATOR = new Parcelable.Creator<SPExclusionList>(){

            @Override
            public SPExclusionList createFromParcel(Parcel in) {
                return new SPExclusionList(in);
            }

            public SPExclusionList[] newArray(int size) {
                return new SPExclusionList[size];
            }
        };

        public SPExclusionList(String nn, String s) {
            this.nodeName = nn;
            this.SSID = s;
        }

        public SPExclusionList() {
        }

        public SPExclusionList(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeString(this.SSID);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.SSID = in.readString();
            }
        }
    }

    public static class PolicyUpdate
    implements Parcelable {
        public String UpdateInterval;
        public String UpdateMethod;
        public String Restriction;
        public String URI;
        public UsernamePassword usernamePassword = new UsernamePassword();
        public String Other;
        public TrustRoot trustRoot = new TrustRoot();
        public static final Parcelable.Creator<PolicyUpdate> CREATOR = new Parcelable.Creator<PolicyUpdate>(){

            @Override
            public PolicyUpdate createFromParcel(Parcel in) {
                return new PolicyUpdate(in);
            }

            public PolicyUpdate[] newArray(int size) {
                return new PolicyUpdate[size];
            }
        };

        public PolicyUpdate() {
        }

        public PolicyUpdate(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.UpdateInterval);
            out.writeString(this.UpdateMethod);
            out.writeString(this.Restriction);
            out.writeString(this.URI);
            out.writeParcelable(this.usernamePassword, flags);
            out.writeString(this.Other);
            out.writeParcelable(this.trustRoot, flags);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.UpdateInterval = in.readString();
                this.UpdateMethod = in.readString();
                this.Restriction = in.readString();
                this.URI = in.readString();
                this.usernamePassword = (UsernamePassword)in.readParcelable(UsernamePassword.class.getClassLoader());
                this.Other = in.readString();
                this.trustRoot = (TrustRoot)in.readParcelable(TrustRoot.class.getClassLoader());
            }
        }
    }

    public static class MinBackhaulThresholdNetwork
    implements Parcelable {
        public String nodeName;
        public String NetworkType;
        public String DLBandwidth;
        public String ULBandwidth;
        public static final Parcelable.Creator<MinBackhaulThresholdNetwork> CREATOR = new Parcelable.Creator<MinBackhaulThresholdNetwork>(){

            @Override
            public MinBackhaulThresholdNetwork createFromParcel(Parcel in) {
                return new MinBackhaulThresholdNetwork(in);
            }

            public MinBackhaulThresholdNetwork[] newArray(int size) {
                return new MinBackhaulThresholdNetwork[size];
            }
        };

        public MinBackhaulThresholdNetwork(String nn, String nt, String d, String u) {
            this.nodeName = nn;
            this.NetworkType = nt;
            this.DLBandwidth = d;
            this.ULBandwidth = u;
        }

        public MinBackhaulThresholdNetwork() {
        }

        public MinBackhaulThresholdNetwork(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeString(this.NetworkType);
            out.writeString(this.DLBandwidth);
            out.writeString(this.ULBandwidth);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.NetworkType = in.readString();
                this.DLBandwidth = in.readString();
                this.ULBandwidth = in.readString();
            }
        }
    }

    public static class PreferredRoamingPartnerList
    implements Parcelable {
        public String nodeName;
        public String FQDN_Match;
        public String Priority;
        public String Country;
        public static final Parcelable.Creator<PreferredRoamingPartnerList> CREATOR = new Parcelable.Creator<PreferredRoamingPartnerList>(){

            @Override
            public PreferredRoamingPartnerList createFromParcel(Parcel in) {
                return new PreferredRoamingPartnerList(in);
            }

            public PreferredRoamingPartnerList[] newArray(int size) {
                return new PreferredRoamingPartnerList[size];
            }
        };

        public PreferredRoamingPartnerList(String nn, String f, String p, String c) {
            this.nodeName = nn;
            this.FQDN_Match = f;
            this.Priority = p;
            this.Country = c;
        }

        public PreferredRoamingPartnerList() {
        }

        public PreferredRoamingPartnerList(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeString(this.FQDN_Match);
            out.writeString(this.Priority);
            out.writeString(this.Country);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.FQDN_Match = in.readString();
                this.Priority = in.readString();
                this.Country = in.readString();
            }
        }
    }

    public static class Policy
    implements Parcelable {
        public HashMap<String, PreferredRoamingPartnerList> preferredRoamingPartnerList = new HashMap();
        public HashMap<String, MinBackhaulThresholdNetwork> minBackhaulThreshold = new HashMap();
        public PolicyUpdate policyUpdate = new PolicyUpdate();
        public HashMap<String, SPExclusionList> sPExclusionList = new HashMap();
        public HashMap<String, RequiredProtoPortTuple> requiredProtoPortTuple = new HashMap();
        public String maximumBSSLoadValue;
        public static final Parcelable.Creator<Policy> CREATOR = new Parcelable.Creator<Policy>(){

            @Override
            public Policy createFromParcel(Parcel in) {
                return new Policy(in);
            }

            public Policy[] newArray(int size) {
                return new Policy[size];
            }
        };

        public PreferredRoamingPartnerList createPreferredRoamingPartnerList(String name, String fqdn, String priority, String country) {
            PreferredRoamingPartnerList obj = new PreferredRoamingPartnerList(name, fqdn, priority, country);
            this.preferredRoamingPartnerList.put(name, obj);
            return obj;
        }

        public MinBackhaulThresholdNetwork createMinBackhaulThreshold(String name, String type, String dl, String ul) {
            MinBackhaulThresholdNetwork obj = new MinBackhaulThresholdNetwork(name, type, dl, ul);
            this.minBackhaulThreshold.put(name, obj);
            return obj;
        }

        public SPExclusionList createSPExclusionList(String name, String ssid) {
            SPExclusionList obj = new SPExclusionList(name, ssid);
            this.sPExclusionList.put(name, obj);
            return obj;
        }

        public RequiredProtoPortTuple createRequiredProtoPortTuple(String name, String proto, String port) {
            RequiredProtoPortTuple obj = new RequiredProtoPortTuple(name, proto, port);
            this.requiredProtoPortTuple.put(name, obj);
            return obj;
        }

        public Policy() {
        }

        public Policy(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeMap(this.preferredRoamingPartnerList);
            out.writeMap(this.minBackhaulThreshold);
            out.writeParcelable(this.policyUpdate, flags);
            out.writeMap(this.sPExclusionList);
            out.writeMap(this.requiredProtoPortTuple);
            out.writeString(this.maximumBSSLoadValue);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                in.readMap(this.preferredRoamingPartnerList, PreferredRoamingPartnerList.class.getClassLoader());
                in.readMap(this.minBackhaulThreshold, MinBackhaulThresholdNetwork.class.getClassLoader());
                this.policyUpdate = (PolicyUpdate)in.readParcelable(PolicyUpdate.class.getClassLoader());
                in.readMap(this.sPExclusionList, SPExclusionList.class.getClassLoader());
                in.readMap(this.requiredProtoPortTuple, RequiredProtoPortTuple.class.getClassLoader());
                this.maximumBSSLoadValue = in.readString();
            }
        }
    }

    public static class CredentialInfo
    implements Parcelable {
        public String nodeName;
        public Policy policy = new Policy();
        public String credentialPriority;
        public HashMap<String, AAAServerTrustRoot> aAAServerTrustRoot = new HashMap();
        public SubscriptionUpdate subscriptionUpdate = new SubscriptionUpdate();
        public HomeSP homeSP = new HomeSP();
        public SubscriptionParameters subscriptionParameters = new SubscriptionParameters();
        public Credential credential = new Credential();
        public Extension extension = new Extension();
        public static final Parcelable.Creator<CredentialInfo> CREATOR = new Parcelable.Creator<CredentialInfo>(){

            @Override
            public CredentialInfo createFromParcel(Parcel in) {
                return new CredentialInfo(in);
            }

            public CredentialInfo[] newArray(int size) {
                return new CredentialInfo[size];
            }
        };

        public CredentialInfo(String nn) {
            this.nodeName = nn;
        }

        public AAAServerTrustRoot createAAAServerTrustRoot(String name, String url, String fp) {
            AAAServerTrustRoot obj = new AAAServerTrustRoot(name, url, fp);
            this.aAAServerTrustRoot.put(name, obj);
            return obj;
        }

        public CredentialInfo() {
        }

        public CredentialInfo(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeParcelable(this.policy, flags);
            out.writeString(this.credentialPriority);
            out.writeMap(this.aAAServerTrustRoot);
            out.writeParcelable(this.subscriptionUpdate, flags);
            out.writeParcelable(this.homeSP, flags);
            out.writeParcelable(this.subscriptionParameters, flags);
            out.writeParcelable(this.credential, flags);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.policy = (Policy)in.readParcelable(Policy.class.getClassLoader());
                this.credentialPriority = in.readString();
                in.readMap(this.aAAServerTrustRoot, AAAServerTrustRoot.class.getClassLoader());
                this.subscriptionUpdate = (SubscriptionUpdate)in.readParcelable(SubscriptionUpdate.class.getClassLoader());
                this.homeSP = (HomeSP)in.readParcelable(HomeSP.class.getClassLoader());
                this.subscriptionParameters = (SubscriptionParameters)in.readParcelable(SubscriptionParameters.class.getClassLoader());
                this.credential = (Credential)in.readParcelable(Credential.class.getClassLoader());
            }
        }
    }

    public static class PerProviderSubscription
    implements Parcelable {
        public String UpdateIdentifier;
        public HashMap<String, CredentialInfo> credentialInfo = new HashMap();
        public static final Parcelable.Creator<PerProviderSubscription> CREATOR = new Parcelable.Creator<PerProviderSubscription>(){

            @Override
            public PerProviderSubscription createFromParcel(Parcel in) {
                return new PerProviderSubscription(in);
            }

            public PerProviderSubscription[] newArray(int size) {
                return new PerProviderSubscription[size];
            }
        };

        public CredentialInfo createCredentialInfo(String name) {
            CredentialInfo obj = new CredentialInfo(name);
            this.credentialInfo.put(name, obj);
            return obj;
        }

        public PerProviderSubscription() {
        }

        public PerProviderSubscription(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.UpdateIdentifier);
            out.writeMap(this.credentialInfo);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.UpdateIdentifier = in.readString();
                in.readMap(this.credentialInfo, CredentialInfo.class.getClassLoader());
            }
        }
    }

    public static class SpFqdn
    implements Parcelable {
        public String nodeName;
        public PerProviderSubscription perProviderSubscription = new PerProviderSubscription();
        public static final Parcelable.Creator<SpFqdn> CREATOR = new Parcelable.Creator<SpFqdn>(){

            @Override
            public SpFqdn createFromParcel(Parcel in) {
                return new SpFqdn(in);
            }

            public SpFqdn[] newArray(int size) {
                return new SpFqdn[size];
            }
        };

        public SpFqdn(String name) {
            this.nodeName = name;
        }

        public SpFqdn() {
        }

        public SpFqdn(Parcel in) {
            this.readFromParcel(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.nodeName);
            out.writeParcelable(this.perProviderSubscription, flags);
        }

        public void readFromParcel(Parcel in) {
            if (in != null) {
                this.nodeName = in.readString();
                this.perProviderSubscription = (PerProviderSubscription)in.readParcelable(PerProviderSubscription.class.getClassLoader());
            }
        }
    }
}

