/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.passpoint;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.passpoint.IWifiPasspointManager;
import android.net.wifi.passpoint.WifiPasspointCredential;
import android.net.wifi.passpoint.WifiPasspointInfo;
import android.net.wifi.passpoint.WifiPasspointOsuProvider;
import android.net.wifi.passpoint.WifiPasspointPolicy;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class WifiPasspointManager {
    private static final String TAG = "PasspointManager";
    private static final boolean DBG = true;
    public static final int PASSPOINT_STATE_UNKNOWN = 0;
    public static final int PASSPOINT_STATE_DISABLED = 1;
    public static final int PASSPOINT_STATE_DISCOVERY = 2;
    public static final int PASSPOINT_STATE_ACCESS = 3;
    public static final int PASSPOINT_STATE_PROVISION = 4;
    public static final int REASON_ERROR = 0;
    public static final int REASON_WIFI_DISABLED = 1;
    public static final int REASON_BUSY = 2;
    public static final int REASON_INVALID_PARAMETER = 3;
    public static final int REASON_NOT_TRUSTED = 4;
    public static final String PROTOCOL_DM = "OMA-DM-ClientInitiated";
    public static final String PROTOCOL_SOAP = "SPP-ClientInitiated";
    public static final String PASSPOINT_STATE_CHANGED_ACTION = "android.net.wifi.passpoint.STATE_CHANGE";
    public static final String PASSPOINT_CRED_CHANGED_ACTION = "android.net.wifi.passpoint.CRED_CHANGE";
    public static final String PASSPOINT_OSU_AVAILABLE_ACTION = "android.net.wifi.passpoint.OSU_AVAILABLE";
    public static final String PASSPOINT_USER_REM_REQ_ACTION = "android.net.wifi.passpoint.USER_REM_REQ";
    private static final int BASE = 163840;
    public static final int REQUEST_ANQP_INFO = 163841;
    public static final int REQUEST_ANQP_INFO_FAILED = 163842;
    public static final int REQUEST_ANQP_INFO_SUCCEEDED = 163843;
    public static final int REQUEST_OSU_ICON = 163844;
    public static final int REQUEST_OSU_ICON_FAILED = 163845;
    public static final int REQUEST_OSU_ICON_SUCCEEDED = 163846;
    public static final int START_OSU = 163847;
    public static final int START_OSU_BROWSER = 163848;
    public static final int START_OSU_FAILED = 163849;
    public static final int START_OSU_SUCCEEDED = 163850;
    private Context mContext;
    IWifiPasspointManager mService;

    public WifiPasspointManager(Context context, IWifiPasspointManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public Channel initialize(Context srcContext, Looper srcLooper, ChannelListener listener) {
        Messenger messenger = this.getMessenger();
        if (messenger == null) {
            return null;
        }
        Channel c = new Channel(srcContext, srcLooper, listener);
        if (c.mAsyncChannel.connectSync(srcContext, (Handler)c.mHandler, messenger) == 0) {
            return c;
        }
        return null;
    }

    public Messenger getMessenger() {
        try {
            return this.mService.getMessenger();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public int getPasspointState() {
        try {
            return this.mService.getPasspointState();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void requestAnqpInfo(Channel c, List<ScanResult> requested, int mask, ActionListener listener) {
        Log.d(TAG, "requestAnqpInfo start");
        Log.d(TAG, "requested.size=" + requested.size());
        WifiPasspointManager.checkChannel(c);
        ArrayList<ScanResult> list = new ArrayList<ScanResult>();
        for (ScanResult sr : requested) {
            if (!sr.capabilities.contains("[HS20]")) continue;
            list.add(sr);
            c.anqpRequestStart(sr);
            Log.d(TAG, "adding " + sr.BSSID);
        }
        int count = list.size();
        Log.d(TAG, "after filter, count=" + count);
        if (count == 0) {
            Log.d(TAG, "ANQP info request contains no HS20 APs, skipped");
            listener.onSuccess();
            return;
        }
        int key = c.putListener(listener, count);
        for (ScanResult sr : list) {
            c.mAsyncChannel.sendMessage(163841, mask, key, sr);
        }
        Log.d(TAG, "requestAnqpInfo end");
    }

    public void requestOsuIcons(Channel c, List<WifiPasspointOsuProvider> requested, int resolution, ActionListener listener) {
    }

    public List<WifiPasspointPolicy> requestCredentialMatch(List<ScanResult> requested) {
        try {
            return this.mService.requestCredentialMatch(requested);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public List<WifiPasspointCredential> getCredentials() {
        try {
            return this.mService.getCredentials();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean addCredential(WifiPasspointCredential cred) {
        try {
            return this.mService.addCredential(cred);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean updateCredential(WifiPasspointCredential cred) {
        try {
            return this.mService.updateCredential(cred);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean removeCredential(WifiPasspointCredential cred) {
        try {
            return this.mService.removeCredential(cred);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void startOsu(Channel c, WifiPasspointOsuProvider osu, OsuRemListener listener) {
        Log.d(TAG, "startOsu start");
        WifiPasspointManager.checkChannel(c);
        int key = c.putListener(listener);
        c.mAsyncChannel.sendMessage(163847, 0, key, osu);
        Log.d(TAG, "startOsu end");
    }

    public void startRemediation(Channel c, OsuRemListener listener) {
    }

    public void connect(WifiPasspointPolicy policy) {
    }

    private static void checkChannel(Channel c) {
        if (c == null) {
            throw new IllegalArgumentException("Channel needs to be initialized");
        }
    }

    public static class ParcelableString
    implements Parcelable {
        public String string;
        public static final Parcelable.Creator<ParcelableString> CREATOR = new Parcelable.Creator<ParcelableString>(){

            @Override
            public ParcelableString createFromParcel(Parcel in) {
                ParcelableString ret = new ParcelableString();
                ret.string = in.readString();
                return ret;
            }

            public ParcelableString[] newArray(int size) {
                return new ParcelableString[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.string);
        }
    }

    public static class Channel {
        private static final int INVALID_LISTENER_KEY = 0;
        private ChannelListener mChannelListener;
        private HashMap<Integer, Object> mListenerMap = new HashMap();
        private HashMap<Integer, Integer> mListenerMapCount = new HashMap();
        private Object mListenerMapLock = new Object();
        private int mListenerKey = 0;
        private List<ScanResult> mAnqpRequest = new LinkedList<ScanResult>();
        private Object mAnqpRequestLock = new Object();
        private AsyncChannel mAsyncChannel = new AsyncChannel();
        private PasspointHandler mHandler;
        Context mContext;

        Channel(Context context, Looper looper, ChannelListener l) {
            this.mHandler = new PasspointHandler(looper);
            this.mChannelListener = l;
            this.mContext = context;
        }

        private int putListener(Object listener) {
            return this.putListener(listener, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int putListener(Object listener, int count) {
            int key;
            if (listener == null || count <= 0) {
                return 0;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                do {
                    ++this.mListenerKey;
                } while (key == 0);
                this.mListenerMap.put(key, listener);
                this.mListenerMapCount.put(key, count);
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object peekListener(int key) {
            Log.d(WifiPasspointManager.TAG, "peekListener() key=" + key);
            if (key == 0) {
                return null;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                return this.mListenerMap.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getListener(int key, boolean forceRemove) {
            Log.d(WifiPasspointManager.TAG, "getListener() key=" + key + " force=" + forceRemove);
            if (key == 0) {
                return null;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                if (!forceRemove) {
                    int count = this.mListenerMapCount.get(key);
                    Log.d(WifiPasspointManager.TAG, "count=" + count);
                    this.mListenerMapCount.put(key, --count);
                    if (count > 0) {
                        return null;
                    }
                }
                Log.d(WifiPasspointManager.TAG, "remove key");
                this.mListenerMapCount.remove(key);
                return this.mListenerMap.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void anqpRequestStart(ScanResult sr) {
            Log.d(WifiPasspointManager.TAG, "anqpRequestStart sr.bssid=" + sr.BSSID);
            Object object = this.mAnqpRequestLock;
            synchronized (object) {
                this.mAnqpRequest.add(sr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void anqpRequestFinish(WifiPasspointInfo result) {
            Log.d(WifiPasspointManager.TAG, "anqpRequestFinish pi.bssid=" + result.bssid);
            Object object = this.mAnqpRequestLock;
            synchronized (object) {
                for (ScanResult sr : this.mAnqpRequest) {
                    if (!sr.BSSID.equals(result.bssid)) continue;
                    Log.d(WifiPasspointManager.TAG, "find hit " + result.bssid);
                    this.mAnqpRequest.remove(sr);
                    Log.d(WifiPasspointManager.TAG, "mAnqpRequest.len=" + this.mAnqpRequest.size());
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void anqpRequestFinish(ScanResult sr) {
            Log.d(WifiPasspointManager.TAG, "anqpRequestFinish sr.bssid=" + sr.BSSID);
            Object object = this.mAnqpRequestLock;
            synchronized (object) {
                for (ScanResult sr1 : this.mAnqpRequest) {
                    if (!sr1.BSSID.equals(sr.BSSID)) continue;
                    this.mAnqpRequest.remove(sr1);
                    break;
                }
            }
        }

        class PasspointHandler
        extends Handler {
            PasspointHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message message) {
                Object listener = null;
                switch (message.what) {
                    case 69636: {
                        if (Channel.this.mChannelListener == null) break;
                        Channel.this.mChannelListener.onChannelDisconnected();
                        Channel.this.mChannelListener = null;
                        break;
                    }
                    case 163843: {
                        WifiPasspointInfo result = (WifiPasspointInfo)message.obj;
                        Channel.this.anqpRequestFinish(result);
                        listener = Channel.this.getListener(message.arg2, false);
                        if (listener == null) break;
                        ((ActionListener)listener).onSuccess();
                        break;
                    }
                    case 163842: {
                        Channel.this.anqpRequestFinish((ScanResult)message.obj);
                        listener = Channel.this.getListener(message.arg2, false);
                        if (listener == null) {
                            Channel.this.getListener(message.arg2, true);
                        }
                        if (listener == null) break;
                        ((ActionListener)listener).onFailure(message.arg1);
                        break;
                    }
                    case 163850: {
                        listener = Channel.this.getListener(message.arg2, true);
                        if (listener == null) break;
                        ((OsuRemListener)listener).onSuccess();
                        break;
                    }
                    case 163849: {
                        listener = Channel.this.getListener(message.arg2, true);
                        if (listener == null) break;
                        ((OsuRemListener)listener).onFailure(message.arg1);
                        break;
                    }
                    case 163848: {
                        listener = Channel.this.peekListener(message.arg2);
                        if (listener == null) break;
                        ParcelableString str = (ParcelableString)message.obj;
                        if (str == null || str.string == null) {
                            ((OsuRemListener)listener).onBrowserDismiss();
                            break;
                        }
                        ((OsuRemListener)listener).onBrowserLaunch(str.string);
                        break;
                    }
                    default: {
                        Log.d(WifiPasspointManager.TAG, "Ignored " + message);
                    }
                }
            }
        }
    }

    public static interface OsuRemListener {
        public void onSuccess();

        public void onFailure(int var1);

        public void onBrowserLaunch(String var1);

        public void onBrowserDismiss();
    }

    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1);
    }

    public static interface ChannelListener {
        public void onChannelDisconnected();
    }
}

