/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.passpoint;

import android.net.wifi.WifiConfiguration;
import android.net.wifi.passpoint.WifiPasspointCredential;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class WifiPasspointPolicy
implements Parcelable {
    private static final String TAG = "PasspointPolicy";
    public static final int HOME_SP = 0;
    public static final int ROAMING_PARTNER = 1;
    public static final int UNRESTRICTED = 2;
    private String mName;
    private int mCredentialPriority;
    private int mRoamingPriority;
    private String mBssid;
    private String mSsid;
    private WifiPasspointCredential mCredential;
    private int mRestriction;
    private boolean mIsHomeSp;
    private final String INT_PRIVATE_KEY = "private_key";
    private final String INT_PHASE2 = "phase2";
    private final String INT_PASSWORD = "password";
    private final String INT_IDENTITY = "identity";
    private final String INT_EAP = "eap";
    private final String INT_CLIENT_CERT = "client_cert";
    private final String INT_CA_CERT = "ca_cert";
    private final String INT_ANONYMOUS_IDENTITY = "anonymous_identity";
    private final String INT_SIM_SLOT = "sim_slot";
    private final String INT_ENTERPRISEFIELD_NAME = "android.net.wifi.WifiConfiguration$EnterpriseField";
    private final String ISO8601DATEFORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private final String ENTERPRISE_PHASE2_MSCHAPV2 = "auth=MSCHAPV2";
    private final String ENTERPRISE_PHASE2_MSCHAP = "auth=MSCHAP";
    public static final Parcelable.Creator<WifiPasspointPolicy> CREATOR = new Parcelable.Creator<WifiPasspointPolicy>(){

        @Override
        public WifiPasspointPolicy createFromParcel(Parcel in) {
            return null;
        }

        public WifiPasspointPolicy[] newArray(int size) {
            return new WifiPasspointPolicy[size];
        }
    };

    public WifiPasspointPolicy(String name, String ssid, String bssid, WifiPasspointCredential pc, int restriction, boolean ishomesp) {
        this.mName = name;
        if (pc != null) {
            this.mCredentialPriority = pc.getPriority();
        }
        this.mRoamingPriority = 128;
        this.mSsid = ssid;
        this.mCredential = pc;
        this.mBssid = bssid;
        this.mRestriction = restriction;
        this.mIsHomeSp = ishomesp;
    }

    public String getSsid() {
        return this.mSsid;
    }

    public void setBssid(String bssid) {
        this.mBssid = bssid;
    }

    public String getBssid() {
        return this.mBssid;
    }

    public void setRestriction(int r) {
        this.mRestriction = r;
    }

    public int getRestriction() {
        return this.mRestriction;
    }

    public void setHomeSp(boolean b) {
        this.mIsHomeSp = b;
    }

    public boolean isHomeSp() {
        return this.mIsHomeSp;
    }

    public void setCredential(WifiPasspointCredential newCredential) {
        this.mCredential = newCredential;
    }

    public WifiPasspointCredential getCredential() {
        return this.mCredential;
    }

    public void setCredentialPriority(int priority) {
        this.mCredentialPriority = priority;
    }

    public void setRoamingPriority(int priority) {
        this.mRoamingPriority = priority;
    }

    public int getCredentialPriority() {
        return this.mCredentialPriority;
    }

    public int getRoamingPriority() {
        return this.mRoamingPriority;
    }

    public WifiConfiguration createWifiConfiguration() {
        Field[] fields;
        WifiConfiguration wfg = new WifiConfiguration();
        if (this.mBssid != null) {
            Log.d(TAG, "create bssid:" + this.mBssid);
            wfg.BSSID = this.mBssid;
        }
        if (this.mSsid != null) {
            Log.d(TAG, "create ssid:" + this.mSsid);
            wfg.SSID = this.mSsid;
        }
        wfg.status = 2;
        wfg.allowedKeyManagement.clear();
        wfg.allowedKeyManagement.set(2);
        wfg.allowedKeyManagement.set(3);
        wfg.allowedGroupCiphers.clear();
        wfg.allowedPairwiseCiphers.set(2);
        wfg.allowedPairwiseCiphers.set(1);
        wfg.allowedProtocols.clear();
        wfg.allowedProtocols.set(1);
        wfg.allowedProtocols.set(0);
        Class<?>[] enterpriseFieldArray = WifiConfiguration.class.getClasses();
        Class<?> enterpriseFieldClass = null;
        for (Class<?> myClass : enterpriseFieldArray) {
            if (!myClass.getName().equals("android.net.wifi.WifiConfiguration$EnterpriseField")) continue;
            enterpriseFieldClass = myClass;
            break;
        }
        Log.d(TAG, "class chosen " + enterpriseFieldClass.getName());
        Field anonymousId = null;
        Field caCert = null;
        Field clientCert = null;
        Field eap = null;
        Field identity = null;
        Field password = null;
        Field phase2 = null;
        Field privateKey = null;
        for (Field tempField : fields = WifiConfiguration.class.getFields()) {
            if (tempField.getName().trim().equals("anonymous_identity")) {
                anonymousId = tempField;
                Log.d(TAG, "field " + anonymousId.getName());
                continue;
            }
            if (tempField.getName().trim().equals("ca_cert")) {
                caCert = tempField;
                continue;
            }
            if (tempField.getName().trim().equals("client_cert")) {
                clientCert = tempField;
                Log.d(TAG, "field " + clientCert.getName());
                continue;
            }
            if (tempField.getName().trim().equals("eap")) {
                eap = tempField;
                Log.d(TAG, "field " + eap.getName());
                continue;
            }
            if (tempField.getName().trim().equals("identity")) {
                identity = tempField;
                Log.d(TAG, "field " + identity.getName());
                continue;
            }
            if (tempField.getName().trim().equals("password")) {
                password = tempField;
                Log.d(TAG, "field " + password.getName());
                continue;
            }
            if (tempField.getName().trim().equals("phase2")) {
                phase2 = tempField;
                Log.d(TAG, "field " + phase2.getName());
                continue;
            }
            if (!tempField.getName().trim().equals("private_key")) continue;
            privateKey = tempField;
        }
        Method setValue = null;
        for (Method m : enterpriseFieldClass.getMethods()) {
            if (!m.getName().trim().equals("setValue")) continue;
            Log.d(TAG, "method " + m.getName());
            setValue = m;
            break;
        }
        try {
            String eapmethod = this.mCredential.getType();
            Log.d(TAG, "eapmethod:" + eapmethod);
            setValue.invoke(eap.get(wfg), eapmethod);
            if ("TTLS".equals(eapmethod)) {
                setValue.invoke(phase2.get(wfg), "auth=MSCHAPV2");
                setValue.invoke(identity.get(wfg), this.mCredential.getUserName());
                setValue.invoke(password.get(wfg), this.mCredential.getPassword());
                setValue.invoke(anonymousId.get(wfg), "anonymous@" + this.mCredential.getRealm());
            }
            String cacertificate = null;
            String rootCA = this.mCredential.getCaRootCertPath();
            cacertificate = rootCA == null ? null : "keystore://WIFI_HS20CACERT_" + rootCA;
            Log.d(TAG, "cacertificate:" + cacertificate);
            setValue.invoke(caCert.get(wfg), cacertificate);
            if ("TLS".equals(eapmethod)) {
                String usercertificate = null;
                String privatekey = null;
                String clientCertPath = this.mCredential.getClientCertPath();
                if (clientCertPath != null) {
                    privatekey = "keystore://WIFI_HS20USRPKEY_" + clientCertPath;
                    usercertificate = "keystore://WIFI_HS20USRCERT_" + clientCertPath;
                }
                Log.d(TAG, "privatekey:" + privatekey);
                Log.d(TAG, "usercertificate:" + usercertificate);
                if (privatekey != null && usercertificate != null) {
                    setValue.invoke(privateKey.get(wfg), privatekey);
                    setValue.invoke(clientCert.get(wfg), usercertificate);
                }
            }
        }
        catch (Exception e) {
            Log.d(TAG, "createWifiConfiguration err:" + e);
        }
        return wfg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareTo(WifiPasspointPolicy another) {
        Log.d(TAG, "this:" + this);
        Log.d(TAG, "another:" + another);
        if (another == null) {
            return -1;
        }
        if (this.mIsHomeSp && !another.isHomeSp()) {
            Log.d(TAG, "compare HomeSP  first, this is HomeSP, another isn't");
            return -1;
        }
        if (this.mIsHomeSp && another.isHomeSp()) {
            Log.d(TAG, "both HomeSP");
            if (this.mCredentialPriority < another.getCredentialPriority()) {
                Log.d(TAG, "this priority is higher");
                return -1;
            }
            if (this.mCredentialPriority != another.getCredentialPriority()) return 1;
            Log.d(TAG, "both priorities equal");
            if (this.mName.compareTo(another.mName) != 0) {
                Log.d(TAG, "compare mName return:" + this.mName.compareTo(another.mName));
                return this.mName.compareTo(another.mName);
            }
            if (this.mCredential != null && another.mCredential != null && this.mCredential.compareTo(another.mCredential) != 0) {
                Log.d(TAG, "compare mCredential return:" + this.mName.compareTo(another.mName));
                return this.mCredential.compareTo(another.mCredential);
            }
        } else if (!this.mIsHomeSp && !another.isHomeSp()) {
            Log.d(TAG, "both RoamingSp");
            if (this.mRoamingPriority < another.getRoamingPriority()) {
                Log.d(TAG, "this priority is higher");
                return -1;
            }
            if (this.mRoamingPriority != another.getRoamingPriority()) return 1;
            Log.d(TAG, "both priorities equal");
            if (this.mName.compareTo(another.mName) != 0) {
                Log.d(TAG, "compare mName return:" + this.mName.compareTo(another.mName));
                return this.mName.compareTo(another.mName);
            }
            if (this.mCredential != null && another.mCredential != null && this.mCredential.compareTo(another.mCredential) != 0) {
                Log.d(TAG, "compare mCredential return:" + this.mCredential.compareTo(another.mCredential));
                return this.mCredential.compareTo(another.mCredential);
            }
        }
        Log.d(TAG, "both policies equal");
        return 0;
    }

    public String toString() {
        return "PasspointPolicy: name=" + this.mName + " CredentialPriority=" + this.mCredentialPriority + " mRoamingPriority" + this.mRoamingPriority + " ssid=" + this.mSsid + " restriction=" + this.mRestriction + " ishomesp=" + this.mIsHomeSp + " Credential=" + this.mCredential;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
    }
}

